/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.dtrace.ui.dataprovider;

import com.jrockit.mc.common.io.IOResource;
import com.jrockit.mc.common.io.IOToolkit;
import com.jrockit.mc.common.persistence.PersistenceToolkit;
import com.jrockit.mc.common.unit.UnitLookup;
import com.jrockit.mc.dtrace.events.code.EventTypeDescriptor;
import com.jrockit.mc.dtrace.events.code.FieldDescriptor;
import com.jrockit.mc.dtrace.events.code.Metadata;
import com.jrockit.mc.dtrace.events.code.ProducerDescriptor;
import com.jrockit.mc.dtrace.ui.dataprovider.ClassDefinitionHook;
import com.jrockit.mc.dtrace.ui.dataprovider.EventBuilder;
import com.jrockit.mc.dtrace.ui.dataprovider.EventValueType;
import com.jrockit.mc.dtrace.ui.dataprovider.IEventParserHook;
import com.jrockit.mc.dtrace.ui.dataprovider.MethodParser;
import com.jrockit.mc.dtrace.ui.dataprovider.Parser;
import com.jrockit.mc.dtrace.ui.dataprovider.ParserEnviroment;
import com.jrockit.mc.dtrace.ui.dataprovider.RepositoryBuilder;
import com.jrockit.mc.dtrace.ui.dataprovider.ThreadParser;
import com.jrockit.mc.dtrace.ui.dataprovider.ThreadRunningHook;
import com.jrockit.mc.dtrace.ui.dataprovider.TypeParser;
import com.jrockit.mc.dtrace.ui.dataprovider.TypeReferenceParser;
import com.jrockit.mc.dtrace.ui.dataprovider.ValueProcessor;
import com.jrockit.mc.dtrace.ui.input.BackgroundInput;
import com.jrockit.mc.dtrace.ui.input.IChunkInput;
import com.jrockit.mc.dtrace.ui.parser.text.CompositeParser;
import com.jrockit.mc.dtrace.ui.parser.text.Datatype;
import com.jrockit.mc.dtrace.ui.parser.text.IParser;
import com.jrockit.mc.dtrace.ui.parser.text.LongParser;
import com.jrockit.mc.dtrace.ui.parser.text.ParserFactory;
import com.jrockit.mc.dtrace.ui.parser.text.chunk.Runner;
import com.jrockit.mc.dtrace.ui.parser.text.input.CharacterChunk;
import com.jrockit.mc.dtrace.ui.parser.text.input.CharacterStreamInput;
import com.jrockit.mc.flightrecorder.internal.fields.ClassPackageField;
import com.jrockit.mc.flightrecorder.internal.fields.MethodClassField;
import com.jrockit.mc.flightrecorder.internal.fields.MethodPackageField;
import com.jrockit.mc.flightrecorder.provider.DefaultFactories;
import com.jrockit.mc.flightrecorder.provider.EventType;
import com.jrockit.mc.flightrecorder.provider.Producer;
import com.jrockit.mc.flightrecorder.spi.FieldType;
import com.jrockit.mc.flightrecorder.spi.IEventFactory;
import com.jrockit.mc.flightrecorder.spi.IEventType;
import com.jrockit.mc.flightrecorder.spi.IField;
import com.jrockit.mc.flightrecorder.spi.IFieldFactory;
import com.jrockit.mc.flightrecorder.spi.IRepository;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public final class XMLEventDataProvider {
    /*
     * Unable to fully structure code
     */
    public static IRepository createRepositoryFromFile(File file) {
        block14: {
            block13: {
                rs = null;
                rs = IOToolkit.createResourceSet((File)file);
                metadataResource = rs.findWithPostfix(".xml");
                eventsResource = rs.findWithPostfix(".clf");
                is = null;
                csi = null;
                metadata = null;
                try {
                    is = metadataResource.open();
                    metadata = (Metadata)PersistenceToolkit.createObjectFromInputStream(Metadata.class, (InputStream)is);
                }
                finally {
                    IOToolkit.closeSilently((Closeable)is);
                }
                csi = XMLEventDataProvider.createStreamInput(eventsResource);
                input = new BackgroundInput<CharacterChunk>(csi, 2);
                var9_10 = XMLEventDataProvider.createRepository(input, file, metadata);
                IOToolkit.closeSilently((Closeable)csi);
                if (rs == null) break block13;
                ** for (resource : rs.getResources())
lbl-1000:
                // 1 sources

                {
                    resource.close();
                    continue;
                }
            }
            return var9_10;
            {
                catch (Throwable var8_15) {
                    try {
                        try {
                            IOToolkit.closeSilently((Closeable)csi);
                            throw var8_15;
                        }
                        catch (IOException e) {
                            throw new IllegalArgumentException(e);
                        }
                    }
                    catch (Throwable var10_16) {
                        if (rs == null) break block14;
                        ** for (resource : rs.getResources())
                    }
                }
            }
lbl-1000:
            // 1 sources

            {
                resource.close();
                continue;
            }
        }
        throw var10_16;
    }

    private static IRepository createRepository(IChunkInput<CharacterChunk> input, File file, Metadata metadata) throws IOException {
        ArrayList<Producer> producers = new ArrayList<Producer>();
        ParserEnviroment pe = new ParserEnviroment();
        int pCounter = 0;
        int eCounter = 4096;
        HashMap<String, ValueProcessor> lookup = new HashMap<String, ValueProcessor>();
        for (ProducerDescriptor pd : metadata.getProducers()) {
            Producer p = new Producer(pCounter, pd.getName(), pd.getDescription(), pd.getURI());
            producers.add(p);
            for (EventTypeDescriptor et : pd.getEventTypeDesciptors()) {
                EventType eventType = p.createEventType(eCounter);
                eventType.setName(et.getName());
                eventType.setDescription(et.getDescription());
                eventType.setPath(et.getPath());
                eventType.setColor(et.getColor().getAWTColor());
                List<FieldDescriptor> beginFields = new ArrayList<FieldDescriptor>();
                List<FieldDescriptor> endFields = new ArrayList<FieldDescriptor>();
                for (FieldDescriptor f : et.getFields()) {
                    if (f.isBeginValue()) {
                        beginFields.add(f);
                    }
                    if (!f.isEndValue()) continue;
                    endFields.add(f);
                }
                beginFields = XMLEventDataProvider.synthesize(beginFields);
                endFields = XMLEventDataProvider.synthesize(endFields);
                ArrayList<FieldDescriptor> allFields = new ArrayList<FieldDescriptor>();
                for (FieldDescriptor f : et.getFields()) {
                    FieldDescriptor b = XMLEventDataProvider.findWithId(beginFields, f.getIdentifier());
                    if (b != null) {
                        allFields.add(b);
                        continue;
                    }
                    FieldDescriptor e = XMLEventDataProvider.findWithId(endFields, f.getIdentifier());
                    if (e == null) continue;
                    allFields.add(e);
                }
                List<FieldDescriptor> filteredFields = XMLEventDataProvider.synthesize(et.getFields());
                IEventFactory eventFactory = DefaultFactories.createEventFactory((int)filteredFields.size());
                IFieldFactory fieldFactory = DefaultFactories.createFieldFactory((EventType)eventType, (int)filteredFields.size());
                EventBuilder eb = new EventBuilder(eventType, beginFields, endFields, allFields, eventFactory);
                XMLEventDataProvider.createFields(eventType, filteredFields, fieldFactory);
                if (beginFields.size() == 0 && endFields.size() == 0) {
                    lookup.put(String.valueOf(et.getKey()) + "!", new ValueProcessor(EventValueType.INSTANT, eb, XMLEventDataProvider.createHook(eventType), XMLEventDataProvider.createParser(et, pe, filteredFields)));
                } else {
                    lookup.put(String.valueOf(et.getKey()) + "...", new ValueProcessor(EventValueType.BEGIN, eb, XMLEventDataProvider.createHook(eventType), XMLEventDataProvider.createParser(et, pe, beginFields)));
                    lookup.put(String.valueOf(et.getKey()) + "!", new ValueProcessor(EventValueType.END, eb, XMLEventDataProvider.createHook(eventType), XMLEventDataProvider.createParser(et, pe, endFields)));
                }
                ++eCounter;
            }
            ++pCounter;
        }
        RepositoryBuilder repositoryBuilder = new RepositoryBuilder();
        Parser mp = new Parser(pe, repositoryBuilder, metadata, lookup);
        Runner r = new Runner(mp);
        r.run(input);
        return repositoryBuilder.buildRepository(producers);
    }

    private static FieldDescriptor findWithId(List<FieldDescriptor> fields, String identifier) {
        for (FieldDescriptor field : fields) {
            if (!identifier.equals(field.getIdentifier())) continue;
            return field;
        }
        return null;
    }

    private static IEventParserHook<ParserEnviroment> createHook(EventType type) {
        if ("Java_Virtual_Machine/Class_Loading/Class_Definition".equals(type.getPath())) {
            return new ClassDefinitionHook(type);
        }
        if ("Operating_System/Thread/Running".equals(type.getPath())) {
            return new ThreadRunningHook((IEventType)type);
        }
        return null;
    }

    private static void createFields(EventType eventType, List<FieldDescriptor> fields, IFieldFactory fieldFactory) {
        for (FieldDescriptor f : fields) {
            String identifier = f.getIdentifier();
            IField field = fieldFactory.createValueField(identifier, identifier, f.getContentType(), f.getName(), f.getDescription(), null, FieldType.OBJECT, new String[0]);
            if (XMLEventDataProvider.isMethod(f)) {
                eventType.addField((IField)new MethodClassField((IEventType)eventType, identifier, field));
                eventType.addField((IField)new MethodPackageField((IEventType)eventType, identifier, field));
            }
            if (!XMLEventDataProvider.isClass(f)) continue;
            eventType.addField((IField)new ClassPackageField((IEventType)eventType, identifier, field));
        }
    }

    private static boolean isMethod(FieldDescriptor desc) {
        return UnitLookup.METHOD.getIdentifier().equals(desc.getContentType());
    }

    private static boolean isClass(FieldDescriptor desc) {
        return UnitLookup.CLASS.getIdentifier().equals(desc.getContentType());
    }

    private static List<FieldDescriptor> synthesize(List<FieldDescriptor> fields) {
        ArrayList<FieldDescriptor> newFields = new ArrayList<FieldDescriptor>();
        int i = 0;
        while (i < fields.size()) {
            if (XMLEventDataProvider.matchContentTypes(i, fields, "class", "method", "descriptor")) {
                newFields.add(fields.get(i + 1));
                i += 3;
            } else {
                newFields.add(fields.get(i));
            }
            ++i;
        }
        return newFields;
    }

    private static boolean matchContentTypes(int index, List<FieldDescriptor> fields, String ... contentTypes) {
        int i = 0;
        while (i < contentTypes.length) {
            int position = index + i;
            if (position >= fields.size()) {
                return false;
            }
            if (!contentTypes[i].equals(fields.get(position).getIdentifier())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static IParser createParser(EventTypeDescriptor type, ParserEnviroment pe, List<FieldDescriptor> fields) {
        ArrayList<IParser> parsers = new ArrayList<IParser>();
        for (FieldDescriptor field : fields) {
            Datatype dt = XMLEventDataProvider.toDataType(field.getDataType());
            if ("thread".equals(field.getContentType()) && dt.isNumeric()) {
                parsers.add(new ThreadParser(pe, ParserFactory.createValueParser(dt)));
                continue;
            }
            if ("class".equals(field.getContentType()) && dt.isNumeric()) {
                parsers.add(new TypeReferenceParser(pe));
                continue;
            }
            if ("class".equals(field.getContentType()) && dt.isString()) {
                parsers.add(new TypeParser(pe));
                continue;
            }
            if ("method".equals(field.getContentType())) {
                parsers.add(new MethodParser(pe));
                continue;
            }
            if ("expectedRecordingTime".equals(field.getIdentifier()) && "timespan".equals(field.getContentType()) && "int".equals(field.getDataType())) {
                parsers.add(new LongParser());
                continue;
            }
            parsers.add(ParserFactory.createValueParser(dt));
        }
        IParser[] ps = parsers.toArray(new IParser[parsers.size()]);
        return new CompositeParser(ps);
    }

    private static Datatype toDataType(String dataType) {
        if (Datatype.STRING.getKey().equals(dataType)) {
            return Datatype.STRING;
        }
        if (Datatype.BOOLEAN.getKey().equals(dataType)) {
            return Datatype.BOOLEAN;
        }
        if (Datatype.INTEGER.getKey().equals(dataType)) {
            return Datatype.INTEGER;
        }
        if (Datatype.FLOAT.getKey().equals(dataType)) {
            return Datatype.FLOAT;
        }
        if (Datatype.DOUBLE.getKey().equals(dataType)) {
            return Datatype.DOUBLE;
        }
        if (Datatype.SHORT.getKey().equals(dataType)) {
            return Datatype.SHORT;
        }
        if (Datatype.LONG.getKey().equals(dataType)) {
            return Datatype.LONG;
        }
        throw new IllegalArgumentException("Unknown datatype " + dataType);
    }

    private static CharacterStreamInput createStreamInput(IOResource resource) throws IOException, FileNotFoundException {
        return new CharacterStreamInput(resource.open());
    }
}

