/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.dtrace.ui.dataprovider;

import com.jrockit.mc.dtrace.ui.dataprovider.EventBuilder;
import com.jrockit.mc.dtrace.ui.dataprovider.EventValueType;
import com.jrockit.mc.dtrace.ui.dataprovider.IEventParserHook;
import com.jrockit.mc.dtrace.ui.dataprovider.ParserEnviroment;
import com.jrockit.mc.dtrace.ui.parser.text.IParser;
import com.jrockit.mc.dtrace.ui.parser.text.input.CharacterChunk;
import com.jrockit.mc.flightrecorder.spi.IEvent;

final class ValueProcessor {
    private final EventValueType m_eventValueType;
    private final IParser m_parser;
    private final EventBuilder m_eventBuilder;
    private final IEventParserHook<ParserEnviroment> m_hook;

    ValueProcessor(EventValueType type, EventBuilder builder, IEventParserHook<ParserEnviroment> hook, IParser parser) {
        this.m_eventValueType = type;
        this.m_eventBuilder = builder;
        this.m_parser = parser;
        this.m_hook = hook;
    }

    EventBuilder getBuilder() {
        return this.m_eventBuilder;
    }

    EventValueType getEventValueType() {
        return this.m_eventValueType;
    }

    IParser getParser() {
        return this.m_parser;
    }

    IEvent process(CharacterChunk chunk, long timestamp) {
        Object[] values = (Object[])this.m_parser.read(chunk);
        switch (this.m_eventValueType) {
            case BEGIN: {
                this.m_eventBuilder.addBegin(timestamp, values);
                return null;
            }
            case END: {
                return this.m_eventBuilder.addEnd(timestamp, values);
            }
            case INSTANT: {
                return this.m_eventBuilder.addInstant(timestamp, values);
            }
        }
        return null;
    }

    IEventParserHook<ParserEnviroment> getHook() {
        return this.m_hook;
    }
}

