/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.dtrace.ui.dataprovider;

import com.jrockit.mc.flightrecorder.internal.model.FLRThread;
import com.jrockit.mc.flightrecorder.internal.model.RootTrackGroup;
import com.jrockit.mc.flightrecorder.provider.EventStorage;
import com.jrockit.mc.flightrecorder.provider.EventType;
import com.jrockit.mc.flightrecorder.provider.Producer;
import com.jrockit.mc.flightrecorder.provider.Repository;
import com.jrockit.mc.flightrecorder.provider.TrackGroup;
import com.jrockit.mc.flightrecorder.spi.IEvent;
import com.jrockit.mc.flightrecorder.spi.IEventType;
import com.jrockit.mc.flightrecorder.spi.IRepository;
import com.jrockit.mc.flightrecorder.spi.ITimeRange;
import com.jrockit.mc.flightrecorder.util.TimeRange;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class RepositoryBuilder {
    private long min = 0x3FFFFFFFFFFFFFFFL;
    private long max = -4611686018427387904L;
    private final Map<IEventType, Map<FLRThread, List<IEvent>>> eventsMap = new HashMap<IEventType, Map<FLRThread, List<IEvent>>>();

    RepositoryBuilder() {
    }

    void addEvent(FLRThread thread, IEvent event) {
        List<IEvent> eventList;
        IEventType eventType = event.getEventType();
        Map<FLRThread, List<IEvent>> evnetTypeMap = this.eventsMap.get(eventType);
        if (evnetTypeMap == null) {
            evnetTypeMap = new HashMap<FLRThread, List<IEvent>>();
            this.eventsMap.put(eventType, evnetTypeMap);
        }
        if ((eventList = evnetTypeMap.get(thread)) == null) {
            eventList = new ArrayList<IEvent>();
            evnetTypeMap.put(thread, eventList);
        }
        eventList.add(event);
        if (event.getStartTimestamp() > 0L) {
            this.min = Math.min(event.getStartTimestamp(), this.min);
        }
        this.max = Math.max(event.getEndTimestamp(), this.max);
    }

    IRepository buildRepository(Collection<Producer> producers) {
        RootTrackGroup trackSystem = new RootTrackGroup();
        ArrayList<EventStorage> allEventStorages = new ArrayList<EventStorage>(100);
        for (Map.Entry<IEventType, Map<FLRThread, List<IEvent>>> typeEntry : this.eventsMap.entrySet()) {
            EventType et = (EventType)typeEntry.getKey();
            for (Map.Entry<FLRThread, List<IEvent>> threadEntry : typeEntry.getValue().entrySet()) {
                List<IEvent> events = threadEntry.getValue();
                EventStorage storage = new EventStorage(events.toArray(new IEvent[events.size()]));
                et.addEventStorage(storage);
                trackSystem.addEventStorage(threadEntry.getKey(), (IEventType)et, storage);
                allEventStorages.add(storage);
            }
        }
        return new Repository(producers, allEventStorages, (TrackGroup)trackSystem, this.getTimeRange());
    }

    private ITimeRange getTimeRange() {
        if (this.min == 0x3FFFFFFFFFFFFFFFL) {
            this.min = 0L;
        }
        if (this.max == -4611686018427387904L) {
            this.max = 1L;
        }
        return new TimeRange(this.min, this.max);
    }
}

