/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.dtrace.ui.dataprovider;

import com.jrockit.mc.common.IMCType;
import com.jrockit.mc.dtrace.ui.dataprovider.TypeLookup;
import com.jrockit.mc.flightrecorder.internal.model.FLRThread;
import com.jrockit.mc.flightrecorder.internal.model.FLRType;
import java.util.HashMap;
import java.util.Map;

public final class ParserEnviroment {
    private final Map<String, IMCType> m_typeLookup = new HashMap<String, IMCType>();
    private final Map<Integer, FLRThread> m_threadLookup = new HashMap<Integer, FLRThread>();
    private final Map<Integer, TypeLookup> m_threadLocal = new HashMap<Integer, TypeLookup>();
    private FLRThread m_currentThread;
    private long m_offset;

    public FLRThread getThread(Integer platformId) {
        FLRThread flrThread = this.m_threadLookup.get(platformId);
        if (flrThread == null) {
            flrThread = new FLRThread();
            this.m_threadLookup.put(platformId, flrThread);
            flrThread.setPlatformId(platformId);
            flrThread.setName("Thread with Id " + platformId);
            flrThread.setThreadGroupName("Threads");
        }
        return flrThread;
    }

    public IMCType getType(String refType) {
        IMCType type = this.m_typeLookup.get(refType);
        if (type == null) {
            type = new FLRType(refType);
            this.m_typeLookup.put(refType, type);
        }
        return type;
    }

    public void removeThread(Integer platformID) {
        this.m_threadLookup.get(platformID);
    }

    public void defineClassName(Integer classIdentifier, String className) {
        if (this.m_currentThread != null) {
            TypeLookup tld = this.m_threadLocal.get(this.m_currentThread.getPlatformId());
            if (tld == null) {
                tld = new TypeLookup();
                this.m_threadLocal.put(this.m_currentThread.getPlatformId(), tld);
            }
            tld.store(classIdentifier, this.getType(className));
        }
    }

    public Object getClassById(Integer classIdentifier, Long classLoaderIdentfier) {
        TypeLookup tld;
        if (this.m_currentThread != null && (tld = this.m_threadLocal.get(this.m_currentThread.getPlatformId())) != null) {
            return tld.getClass(classIdentifier);
        }
        return classIdentifier;
    }

    public void setCurrentThread(FLRThread t) {
        this.m_currentThread = t;
    }

    public FLRThread getCurrentThread() {
        return this.m_currentThread;
    }

    public void setOffset(long time) {
        this.m_offset = time;
    }

    public long getOffset() {
        return this.m_offset;
    }
}

