/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.dtrace.ui.dataprovider;

import com.jrockit.mc.dtrace.events.code.Metadata;
import com.jrockit.mc.dtrace.ui.dataprovider.EventValues;
import com.jrockit.mc.dtrace.ui.dataprovider.IEventParserHook;
import com.jrockit.mc.dtrace.ui.dataprovider.ParserEnviroment;
import com.jrockit.mc.dtrace.ui.dataprovider.RepositoryBuilder;
import com.jrockit.mc.dtrace.ui.dataprovider.ValueProcessor;
import com.jrockit.mc.dtrace.ui.parser.text.LongParser;
import com.jrockit.mc.dtrace.ui.parser.text.SymbolParser;
import com.jrockit.mc.dtrace.ui.parser.text.chunk.IProcessor;
import com.jrockit.mc.dtrace.ui.parser.text.input.CharacterChunk;
import com.jrockit.mc.flightrecorder.internal.model.FLRThread;
import com.jrockit.mc.flightrecorder.spi.IEvent;
import java.util.Collection;
import java.util.Map;

final class Parser
implements IProcessor {
    private final Map<String, ValueProcessor> m_lookup;
    private final SymbolParser m_typeIdParser = new SymbolParser();
    private final RepositoryBuilder m_eventMapper;
    private final ParserEnviroment m_environment;
    private final ValueProcessor m_startTimeProcessor;
    private final ValueProcessor m_endTimeProcessor;
    private long time;
    private Long nanosSince1970;
    private long offset;

    public Parser(ParserEnviroment pe, RepositoryBuilder eventMapper, Metadata metadata, Map<String, ValueProcessor> lookup) {
        this.m_lookup = lookup;
        this.m_eventMapper = eventMapper;
        this.m_environment = pe;
        this.m_startTimeProcessor = lookup.get("Recording...");
        this.m_endTimeProcessor = lookup.get("Recording!");
    }

    private ValueProcessor lookup(String typeID) {
        return this.m_lookup.get(typeID);
    }

    @Override
    public void initialize() {
    }

    @Override
    public void finish() {
        ValueProcessor pt = this.lookup("ThreadRunning!");
        if (pt != null) {
            for (IEvent event : pt.getBuilder().finishEvents(this.time)) {
                this.processEvent(pt, event);
            }
        }
    }

    @Override
    public void processChunkPart(CharacterChunk chunk) {
        String typeID;
        ValueProcessor pt;
        this.time = LongParser.readLong(chunk);
        if (this.time == 1L) {
            this.time = this.nanosSince1970 - this.offset;
        }
        if ((pt = this.lookup(typeID = this.m_typeIdParser.read(chunk))) != null) {
            if (this.m_startTimeProcessor == pt) {
                pt.process(chunk, this.time);
                Collection<EventValues> eventValues = pt.getBuilder().getValues();
                EventValues first = eventValues.iterator().next();
                Object[] values = first.getValues();
                long dtraceTime = (Long)values[0];
                this.nanosSince1970 = (Long)values[1];
                this.offset = this.nanosSince1970 - dtraceTime;
                for (ValueProcessor proc : this.m_lookup.values()) {
                    if ("Recording/recording".equals(proc.getBuilder().getEventType().getPath())) {
                        proc.getBuilder().setOffset(this.nanosSince1970);
                        continue;
                    }
                    proc.getBuilder().setOffset(this.offset);
                }
            } else if (this.m_endTimeProcessor == pt) {
                IEvent e = pt.process(chunk, this.time - (this.nanosSince1970 - this.offset));
                this.addEvent(e, null);
            } else {
                IEvent e = pt.process(chunk, this.time);
                if (e != null) {
                    this.processEvent(pt, e);
                }
            }
        }
    }

    private void processEvent(ValueProcessor pt, IEvent e) {
        IEventParserHook<ParserEnviroment> hook = pt.getHook();
        Object objectThread = e.getValue("thread");
        FLRThread thread = null;
        if (objectThread instanceof FLRThread) {
            thread = (FLRThread)objectThread;
        }
        this.m_environment.setCurrentThread(thread);
        if (hook != null) {
            IEvent[] iEventArray = hook.processEvent(e, this.m_environment);
            int n = iEventArray.length;
            int n2 = 0;
            while (n2 < n) {
                IEvent event = iEventArray[n2];
                this.addEvent(event, thread);
                ++n2;
            }
        } else {
            this.addEvent(e, thread);
        }
    }

    private void addEvent(IEvent e, FLRThread thread) {
        this.m_eventMapper.addEvent(thread, e);
    }
}

