/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.dtrace.ui.dataprovider;

import com.jrockit.mc.common.IMCType;
import com.jrockit.mc.dtrace.ui.dataprovider.ParserEnviroment;
import com.jrockit.mc.dtrace.ui.parser.text.IParser;
import com.jrockit.mc.dtrace.ui.parser.text.StringParser;
import com.jrockit.mc.dtrace.ui.parser.text.input.CharacterChunk;
import com.jrockit.mc.flightrecorder.internal.model.FLRMethod;

final class MethodParser
implements IParser {
    private final StringParser CLASS_PARSER;
    private final StringParser METHOD_PARSER;
    private final StringParser DESCRIPTOR_PARSER;
    private final ParserEnviroment m_parserEnvironment;

    public MethodParser(ParserEnviroment parserEnviroment) {
        this.m_parserEnvironment = parserEnviroment;
        this.CLASS_PARSER = new StringParser();
        this.METHOD_PARSER = new StringParser();
        this.DESCRIPTOR_PARSER = new StringParser();
    }

    @Override
    public Object read(CharacterChunk chunk) {
        String clazzString = this.CLASS_PARSER.read(chunk);
        String methodString = this.METHOD_PARSER.read(chunk);
        String descriptorString = this.DESCRIPTOR_PARSER.read(chunk);
        IMCType type = this.m_parserEnvironment.getType(clazzString);
        FLRMethod method = new FLRMethod();
        method.setMethodName(methodString);
        method.setClassName(type.getTypeName());
        method.setPackageName(type.getPackageName());
        method.setType(type);
        method.setFormalDescriptor(descriptorString);
        return method;
    }
}

