/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.dtrace.ui.dataprovider;

import com.jrockit.mc.flightrecorder.spi.IEventType;
import com.jrockit.mc.flightrecorder.util.EqualsToolkit;

final class EventValues {
    private final int m_hashCode;
    private final Object[] m_values;
    private final int[] m_keyIndices;
    private final long m_timestamp;
    private final IEventType m_type;

    EventValues(IEventType type, int[] keyIndices, Object[] values, long timestamp) {
        this.m_keyIndices = keyIndices;
        this.m_values = values;
        this.m_timestamp = timestamp;
        this.m_hashCode = this.calculateHash(type, values);
        this.m_type = type;
    }

    private int calculateHash(IEventType type, Object[] values) {
        int hash = 23;
        int[] nArray = this.m_keyIndices;
        int n = this.m_keyIndices.length;
        int n2 = 0;
        while (n2 < n) {
            int m_keyIndice = nArray[n2];
            hash = EqualsToolkit.hash((int)hash, (Object)this.m_values[m_keyIndice]);
            ++n2;
        }
        return hash;
    }

    public boolean equals(Object object) {
        if (!(object instanceof EventValues)) {
            return false;
        }
        EventValues that = (EventValues)object;
        if (this.m_type == that.m_type) {
            Object[] thoseValue = that.m_values;
            int[] thoseIndices = that.m_keyIndices;
            if (this.m_keyIndices.length == that.m_keyIndices.length) {
                int n = 0;
                while (n < this.m_keyIndices.length) {
                    if (!EqualsToolkit.nullSafeEquals((Object)this.m_values[this.m_keyIndices[n]], (Object)thoseValue[thoseIndices[n]])) {
                        return false;
                    }
                    ++n;
                }
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.m_hashCode;
    }

    public Object[] getValues() {
        return this.m_values;
    }

    public long getTimestamp() {
        return this.m_timestamp;
    }
}

