/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.dtrace.ui.dataprovider;

import com.jrockit.mc.dtrace.events.code.FieldDescriptor;
import com.jrockit.mc.dtrace.ui.dataprovider.EventValues;
import com.jrockit.mc.flightrecorder.provider.EventType;
import com.jrockit.mc.flightrecorder.spi.IEvent;
import com.jrockit.mc.flightrecorder.spi.IEventFactory;
import com.jrockit.mc.flightrecorder.spi.IEventType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

final class EventBuilder {
    private final IEventFactory m_factory;
    private final Map<EventValues, EventValues> m_valueLookup = new HashMap<EventValues, EventValues>();
    private final EventType m_type;
    private final int m_size;
    private final Indices m_beginIndices;
    private final Indices m_endIndices;
    private long m_offset;

    EventBuilder(EventType type, List<FieldDescriptor> beginFields, List<FieldDescriptor> endFields, List<FieldDescriptor> allFields, IEventFactory factory) {
        this.m_beginIndices = this.createIndices(allFields, beginFields, endFields);
        this.m_endIndices = this.createIndices(allFields, endFields, beginFields);
        this.m_size = allFields.size();
        this.m_type = type;
        this.m_factory = factory;
    }

    private Indices createIndices(List<FieldDescriptor> allFields, List<FieldDescriptor> primary, List<FieldDescriptor> secondary) {
        int[] values = new int[primary.size()];
        int n = 0;
        while (n < values.length) {
            values[n] = allFields.indexOf(primary.get(n));
            ++n;
        }
        ArrayList<Integer> keyList = new ArrayList<Integer>();
        int i = 0;
        while (i < primary.size()) {
            if (secondary.contains(primary.get(i))) {
                keyList.add(i);
            }
            ++i;
        }
        return new Indices(values, this.createIntArray(keyList));
    }

    private int[] createIntArray(List<Integer> b) {
        int[] array = new int[b.size()];
        int n = 0;
        while (n < array.length) {
            array[n] = b.get(n);
            ++n;
        }
        return array;
    }

    IEvent addBegin(long timestamp, Object[] values) {
        EventValues key = new EventValues((IEventType)this.m_type, this.m_beginIndices.keys, values, timestamp);
        this.m_valueLookup.put(key, key);
        return null;
    }

    IEvent addEnd(long timestamp, Object[] values) {
        EventValues endKey = new EventValues((IEventType)this.m_type, this.m_endIndices.keys, values, timestamp);
        EventValues beginKey = this.m_valueLookup.remove(endKey);
        if (beginKey != null) {
            return this.buildEvent(beginKey, endKey);
        }
        return null;
    }

    private IEvent buildEvent(EventValues begin, EventValues end) {
        Object[] beginValues = begin.getValues();
        Object[] endValues = end.getValues();
        int[] beginIndices = this.m_beginIndices.values;
        int[] endIndices = this.m_endIndices.values;
        Object[] values = new Object[this.m_size];
        int n = 0;
        while (n < beginValues.length) {
            values[beginIndices[n]] = beginValues[n];
            ++n;
        }
        n = 0;
        while (n < endValues.length) {
            values[endIndices[n]] = endValues[n];
            ++n;
        }
        if (begin.getTimestamp() > end.getTimestamp()) {
            return null;
        }
        return this.createEvent(begin.getTimestamp() + this.m_offset, end.getTimestamp() + this.m_offset, values);
    }

    IEvent addInstant(long timestamp, Object[] values) {
        return this.createEvent(this.m_offset + timestamp, this.m_offset + timestamp, values);
    }

    private IEvent createEvent(long startTime, long endTime, Object ... values) {
        return this.m_factory.createEvent(startTime, endTime, (IEventType)this.m_type, values);
    }

    public void setOffset(long offset) {
        this.m_offset = offset;
    }

    public Collection<EventValues> getValues() {
        return this.m_valueLookup.values();
    }

    public List<IEvent> finishEvents(long endTimestamp) {
        ArrayList<IEvent> events = new ArrayList<IEvent>();
        EventValues endValue = new EventValues((IEventType)this.m_type, new int[0], new Object[0], endTimestamp);
        for (EventValues beginValue : this.m_valueLookup.keySet()) {
            events.add(this.buildEvent(beginValue, endValue));
        }
        return events;
    }

    public EventType getEventType() {
        return this.m_type;
    }

    private static final class Indices {
        final int[] values;
        final int[] keys;

        public Indices(int[] values, int[] keys) {
            this.values = values;
            this.keys = keys;
        }
    }
}

