/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.dtrace.ui;

import com.jrockit.mc.common.io.IOToolkit;
import com.jrockit.mc.core.MCFile;
import com.jrockit.mc.core.idesupport.IDESupportToolkit;
import com.jrockit.mc.dtrace.ui.DTraceUIPlugin;
import com.jrockit.mc.dtrace.ui.InstallationFile;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Shell;

public class WorkspaceInstallation {
    public static final WorkspaceInstallation INSTANCE = new WorkspaceInstallation(new InstallationFile("com.jrockit.mc.dtrace.ui", "/installation/default.de", "default.de", "DTrace Event script that allows you to monitor Hotspot", true), new InstallationFile("com.jrockit.mc.dtrace.ui", "/installation/dtracerecorder.jar", "dtracerecorder.jar", "Java program for running DTrace Recorder on a remote machine", true), new InstallationFile("com.jrockit.mc.dtrace.samples", "/installation/latencies.dfr", "latencies.dfr", "DTrace recording sample file", true), new InstallationFile("com.jrockit.mc.dtrace.samples", "/installation/java2d_demo.dfr", "java_2d_demo.dfr", "DTrace recording sample file", true));
    private static final String DONT_CHECK_FOR_INSTALLATION = "dontCheckInstallation";
    private final List<InstallationFile> m_files;

    private WorkspaceInstallation(InstallationFile ... files) {
        this.m_files = new ArrayList<InstallationFile>(Arrays.asList(files));
    }

    public File install(Shell shell, IProgressMonitor monitor) throws IOException {
        File defaultScript = null;
        for (InstallationFile iFile : this.getInstallableFiles()) {
            MCFile mcFile = IDESupportToolkit.createDefaultFileResource((String)iFile.destinationName);
            InputStream is = iFile.getResourceStream();
            try {
                mcFile.writeStream(is, monitor, false);
            }
            finally {
                IOToolkit.closeSilently((Closeable)is);
            }
            if (defaultScript != null) continue;
            try {
                defaultScript = IDESupportToolkit.resolveFileSystemPath((String)mcFile.getPath());
            }
            catch (FileNotFoundException e) {
                defaultScript = new File(iFile.destinationName);
            }
        }
        return defaultScript;
    }

    public List<InstallationFile> getInstallableFiles() {
        ArrayList<InstallationFile> installableFiles = new ArrayList<InstallationFile>();
        for (InstallationFile iFile : this.getInstallationFiles()) {
            if (!iFile.resourceExists()) continue;
            installableFiles.add(iFile);
        }
        return installableFiles;
    }

    private List<InstallationFile> getInstallationFiles() {
        return this.m_files;
    }

    public boolean checkForInstallation() {
        return !DTraceUIPlugin.getDefault().getPreferenceStore().getBoolean(DONT_CHECK_FOR_INSTALLATION);
    }

    public void setCheckForInstallation(boolean checkForInstallation) {
        DTraceUIPlugin.getDefault().getPreferenceStore().setValue(DONT_CHECK_FOR_INSTALLATION, !checkForInstallation);
    }
}

