/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.dtrace.ui;

import com.jrockit.mc.core.StatusFactory;
import com.jrockit.mc.dtrace.ui.DTraceStartJob;
import com.jrockit.mc.dtrace.ui.DTraceUIPlugin;
import com.jrockit.mc.dtrace.ui.WorkspaceInstallation;
import com.jrockit.mc.ui.misc.ErrorDialog;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class InstallationJob
extends Job {
    private final DTraceStartJob m_startJob;
    private final Shell m_shell;

    public InstallationJob(Shell shell, DTraceStartJob startJob) {
        super("Install DTrace Recorder files");
        this.m_startJob = startJob;
        this.m_shell = shell;
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            File defaultScript = WorkspaceInstallation.INSTANCE.install(this.m_shell, monitor);
            File sourceFile = DTraceUIPlugin.getDefault().getConfiguration().getSourceFile();
            if (sourceFile == null) {
                DTraceUIPlugin.getDefault().getConfiguration().setSourceFile(defaultScript);
            }
            WorkspaceInstallation.INSTANCE.setCheckForInstallation(false);
        }
        catch (IOException e) {
            DTraceUIPlugin.getDefault().getLogger().log(Level.WARNING, "An error occured when trying to copy installation files", e);
            this.showCantFixInstallation(e);
        }
        this.m_startJob.schedule();
        return StatusFactory.createOk((String)"");
    }

    private void showCantFixInstallation(Exception e) {
        ErrorDialog.showExceptionDialogAsync((Display)this.m_shell.getDisplay(), (String)"File Installation Error", (String)"An error occured when trying to copy installation files", (Throwable)e);
    }
}

