/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.dtrace.ui;

import com.jrockit.mc.common.io.IOToolkit;
import com.jrockit.mc.common.persistence.PersistenceToolkit;
import com.jrockit.mc.core.StatusFactory;
import com.jrockit.mc.dtrace.events.code.CodeGenerator;
import com.jrockit.mc.dtrace.events.code.Configuration;
import com.jrockit.mc.dtrace.events.code.IProgress;
import com.jrockit.mc.dtrace.events.code.Parameter;
import com.jrockit.mc.dtrace.events.code.ScriptModel;
import com.jrockit.mc.dtrace.events.code.SimpleProgress;
import com.jrockit.mc.dtrace.events.code.TemplateDescriptor;
import com.jrockit.mc.dtrace.recorder.DTraceRecorder;
import com.jrockit.mc.dtrace.recorder.DTraceRecorderException;
import com.jrockit.mc.dtrace.recorder.Factory;
import com.jrockit.mc.dtrace.recorder.RecordingOptions;
import com.jrockit.mc.dtrace.ui.DTraceRecordingJob;
import com.jrockit.mc.dtrace.ui.DTraceUIPlugin;
import com.jrockit.mc.dtrace.ui.WizardConfig;
import com.jrockit.mc.dtrace.ui.wizard.CompilationErrorDialog;
import com.jrockit.mc.dtrace.ui.wizard.DtraceRecordingWizardPage;
import com.jrockit.mc.rjmx.ConnectionException;
import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.IServerHandle;
import com.jrockit.mc.rjmx.ServerToolkit;
import com.jrockit.mc.ui.misc.DisplayToolkit;
import com.jrockit.mc.ui.misc.ExceptionDialog;
import com.jrockit.mc.ui.wizards.OnePageWizardDialog;
import java.io.Closeable;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import javax.management.MBeanServerConnection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public final class DTraceStartJob
extends Job {
    private final IServerHandle m_server;
    private final Shell m_shell;

    public DTraceStartJob(Shell shell, IServerHandle serverHandle) {
        super("Start DTrace Recording");
        this.m_server = serverHandle;
        this.m_shell = shell;
    }

    protected IStatus run(IProgressMonitor monitor) {
        monitor.beginTask("Connecting to DTrace Recorder.", 1);
        if (this.hasLocalPid()) {
            this.startLocal();
        } else {
            this.startRemote();
        }
        monitor.done();
        return StatusFactory.createOk((String)"Start Dtrace Recording Finished");
    }

    private boolean hasLocalPid() {
        return this.isAttachable() && this.getPid() != null;
    }

    private boolean isAttachable() {
        return ServerToolkit.isAttachable((IServerHandle)this.m_server);
    }

    private void startRemote() {
        IConnectionHandle conn = this.createConnection();
        if (conn != null && conn.isConnected()) {
            MBeanServerConnection server = (MBeanServerConnection)conn.getServiceOrNull(MBeanServerConnection.class);
            if (server != null) {
                DTraceRecorder recorder = this.createRemoteRecorder(server);
                if (recorder != null) {
                    WizardConfig wc = new WizardConfig();
                    wc.setRecorder(recorder);
                    wc.setPid(null);
                    wc.setConnectionHandle(conn);
                    wc.setWizardTitle("Start DTrace Recording");
                    this.startWizardInUI(wc);
                } else {
                    IOToolkit.closeSilently((Closeable)conn);
                }
            } else {
                this.showError("Connection service not available. No MBeanServerConnection service could be found in connection handle.", null);
                IOToolkit.closeSilently((Closeable)conn);
            }
        }
    }

    private void startLocal() {
        DTraceRecorder recorder = Factory.createDTraceRecorder();
        if (recorder != null) {
            WizardConfig wc = new WizardConfig();
            wc.setPid(this.getPid());
            wc.setRecorder(recorder);
            wc.setWizardTitle("Starting DTrace Recording on " + this.m_server.getServerDescriptor().getDisplayName());
            this.startWizardInUI(wc);
        }
    }

    private DTraceRecorder createRemoteRecorder(MBeanServerConnection server) {
        try {
            return Factory.createRemoteDTraceRecorder((MBeanServerConnection)server);
        }
        catch (DTraceRecorderException e) {
            this.showError("Error when connecting to remote DTrace Recorder", (Exception)((Object)e));
            return null;
        }
    }

    private IConnectionHandle createConnection() {
        try {
            return this.m_server.connect("Start DTrace Recording");
        }
        catch (ConnectionException e) {
            this.showError("Error when creating remote connection. Could not establish connection DTrace Server. ", (Exception)((Object)e));
            return null;
        }
    }

    private void showError(final String message, final Exception e) {
        DisplayToolkit.safeSyncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                ExceptionDialog.openExceptionDialog((Shell)DTraceStartJob.this.getShell(), (String)"DTrace Recorder Error", (String)(String.valueOf(message) + (e != null ? "\n" + e.getLocalizedMessage() : "")), (Throwable)e, (boolean)true, (String)"com.jrockit.mc.dtrace.ui.about");
            }
        });
    }

    private Integer getPid() {
        return ServerToolkit.getPid((IServerHandle)this.m_server);
    }

    void startWizardInUI(final WizardConfig wc) {
        DisplayToolkit.safeSyncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                DTraceStartJob.this.showStartWizard(wc);
            }
        });
    }

    private void showStartWizard(WizardConfig wc) {
        Configuration c = DTraceUIPlugin.getDefault().getConfiguration();
        DtraceRecordingWizardPage rp = new DtraceRecordingWizardPage(c, wc);
        OnePageWizardDialog dialog = new OnePageWizardDialog(this.getShell(), (IWizardPage)rp);
        dialog.setTitle("Select a template and click OK to start a recording");
        dialog.setWidthConstraint(700, 800);
        dialog.setHeightConstraint(500, 600);
        int returnCode = dialog.open();
        if (returnCode == 0) {
            ScriptModel script = rp.getScript();
            if (script != null) {
                this.startWithScript(wc, script);
            }
        } else {
            IOToolkit.closeSilently((Closeable)wc.getConnectionHandle());
        }
    }

    private void startWithScript(WizardConfig wc, ScriptModel script) {
        StringWriter sw = new StringWriter();
        PrintWriter p = new PrintWriter((Writer)sw, false);
        CodeGenerator cg = new CodeGenerator(script, p);
        SimpleProgress sp = new SimpleProgress();
        if (!cg.generate((IProgress)sp)) {
            this.showCompilationErrorDialog(sp);
            IOToolkit.closeSilently((Closeable)wc.getConnectionHandle());
        } else {
            this.startRecordingJob(wc, script, sw);
        }
    }

    private void startRecordingJob(final WizardConfig wc, ScriptModel script, StringWriter sw) {
        String sourceCode = sw.toString();
        String metadata = PersistenceToolkit.exportToString((Object)script.getMetadata());
        RecordingOptions options = this.createRecordingOptions(script.getSelectedTemplate());
        DTraceRecordingJob job = new DTraceRecordingJob(wc.getRecorder(), options, sourceCode, metadata);
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                IOToolkit.closeSilently((Closeable)wc.getConnectionHandle());
            }
        });
        job.schedule();
    }

    private Shell getShell() {
        return this.m_shell;
    }

    private RecordingOptions createRecordingOptions(TemplateDescriptor templateDescriptor) {
        RecordingOptions ro = new RecordingOptions();
        Parameter recordingTime = templateDescriptor.getRecordingTime();
        ro.setRecordingTime(Long.parseLong(recordingTime.getLastValue()));
        Parameter bufferPolicy = templateDescriptor.getBufferPolicy();
        ro.setBufferPolicy(bufferPolicy.getLastValue());
        for (Parameter p : templateDescriptor.getParameters()) {
            if (!"process".equals(p.getType())) continue;
            ro.setProcessIdentifier(Integer.parseInt(p.getLastValue()));
        }
        return ro;
    }

    private void showCompilationErrorDialog(final SimpleProgress progress) {
        DisplayToolkit.safeSyncExec((Widget)this.getShell(), (Runnable)new Runnable(){

            @Override
            public void run() {
                CompilationErrorDialog.show(DTraceStartJob.this.getShell(), progress);
            }
        });
    }
}

