/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.dtrace.ui;

import com.jrockit.mc.common.io.IOToolkit;
import com.jrockit.mc.core.StatusFactory;
import com.jrockit.mc.dtrace.recorder.DTraceRecorder;
import com.jrockit.mc.dtrace.recorder.RecordingDescriptor;
import com.jrockit.mc.dtrace.recorder.RecordingOptions;
import com.jrockit.mc.dtrace.recorder.RecordingState;
import com.jrockit.mc.dtrace.ui.input.BackgroundInput;
import com.jrockit.mc.dtrace.ui.parser.text.chunk.Runner;
import com.jrockit.mc.dtrace.ui.parser.text.chunk.UglyHack;
import com.jrockit.mc.dtrace.ui.parser.text.input.CharacterChunk;
import com.jrockit.mc.dtrace.ui.parser.text.input.CharacterStreamInput;
import com.jrockit.mc.ui.MCPathEditorInput;
import com.jrockit.mc.ui.WorkbenchToolkit;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.IPathEditorInput;

public final class DTraceRecordingJob
extends Job {
    private final DTraceRecorder m_recorder;
    private final String m_script;
    private final String m_metadata;
    private final RecordingOptions m_options;
    private volatile File m_file;

    public DTraceRecordingJob(DTraceRecorder recorder, RecordingOptions options, String script, String metadata) {
        super("DTrace Recording");
        this.m_recorder = recorder;
        this.m_script = script;
        this.m_metadata = metadata;
        this.m_options = options;
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            block7: {
                RecordingDescriptor rStart = this.m_recorder.startRecording(this.m_script, this.m_metadata, this.m_options);
                try {
                    RecordingDescriptor rEnd = this.waitForRecordingToComplete(monitor, rStart);
                    if (rEnd == null) break block7;
                    try {
                        if (rEnd.getFile().toString().length() == 0) {
                            return StatusFactory.createErr((String)"No recording file could be produced.\n\nMake sure the OS supports DTrace and that access privileges are set correctly. Also look at the output from dtracerecorder to see if it contains any error messages.");
                        }
                        this.transferFile(rStart, monitor);
                        WorkbenchToolkit.asyncOpenEditor((IPathEditorInput)new MCPathEditorInput(this.m_file));
                    }
                    catch (IOException e) {
                        return StatusFactory.createErr((String)"Error transfering recording.", (Throwable)e, (boolean)true);
                    }
                }
                catch (RuntimeException re) {
                    return StatusFactory.createErr((String)"Error completing recording.", (Throwable)re, (boolean)true);
                }
            }
            return StatusFactory.createOk((String)"Recording complete.");
        }
        catch (IOException e) {
            return StatusFactory.createErr((String)"Error starting recording.", (Throwable)e, (boolean)true);
        }
    }

    private void transferFile(RecordingDescriptor rd, IProgressMonitor monitor) throws IOException {
        File file = new File(String.valueOf(System.getProperty("user.home")) + "/recording.jar");
        monitor.beginTask("Transfering recording", 1);
        InputStream is = this.m_recorder.openStream(rd);
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(file));
        try {
            IOToolkit.copy((InputStream)is, (OutputStream)os);
        }
        finally {
            IOToolkit.closeSilently((Closeable)os);
        }
        monitor.worked(1);
        monitor.beginTask("Find events out of order", 1);
        JarFile jarFile = new JarFile(file);
        ZipEntry logEntry = jarFile.getEntry("log.clf");
        ZipEntry metadataEntry = jarFile.getEntry("metadata.xml");
        InputStream logInputStream = null;
        InputStream metadataInputStream = null;
        FileOutputStream fos = null;
        JarOutputStream jos = null;
        BufferedInputStream allSortedIs = null;
        try {
            logInputStream = jarFile.getInputStream(logEntry);
            metadataInputStream = jarFile.getInputStream(metadataEntry);
            if (logInputStream != null && metadataInputStream != null) {
                BackgroundInput<CharacterChunk> unSortedInputStream = new BackgroundInput<CharacterChunk>(new CharacterStreamInput(logInputStream), 2);
                File allSortedOutput = new File(String.valueOf(System.getProperty("user.home")) + "/allSorted.clf");
                UglyHack uh = new UglyHack(allSortedOutput);
                Runner uhRunner = new Runner(uh);
                uhRunner.run(unSortedInputStream);
                monitor.worked(1);
                monitor.beginTask("Repack recording", 1);
                this.m_file = new File(String.valueOf(System.getProperty("user.home")) + this.createUniqueName());
                fos = new FileOutputStream(this.m_file);
                jos = new JarOutputStream(fos);
                jos.putNextEntry(new ZipEntry(logEntry.getName()));
                allSortedIs = new BufferedInputStream(new FileInputStream(allSortedOutput));
                IOToolkit.copy((InputStream)allSortedIs, (OutputStream)jos);
                jos.putNextEntry(new ZipEntry(metadataEntry.getName()));
                IOToolkit.copy((InputStream)metadataInputStream, (OutputStream)jos);
                jos.close();
            }
        }
        finally {
            IOToolkit.closeSilently((ZipFile)jarFile);
            IOToolkit.closeSilently((Closeable)logInputStream);
            IOToolkit.closeSilently((Closeable)metadataInputStream);
            IOToolkit.closeSilently(allSortedIs);
            IOToolkit.closeSilently(jos);
            IOToolkit.closeSilently(fos);
        }
        monitor.worked(1);
        monitor.done();
    }

    private String createUniqueName() {
        SimpleDateFormat sm = new SimpleDateFormat("yyyy-MM-dd_HH_mm_ss");
        return "/recording_" + sm.format(new Date(System.currentTimeMillis())) + ".dfr";
    }

    private RecordingDescriptor waitForRecordingToComplete(IProgressMonitor monitor, RecordingDescriptor rd) {
        RecordingDescriptor r;
        block0: while (true) {
            RecordingState state;
            this.takeNap();
            if (monitor.isCanceled()) {
                return null;
            }
            Iterator iterator = this.m_recorder.getAvailableRecordings().iterator();
            do {
                if (!iterator.hasNext()) continue block0;
            } while ((r = (RecordingDescriptor)iterator.next()).getIdentifier() != rd.getIdentifier() || (state = r.getRecordingState()) != RecordingState.FINISHED);
            break;
        }
        return r;
    }

    private void takeNap() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

