/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.dtrace.ui;

import com.jrockit.mc.core.CorePlugin;
import com.jrockit.mc.dtrace.ui.DTraceStartJob;
import com.jrockit.mc.dtrace.ui.InstallationFile;
import com.jrockit.mc.dtrace.ui.InstallationJob;
import com.jrockit.mc.dtrace.ui.WorkspaceInstallation;
import com.jrockit.mc.rjmx.IServerHandle;
import com.jrockit.mc.ui.UIPlugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class DTraceRecording {
    public static void start(IServerHandle serverHandle) {
        if (serverHandle != null) {
            Shell shell = UIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell();
            DTraceStartJob startJob = new DTraceStartJob(shell, serverHandle);
            if (WorkspaceInstallation.INSTANCE.checkForInstallation() && DTraceRecording.askForInstallation(shell)) {
                InstallationJob i = new InstallationJob(shell, startJob);
                i.schedule();
                return;
            }
            startJob.schedule();
        }
    }

    private static boolean askForInstallation(Shell shell) {
        String title = "DTrace Recorder Installation";
        String message = "Could not find DTrace Recorder files in your workspace. Do you want the files to be copied there? ";
        message = String.valueOf(message) + "Your workspace directory is located at: " + CorePlugin.getDefault().getWorkspaceDirectory() + "\n\n";
        for (InstallationFile iFile : WorkspaceInstallation.INSTANCE.getInstallableFiles()) {
            message = String.valueOf(message) + iFile.destinationName + " - " + iFile.description + "\n\n";
        }
        message = String.valueOf(message) + "For more information on how to use DTrace Recorder see the Mission Control help.";
        return MessageDialog.open((int)3, (Shell)shell, (String)title, (String)message, (int)0);
    }
}

