/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.common;

import java.lang.reflect.Executable;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.common.LoadBalancer;
import oracle.ucp.common.Service;
import oracle.ucp.logging.ClioSupport;
import oracle.ucp.util.RingBuffer;

@DefaultLogger(value="oracle.ucp.common")
@Supports(value={Feature.LOAD_BALANCING, Feature.HIGH_AVAILABILITY})
public class ServiceMember {
    public static final String NONAME_INSTANCE = "***noname***";
    public static final int ADVISED_LOAD_RING_SIZE = 6;
    public static final int PEAK_BORROW_RING_SIZE = 3;
    private Key memberKey = null;
    private final String name;
    private String database = null;
    private String serviceName = null;
    private String host = null;
    private AtomicInteger dbInstanceId = new AtomicInteger(0);
    private String dbUniqueId = null;
    public final Service serviceRef;
    public final AtomicInteger activeCount = new AtomicInteger(0);
    public final AtomicInteger borrowedCount = new AtomicInteger(0);
    final AtomicInteger pendingCloseCount = new AtomicInteger(0);
    private final AtomicBoolean active = new AtomicBoolean(true);
    final AtomicBoolean affined = new AtomicBoolean(true);
    final AtomicBoolean violating = new AtomicBoolean(false);
    private final AtomicInteger id = new AtomicInteger(-1);
    public final LoadBalancer.Stats lbStats = new LoadBalancer.Stats();
    private final AdvisedLoadHistory advisedLoadHistory = new AdvisedLoadHistory();
    private final RingBuffer<Integer> peakBorrowsHistory = new RingBuffer(3);
    final AtomicInteger connsToRebalance = new AtomicInteger(0);
    private boolean isRLBHistoryClean = true;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;

    public ServiceMember(Properties connProps, Service service) {
        this(connProps.getProperty("INSTANCE_NAME", NONAME_INSTANCE), connProps.getProperty("DATABASE_NAME", ""), connProps.getProperty("SERVER_HOST", ""), connProps.getProperty("SERVICE_NAME", ""), connProps.getProperty("AUTH_GLOBALLY_UNIQUE_DBID", ""), connProps.getProperty("AUTH_SC_INSTANCE_ID", ""), service);
    }

    public ServiceMember(String name, String database, String host, String serviceName, Service service) {
        this(name, database, host, serviceName, null, "0", service);
    }

    private ServiceMember(String name, String database, String host, String serviceName, String dbUniqueId, String instIdStr, Service service) {
        this.name = null == name || "".equals(name) ? NONAME_INSTANCE : ServiceMember.toLowerCase(name);
        this.database = ServiceMember.toLowerCase(database);
        this.host = ServiceMember.toLowerCase(host);
        this.serviceName = ServiceMember.toLowerCase(serviceName);
        this.dbInstanceId.set(Integer.parseInt(instIdStr.isEmpty() ? "0" : instIdStr));
        this.serviceRef = service;
        this.dbUniqueId = dbUniqueId;
        this.memberKey = new Key(this.name, this.database, this.host, this.serviceName);
    }

    public Key key() {
        return this.memberKey;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ServiceMember) {
            return this.key().equals(((ServiceMember)obj).key());
        }
        return false;
    }

    public int hashCode() {
        return this.key().hashCode();
    }

    public void saveAdvisedLoad(float load) {
        this.advisedLoadHistory.addItem(Float.valueOf(load));
        this.isRLBHistoryClean = false;
    }

    public void clearRLBHistory() {
        ClioSupport.ilogFinest(null, null, null, null, "Clearing RLB advised load and peak borrow history");
        this.isRLBHistoryClean = true;
        this.advisedLoadHistory.clear();
        this.peakBorrowsHistory.clear();
    }

    public void savePeakBorrows() {
        this.peakBorrowsHistory.addItem(this.lbStats.peakBorrows.delta());
        ClioSupport.ilogFinest(null, null, null, null, "peakBorrowHistory=" + this.peakBorrowsHistory.getAsList() + (this.peaked() ? ", " : ", un") + "peaked");
    }

    boolean isRLBHistoryClean() {
        return this.isRLBHistoryClean;
    }

    public float averageAdvisedLoad() {
        return this.advisedLoadHistory.averageAdvisedLoad();
    }

    float averageAdvisedLoad(ConnectionRetrievalInfo cri, Collection<ServiceMember> allMembers) {
        if (cri == null) {
            return this.averageAdvisedLoad();
        }
        float totalAdvisedLoad = (float)allMembers.stream().mapToDouble(sm -> sm.averageAdvisedLoad()).sum();
        return this.averageAdvisedLoad() / totalAdvisedLoad * 100.0f;
    }

    public boolean peaked() {
        List<Integer> list = this.peakBorrowsHistory.getAsList();
        int ac = this.activeCount.get();
        int sumBorrowed = 0;
        if (!this.active.get()) {
            return false;
        }
        if (ac == 0) {
            for (int bc : list) {
                sumBorrowed += bc;
            }
            if (sumBorrowed == 0) {
                return false;
            }
        }
        boolean peaked = true;
        for (int pb : list) {
            if (pb >= ac) continue;
            peaked = false;
            break;
        }
        return peaked;
    }

    void initId() {
        this.id.compareAndSet(-1, this.serviceRef.idCount.getAndIncrement());
    }

    public boolean active() {
        return this.active.get();
    }

    public void markActive(boolean active) {
        if (this.active.compareAndSet(!active, active)) {
            if (active) {
                this.serviceRef.activeMembers.getAndIncrement();
            } else {
                this.serviceRef.activeMembers.getAndDecrement();
            }
            ClioSupport.ilogFinest(null, null, null, null, "about to interrupt pending connection creation operations");
            this.serviceRef.interruptPendingCreations();
        }
    }

    @DisableTrace
    public String name() {
        return this.name;
    }

    @DisableTrace
    public String database() {
        return null == this.database ? "" : this.database;
    }

    @DisableTrace
    public String service() {
        return null == this.serviceName ? "" : this.serviceName;
    }

    @DisableTrace
    public String host() {
        return null == this.host ? "" : this.host;
    }

    @DisableTrace
    public String dbUniqueId() {
        return null == this.dbUniqueId ? "" : this.dbUniqueId;
    }

    @DisableTrace
    public int dbInstanceId() {
        return this.dbInstanceId.get();
    }

    @DisableTrace
    public void markAffined(boolean affined) {
        this.affined.set(affined);
    }

    @DisableTrace
    public boolean affined() {
        return this.affined.get();
    }

    @DisableTrace
    public boolean violating() {
        return this.violating.get();
    }

    @DisableTrace
    public void markViolating(boolean violating) {
        this.violating.set(violating);
    }

    @DisableTrace
    public int id() {
        return this.id.get();
    }

    @DisableTrace
    public String toString() {
        return this.name() + ",db=" + this.database() + ",service=" + this.service() + ",host=" + this.host() + ":(activeCount:" + this.activeCount.get() + ",borrowedCount:" + this.borrowedCount.get() + ",active:" + this.active.get() + ",aff=" + this.affined.get() + ",violating=" + this.violating.get() + ",id=" + this.id.get() + ')';
    }

    private static String toLowerCase(String s) {
        return null == s ? null : s.toLowerCase();
    }

    boolean violatingRLBAdvisory() {
        float instanceLoad;
        if (!this.active()) {
            return false;
        }
        if (this.advisedLoadHistory.isEmpty()) {
            return false;
        }
        float advisedLoad = this.averageAdvisedLoad();
        long instBorrowedTime = this.lbStats.borrowTimes.totalDelta();
        long totalBorrowedTime = this.serviceRef.lbStats.borrowTimes.totalDelta();
        float f = instanceLoad = 0L != totalBorrowedTime ? (float)instBorrowedTime * 100.0f / (float)totalBorrowedTime : 0.0f;
        return !(instanceLoad <= advisedLoad);
    }

    public long totalBorrowTimes() {
        return this.lbStats.borrowTimes.totalDelta();
    }

    static {
        try {
            $$$methodRef$$$19 = ServiceMember.class.getDeclaredConstructor(String.class, String.class, String.class, String.class, String.class, String.class, Service.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$18 = ServiceMember.class.getDeclaredConstructor(String.class, String.class, String.class, String.class, Service.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$17 = ServiceMember.class.getDeclaredConstructor(Properties.class, Service.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$16 = ServiceMember.class.getDeclaredMethod("lambda$averageAdvisedLoad$0", ServiceMember.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$15 = ServiceMember.class.getDeclaredMethod("totalBorrowTimes", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$14 = ServiceMember.class.getDeclaredMethod("violatingRLBAdvisory", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$13 = ServiceMember.class.getDeclaredMethod("toLowerCase", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$12 = ServiceMember.class.getDeclaredMethod("markActive", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$11 = ServiceMember.class.getDeclaredMethod("active", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$10 = ServiceMember.class.getDeclaredMethod("initId", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$9 = ServiceMember.class.getDeclaredMethod("peaked", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$8 = ServiceMember.class.getDeclaredMethod("averageAdvisedLoad", ConnectionRetrievalInfo.class, Collection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$7 = ServiceMember.class.getDeclaredMethod("averageAdvisedLoad", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$6 = ServiceMember.class.getDeclaredMethod("isRLBHistoryClean", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$5 = ServiceMember.class.getDeclaredMethod("savePeakBorrows", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$4 = ServiceMember.class.getDeclaredMethod("clearRLBHistory", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$3 = ServiceMember.class.getDeclaredMethod("saveAdvisedLoad", Float.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$2 = ServiceMember.class.getDeclaredMethod("hashCode", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$1 = ServiceMember.class.getDeclaredMethod("equals", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$0 = ServiceMember.class.getDeclaredMethod("key", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
    }

    private class AdvisedLoadHistory {
        private RingBuffer<Float> history = new RingBuffer(6);
        private volatile float averageAdvisedLoad = 0.0f;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;
        private static Executable $$$methodRef$$$5;
        private static Logger $$$loggerRef$$$5;
        private static Executable $$$methodRef$$$6;
        private static Logger $$$loggerRef$$$6;
        private static Executable $$$methodRef$$$7;
        private static Logger $$$loggerRef$$$7;
        private static Executable $$$methodRef$$$8;
        private static Logger $$$loggerRef$$$8;
        private static Executable $$$methodRef$$$9;
        private static Logger $$$loggerRef$$$9;
        private static Executable $$$methodRef$$$10;
        private static Logger $$$loggerRef$$$10;

        private AdvisedLoadHistory() {
        }

        private void addItem(Float load) {
            this.history.addItem(load);
            this.computeAverageAdvisedLoad();
            ClioSupport.ilogFinest(null, null, null, null, "advisedLoadHistory=" + this.history.getAsList() + ", average=" + this.averageAdvisedLoad());
        }

        private void clear() {
            this.history.clear();
            this.computeAverageAdvisedLoad();
        }

        private void computeAverageAdvisedLoad() {
            List<Float> list = this.history.getAsList();
            if (list.isEmpty()) {
                int instanceCount = ServiceMember.this.serviceRef.activeMembers.get();
                this.averageAdvisedLoad = instanceCount == 0 ? 100.0f : 100.0f / (float)instanceCount;
            }
            float sumLoad = 0.0f;
            for (float load : list) {
                sumLoad += load;
            }
            this.averageAdvisedLoad = sumLoad / (float)list.size();
        }

        private float averageAdvisedLoad() {
            return this.averageAdvisedLoad;
        }

        private boolean isEmpty() {
            return this.history.getAsList().isEmpty();
        }

        static {
            try {
                $$$methodRef$$$10 = AdvisedLoadHistory.class.getDeclaredConstructor(ServiceMember.class, 1.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$9 = AdvisedLoadHistory.class.getDeclaredConstructor(ServiceMember.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$8 = AdvisedLoadHistory.class.getDeclaredMethod("access$400", AdvisedLoadHistory.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$7 = AdvisedLoadHistory.class.getDeclaredMethod("access$300", AdvisedLoadHistory.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$6 = AdvisedLoadHistory.class.getDeclaredMethod("access$200", AdvisedLoadHistory.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$5 = AdvisedLoadHistory.class.getDeclaredMethod("access$100", AdvisedLoadHistory.class, Float.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$4 = AdvisedLoadHistory.class.getDeclaredMethod("isEmpty", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$3 = AdvisedLoadHistory.class.getDeclaredMethod("averageAdvisedLoad", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$2 = AdvisedLoadHistory.class.getDeclaredMethod("computeAverageAdvisedLoad", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$1 = AdvisedLoadHistory.class.getDeclaredMethod("clear", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$0 = AdvisedLoadHistory.class.getDeclaredMethod("addItem", Float.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        }
    }

    @DisableTrace
    static class Key {
        private final String key;

        Key(String inst, String db, String host, String service) {
            this.key = this.norm(inst) + ':' + this.norm(db) + ':' + this.norm(service);
        }

        private String norm(String str) {
            return null != str ? str : "";
        }

        public int hashCode() {
            return this.key.hashCode();
        }

        public boolean equals(Object that) {
            if (that instanceof Key) {
                Key thatKey = (Key)that;
                return this.key.equals(thatKey.key);
            }
            return false;
        }

        public String toString() {
            return this.key;
        }
    }
}

