/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.util.builder;

import java.util.HashMap;
import java.util.Vector;
import oracle.i18n.util.GDKOracleMetaData;
import oracle.i18n.util.builder.UnicodeMap;

public class UnicodeMapChar
extends UnicodeMap {
    static final long serialVersionUID = GDKOracleMetaData.getOracleVersionID();
    private static char flag_mask = (char)65280;
    private static char index_mask = (char)255;
    private char[] dataArray = null;
    private char[][] expandingTable = null;
    private char expanding_flag = (char)63488;
    private char surrogate_flag = (char)63744;

    public UnicodeMapChar(Vector vector) {
        if (vector == null) {
            return;
        }
        Vector vector2 = new Vector();
        int n = vector.size();
        char[] cArray = new char[65536];
        Vector vector3 = new Vector();
        for (int i = 0; i < n; ++i) {
            Object[] objectArray = (Object[])vector.elementAt(i);
            int[] nArray = (int[])objectArray[0];
            if (nArray.length == 1) {
                nArray = this.toUTF16(nArray[0]);
            }
            int[] nArray2 = (int[])objectArray[1];
            this.putMap(nArray, nArray2, cArray, vector2, vector3);
        }
        this.setSurrogateTable(vector2);
        this.setExpandingTable(vector3);
        this.setData(cArray);
    }

    public UnicodeMapChar(HashMap hashMap) {
        if (hashMap == null) {
            return;
        }
        Object[] objectArray = hashMap.keySet().toArray();
        Vector vector = new Vector();
        int n = objectArray.length;
        char[] cArray = new char[65536];
        Vector vector2 = new Vector();
        for (int i = 0; i < n; ++i) {
            Integer n2 = (Integer)objectArray[i];
            int n3 = n2;
            int[] nArray = this.toUTF16(n3);
            int[] nArray2 = (int[])hashMap.get(n2);
            this.putMap(nArray, nArray2, cArray, vector, vector2);
        }
        this.setSurrogateTable(vector);
        this.setExpandingTable(vector2);
        this.setData(cArray);
    }

    public UnicodeMapChar(char c, char c2, Vector vector) {
        this.expanding_flag = c;
        this.surrogate_flag = c2;
        if (vector == null) {
            return;
        }
        Vector vector2 = new Vector();
        int n = vector.size();
        char[] cArray = new char[65536];
        Vector vector3 = new Vector();
        for (int i = 0; i < n; ++i) {
            Object[] objectArray = (Object[])vector.elementAt(i);
            int[] nArray = (int[])objectArray[0];
            if (nArray.length == 1) {
                nArray = this.toUTF16(nArray[0]);
            }
            int[] nArray2 = (int[])objectArray[1];
            this.putMap(nArray, nArray2, cArray, vector2, vector3);
        }
        this.setSurrogateTable(vector2);
        this.setExpandingTable(vector3);
        this.setData(cArray);
    }

    public UnicodeMapChar(char c, char c2, HashMap hashMap) {
        this.expanding_flag = c;
        this.surrogate_flag = c2;
        if (hashMap == null) {
            return;
        }
        Object[] objectArray = hashMap.keySet().toArray();
        Vector vector = new Vector();
        int n = objectArray.length;
        char[] cArray = new char[65536];
        Vector vector2 = new Vector();
        for (int i = 0; i < n; ++i) {
            Integer n2 = (Integer)objectArray[i];
            int n3 = n2;
            int[] nArray = this.toUTF16(n3);
            int[] nArray2 = (int[])hashMap.get(n2);
            this.putMap(nArray, nArray2, cArray, vector, vector2);
        }
        this.setSurrogateTable(vector);
        this.setExpandingTable(vector2);
        this.setData(cArray);
    }

    public char[] getMapping(char c) {
        char c2 = this.getData(c);
        char c3 = (char)(c2 & flag_mask);
        char[] cArray = null;
        if (c3 == this.expanding_flag) {
            int n = c2 & index_mask;
            int n2 = this.expandingTable[n].length;
            cArray = new char[n2];
            System.arraycopy(this.expandingTable[n], 0, cArray, 0, n2);
        } else if (c3 != this.surrogate_flag) {
            cArray = new char[]{c2 != '\u0000' ? c2 : c};
        }
        return cArray;
    }

    public String getMapping(String string) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        while (n2 < n) {
            char c;
            char c2;
            char c3;
            if ((c3 = (char)((c2 = this.getData(c = string.charAt(n2++))) & flag_mask)) == this.expanding_flag) {
                stringBuffer.append(this.expandingTable[c2 & index_mask]);
                continue;
            }
            if (c3 != this.surrogate_flag) {
                if (c2 != '\u0000') {
                    stringBuffer.append(c2);
                    continue;
                }
                stringBuffer.append(c);
                continue;
            }
            if (n2 == n) {
                stringBuffer.append(c);
                continue;
            }
            char c4 = string.charAt(n2);
            int n3 = c4 - 56320;
            if (n3 <= 0 || n3 >= 1023) {
                stringBuffer.append(c);
                continue;
            }
            ++n2;
            int n4 = this.surrogateTable[c2 & index_mask][n3];
            if (n4 == 0) {
                stringBuffer.append(c);
                stringBuffer.append(c4);
                continue;
            }
            char c5 = (char)(n4 >>> 16);
            char c6 = (char)(n4 & 0xFFFF);
            if (c5 != '\u0000') {
                stringBuffer.append(c5);
            }
            stringBuffer.append(c6);
        }
        return stringBuffer.toString();
    }

    public char[] getSurrogate(char c, char c2) {
        int n = c & 0xFFFF;
        int n2 = c2 & 0xFFFF;
        if (n < 55296 || n > 56319 || n2 < 56320 || n2 > 57343) {
            return null;
        }
        char c3 = this.getData(c);
        int n3 = this.surrogateTable[c3 & index_mask][c2 - 56320];
        char c4 = (char)(n3 >>> 16);
        char c5 = (char)(n3 & 0xFFFF);
        char[] cArray = c4 != '\u0000' ? new char[]{c4, c5} : (c5 != '\u0000' ? new char[]{c5} : new char[]{c, c2});
        return cArray;
    }

    private char getData(char c) {
        return this.dataArray[this.indexArray[c >>> 8] + (c & 0xFF)];
    }

    private void putMap(int[] nArray, int[] nArray2, char[] cArray, Vector vector, Vector vector2) {
        if (nArray.length == 1) {
            if (nArray2.length == 1) {
                cArray[nArray[0]] = (char)nArray2[0];
                return;
            }
            int n = vector2.size();
            cArray[nArray[0]] = (char)(this.expanding_flag + n);
            char[] cArray2 = new char[nArray2.length];
            for (int i = 0; i < nArray2.length; ++i) {
                cArray2[i] = (char)nArray2[i];
            }
            vector2.addElement(cArray2);
            return;
        }
        if (nArray[0] < 55296 || nArray[0] > 56319 || nArray[1] < 56320 || nArray[1] > 57343) {
            System.out.println("NLT error -- invalid surrogate code points");
        } else {
            int n = nArray[0] - 55296;
            int n2 = nArray[1] - 56320;
            int[] nArray3 = null;
            if (cArray[nArray[0]] == '\u0000') {
                char c;
                nArray3 = new int[1024];
                int n3 = vector.size();
                cArray[nArray[0]] = c = (char)(this.surrogate_flag + n3);
                vector.addElement(nArray3);
            } else {
                int n4 = cArray[nArray[0]] & index_mask;
                nArray3 = (int[])vector.elementAt(n4);
            }
            if (nArray2.length == 1) {
                nArray3[n2] = nArray2[0];
            } else if (nArray2.length == 2) {
                nArray3[n2] = nArray2[0] << 16 + nArray2[1] & 0xFFFF;
            }
        }
    }

    private void setExpandingTable(Vector vector) {
        if (vector == null || vector.size() == 0) {
            return;
        }
        int n = vector.size();
        this.expandingTable = new char[n][];
        for (int i = 0; i < n; ++i) {
            if (i == 240) {
                System.out.println(i);
            }
            char[] cArray = (char[])vector.elementAt(i);
            this.expandingTable[i] = new char[cArray.length];
            for (int j = 0; j < cArray.length; ++j) {
                this.expandingTable[i][j] = cArray[j];
            }
        }
    }

    private void setData(char[] cArray) {
        this.indexArray = new int[256];
        int n = this.compressCharArray(cArray, this.indexArray);
        this.dataArray = new char[n];
        System.arraycopy(cArray, 0, this.dataArray, 0, n);
    }

    private int compressCharArray(char[] cArray, int[] nArray) {
        nArray[0] = 0;
        int n = 256;
        for (int i = 1; i < 256; ++i) {
            int n2;
            int n3;
            for (n3 = 0; n3 < n; ++n3) {
                int n4;
                char c;
                char c2;
                for (n2 = 0; n2 < (256 < n - n3 ? 256 : n - n3) && (c2 = cArray[n3 + n2]) == (c = cArray[(n4 = i << 8) | n2]); ++n2) {
                }
                if (n2 == (256 < n - n3 ? 256 : n - n3)) break;
            }
            nArray[i] = (short)n3;
            for (n2 = (i << 8) + (n - n3); n2 < i + 1 << 8; ++n2) {
                cArray[n++] = cArray[n2];
            }
        }
        return n;
    }

    private int[] toUTF16(int n) {
        int[] nArray = new int[1];
        if ((n & 0xFFFF0000) != 0) {
            nArray = new int[]{(n & 0xFFFF0000) >>> 16, n & 0xFFFF};
        } else {
            nArray[0] = n;
        }
        return nArray;
    }

    private void statistic() {
        System.out.println("dataArray length is " + this.dataArray.length);
        System.out.println("expanding table length is  " + this.expandingTable.length);
        System.out.println("surrogate table length is " + this.surrogateTable.length);
        System.out.println("surrogate table block length is " + this.surrogateTable[0].length);
    }
}

