@echo off
REM =========================
REM ODAC XCOPY INSTALL SCRIPT
REM =========================
REM 
REM  This batch file installs components in an Oracle Instant Client Home
REM 
REM  ====================
REM  MODIFICATION HISTORY
REM  ====================
REM  
REM  06/04/22 - xcopyAll with Global Option

goto :ParseArgs


REM **********************
REM INSTALL ALL COMPONENTS
REM **********************
:InstallAll
REM installing everything so set DEP to false or else dependencies such as 
REM basic client will get installed needlessly by each component
set DEP=false
set InstallAll=true
call :basic %1 %2 %3 %4 %5 %6
call :odp.net4 %1 %2 %3 %4 %5 %6
call :oledb %1 %2 %3 %4 %5 %6
call :oledbolap %1 %2 %3 %4 %5 %6
call :oramts %1 %2 %3 %4 %5 %6
call :EndOfInstall
goto :EOF



REM ***********************************
REM INSTALL Basic Oracle Instant Client
REM ***********************************

:basic

REM echo Please wait... installing Basic Oracle Instant Client

echo ************************************** >> %2\install.log
echo Installing Basic Oracle Instant Client >> %2\install.log
echo ************************************** >> %2\install.log

REM copy the files
xcopy instantclient %2 /E /F /R /Y >> %2\install.log

echo.>> %2\install.log

pushd %2

call configure.bat basic %3 %MACHINE_WIDE_CONFIG% %6

popd

echo.>> %2\install.log
echo ************************************* >> %2\install.log
echo Basic Oracle Instant Client installed >> %2\install.log
echo ************************************* >> %2\install.log
echo.>> %2\install.log
REM echo Basic Oracle Instant Client installed.
REM echo.
REM echo Please prepend %2 and %2\bin to system path environment variable

if /i {%1} == {basic} call :EndOfInstall

goto :EOF


REM *****************
REM INSTALL ODP.NET 4
REM *****************

:odp.net4

REM echo Please wait... installing Oracle Data Provider for .NET 4

if {%DEP%} == {true} (
call :basic %1 %2 %3 %4
)

echo ****************************************** >> %2\install.log
echo Installing Oracle Data Provider for .NET 4 >> %2\install.log
echo ****************************************** >> %2\install.log

REM copy the files
xcopy odp.net4 %2 /E /F /R /Y >> %2\install.log

echo.>> %2\install.log

pushd %2

REM not calling configure.bat as follows since on Win2k when dir names contain 
REM a space it has issues when retreiving CURRENT DIR in configure.bat
REM call %2\configure.bat odp.net4 %3

call configure.bat odp.net4 %3 %DEP% %MACHINE_WIDE_CONFIG% %6

popd

echo.>> %2\install.log
echo ***************************************** >> %2\install.log
echo Oracle Data Provider for .NET 4 installed >> %2\install.log
echo ***************************************** >> %2\install.log
echo.>> %2\install.log
REM echo Oracle Data Provider for .NET 4 installed in an Oracle Instant Client Home.

if {%InstallAll%} == {false} call :EndOfInstall

goto :EOF



REM *************
REM INSTALL OLEDB
REM *************

:oledb

REM echo Please wait... installing Oracle Provider for OLEDB

if {%DEP%} == {true} (
call :basic %1 %2 %3 %4
)

echo ************************************* >> %2\install.log
echo Installing Oracle Provider for OLE DB >> %2\install.log
echo ************************************* >> %2\install.log

REM copy the files
xcopy oledb %2 /E /F /R /Y >> %2\install.log

echo.>> %2\install.log

pushd %2

REM not calling configure.bat as follows since on Win2k when dir names contain 
REM a space it has issues when retreiving CURRENT DIR in configure.bat
REM call %2\configure.bat oledb %3

call configure.bat oledb %3 %DEP% %MACHINE_WIDE_CONFIG% %6

popd

echo.>> %2\install.log
echo ************************************ >> %2\install.log
echo Oracle Provider for OLE DB installed >> %2\install.log
echo ************************************ >> %2\install.log
echo.>> %2\install.log
REM echo Oracle Provider for OLEDB installed in an Oracle Instant Client Home.

if {%InstallAll%} == {false} call :EndOfInstall

goto :EOF



REM ******************
REM INSTALL OLEDB OLAP
REM ******************

:oledbolap

REM echo Please wait... installing Oracle Provider for OLEDB OLAP

if {%DEP%} == {true} (
call :basic %1 %2 %3 %4
)

echo ****************************************** >> %2\install.log
echo Installing Oracle Provider for OLE DB OLAP >> %2\install.log
echo ****************************************** >> %2\install.log

REM copy the files
xcopy oledbolap %2 /E /F /R /Y >> %2\install.log

echo.>> %2\install.log

pushd %2

REM not calling configure.bat as follows since on Win2k when dir names contain 
REM a space it has issues when retreiving CURRENT DIR in configure.bat
REM call %2\configure.bat oledbolap %3

call configure.bat oledbolap %3 %DEP% %MACHINE_WIDE_CONFIG% %6

popd

echo.>> %2\install.log
echo ***************************************** >> %2\install.log
echo Oracle Provider for OLE DB OLAP installed >> %2\install.log
echo ***************************************** >> %2\install.log
echo.>> %2\install.log
REM echo Oracle Provider for OLEDB OLAP installed in an Oracle Instant Client Home.

if {%InstallAll%} == {false} call :EndOfInstall

goto :EOF





REM **************
REM INSTALL ORAMTS
REM **************

:oramts

REM echo Please wait... installing Oracle Services for MTS

if {%DEP%} == {true} (
call :basic %1 %2 %3 %4
)

echo ********************************** >> %2\install.log
echo Installing Oracle Services for MTS >> %2\install.log
echo ********************************** >> %2\install.log

REM copy the files
xcopy oramts %2 /E /F /R /Y >> %2\install.log

echo.>> %2\install.log

pushd %2


REM not calling configure.bat as follows since on Win2k when dir names contain 
REM a space it has issues when retreiving CURRENT DIR in configure.bat
REM call %2\configure.bat oramts %3

call configure.bat oramts %3 %DEP% %MACHINE_WIDE_CONFIG% %6

popd

echo.>> %2\install.log
echo ********************************* >> %2\install.log
echo Oracle Services for MTS installed >> %2\install.log
echo ********************************* >> %2\install.log
echo.>> %2\install.log
REM echo Oracle Services for MTS installed in an Oracle Instant Client Home.

if {%InstallAll%} == {false} call :EndOfInstall

goto :EOF



REM **************
REM END OF INSTALL
REM **************

:EndOfInstall

echo Please review the README for information on securing the ODAC Xcopy installation.

goto :EOF



REM =======================
REM Parse Script Arguments
REM =======================
:ParseArgs
if /i {%1} == {} goto :Usage
if /i {%2} == {} goto :Usage
if /i {%3} == {} goto :Usage
if /i {%1} == {-h} goto :Usage
if /i {%1} == {-help} goto :Usage

REM install dependencies or not - default is true
set DEP=true
if /i {%4} == {false} set DEP=false

REM configure machine wide or not - default is false
set MACHINE_WIDE_CONFIG=false
if /i {%5} == {true} set MACHINE_WIDE_CONFIG=true

if NOT EXIST %2\*.* (
  mkdir %2 > NUL 2>&1
)

echo ****************** >> %2\install.log
echo ODAC install files >> %2\install.log
echo ****************** >> %2\install.log
REM /R to overwrite readonly files at destination
REM /Y to overwrite an existing file without prompting
xcopy configure.bat %2 /R /Y /F >> %2\install.log
xcopy unconfigure.bat %2 /R /Y /F >> %2\install.log
xcopy uninstall.bat %2 /R /Y /F >> %2\install.log
xcopy network\admin\sample\tnsnames.ora %2\network\admin\sample\ /R /Y /F >> %2\install.log
xcopy network\admin\sample\sqlnet.ora %2\network\admin\sample\ /R /Y /F >> %2\install.log

echo.>> %2\install.log

set InstallAll=false

if /i {%1} == {basic}     goto :basic
if /i {%1} == {odp.net4}  goto :odp.net4
if /i {%1} == {odp.net4}      goto :odp.net4
if /i {%1} == {oledb}     goto :oledb
if /i {%1} == {oledbolap} goto :oledbolap
if /i {%1} == {oramts}    goto :oramts
if /i {%1} == {all}       goto :InstallAll
goto :Usage


:Usage
echo.
echo Usage:
echo   install.bat component_name oracle_home_path oracle_home_name [install_dependents] [machine_wide_configuration] [tns_admin_location]
echo.
echo Example:
echo   install.bat all     c:\oracle myhome true         
echo   (install all components and their dependencies)
echo.
echo   install.bat odp.net4    c:\oracle myhome true true c:\tns
echo   (install and configure ODP.NET 4, Unmanaged Driver at the machine level, set TNS_ADMIN to c:\tns)
echo.
echo   install.bat oramts  c:\oracle myhome true
echo   (install ORAMTS and its dependent components)
echo.
echo   install.bat oledb     c:\oracle myhome true
echo   (install OraOLEDB and its dependent components)
echo.
echo   install.bat oledbolap c:\oracle myhome true
echo   (install OraOLEDB OLAP and its dependent components)
echo.
echo   install.bat basic   c:\oracle myhome false
echo   (install Oracle Instant Client)
echo.
echo NOTE: 
echo - By default, install_dependents=true and machine_wide_configuration=false.
echo - machine_wide_configuration only applies to odp.net4 component.
echo - In order to specify tns_admin_location, machine_wide_configuration and install_dependents have to be specified.
goto :EOF
