/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.SQLException;
import java.util.logging.Level;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleInputStream;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.RawCommonAccessor;

class LongRawAccessor
extends RawCommonAccessor {
    private static final String CLASS_NAME = LongRawAccessor.class.getName();
    static final int MAXLENGTH = Integer.MAX_VALUE;
    OracleInputStream stream;
    int columnPosition = 0;

    LongRawAccessor(OracleStatement stmt, int column_pos, int max_len, short form, int external_type, boolean isOutBind, boolean isStoredInBindData) throws SQLException {
        super(stmt, Integer.MAX_VALUE, isStoredInBindData);
        this.init(stmt, 24, 24, form, isOutBind);
        this.columnPosition = column_pos;
        this.initForDataAccess(external_type, max_len, null);
    }

    LongRawAccessor(OracleStatement stmt, int column_pos, int max_len, boolean nullable, int flags, int precision, int scale, long contflag, int total_elems, short form) throws SQLException {
        super(stmt, Integer.MAX_VALUE, false);
        this.init(stmt, 24, 24, form, false);
        this.columnPosition = column_pos;
        this.initForDescribe(24, max_len, nullable, flags, precision, scale, contflag, total_elems, form, null);
        int max_field_size = stmt.maxFieldSize;
        if (max_field_size > 0 && (max_len == 0 || max_field_size < max_len)) {
            max_len = max_field_size;
        }
        this.initForDataAccess(0, max_len, null);
    }

    @Override
    void initForDataAccess(int external_type, int max_len, String typeName) throws SQLException {
        if (external_type != 0) {
            this.externalType = external_type;
        }
        this.isStream = true;
        this.isColumnNumberAware = true;
        this.byteLength = 0;
        this.stream = this.statement.connection.driverExtension.createInputStream(this.statement, this.columnPosition, this);
        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "initForDataAccess", "columnPosition={0}, stream={1}. ", (String)null, (Throwable)null, (Object)this.columnPosition, (Object)this.stream);
    }

    @Override
    OracleInputStream initForNewRow() throws SQLException {
        this.debugp(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "initForNewRow", "accessor={0}, old stream={1}. ", null, null, () -> new Object[]{this.toString(), this.stream});
        this.stream = this.statement.connection.driverExtension.createInputStream(this.statement, this.columnPosition, this);
        this.debugp(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "initForNewRow", "accessor={0},new stream={1}. ", null, null, () -> new Object[]{this.toString(), this.stream});
        return this.stream;
    }

    @Override
    void updateColumnNumber(int colNumber) {
        this.columnPosition = ++colNumber;
        if (this.stream != null) {
            this.stream.columnIndex = colNumber;
        }
    }

    @Override
    byte[] getBytesInternal(int currentRow) throws SQLException {
        if (this.isNull(currentRow)) {
            return null;
        }
        if (this.statement.isFetchStreams) {
            return super.getBytesInternal(currentRow);
        }
        if (this.stream == null) {
            return null;
        }
        if (!this.isStream) {
            return super.getBytesInternal(currentRow);
        }
        if (this.stream.closed) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 27).fillInStackTrace();
        }
        ByteArrayOutputStream outs = new ByteArrayOutputStream(1024);
        byte[] buffer = new byte[1024];
        try {
            int length;
            while ((length = this.stream.readInternal(buffer)) != -1) {
                outs.write(buffer, 0, length);
            }
        }
        catch (IOException e) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), e).fillInStackTrace();
        }
        return outs.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InputStream convertBytesToStream(int currentRow, int conversion) throws SQLException {
        ByteArrayInputStream is = new ByteArrayInputStream(this.getBytesInternal(currentRow));
        try {
            InputStream result;
            InputStream inputStream = result = this.statement.connection.conversion.ConvertStream(is, conversion, this.statement.connection);
            return inputStream;
        }
        finally {
            try {
                if (is != null) {
                    ((InputStream)is).close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    InputStream getAsciiStream(int currentRow) throws SQLException {
        PhysicalConnection conn = this.statement.connection;
        if (this.isNull(currentRow)) {
            return null;
        }
        if (this.statement.isFetchStreams) {
            return this.convertBytesToStream(currentRow, 2);
        }
        if (this.stream.closed) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 27).fillInStackTrace();
        }
        return conn.conversion.ConvertStream(this.stream, 2, conn);
    }

    @Override
    InputStream getUnicodeStream(int currentRow) throws SQLException {
        PhysicalConnection conn = this.statement.connection;
        if (this.isNull(currentRow)) {
            return null;
        }
        if (this.statement.isFetchStreams) {
            return this.convertBytesToStream(currentRow, 3);
        }
        if (this.stream.closed) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 27).fillInStackTrace();
        }
        return conn.conversion.ConvertStream(this.stream, 3, conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Reader getCharacterStream(int currentRow) throws SQLException {
        if (this.isNull(currentRow)) {
            return null;
        }
        if (this.statement.isFetchStreams) {
            ByteArrayInputStream is = new ByteArrayInputStream(this.getBytesInternal(currentRow));
            try {
                Reader result;
                PhysicalConnection conn = this.statement.connection;
                Reader reader = result = this.statement.connection.conversion.ConvertCharacterStream(is, 8, this.formOfUse, conn);
                return reader;
            }
            finally {
                try {
                    if (is != null) {
                        ((InputStream)is).close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        if (this.stream.closed) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 27).fillInStackTrace();
        }
        PhysicalConnection conn = this.statement.connection;
        return conn.conversion.ConvertCharacterStream(this.stream, 8, this.formOfUse, conn);
    }

    @Override
    InputStream getBinaryStream(int currentRow) throws SQLException {
        PhysicalConnection conn = this.statement.connection;
        if (this.isNull(currentRow)) {
            return null;
        }
        if (this.statement.isFetchStreams) {
            return this.convertBytesToStream(currentRow, 6);
        }
        if (this.stream.closed) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 27).fillInStackTrace();
        }
        return conn.conversion.ConvertStream(this.stream, 6, conn);
    }

    @Override
    public String toString() {
        return "LongRawAccessor@" + Integer.toHexString(this.hashCode()) + "{columnPosition = " + this.columnPosition + "}";
    }
}

