/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.utils;

import java.util.ArrayList;
import java.util.List;
import oracle.jdbc.driver.utils.AutoCloseableAdapter;
import oracle.jdbc.driver.utils.CheckedExceptionHandler;
import oracle.jdbc.driver.utils.ThrowingConsumer;

public class CompositeAutoCloseable<E extends Exception>
implements AutoCloseableAdapter<E> {
    private final List<AutoCloseableAdapter<E>> autoCloseableAdapters = new ArrayList<AutoCloseableAdapter<E>>();
    private final Class<E> exceptionClass;

    public CompositeAutoCloseable(Class<E> exceptionClass) {
        this.exceptionClass = exceptionClass;
    }

    public void add(AutoCloseableAdapter<E> autoCloseableAdapter) {
        if (autoCloseableAdapter == null) {
            return;
        }
        this.autoCloseableAdapters.add(autoCloseableAdapter);
    }

    public <T> void addAll(T[] closeables, ThrowingConsumer<T, E> closeFunction) {
        if (closeables == null || closeFunction == null) {
            return;
        }
        this.autoCloseableAdapters.add(() -> {
            for (Object closeable : closeables) {
                if (closeable == null) continue;
                closeFunction.acceptOrThrow(closeable);
            }
        });
    }

    @Override
    public void close() throws E {
        Exception exception = null;
        for (int i = this.autoCloseableAdapters.size() - 1; i >= 0; --i) {
            AutoCloseableAdapter<E> autoCloseableAdapter = this.autoCloseableAdapters.get(i);
            if (autoCloseableAdapter == null) continue;
            try {
                autoCloseableAdapter.close();
                continue;
            }
            catch (Exception thrown) {
                if (exception == null) {
                    exception = thrown;
                    continue;
                }
                exception.addSuppressed(thrown);
            }
        }
        if (exception == null) {
            return;
        }
        if (this.exceptionClass.isInstance(exception)) {
            throw (Exception)this.exceptionClass.cast(exception);
        }
        throw CheckedExceptionHandler.toRuntimeException(exception);
    }
}

