/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import java.text.DateFormatSymbols;
import java.util.TimeZone;
import oracle.jdbc.OracleResultSetMetaData;
import oracle.jdbc.VectorMetaData;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.AccessorPrototype;
import oracle.jdbc.driver.ByteArray;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.DynamicByteArray;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CMAREngine;
import oracle.jdbc.driver.TimestampltzAccessor;

class T4CTimestampltzAccessor
extends TimestampltzAccessor {
    T4CMAREngine mare;
    boolean underlyingLongRaw = false;

    T4CTimestampltzAccessor(OracleStatement stmt, int max_len, short form, int external_type, boolean isOutBind, T4CMAREngine _mare) throws SQLException {
        super(stmt, max_len, form, external_type, isOutBind, false);
        this.mare = _mare;
    }

    T4CTimestampltzAccessor(OracleStatement stmt, int max_len, boolean nullable, int flags, int precision, int scale, long contflag, int total_elems, short form, int _definedColumnType, int _definedColumnSize, T4CMAREngine _mare) throws SQLException {
        super(stmt, max_len == -1 ? _definedColumnSize : max_len, nullable, flags, precision, scale, contflag, total_elems, form);
        this.mare = _mare;
        if (stmt != null && stmt.implicitDefineForLobPrefetchDone) {
            this.definedColumnType = 0;
            this.definedColumnSize = 0;
        } else {
            this.definedColumnType = _definedColumnType;
            this.definedColumnSize = _definedColumnSize;
        }
        if (max_len == -1) {
            this.underlyingLongRaw = true;
        }
    }

    public T4CMAREngine getMAREngine() {
        return this.mare;
    }

    public void unmarshalColumnMetadata() throws SQLException, IOException {
        if (this.statement.statementType != 2 && !this.statement.sqlKind.isPlsqlOrCall() && this.securityAttribute == OracleResultSetMetaData.SecurityAttribute.ENABLED) {
            this.setRowMetadata(this.lastRowProcessed, (byte)this.mare.unmarshalUB1());
        }
    }

    public void processIndicator(int size) throws IOException, SQLException {
        if (this.internalType == 1 && (this.describeType == 112 || this.describeType == 127) || this.internalType == 23 && this.describeType == 113 || this.internalType == 112 && this.describeType == 127) {
            this.mare.unmarshalSB2();
            this.mare.unmarshalUB2();
        } else if (this.statement.connection.versionNumber < 9200) {
            this.mare.unmarshalSB2();
            if (!this.statement.sqlKind.isPlsqlOrCall()) {
                this.mare.unmarshalSB2();
            }
        } else if (this.statement.sqlKind.isPlsqlOrCall() || this.isDMLReturnedParam) {
            this.mare.processIndicator(size <= 0, size);
        }
    }

    @Override
    int getPreviousRowProcessed() {
        if (this.previousRowProcessed == -1) {
            this.previousRowProcessed = this.statement.rowPrefetchInLastFetch - 1;
        }
        return this.previousRowProcessed;
    }

    @Override
    void reinitForResultSetCache(ByteArray dba, OracleStatement stmt) throws SQLException {
        this.rowData = dba;
        this.mare = ((T4CConnection)stmt.connection).mare;
        this.rowNull = null;
        this.setCapacity(stmt.getFetchSize());
    }

    @Override
    boolean unmarshalOneRow() throws SQLException, IOException {
        boolean isStream = false;
        if (!this.isUseless()) {
            if (this.isUnexpected()) {
                long pos = this.rowData.getPosition();
                this.unmarshalColumnMetadata();
                this.unmarshalBytes();
                this.rowData.setPosition(pos);
                this.setNull(this.lastRowProcessed, true);
            } else if (this.isNullByDescribe()) {
                this.setNull(this.lastRowProcessed, true);
                this.unmarshalColumnMetadata();
                if (this.statement.connection.versionNumber < 9200) {
                    this.processIndicator(0);
                }
            } else {
                this.unmarshalColumnMetadata();
                isStream = this.unmarshalBytes();
            }
        }
        this.previousRowProcessed = this.lastRowProcessed++;
        return isStream;
    }

    boolean unmarshalBytes() throws SQLException, IOException {
        this.setOffset(this.lastRowProcessed);
        int len = this.statement.maxFieldSize > 0 ? ((DynamicByteArray)this.rowData).unmarshalCLR(this.mare, this.statement.maxFieldSize) : ((DynamicByteArray)this.rowData).unmarshalCLR(this.mare);
        this.processIndicator(len);
        this.setLength(this.lastRowProcessed, len);
        this.setNull(this.lastRowProcessed, len == 0);
        return false;
    }

    @Override
    void copyRow() throws SQLException, IOException {
        if (this.isNullByDescribe || this.previousRowProcessed == -1) {
            this.setNull(this.lastRowProcessed, true);
            this.previousRowProcessed = this.statement.rowPrefetchInLastFetch - 1;
        } else if (this.lastRowProcessed == 0) {
            if (this.previousRowProcessed == -1) {
                this.previousRowProcessed = this.statement.rowPrefetchInLastFetch - 1;
            }
            if (this.lastCopyRow == this.previousRowProcessed) {
                this.setNull(this.lastRowProcessed, this.lastCopyRowIsNull);
                this.rowMetadata[this.lastRowProcessed] = this.lastCopyRowMetaData;
                if (!this.lastCopyRowIsNull) {
                    this.setOffset(this.lastRowProcessed);
                    this.rowData.copyLeft(this.lastCopyRowOffset, this.lastCopyRowLength);
                    this.setLength(this.lastRowProcessed, this.lastCopyRowLength);
                }
            } else {
                long previousOffset = this.getOffset(this.previousRowProcessed);
                this.setNull(this.lastRowProcessed, this.isNull(this.previousRowProcessed));
                this.rowMetadata[this.lastRowProcessed] = this.rowMetadata[this.previousRowProcessed];
                if (!this.isNull(this.previousRowProcessed)) {
                    this.setOffset(this.lastRowProcessed);
                    this.rowData.copyLeft(previousOffset, this.getLength(this.previousRowProcessed));
                    this.setLength(this.lastRowProcessed, this.getLength(this.previousRowProcessed));
                }
            }
        } else if (this.lastCopyRow == this.previousRowProcessed) {
            this.setNull(this.lastRowProcessed, this.lastCopyRowIsNull);
            this.rowMetadata[this.lastRowProcessed] = this.lastCopyRowMetaData;
            this.setOffset(this.lastRowProcessed, this.lastCopyRowOffset);
            this.setLength(this.lastRowProcessed, this.lastCopyRowLength);
        } else {
            this.setNull(this.lastRowProcessed, this.isNull(this.previousRowProcessed));
            this.rowMetadata[this.lastRowProcessed] = this.rowMetadata[this.previousRowProcessed];
            this.setOffset(this.lastRowProcessed, this.getOffset(this.previousRowProcessed));
            this.setLength(this.lastRowProcessed, this.getLength(this.previousRowProcessed));
        }
        this.lastCopyRow = -1;
        this.previousRowProcessed = this.lastRowProcessed++;
    }

    @Override
    String toText(int year, int month, int day, int hour, int min, int sec, int nanos, boolean am, String zone) throws SQLException {
        if (this.definedColumnType == 0 || this.definedColumnType == -102) {
            return super.toText(year, month, day, hour, min, sec, nanos, am, zone);
        }
        String format = (String)this.statement.connection.sessionProperties.get("AUTH_NLS_LXCSTMPFM");
        return T4CTimestampltzAccessor.nlsFormatToText(year, month, day, hour, min, sec, nanos, am, zone, format);
    }

    private static final String nlsFormatToText(int year, int month, int day, int hour, int min, int sec, int nanos, boolean am, String zone, String format) throws SQLException {
        char[] fChars = (format + "      ").toCharArray();
        int fLength = format.length();
        StringBuffer sb = new StringBuffer(fLength + 25);
        String[] sMonths = null;
        String[] lMonths = null;
        TimeZone tz = null;
        int normYear = year < 0 ? Math.abs(year) + 1 : year;
        boolean bJulianBC = false;
        block13: for (int i = 0; i < fLength; ++i) {
            switch (fChars[i]) {
                case 'R': 
                case 'r': {
                    if (fChars[i + 1] != 'R' && fChars[i + 1] != 'r') continue block13;
                    if (!(fChars[i + 2] != 'R' && fChars[i + 2] != 'r' || fChars[i + 3] != 'R' && fChars[i + 3] != 'r')) {
                        if (normYear < 1000) {
                            sb.append("0" + normYear);
                        } else if (normYear < 100) {
                            sb.append("00" + normYear);
                        } else if (normYear < 10) {
                            sb.append("000" + normYear);
                        } else {
                            sb.append(normYear);
                        }
                        i += 3;
                        continue block13;
                    }
                    if (normYear >= 100) {
                        normYear %= 100;
                    }
                    if (normYear < 10) {
                        sb.append("0" + normYear);
                    } else {
                        sb.append(normYear);
                    }
                    ++i;
                    continue block13;
                }
                case 'Y': 
                case 'y': {
                    if (fChars[i + 1] != 'Y' && fChars[i + 1] != 'y') continue block13;
                    if (!(fChars[i + 2] != 'Y' && fChars[i + 2] != 'y' || fChars[i + 3] != 'Y' && fChars[i + 3] != 'y')) {
                        int localYear;
                        int n = localYear = year < 0 && bJulianBC ? Math.abs(year) : normYear;
                        if (localYear < 1000) {
                            sb.append("0" + localYear);
                        } else if (localYear < 100) {
                            sb.append("00" + localYear);
                        } else if (localYear < 10) {
                            sb.append("000" + localYear);
                        } else {
                            sb.append(localYear);
                        }
                        i += 3;
                        continue block13;
                    }
                    if (normYear >= 100) {
                        normYear %= 100;
                    }
                    if (normYear < 10) {
                        sb.append("0" + normYear);
                    } else {
                        sb.append(normYear);
                    }
                    ++i;
                    continue block13;
                }
                case 'D': 
                case 'd': {
                    if (fChars[i + 1] != 'D' && fChars[i + 1] != 'd') continue block13;
                    sb.append((day < 10 ? "0" : "") + day);
                    ++i;
                    continue block13;
                }
                case 'M': 
                case 'm': {
                    if (fChars[i + 1] == 'M' || fChars[i + 1] == 'm') {
                        sb.append((month < 10 ? "0" : "") + month);
                        ++i;
                        continue block13;
                    }
                    if (fChars[i + 1] == 'I' || fChars[i + 1] == 'i') {
                        sb.append((min < 10 ? "0" : "") + min);
                        ++i;
                        continue block13;
                    }
                    if (fChars[i + 1] != 'O' && fChars[i + 1] != 'o' || fChars[i + 2] != 'N' && fChars[i + 2] != 'n') continue block13;
                    if (!(fChars[i + 3] != 'T' && fChars[i + 3] != 't' || fChars[i + 4] != 'H' && fChars[i + 4] != 'h')) {
                        if (lMonths == null) {
                            lMonths = new DateFormatSymbols().getMonths();
                        }
                        if (fChars[i] == 'm') {
                            sb.append(lMonths[month - 1].toLowerCase());
                        } else if (fChars[i + 1] == 'O') {
                            sb.append(lMonths[month - 1].toUpperCase());
                        } else {
                            sb.append(lMonths[month - 1]);
                        }
                        i += 4;
                        continue block13;
                    }
                    if (sMonths == null) {
                        sMonths = new DateFormatSymbols().getShortMonths();
                    }
                    if (fChars[i] == 'm') {
                        sb.append(sMonths[month - 1].toLowerCase());
                    } else if (fChars[i + 1] == 'O') {
                        sb.append(sMonths[month - 1].toUpperCase());
                    } else {
                        sb.append(sMonths[month - 1]);
                    }
                    i += 2;
                    continue block13;
                }
                case 'H': 
                case 'h': {
                    if (fChars[i + 1] != 'H' && fChars[i + 1] != 'h') continue block13;
                    if (fChars[i + 2] == '2' || fChars[i + 3] == '4') {
                        sb.append((hour < 10 ? "0" : "") + hour);
                        i += 3;
                        continue block13;
                    }
                    if (hour > 12) {
                        hour -= 12;
                    }
                    sb.append((hour < 10 ? "0" : "") + hour);
                    ++i;
                    continue block13;
                }
                case 'S': 
                case 's': {
                    if (fChars[i + 1] == 'S' || fChars[i + 1] == 's') {
                        sb.append((sec < 10 ? "0" : "") + sec);
                        if (fChars[++i + 1] != 'X' && fChars[i + 1] != 'x' || fChars[i + 2] != 'F' && fChars[i + 2] != 'f' || fChars[i + 3] != 'F' && fChars[i + 3] != 'f') continue block13;
                        sb.append(".");
                        ++i;
                        continue block13;
                    }
                    if (fChars[i + 1] != 'Y' && fChars[i + 1] != 'y' || fChars[i + 2] != 'Y' && fChars[i + 2] != 'y' || fChars[i + 3] != 'Y' && fChars[i + 3] != 'y' || year >= 0) continue block13;
                    sb.append("-");
                    bJulianBC = true;
                    continue block13;
                }
                case 'F': 
                case 'f': {
                    if (fChars[i + 1] != 'F' && fChars[i + 1] != 'f') continue block13;
                    if (nanos >= 0) {
                        sb.append(nanos);
                    } else {
                        sb.append(0);
                    }
                    ++i;
                    continue block13;
                }
                case 'T': 
                case 't': {
                    if (fChars[i + 1] != 'Z' && fChars[i + 1] != 'z') continue block13;
                    if (fChars[i + 2] == 'R' || fChars[i + 2] == 'r') {
                        if (zone.length() > 3 && zone.startsWith("GMT")) {
                            sb.append(zone.substring(3));
                        } else {
                            sb.append(zone.toUpperCase());
                        }
                        i += 2;
                        continue block13;
                    }
                    if (fChars[i + 2] == 'H' || fChars[i + 2] == 'h') {
                        if (tz == null) {
                            tz = TimeZone.getTimeZone(zone);
                        }
                        long offsetHr = tz.getRawOffset() / 3600000;
                        sb.append(offsetHr);
                        i += 2;
                        continue block13;
                    }
                    if (fChars[i + 2] != 'M' && fChars[i + 2] != 'm') continue block13;
                    if (tz == null) {
                        tz = TimeZone.getTimeZone(zone);
                    }
                    long offsetMin = Math.abs(tz.getRawOffset()) % 3600000 / 60000;
                    sb.append((offsetMin < 10L ? "0" : "") + offsetMin);
                    i += 2;
                    continue block13;
                }
                case 'A': 
                case 'a': {
                    if (fChars[i + 1] == 'M' || fChars[i + 1] == 'm') {
                        sb.append(am ? "AM" : "PM");
                        ++i;
                        continue block13;
                    }
                    if (fChars[i + 1] != 'D' && fChars[i + 1] != 'd') continue block13;
                    sb.append(year < 0 ? "BC" : "AD");
                    ++i;
                    continue block13;
                }
                case 'B': 
                case 'b': {
                    if (fChars[i + 1] != 'C' && fChars[i + 1] != 'c') continue block13;
                    sb.append(year < 0 ? "BC" : "AD");
                    ++i;
                    continue block13;
                }
                case 'P': 
                case 'p': {
                    if (fChars[i + 1] != 'M' && fChars[i + 1] != 'm') continue block13;
                    sb.append(am ? "AM" : "PM");
                    ++i;
                    continue block13;
                }
                default: {
                    sb.append(fChars[i]);
                }
            }
        }
        return sb.substring(0, sb.length());
    }

    @Override
    Object getObject(int currentRow) throws SQLException {
        if (this.definedColumnType == 0) {
            return super.getObject(currentRow);
        }
        if (this.isUnexpected()) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21).fillInStackTrace();
        }
        if (this.isNull(currentRow)) {
            return null;
        }
        switch (this.definedColumnType) {
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: {
                return this.getString(currentRow);
            }
            case 93: {
                return this.getTimestamp(currentRow);
            }
            case -102: {
                return this.getTIMESTAMPLTZ(currentRow);
            }
            case 91: {
                return this.getDate(currentRow);
            }
            case 92: {
                return this.getTime(currentRow);
            }
            case -4: 
            case -3: 
            case -2: {
                return this.getBytes(currentRow);
            }
        }
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
    }

    @Override
    AccessorPrototype newPrototype(int numRows) {
        assert (numRows >= 0) : "numRows: " + numRows;
        final VectorMetaData vectorMetaData = this.getVectorMetaData();
        AccessorPrototype p = new AccessorPrototype(numRows, this, this.statement.rowData){

            @Override
            Accessor newAccessor(OracleStatement stmt) throws SQLException {
                T4CTimestampltzAccessor acc = new T4CTimestampltzAccessor(stmt, T4CTimestampltzAccessor.this.describeMaxLength, T4CTimestampltzAccessor.this.nullable, -1, T4CTimestampltzAccessor.this.precision, T4CTimestampltzAccessor.this.scale, T4CTimestampltzAccessor.this.contflag, -1, T4CTimestampltzAccessor.this.formOfUse, T4CTimestampltzAccessor.this.definedColumnType, T4CTimestampltzAccessor.this.definedColumnSize, null);
                acc.setVectorMetaData(vectorMetaData);
                this.initializeRowData(acc);
                return acc;
            }
        };
        return p;
    }
}

