/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.common.waitfreepool;

import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Predicate;
import oracle.ucp.common.waitfreepool.Pool;
import oracle.ucp.common.waitfreepool.PoolElement;
import oracle.ucp.common.waitfreepool.PoolIterator;
import oracle.ucp.common.waitfreepool.Queue;

final class CopyOnWriteArrayListPool<T>
implements Pool<T> {
    private final List<Element<T>> pool = new CopyOnWriteArrayList<Element<T>>();
    private AtomicLong elementsInstantiated = new AtomicLong();

    CopyOnWriteArrayListPool() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(T data) {
        Queue<Element<T>> putRevisitQueue = new Queue<Element<T>>();
        int farthestIndex = 0;
        Element<T> element = null;
        for (int i = 0; i < this.pool.size(); ++i) {
            farthestIndex = i;
            element = this.pool.get(i);
            assert (element != null) : "pool has to be always filled up with elements";
            if (element.tryReserve()) {
                try {
                    if (element.data != null) continue;
                    element.data = data;
                    return;
                }
                finally {
                    element.release();
                }
            }
            putRevisitQueue.enqueue(element);
        }
        Element<T> first = null;
        while (null != (element = (Element<T>)putRevisitQueue.dequeue())) {
            if (first == element) {
                first = null;
                Thread.yield();
            }
            if (null == first) {
                first = element;
            }
            if (element.tryReserve()) {
                try {
                    if (null != element.data) continue;
                    element.data = data;
                    return;
                }
                finally {
                    element.release();
                    continue;
                }
            }
            putRevisitQueue.enqueue(element);
        }
        this.pool.add(new Element<T>(data));
    }

    @Override
    public PoolIterator<T> poolIterator(final boolean revisit) {
        final Thread iteratorThread = Thread.currentThread();
        return new PoolIterator<T>(){
            private volatile int currentIndex = 0;
            private volatile Element<T> currentElement = null;
            private volatile boolean outerReservation = false;
            private volatile boolean nextReserved = false;
            private final AtomicBoolean released = new AtomicBoolean(false);
            private final Queue<Element<T>> revisitQueue = new Queue();

            private void throwIfWrongThread() {
                if (iteratorThread != Thread.currentThread()) {
                    throw new IllegalStateException("PoolIterator has been run by a wrong thread");
                }
            }

            private boolean preReserved(Element<T> element) {
                return element.reserved.get() == Thread.currentThread();
            }

            private Element<T> reserveNext() {
                while (this.currentIndex < CopyOnWriteArrayListPool.this.pool.size()) {
                    Element element = CopyOnWriteArrayListPool.this.pool.get(this.currentIndex++);
                    assert (element != null) : "pool has to be always filled up with elements";
                    if (element.tryReserve()) {
                        if (element.data != null) {
                            return element;
                        }
                        element.release();
                        continue;
                    }
                    if (this.preReserved(element)) {
                        if (element.data == null) continue;
                        this.outerReservation = true;
                        return element;
                    }
                    if (!revisit) continue;
                    this.revisitQueue.enqueue(element);
                }
                Element first = null;
                while (revisit) {
                    Element element = this.revisitQueue.dequeue();
                    if (element == null) {
                        return null;
                    }
                    if (element == first) {
                        first = null;
                        Thread.yield();
                    }
                    if (null == first) {
                        first = element;
                    }
                    if (element.tryReserve()) {
                        if (element.data != null) {
                            return element;
                        }
                        element.release();
                        continue;
                    }
                    this.revisitQueue.enqueue(element);
                }
                return null;
            }

            @Override
            public boolean hasNext() {
                this.throwIfWrongThread();
                if (this.nextReserved) {
                    return true;
                }
                if (this.currentElement != null) {
                    if (this.outerReservation) {
                        this.outerReservation = false;
                    } else {
                        this.currentElement.release();
                    }
                }
                this.nextReserved = (this.currentElement = this.reserveNext()) != null;
                return this.nextReserved;
            }

            @Override
            public T next() {
                this.throwIfWrongThread();
                if (this.hasNext()) {
                    this.nextReserved = false;
                    Object data = this.currentElement.data;
                    assert (data != null);
                    return data;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                this.throwIfWrongThread();
                if (this.currentElement == null) {
                    throw new IllegalStateException();
                }
                this.currentElement.data = null;
            }

            @Override
            public void release() {
                this.throwIfWrongThread();
                if (this.released.compareAndSet(false, true)) {
                    this.revisitQueue.clear();
                    if (this.currentElement != null) {
                        if (this.outerReservation) {
                            this.outerReservation = false;
                        } else {
                            this.currentElement.release();
                        }
                        this.currentElement = null;
                    }
                }
            }

            @Override
            public boolean isAlive() {
                return iteratorThread.isAlive();
            }

            @Override
            @Deprecated
            public boolean isSleeping() {
                return false;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T findFirst(Predicate<T> selector, Consumer<T> applicator) {
        for (int i = 0; i < this.pool.size(); ++i) {
            Element<T> element = this.pool.get(i);
            assert (element != null) : "pool has to be always filled up with elements";
            if (!element.tryReserve()) continue;
            try {
                T data = element.getData();
                if (null == data || !selector.test(data)) continue;
                applicator.accept(data);
                T t = data;
                return t;
            }
            finally {
                element.release();
            }
        }
        return null;
    }

    private final class Element<T>
    implements PoolElement<T> {
        private final long id;
        volatile T data;
        private AtomicReference<Thread> reserved = new AtomicReference();

        private Element() {
            this(null);
        }

        private Element(T data) {
            this.data = data;
            this.id = CopyOnWriteArrayListPool.this.elementsInstantiated.getAndIncrement();
        }

        private boolean tryReserve() {
            return this.reserved.compareAndSet(null, Thread.currentThread());
        }

        private void release() {
            Thread currentThread = Thread.currentThread();
            if (!this.reserved.compareAndSet(currentThread, null)) {
                throw new IllegalStateException("element is released by wrong thread: " + String.valueOf(currentThread));
            }
        }

        @Override
        public T getData() {
            return this.data;
        }
    }
}

