/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nt;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.SocketException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.Function;
import javax.net.ssl.SSLContext;
import oracle.jdbc.OracleHostnameResolver;
import oracle.jdbc.diagnostics.SecuredLogger;
import oracle.jdbc.driver.DMSFactory;
import oracle.jdbc.internal.CompletionStageUtil;
import oracle.jdbc.internal.OpaqueString;
import oracle.jdbc.logging.annotations.Blind;
import oracle.jdbc.logging.annotations.PropertiesBlinder;
import oracle.net.ns.NetException;
import oracle.net.nt.AsyncOutboundTimeoutHandler;
import oracle.net.nt.ConnOption;
import oracle.net.nt.ConnectDescription;
import oracle.net.nt.DownHostsCache;
import oracle.net.nt.TimeoutInterruptHandler;
import oracle.net.resolver.EnvVariableResolver;
import oracle.net.resolver.TimeUnitSuffixUtility;

public class ConnStrategy {
    static final boolean DEBUG = false;
    static final int MAX_ITERATION_COUNT = 100;
    private boolean optFound = false;
    public boolean reuseOpt = false;
    private ConnOption copt;
    public int sdu;
    public int tdu;
    public int nextOptToTry = 0;
    public Properties socketOptions = new Properties();
    private String osuser;
    private String programName;
    public int retryCount = 0;
    private int lastRetryCounter = 0;
    private int lastRetryConnectDescription = 0;
    private final Properties userProp;
    private ConnectDescription currentDescription;
    private ArrayList<ConnectDescription> descriptionList = new ArrayList(4);
    private final SecuredLogger securedLogger;
    private final SSLContext sslContext;
    private final OracleHostnameResolver hostnameResolver;
    private int outboundConnectTimeout = 0;
    private String connectionIdPrefix;

    public ConnStrategy(@Blind(value=PropertiesBlinder.class) Properties properties) {
        this(properties, null, null, SecuredLogger.noOpLogger());
    }

    public ConnStrategy(@Blind(value=PropertiesBlinder.class) Properties properties, SSLContext sSLContext, OracleHostnameResolver oracleHostnameResolver, SecuredLogger securedLogger) {
        this.osuser = properties.getProperty("oracle.jdbc.v$session.osuser");
        this.programName = properties.getProperty("oracle.jdbc.v$session.program");
        DownHostsCache.DOWN_HOSTS_TIMEOUT = Integer.parseInt(properties.getProperty("oracle.net.DOWN_HOSTS_TIMEOUT", "600"));
        this.userProp = properties;
        this.createSocketOptions(properties);
        this.sslContext = sSLContext;
        this.hostnameResolver = oracleHostnameResolver;
        this.securedLogger = securedLogger;
        if (securedLogger != null) {
            this.socketOptions.put((Object)32, securedLogger.getId());
        }
    }

    public String getOSUsername() {
        return this.osuser;
    }

    public String getProgramName() {
        return this.programName;
    }

    public void createSocketOptions(@Blind(value=PropertiesBlinder.class) Properties properties) {
        ConnStrategy.createSocketOptions(properties, this.socketOptions, !this.reuseOpt);
    }

    static void createSocketOptions(@Blind(value=PropertiesBlinder.class) Properties properties, @Blind(value=PropertiesBlinder.class) Properties properties2) {
        ConnStrategy.createSocketOptions(properties, properties2, true);
    }

    static void createSocketOptions(@Blind(value=PropertiesBlinder.class) Properties properties, @Blind(value=PropertiesBlinder.class) Properties properties2, boolean bl) {
        String string = null;
        String string2 = null;
        boolean bl2 = false;
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            Object object;
            string = (String)enumeration.nextElement();
            if (string.equalsIgnoreCase("TCP.NODELAY")) {
                bl2 = true;
                string2 = properties.getProperty("TCP.NODELAY").toUpperCase();
                if (string2.equals("NO")) {
                    properties2.put((Object)0, "NO");
                    continue;
                }
                properties2.put((Object)0, "YES");
                continue;
            }
            if (string.equalsIgnoreCase("oracle.net.READ_TIMEOUT")) {
                string2 = properties.getProperty("oracle.net.READ_TIMEOUT");
                properties2.put((Object)3, string2);
                continue;
            }
            if (string.equalsIgnoreCase("oracle.net.CONNECT_TIMEOUT")) {
                string2 = properties.getProperty("oracle.net.CONNECT_TIMEOUT");
                properties2.put((Object)2, String.valueOf(TimeUnitSuffixUtility.getTimeInMilliseconds(string2, false, 0)));
                continue;
            }
            if (string.equalsIgnoreCase("oracle.net.ssl_server_dn_match")) {
                string2 = properties.getProperty("oracle.net.ssl_server_dn_match");
                properties2.put((Object)4, string2);
                continue;
            }
            if (string.equalsIgnoreCase("oracle.net.ssl_allow_weak_dn_match")) {
                string2 = properties.getProperty(string);
                properties2.put((Object)43, string2);
                continue;
            }
            if (string.equalsIgnoreCase("oracle.net.ssl_server_cert_dn")) {
                string2 = properties.getProperty("oracle.net.ssl_server_cert_dn");
                properties2.put((Object)28, string2);
                continue;
            }
            if (string.equalsIgnoreCase("oracle.net.wallet_location")) {
                string2 = properties.getProperty("oracle.net.wallet_location");
                properties2.put((Object)5, EnvVariableResolver.resolveEnvPlaceHolders(string2, properties));
                continue;
            }
            if (string.equalsIgnoreCase("oracle.net.wallet_password")) {
                object = properties.get("oracle.net.wallet_password");
                properties2.put((Object)16, object instanceof String ? OpaqueString.newOpaqueString((String)object) : (OpaqueString)object);
                continue;
            }
            if (string.equalsIgnoreCase("oracle.net.ssl_version")) {
                string2 = properties.getProperty("oracle.net.ssl_version");
                properties2.put((Object)6, string2);
                continue;
            }
            if (string.equalsIgnoreCase("oracle.net.ssl_cipher_suites")) {
                string2 = properties.getProperty("oracle.net.ssl_cipher_suites");
                properties2.put((Object)7, string2);
                continue;
            }
            if (string.equalsIgnoreCase("javax.net.ssl.keyStore")) {
                string2 = properties.getProperty("javax.net.ssl.keyStore");
                properties2.put((Object)8, string2);
                continue;
            }
            if (string.equalsIgnoreCase("javax.net.ssl.keyStoreType")) {
                string2 = properties.getProperty("javax.net.ssl.keyStoreType");
                properties2.put((Object)9, string2);
                continue;
            }
            if (string.equalsIgnoreCase("javax.net.ssl.keyStorePassword")) {
                object = properties.get("javax.net.ssl.keyStorePassword");
                properties2.put((Object)10, object instanceof String ? OpaqueString.newOpaqueString((String)object) : (OpaqueString)object);
                continue;
            }
            if (string.equalsIgnoreCase("javax.net.ssl.trustStore")) {
                string2 = properties.getProperty("javax.net.ssl.trustStore");
                properties2.put((Object)11, string2);
                continue;
            }
            if (string.equalsIgnoreCase("javax.net.ssl.trustStoreType")) {
                string2 = properties.getProperty("javax.net.ssl.trustStoreType");
                properties2.put((Object)12, string2);
                continue;
            }
            if (string.equalsIgnoreCase("javax.net.ssl.trustStorePassword")) {
                object = properties.get("javax.net.ssl.trustStorePassword");
                properties2.put((Object)13, object instanceof String ? OpaqueString.newOpaqueString((String)object) : (OpaqueString)object);
                continue;
            }
            if (string.equalsIgnoreCase("ssl.keyManagerFactory.algorithm")) {
                string2 = properties.getProperty("ssl.keyManagerFactory.algorithm");
                properties2.put((Object)14, string2);
                continue;
            }
            if (string.equalsIgnoreCase("FORCE_DNS_LOAD_BALANCING")) {
                string2 = properties.getProperty("FORCE_DNS_LOAD_BALANCING");
                properties2.put((Object)18, string2);
                continue;
            }
            if (string.equalsIgnoreCase("oracle.net.keepAlive")) {
                string2 = properties.getProperty("oracle.net.keepAlive");
                if (Boolean.parseBoolean(string2)) {
                    properties2.put((Object)1, "YES");
                    continue;
                }
                properties2.put((Object)1, "NO");
                continue;
            }
            if (string.equalsIgnoreCase("oracle.jdbc.useNio")) {
                string2 = properties.getProperty("oracle.jdbc.useNio");
                properties2.put((Object)20, string2);
                continue;
            }
            if (string.equalsIgnoreCase("oracle.jdbc.javaNetLocalIPForMsgq")) {
                string2 = properties.getProperty("oracle.jdbc.javaNetLocalIPForMsgq");
                properties2.put((Object)21, string2);
                continue;
            }
            if (string.equalsIgnoreCase("oracle.jdbc.javaNetMsgqTransport")) {
                string2 = properties.getProperty("oracle.jdbc.javaNetMsgqTransport");
                properties2.put((Object)22, string2);
                continue;
            }
            if (string.equalsIgnoreCase("oracle.jdbc.javaNetMsgqBusyWait")) {
                string2 = properties.getProperty("oracle.jdbc.javaNetMsgqBusyWait");
                properties2.put((Object)23, string2);
                continue;
            }
            if (string.equalsIgnoreCase("oracle.jdbc.javaNetMsgqKernelWait")) {
                string2 = properties.getProperty("oracle.jdbc.javaNetMsgqKernelWait");
                properties2.put((Object)24, string2);
                continue;
            }
            if (string.equalsIgnoreCase("oracle.net.OUTBOUND_CONNECT_TIMEOUT")) {
                string2 = properties.getProperty("oracle.net.OUTBOUND_CONNECT_TIMEOUT");
                properties2.put((Object)25, String.valueOf(TimeUnitSuffixUtility.getTimeInMilliseconds(string2, true, 0)));
                continue;
            }
            if (string.equalsIgnoreCase("oracle.net.websocketUser")) {
                string2 = properties.getProperty("oracle.net.websocketUser");
                properties2.put((Object)26, string2);
                continue;
            }
            if (string.equalsIgnoreCase("oracle.net.websocketPassword")) {
                object = properties.get("oracle.net.websocketPassword");
                properties2.put((Object)27, object instanceof String ? OpaqueString.newOpaqueString((String)object) : (OpaqueString)object);
                continue;
            }
            if (string.equalsIgnoreCase("oracle.net.ssl_certificate_alias")) {
                string2 = properties.getProperty("oracle.net.ssl_certificate_alias");
                properties2.put((Object)29, string2);
                continue;
            }
            if (string.equalsIgnoreCase("oracle.net.httpsProxyHost")) {
                string2 = properties.getProperty("oracle.net.httpsProxyHost");
                properties2.put((Object)30, string2);
                properties2.put((Object)31, properties.getProperty("oracle.net.httpsProxyPort"));
                continue;
            }
            if (string.equalsIgnoreCase("oracle.net.socksProxyHost")) {
                string2 = properties.getProperty("oracle.net.socksProxyHost");
                properties2.put((Object)36, string2);
                properties2.put((Object)37, properties.getProperty("oracle.net.socksProxyPort"));
                continue;
            }
            if (string.equalsIgnoreCase("oracle.net.socksRemoteDNS")) {
                string2 = properties.getProperty("oracle.net.socksRemoteDNS");
                properties2.put((Object)39, string2);
                continue;
            }
            if (string.equalsIgnoreCase("oracle.net.TCP_KEEPIDLE")) {
                properties2.put((Object)33, properties.getProperty("oracle.net.TCP_KEEPIDLE"));
                continue;
            }
            if (string.equalsIgnoreCase("oracle.net.TCP_KEEPINTERVAL")) {
                properties2.put((Object)34, properties.getProperty("oracle.net.TCP_KEEPINTERVAL"));
                continue;
            }
            if (string.equalsIgnoreCase("oracle.net.TCP_KEEPCOUNT")) {
                properties2.put((Object)35, properties.getProperty("oracle.net.TCP_KEEPCOUNT"));
                continue;
            }
            if (string.equalsIgnoreCase("oracle.net.ssl_context_protocol")) {
                properties2.put((Object)38, properties.getProperty("oracle.net.ssl_context_protocol"));
                continue;
            }
            if (string.equalsIgnoreCase("oracle.net.ssl_server_dn_match_default")) {
                properties2.put((Object)40, properties.getProperty("oracle.net.ssl_server_dn_match_default"));
                continue;
            }
            if (!string.equalsIgnoreCase("oracle.net.useTcpFastOpen")) continue;
            string2 = properties.getProperty(string);
            properties2.put((Object)109, string2);
        }
        if (!bl2 && bl) {
            properties2.put((Object)0, "YES");
        }
    }

    public void addSocketOptions(boolean bl) {
        if (bl) {
            this.socketOptions.put((Object)1, "YES");
        } else if (!this.reuseOpt && !this.socketOptions.containsKey(1)) {
            this.socketOptions.put((Object)1, "NO");
        }
    }

    public void addSocketOptions_FORCE_DNS_LOAD_BALANCING_OFF() {
        this.socketOptions.put((Object)18, "true");
    }

    public boolean hasMoreOptions() {
        int n2 = 0;
        for (ConnectDescription connectDescription : this.descriptionList) {
            n2 += connectDescription.getConnectOptions().size();
        }
        return this.nextOptToTry < n2;
    }

    public ConnOption execute(boolean bl, DMSFactory.DMSNoun dMSNoun) throws NetException, InterruptedIOException {
        IOException iOException = null;
        for (int i2 = this.lastRetryConnectDescription; i2 < this.descriptionList.size(); ++i2) {
            ConnectDescription connectDescription = this.descriptionList.get(i2);
            ArrayList<ConnOption> arrayList = connectDescription.getConnectOptions();
            this.prepareForExecuteDescription(connectDescription);
            this.outboundConnectTimeout = this.getOutboundConnectTimeout(connectDescription);
            int n2 = connectDescription.getDelayInMillis();
            for (int i3 = this.lastRetryCounter; i3 <= this.retryCount; ++i3) {
                int n3 = 0;
                if (this.nextOptToTry == 0) {
                    DownHostsCache.getInstance().reorderAddresses(arrayList);
                }
                while (this.nextOptToTry < arrayList.size() && n3++ < 100) {
                    try {
                        this.copt = arrayList.get(this.nextOptToTry);
                        this.prepareForExecuteConnOption(this.copt);
                        this.executeConnOption(this.copt, dMSNoun, connectDescription.getTransportConnectTimeout(), bl, this.outboundConnectTimeout);
                        this.handleExecuteConnOptionCompletion(this.copt);
                        this.lastRetryCounter = i3;
                        this.lastRetryConnectDescription = i2;
                        return this.copt;
                    }
                    catch (InterruptedIOException interruptedIOException) {
                        this.handleExecuteConnOptionFailure(this.copt, interruptedIOException);
                        throw interruptedIOException;
                    }
                    catch (IOException iOException2) {
                        this.handleExecuteConnOptionFailure(this.copt, iOException2);
                        iOException = iOException2;
                    }
                }
                this.nextOptToTry = 0;
                if (n2 <= 0 || i3 >= this.retryCount) continue;
                try {
                    Thread.sleep(n2);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    throw new InterruptedIOException(interruptedException.getMessage());
                }
            }
            this.lastRetryCounter = 0;
        }
        if (iOException == null) {
            throw new NetException(20);
        }
        throw (NetException)new NetException(20).initCause(iOException);
    }

    public String getConnectionIdPrefix() {
        return this.connectionIdPrefix;
    }

    private void prepareForExecuteDescription(ConnectDescription connectDescription) {
        this.setSecurityOptions(connectDescription);
        if (connectDescription.getTransportConnectTimeout() >= 0) {
            this.socketOptions.put((Object)2, Integer.toString(connectDescription.getTransportConnectTimeout()));
        }
        this.sdu = connectDescription.getSdu();
        this.tdu = connectDescription.getTdu();
        this.retryCount = connectDescription.getRetryCount();
        if (this.retryCount < 0) {
            this.retryCount = 0;
        }
        this.socketOptions.put((Object)17, Integer.toString(this.retryCount));
        this.setExpireTimeSocketOption(connectDescription.getExpireTime(), this.socketOptions);
        this.connectionIdPrefix = this.userProp.getProperty("oracle.net.connectionIdPrefix", connectDescription.getConnectionIdPrefix());
        if ("OCI_TOKEN".equals(connectDescription.getTokenAuthentication()) || "OCI_TOKEN".equals(connectDescription.getPasswordAuthentication())) {
            this.socketOptions.put((Object)40, "true");
        }
    }

    private void setSecurityOptions(ConnectDescription connectDescription) {
        if (connectDescription.getEncryptionClient() != null) {
            this.userProp.setProperty("oracle.net.encryption_client", connectDescription.getEncryptionClient());
        }
        if (connectDescription.getEncryptionClientTypes() != null) {
            this.userProp.setProperty("oracle.net.encryption_types_client", connectDescription.getEncryptionClientTypes());
        }
        if (connectDescription.getChecksumClient() != null) {
            this.userProp.setProperty("oracle.net.crypto_checksum_client", connectDescription.getChecksumClient());
        }
        if (connectDescription.getChecksumClientTypes() != null) {
            this.userProp.setProperty("oracle.net.crypto_checksum_types_client", connectDescription.getChecksumClientTypes());
        }
        if (connectDescription.getAllowWeakCrypto() != null) {
            this.userProp.setProperty("oracle.net.allow_weak_crypto", connectDescription.getAllowWeakCrypto());
        }
        if (connectDescription.getTokenAuthentication() != null) {
            this.userProp.setProperty("oracle.jdbc.tokenAuthentication", connectDescription.getTokenAuthentication());
        }
        if (connectDescription.getTokenLocation() != null) {
            this.userProp.setProperty("oracle.jdbc.tokenLocation", connectDescription.getTokenLocation());
        }
        if (connectDescription.getPasswordAuthentication() != null) {
            this.userProp.setProperty("oracle.jdbc.passwordAuthentication", connectDescription.getPasswordAuthentication());
        }
        if (connectDescription.getOciIamUrl() != null) {
            this.userProp.setProperty("oracle.jdbc.ociIamUrl", connectDescription.getOciIamUrl());
        }
        if (connectDescription.getOciTenancy() != null) {
            this.userProp.setProperty("oracle.jdbc.ociTenancy", connectDescription.getOciTenancy());
        }
        if (connectDescription.getOciCompartment() != null) {
            this.userProp.setProperty("oracle.jdbc.ociCompartment", connectDescription.getOciCompartment());
        }
        if (connectDescription.getOciDatabase() != null) {
            this.userProp.setProperty("oracle.jdbc.ociDatabase", connectDescription.getOciDatabase());
        }
    }

    private void prepareForExecuteConnOption(ConnOption connOption) {
        if (connOption.walletDirectory != null) {
            this.socketOptions.put((Object)5, EnvVariableResolver.resolveFilePath(connOption.walletDirectory, this.userProp));
        }
        if (connOption.sslServerDNMatch != null) {
            this.socketOptions.put((Object)4, connOption.sslServerDNMatch);
        }
        if (connOption.sslServerCertDN == null) {
            connOption.sslServerCertDN = (String)this.socketOptions.get(28);
        }
        if (connOption.sslAllowWeakDNMatch == null) {
            connOption.sslAllowWeakDNMatch = (String)this.socketOptions.get(43);
        }
        if (connOption.sslServerCertDN != null && this.socketOptions.get(4) == null) {
            this.socketOptions.put((Object)4, "TRUE");
        }
        if (connOption.useTcpFastOpen != null) {
            this.socketOptions.put((Object)109, connOption.useTcpFastOpen);
        }
    }

    private void handleExecuteConnOptionCompletion(ConnOption connOption) {
        connOption.sdu = this.sdu;
        connOption.tdu = this.tdu;
        this.optFound = true;
        if (!connOption.nt.hasMoreInetAddresses()) {
            ++this.nextOptToTry;
        }
    }

    private void handleExecuteConnOptionFailure(ConnOption connOption, IOException iOException) {
        DownHostsCache.getInstance().markDownHost(connOption);
        if (connOption.nt == null || !connOption.nt.hasMoreInetAddresses() || iOException instanceof NetException && ((NetException)iOException).getErrorNumber() == 410) {
            ++this.nextOptToTry;
        }
    }

    private void executeConnOption(ConnOption connOption, DMSFactory.DMSNoun dMSNoun, int n2, boolean bl, int n3) throws IOException, InterruptedIOException {
        if (n3 > 0 && bl) {
            TimeoutInterruptHandler.scheduleInterrupt(TimeoutInterruptHandler.InterruptTaskType.OUTBOUND_TIMEOUT, n3, Thread.currentThread());
        }
        connOption.connectTimeout = n3;
        connOption.transportConnectTimeout = n2;
        try {
            connOption.connect(this.socketOptions, dMSNoun, this.sslContext, this.hostnameResolver);
        }
        catch (InterruptedIOException interruptedIOException) {
            if (n3 > 0 && !this.cancelOutboundTimeout()) {
                throw new IOException("Outbound connect timeout expired", interruptedIOException);
            }
            throw interruptedIOException;
        }
        catch (IOException iOException) {
            if (n3 > 0) {
                this.cancelOutboundTimeout();
            }
            throw iOException;
        }
    }

    private boolean cancelOutboundTimeout() {
        TimeoutInterruptHandler.InterruptTask interruptTask = TimeoutInterruptHandler.cancelInterrupt(TimeoutInterruptHandler.InterruptTaskType.OUTBOUND_TIMEOUT, Thread.currentThread());
        return interruptTask != null && !interruptTask.isInterrupted();
    }

    private final int getOutboundConnectTimeout(ConnectDescription connectDescription) {
        if (connectDescription.getConnectTimeout() >= 0) {
            return connectDescription.getConnectTimeout();
        }
        String string = (String)this.socketOptions.get(25);
        if (string != null) {
            try {
                return Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                return 0;
            }
        }
        return 0;
    }

    public CompletionStage<ConnOption> executeAsync(boolean bl, DMSFactory.DMSNoun dMSNoun, AsyncOutboundTimeoutHandler asyncOutboundTimeoutHandler, Executor executor) {
        if (this.lastRetryConnectDescription >= this.descriptionList.size()) {
            return CompletionStageUtil.completedStage(null);
        }
        return this.executeDescriptionAsync(this.lastRetryConnectDescription, dMSNoun, bl, asyncOutboundTimeoutHandler, executor).handle(CompletionStageUtil.completionHandler(connOption -> {
            if (connOption != null) {
                return connOption;
            }
            throw new NetException(20);
        }, IOException.class, iOException -> {
            throw (NetException)new NetException(20).initCause(iOException);
        }));
    }

    private final CompletionStage<ConnOption> executeDescriptionAsync(int n2, DMSFactory.DMSNoun dMSNoun, boolean bl, AsyncOutboundTimeoutHandler asyncOutboundTimeoutHandler, Executor executor) {
        ConnectDescription connectDescription = this.descriptionList.get(n2);
        ArrayList<ConnOption> arrayList = connectDescription.getConnectOptions();
        DownHostsCache.getInstance().reorderAddresses(arrayList);
        this.prepareForExecuteDescription(connectDescription);
        this.outboundConnectTimeout = this.getOutboundConnectTimeout(connectDescription);
        int n3 = connectDescription.getDelayInMillis();
        CompletionStage<Object> completionStage = this.lastRetryCounter <= this.retryCount ? this.executeConnOptionListAsync(this.lastRetryCounter, arrayList, n3, connectDescription.getTransportConnectTimeout(), dMSNoun, bl, this.outboundConnectTimeout, asyncOutboundTimeoutHandler, executor) : CompletionStageUtil.completedStage(null);
        int n4 = n2 + 1;
        return completionStage.exceptionally(CompletionStageUtil.exceptionalCompletionHandler(IOException.class, iOException -> {
            if (n4 < this.descriptionList.size()) {
                return null;
            }
            throw iOException;
        })).thenCompose(CompletionStageUtil.normalCompletionHandler(connOption -> {
            if (connOption != null) {
                this.lastRetryConnectDescription = n2;
                return CompletionStageUtil.completedStage(connOption);
            }
            this.lastRetryCounter = 0;
            return n4 < this.descriptionList.size() ? this.executeDescriptionAsync(n4, dMSNoun, bl, asyncOutboundTimeoutHandler, executor) : CompletionStageUtil.completedStage(null);
        }));
    }

    private CompletionStage<ConnOption> executeConnOptionListAsync(int n2, List<ConnOption> list, int n3, int n4, DMSFactory.DMSNoun dMSNoun, boolean bl, int n5, AsyncOutboundTimeoutHandler asyncOutboundTimeoutHandler, Executor executor) {
        CompletionStage<Object> completionStage = this.nextOptToTry < list.size() ? this.executeNextConnOptionAsync(list, dMSNoun, n4, bl, n5, asyncOutboundTimeoutHandler, executor) : CompletionStageUtil.completedStage(null);
        return completionStage.exceptionally(CompletionStageUtil.exceptionalCompletionHandler(IOException.class, iOException -> {
            if (n2 < this.retryCount) {
                return null;
            }
            throw iOException;
        })).thenCompose(CompletionStageUtil.normalCompletionHandler(connOption -> {
            if (connOption != null) {
                this.lastRetryCounter = n2;
                return CompletionStageUtil.completedStage(connOption);
            }
            this.nextOptToTry = 0;
            if (n2 < this.retryCount) {
                CompletableFuture completableFuture = new CompletableFuture();
                if (n3 <= 0) {
                    completableFuture.complete(null);
                } else {
                    TimeoutInterruptHandler.scheduleTask(() -> completableFuture.complete(null), n3);
                }
                return completableFuture.thenCompose(void_ -> this.executeConnOptionListAsync(n2 + 1, list, n3, n4, dMSNoun, bl, n5, asyncOutboundTimeoutHandler, executor));
            }
            return CompletionStageUtil.completedStage(null);
        }));
    }

    private final CompletionStage<ConnOption> executeNextConnOptionAsync(List<ConnOption> list, DMSFactory.DMSNoun dMSNoun, int n2, boolean bl, int n3, AsyncOutboundTimeoutHandler asyncOutboundTimeoutHandler, Executor executor) {
        this.copt = list.get(this.nextOptToTry);
        this.prepareForExecuteConnOption(this.copt);
        CompletionStage<CompletionStage> completionStage = this.executeConnOptionAsync(this.copt, dMSNoun, bl, n3, asyncOutboundTimeoutHandler, n2, executor).handle(CompletionStageUtil.completionHandler(void_ -> {
            this.handleExecuteConnOptionCompletion(this.copt);
            return CompletionStageUtil.completedStage(this.copt);
        }, IOException.class, iOException -> {
            this.handleExecuteConnOptionFailure(this.copt, (IOException)iOException);
            return this.nextOptToTry < list.size() ? this.executeNextConnOptionAsync(list, dMSNoun, n2, bl, n3, asyncOutboundTimeoutHandler, executor) : CompletionStageUtil.failedStage(iOException);
        }));
        return completionStage.thenCompose(Function.identity());
    }

    private final CompletionStage<Void> executeConnOptionAsync(ConnOption connOption, DMSFactory.DMSNoun dMSNoun, boolean bl, int n2, AsyncOutboundTimeoutHandler asyncOutboundTimeoutHandler, int n3, Executor executor) {
        if (n2 > 0 && bl) {
            try {
                asyncOutboundTimeoutHandler.scheduleTimeout(Duration.ofMillis(n2));
            }
            catch (IOException iOException) {
                return CompletionStageUtil.failedStage(iOException);
            }
        }
        connOption.connectTimeout = n2;
        connOption.transportConnectTimeout = n3;
        CompletionStage<Void> completionStage = connOption.connectAsync(this.socketOptions, dMSNoun, this.sslContext, this.hostnameResolver, asyncOutboundTimeoutHandler, executor);
        if (n2 > 0) {
            return completionStage.whenComplete((void_, throwable) -> {
                if (throwable != null) {
                    asyncOutboundTimeoutHandler.cancelTimeout();
                }
            });
        }
        return completionStage;
    }

    public boolean optAvailable() {
        return this.optFound;
    }

    public void clearElements() {
        this.descriptionList = null;
    }

    public ConnOption getOption() {
        return this.copt;
    }

    public boolean isConnectionSocketKeepAlive() throws SocketException {
        return this.copt.isConnectionSocketKeepAlive();
    }

    public ConnectDescription newConnectDescription() {
        this.currentDescription = new ConnectDescription();
        return this.currentDescription;
    }

    public ConnectDescription currentDescription() {
        return this.currentDescription;
    }

    public void closeDescription() {
        this.descriptionList.add(this.currentDescription);
        this.currentDescription = null;
    }

    public List<ConnectDescription> getAllDescriptions() {
        return this.descriptionList;
    }

    public int getOutboundConnectTimeout() {
        return this.outboundConnectTimeout;
    }

    public boolean isUsingCustomHostnameResolver() {
        return this.hostnameResolver != null;
    }

    private final void setExpireTimeSocketOption(int n2, @Blind(value=PropertiesBlinder.class) Properties properties) {
        if (n2 < 0) {
            return;
        }
        int n3 = n2 * 60;
        properties.putIfAbsent((Object)33, Integer.toString(n3));
    }
}

