/*
 * Decompiled with CFR 0.152.
 */
package oracle.streams;

import java.util.ArrayList;
import java.util.Properties;
import oracle.jdbc.internal.OracleConnection;
import oracle.streams.ChunkColumnValue;
import oracle.streams.DefaultRowLCR;
import oracle.streams.DefaultRowLCRCache;
import oracle.streams.LCR;
import oracle.streams.StreamsException;
import oracle.streams.XStreamLCRCallbackHandler;

public class XStreamOut {
    private static final boolean TRACING = false;
    private String xsOutName = null;
    private long ocisvc;
    private long ocierr;
    private int batchStatus = 0;
    private byte[] fetchLowWatermark = null;
    private static boolean library_loaded = false;
    private int batchInterval = 30;
    private int idleTimeout = 1;
    private DefaultRowLCRCache rowLCRCache = null;
    public static final int DEFAULT_MODE = 0;
    public static final int NEW_COLUMN_ONLY_MODE = 1;
    public static final int DEFAULT_BATCH_INTERVAL = 30;
    public static final int DEFAULT_IDLE_TIMEOUT = 1;
    public static final int FINISHED = 0;
    public static final int EXECUTING = 1;
    public static final int ATTACH_APP_CONTAINER_MODE = 256;
    public static final int ATTACH_EXTENDED_ID_MODE = 512;

    private XStreamOut(long l, long l2, String string) {
        this.xsOutName = string;
        this.ocisvc = l;
        this.ocierr = l2;
        this.rowLCRCache = new DefaultRowLCRCache();
    }

    public static XStreamOut attach(oracle.jdbc.OracleConnection oracleConnection, String string, byte[] byArray, int n) throws StreamsException {
        return XStreamOut.attachInternal(oracleConnection, string, byArray, 30, 1, n);
    }

    public static XStreamOut attach(oracle.jdbc.OracleConnection oracleConnection, String string, byte[] byArray, int n, int n2, int n3) throws StreamsException {
        return XStreamOut.attachInternal(oracleConnection, string, byArray, n, n2, n3);
    }

    private static XStreamOut attachInternal(oracle.jdbc.OracleConnection oracleConnection, String string, byte[] byArray, int n, int n2, int n3) throws StreamsException {
        XStreamOut xStreamOut = null;
        Properties properties = null;
        try {
            OracleConnection oracleConnection2 = oracleConnection.physicalConnectionWithin();
            properties = oracleConnection2.getOCIHandles();
            long l = Long.parseLong(properties.getProperty("OCISvcCtxHandle"));
            long l2 = Long.parseLong(properties.getProperty("OCIErrHandle"));
            xStreamOut = new XStreamOut(l, l2, string);
            xStreamOut.batchInterval = n;
            xStreamOut.idleTimeout = n2;
            xStreamOut.XStreamOutAttachNative(l, l2, string, byArray, n, n2, n3);
        }
        catch (StreamsException streamsException) {
            throw streamsException;
        }
        catch (Exception exception) {
            throw new StreamsException("Oracle XStreamOut: failed to attach to XStream outbound server(" + string + ")\n", exception);
        }
        return xStreamOut;
    }

    public void detach(int n) throws StreamsException {
        try {
            this.XStreamOutDetachNative(this.ocisvc, this.ocierr, n);
        }
        catch (StreamsException streamsException) {
            throw streamsException;
        }
        catch (Exception exception) {
            throw new StreamsException("Oracle XStreamOut: failed to detach from XStream outbound server(" + this.xsOutName + ")\n", exception);
        }
    }

    public void receiveLCRCallback(XStreamLCRCallbackHandler xStreamLCRCallbackHandler, int n) throws StreamsException {
        try {
            this.fetchLowWatermark = this.XStreamOutReceiveLCRCallbackNative(this.ocisvc, this.ocierr, xStreamLCRCallbackHandler, n);
        }
        catch (StreamsException streamsException) {
            throw streamsException;
        }
        catch (Exception exception) {
            throw new StreamsException("XStreamOut receiveLCRCallback: failed to receive LCR from server(" + this.xsOutName + ")\n", exception);
        }
    }

    public LCR receiveLCR(int n) throws StreamsException {
        try {
            ArrayList arrayList = this.XStreamOutReceiveLCRNative(this.ocisvc, this.ocierr, n);
            if (null == arrayList) {
                this.batchStatus = this.rowLCRCache.headerFieldLength[14];
                if (this.rowLCRCache.headerFieldLength[13] > 0) {
                    this.fetchLowWatermark = new byte[this.rowLCRCache.headerFieldLength[13]];
                    System.arraycopy(this.rowLCRCache.lowWaterMark, 0, this.fetchLowWatermark, 0, this.rowLCRCache.headerFieldLength[13]);
                } else {
                    this.fetchLowWatermark = null;
                }
                DefaultRowLCR defaultRowLCR = this.rowLCRCache.exportDefaultRowLCR();
                return defaultRowLCR;
            }
            this.batchStatus = (Integer)arrayList.get(0);
            this.fetchLowWatermark = (byte[])arrayList.get(1);
            return (LCR)arrayList.get(2);
        }
        catch (StreamsException streamsException) {
            throw streamsException;
        }
        catch (Exception exception) {
            throw new StreamsException("XStreamOut receiveLCR: failed to receive LCR from server(" + this.xsOutName + ")\n", exception);
        }
    }

    public ChunkColumnValue receiveChunk(int n) throws StreamsException {
        ChunkColumnValue chunkColumnValue = null;
        try {
            chunkColumnValue = this.XStreamOutReceiveChunkNative(this.ocisvc, this.ocierr, n);
        }
        catch (StreamsException streamsException) {
            throw streamsException;
        }
        catch (Exception exception) {
            throw new StreamsException("Oracle XStreamOut.getNextChunk: failed to Get Next Chunk\n", exception);
        }
        return chunkColumnValue;
    }

    public int getBatchStatus() {
        return this.batchStatus;
    }

    public byte[] getFetchLowWatermark() {
        return this.fetchLowWatermark;
    }

    public void setProcessedLowWatermark(byte[] byArray, int n) throws StreamsException {
        try {
            this.XStreamOutSetProcessedLowWatermarkNative(this.ocisvc, this.ocierr, byArray, n);
        }
        catch (StreamsException streamsException) {
            throw streamsException;
        }
        catch (Exception exception) {
            throw new StreamsException("XStreamOut setProcessedLowWatermark: failed to set watermark\n", exception);
        }
    }

    public void setProcessedLowWatermark(byte[] byArray, byte[] byArray2, int n) throws StreamsException {
        try {
            this.XStreamOutSetProcessedLowWatermark2Native(this.ocisvc, this.ocierr, byArray, byArray2, n);
        }
        catch (StreamsException streamsException) {
            throw streamsException;
        }
        catch (Exception exception) {
            throw new StreamsException("XStreamOut setProcessedLowWatermark2: failed to set watermark\n", exception);
        }
    }

    private synchronized native void XStreamOutAttachNative(long var1, long var3, String var5, byte[] var6, int var7, int var8, int var9) throws StreamsException;

    private synchronized native void XStreamOutDetachNative(long var1, long var3, int var5) throws StreamsException;

    private synchronized native byte[] XStreamOutReceiveLCRCallbackNative(long var1, long var3, XStreamLCRCallbackHandler var5, int var6) throws StreamsException;

    private synchronized native ArrayList XStreamOutReceiveLCRNative(long var1, long var3, int var5) throws StreamsException;

    private synchronized native ChunkColumnValue XStreamOutReceiveChunkNative(long var1, long var3, int var5) throws StreamsException;

    private synchronized native void XStreamOutSetProcessedLowWatermarkNative(long var1, long var3, byte[] var5, int var6) throws StreamsException;

    private synchronized native void XStreamOutSetProcessedLowWatermark2Native(long var1, long var3, byte[] var5, byte[] var6, int var7) throws StreamsException;

    static {
        if (!library_loaded) {
            String string = System.getProperty("os.name");
            if (null != string && string.toUpperCase().startsWith("WINDOWS")) {
                System.loadLibrary("oci");
                library_loaded = true;
            } else if (null != string && string.equalsIgnoreCase("Mac OS X")) {
                System.loadLibrary("clntsh");
                library_loaded = true;
            } else if (string.equalsIgnoreCase("AIX")) {
                System.loadLibrary("clntsh");
                library_loaded = true;
            }
        }
    }
}

