/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.tuners;

import java.lang.reflect.Executable;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Logger;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.admin.UniversalConnectionPoolManagerBase;
import oracle.ucp.common.Clock;
import oracle.ucp.logging.ClioSupport;
import oracle.ucp.logging.annotations.DefaultLogger;
import oracle.ucp.logging.annotations.Feature;
import oracle.ucp.logging.annotations.Supports;
import oracle.ucp.tuners.Tunable;
import oracle.ucp.tuners.stats.Histogram;
import oracle.ucp.tuners.stats.HistogramRegistry;
import oracle.ucp.util.Pair;
import oracle.ucp.util.UCPTaskBase;
import oracle.ucp.util.Util;

@DefaultLogger(value="oracle.ucp.tuners")
@Supports(value={Feature.ADMIN})
public class PoolSizeTuner {
    private static final boolean enabled;
    private static long TUNEUP_TIMEOUT;
    private static int TURN_RING_TIMEOUT;
    private static long SINGLE_RUN_TIMEOUT;
    private static final AtomicBoolean inProgress;
    private static volatile long giveUpTime;
    private static final AtomicBoolean tunedUp;
    private static final Set<Tunable> listTunable;
    private static final ReentrantReadWriteLock rwLock;
    private static final ReentrantReadWriteLock.ReadLock rLock;
    private static final ReentrantReadWriteLock.WriteLock wLock;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;

    public static void trigger() {
        if (!enabled) {
            return;
        }
        giveUpTime = Clock.clock() + SINGLE_RUN_TIMEOUT;
        if (inProgress.compareAndSet(false, true)) {
            try {
                UniversalConnectionPoolManagerBase.getTaskManager().submitTask(PoolSizeTuner.getTunerTask());
            }
            catch (RuntimeException e) {
                inProgress.set(false);
            }
        }
    }

    private static UCPTaskBase<Object> getTunerTask() {
        return new UCPTaskBase<Object>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;

            @Override
            @DefaultLogger(value="oracle.ucp.tuners")
            @Supports(value={Feature.ADMIN})
            public void run() {
                ClioSupport.ilogFinest(null, null, null, null, "started");
                while (Clock.clock() < giveUpTime) {
                    for (int i = 0; i < TURN_RING_TIMEOUT; ++i) {
                        if (!Util.isSelfTunerEnabled()) {
                            return;
                        }
                        try {
                            Thread.sleep(TUNEUP_TIMEOUT);
                        }
                        catch (InterruptedException e) {
                            ClioSupport.ilogThrowing(null, null, null, null, e);
                        }
                        PoolSizeTuner.tuneUp();
                    }
                    PoolSizeTuner.turnRing();
                }
                inProgress.set(false);
                ClioSupport.ilogFinest(null, null, null, null, "ended");
            }

            static {
                try {
                    $$$methodRef$$$1 = 1.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$0 = 1.class.getDeclaredMethod("run", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            }
        };
    }

    private static void turnRing() {
        if (!enabled) {
            return;
        }
        rLock.lock();
        try {
            listTunable.forEach(p -> PoolSizeTuner.turnRing(p));
        }
        finally {
            rLock.unlock();
        }
        ClioSupport.ilogFinest(null, null, null, null, "ring turned");
    }

    private static void turnRing(Tunable tunable) {
        if (!enabled) {
            return;
        }
        tunable.getAvailableRegistry().turnRing();
        tunable.getBorrowedRegistry().turnRing();
        tunable.getCreatedRegistry().turnRing();
    }

    private static void tuneUp() {
        if (!enabled) {
            return;
        }
        rLock.lock();
        try {
            listTunable.forEach(p -> PoolSizeTuner.tuneUp(p));
        }
        finally {
            rLock.unlock();
        }
    }

    private static void tuneUp(Tunable tunable) {
        if (!enabled) {
            return;
        }
        HistogramRegistry availableRegistry = tunable.getAvailableRegistry().collect();
        HistogramRegistry borrowedRegistry = tunable.getBorrowedRegistry().collect();
        HistogramRegistry createdRegistry = tunable.getCreatedRegistry().collect();
        availableRegistry.forEach((cri, availHist) -> PoolSizeTuner.tuneUp(cri, availHist, borrowedRegistry.getHistogram((ConnectionRetrievalInfo)cri), createdRegistry.getHistogram((ConnectionRetrievalInfo)cri), tunable));
    }

    private static void tuneUp(ConnectionRetrievalInfo cri, Histogram availHist, Histogram borrowHist, Histogram createHist, Tunable tunable) {
        if (!enabled) {
            return;
        }
        Pair<Long, Long> availER = availHist.computeEffectiveRange();
        Pair<Long, Long> borrowedER = borrowHist.computeEffectiveRange();
        Pair<Long, Long> createdER = createHist.computeEffectiveRange();
        boolean availGrowsInProgress = tunable.availableGrowsInProgress();
        int neverUsedConnCount = tunable.getNeverUsedConnectionsCounter().getCounter(cri).get();
        int totalConnsCount = tunable.getTotalConnectionsCount(cri);
        String msgEnter = "cri=" + cri + ", availER=" + availER + ", borrowER=" + borrowedER + ", createdER=" + createdER + ", availGrowsInProgress=" + availGrowsInProgress + ", neverUsedConnCount=" + neverUsedConnCount + ", totalConnsCount=" + totalConnsCount;
        ClioSupport.ilogFinest(null, null, null, null, msgEnter);
        if (availER.get1st() >= borrowedER.get1st() || availER.get2nd() > borrowedER.get2nd()) {
            long midAvail = availER.get2nd() + availER.get1st() / 2L;
            long midBorrowed = borrowedER.get2nd() + borrowedER.get1st() / 2L;
            long countToReduce = Math.max(1L, (long)totalConnsCount * (long)Math.ceil((double)Math.abs(midAvail - midBorrowed) / 60000.0));
            int i = 0;
            while ((long)i < countToReduce) {
                tunable.getConnectionReducer().reduce(cri);
                ++i;
            }
            String msgReduce = "attempted to reduce " + countToReduce + " connection(s) for CRI=" + cri;
            ClioSupport.ilogFinest(null, null, null, null, msgReduce);
            tunedUp.set(true);
        } else if (!(availGrowsInProgress || 0 != neverUsedConnCount || createdER.get1st() <= borrowedER.get1st() && createdER.get2nd() <= borrowedER.get2nd())) {
            long midCreated = createdER.get2nd() + createdER.get1st() / 2L;
            long midBorrowed = borrowedER.get2nd() + borrowedER.get1st() / 2L;
            long countToGrow = Math.max(1L, (long)totalConnsCount * (long)Math.ceil((double)Math.abs(midCreated - midBorrowed) / 60000.0));
            int i = 0;
            while ((long)i < countToGrow) {
                tunable.getConnectionGrower().grow(cri);
                ++i;
            }
            String msgGrow = "attempted to grow " + countToGrow + " connection(s) for CRI=" + cri;
            ClioSupport.ilogFinest(null, null, null, null, msgGrow);
            tunedUp.set(true);
        } else {
            tunedUp.set(false);
        }
    }

    private PoolSizeTuner() {
    }

    public static void plug(Tunable poolSizeTunerMetadata) {
        wLock.lock();
        try {
            listTunable.add(poolSizeTunerMetadata);
        }
        finally {
            wLock.unlock();
        }
    }

    public static void unplug(Tunable poolSizeTunerMetadata) {
        wLock.lock();
        try {
            listTunable.remove(poolSizeTunerMetadata);
        }
        finally {
            wLock.unlock();
        }
    }

    static {
        try {
            $$$methodRef$$$12 = PoolSizeTuner.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$11 = PoolSizeTuner.class.getDeclaredMethod("lambda$turnRing$0", Tunable.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$10 = PoolSizeTuner.class.getDeclaredMethod("lambda$tuneUp$1", Tunable.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$9 = PoolSizeTuner.class.getDeclaredMethod("lambda$tuneUp$2", HistogramRegistry.class, HistogramRegistry.class, Tunable.class, ConnectionRetrievalInfo.class, Histogram.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$8 = PoolSizeTuner.class.getDeclaredMethod("unplug", Tunable.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$7 = PoolSizeTuner.class.getDeclaredMethod("plug", Tunable.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$6 = PoolSizeTuner.class.getDeclaredMethod("tuneUp", ConnectionRetrievalInfo.class, Histogram.class, Histogram.class, Histogram.class, Tunable.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$5 = PoolSizeTuner.class.getDeclaredMethod("tuneUp", Tunable.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$4 = PoolSizeTuner.class.getDeclaredMethod("tuneUp", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$3 = PoolSizeTuner.class.getDeclaredMethod("turnRing", Tunable.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$2 = PoolSizeTuner.class.getDeclaredMethod("turnRing", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$1 = PoolSizeTuner.class.getDeclaredMethod("getTunerTask", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$0 = PoolSizeTuner.class.getDeclaredMethod("trigger", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        enabled = Util.isSelfTunerEnabled();
        TUNEUP_TIMEOUT = 5000L;
        TURN_RING_TIMEOUT = 5;
        SINGLE_RUN_TIMEOUT = 600000L;
        inProgress = new AtomicBoolean(false);
        giveUpTime = 0L;
        tunedUp = new AtomicBoolean(false);
        listTunable = new HashSet<Tunable>();
        rwLock = new ReentrantReadWriteLock();
        rLock = rwLock.readLock();
        wLock = rwLock.writeLock();
    }
}

