/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.routing;

import java.lang.reflect.Executable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import oracle.jdbc.OracleShardingKey;
import oracle.jdbc.pool.OracleShardingKeyImpl;
import oracle.ucp.logging.ClioSupport;
import oracle.ucp.routing.Chunk;
import oracle.ucp.routing.HashRangeShardingKeys;
import oracle.ucp.routing.RangeMap;
import oracle.ucp.routing.RoutingKey;
import oracle.ucp.routing.ShardingKeys;
import oracle.ucp.routing.SuperShardingKeys;
import oracle.ucp.util.Pair;

class ShardingRangeMap {
    private final Function<OracleShardingKey, Long> shardKeyOraHash;
    private final RangeMap<OracleShardingKey, RangeMap<Long, Chunk>> hashRangeMap = new RangeMap();
    private RangeMap<Long, Chunk> defaultHashRangeMap = new RangeMap();
    private final RangeMap<OracleShardingKey, RangeMap<OracleShardingKey, Chunk>> rangeMap = new RangeMap();
    private RangeMap<OracleShardingKey, Chunk> defaultRangeMap = new RangeMap();
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;

    ShardingRangeMap(Map<RoutingKey, Chunk> routingTable, Function<OracleShardingKey, Long> shardKeyOraHash) {
        this.shardKeyOraHash = shardKeyOraHash;
        HashMap groupingMap = new HashMap();
        HashMap hashGroupingMap = new HashMap();
        routingTable.entrySet().forEach(entry -> {
            SuperShardingKeys skeys = ((RoutingKey)entry.getKey()).getSuperShardingKeys();
            ShardingKeys keys = ((RoutingKey)entry.getKey()).getShardingKeys();
            Chunk chunk = (Chunk)entry.getValue();
            if (keys instanceof HashRangeShardingKeys) {
                hashGroupingMap.computeIfAbsent(skeys, p -> new ArrayList()).add(new Pair<HashRangeShardingKeys, Chunk>((HashRangeShardingKeys)keys, chunk));
            } else {
                groupingMap.computeIfAbsent(skeys, p -> new ArrayList()).add(new Pair<ShardingKeys, Chunk>(keys, chunk));
            }
        });
        hashGroupingMap.entrySet().forEach(entry -> {
            RangeMap rmap = new RangeMap();
            ((List)entry.getValue()).forEach(pair -> ((HashRangeShardingKeys)pair.get1st()).getKeys().stream().forEach(p -> rmap.put(Long.valueOf(((OracleShardingKeyImpl)p.get1st()).getShardingKeyOraHash()), Long.valueOf(((OracleShardingKeyImpl)p.get2nd()).getShardingKeyOraHash()), (Chunk)pair.get2nd())));
            if (SuperShardingKeys.DEFAULT_SUPER_SHARDING_KEYS == entry.getKey()) {
                this.defaultHashRangeMap = rmap;
            } else if (0 == ((SuperShardingKeys)entry.getKey()).getKeys().size()) {
                this.defaultHashRangeMap = rmap;
            } else {
                ((SuperShardingKeys)entry.getKey()).getKeys().stream().forEach(srange -> this.hashRangeMap.put((OracleShardingKey)srange.get1st(), (OracleShardingKey)srange.get2nd(), rmap));
            }
        });
        ClioSupport.ilogFinest(null, null, null, null, "hashRangeMap=" + (Objects.nonNull(this.hashRangeMap) ? this.hashRangeMap.toString() : "null"));
        ClioSupport.ilogFinest(null, null, null, null, "defaultHashRangeMap=" + (Objects.nonNull(this.defaultHashRangeMap) ? this.defaultHashRangeMap.toString() : "null"));
        groupingMap.entrySet().forEach(entry -> {
            RangeMap rmap = new RangeMap();
            ((List)entry.getValue()).forEach(pair -> ((ShardingKeys)pair.get1st()).getKeys().stream().forEach(p -> rmap.put((OracleShardingKey)p.get1st(), (OracleShardingKey)p.get2nd(), (Chunk)pair.get2nd())));
            if (SuperShardingKeys.DEFAULT_SUPER_SHARDING_KEYS == entry.getKey()) {
                this.defaultRangeMap = rmap;
            } else if (0 == ((SuperShardingKeys)entry.getKey()).getKeys().size()) {
                this.defaultRangeMap = rmap;
            } else {
                ((SuperShardingKeys)entry.getKey()).getKeys().stream().forEach(srange -> this.rangeMap.put((OracleShardingKey)srange.get1st(), (OracleShardingKey)srange.get2nd(), rmap));
            }
        });
        ClioSupport.ilogFinest(null, null, null, null, "rangeMap=" + (Objects.nonNull(this.rangeMap) ? this.rangeMap.toString() : "null"));
        ClioSupport.ilogFinest(null, null, null, null, "defaultRangeMap=" + (Objects.nonNull(this.defaultRangeMap) ? this.defaultRangeMap.toString() : "null"));
    }

    private static <T> List<T> combine(List<T> ... lists) {
        return Stream.of(lists).flatMap(Collection::stream).collect(Collectors.toList());
    }

    List<Chunk> get(OracleShardingKey superKey, OracleShardingKey key) {
        if (Objects.isNull(key)) {
            return Collections.emptyList();
        }
        if (Objects.isNull(superKey) || SuperShardingKeys.DEFAULT_SUPER_SHARDING_KEYS == superKey) {
            if (this.defaultRangeMap.isEmpty()) {
                return this.defaultHashRangeMap.get(this.shardKeyOraHash.apply(key));
            }
            if (this.defaultHashRangeMap.isEmpty()) {
                return this.defaultRangeMap.get(key);
            }
            ClioSupport.ilogWarning(null, null, null, null, "unexpected case: bothe hash and non-hash cases are defined");
            return Stream.of(this.defaultHashRangeMap.get(this.shardKeyOraHash.apply(key)), this.defaultRangeMap.get(key)).flatMap(Collection::stream).collect(Collectors.toList());
        }
        List<Chunk> l1 = this.rangeMap.get(superKey).stream().map(p -> p.get(key)).flatMap(Collection::stream).collect(Collectors.toList());
        List<Chunk> l2 = this.hashRangeMap.get(superKey).stream().map(p -> p.get(this.shardKeyOraHash.apply(key))).flatMap(Collection::stream).collect(Collectors.toList());
        if (l1.isEmpty()) {
            return l2;
        }
        if (l2.isEmpty()) {
            return l1;
        }
        ClioSupport.ilogWarning(null, null, null, null, "unexpected case: bothe hash and non-hash cases are defined");
        return Stream.of(l1, l2).flatMap(Collection::stream).collect(Collectors.toList());
    }

    static {
        try {
            $$$methodRef$$$15 = ShardingRangeMap.class.getDeclaredConstructor(Map.class, Function.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$14 = ShardingRangeMap.class.getDeclaredMethod("lambda$new$0", SuperShardingKeys.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$13 = ShardingRangeMap.class.getDeclaredMethod("lambda$new$1", SuperShardingKeys.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$12 = ShardingRangeMap.class.getDeclaredMethod("lambda$new$2", Map.class, Map.class, Map.Entry.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$11 = ShardingRangeMap.class.getDeclaredMethod("lambda$new$3", RangeMap.class, Pair.class, Pair.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$10 = ShardingRangeMap.class.getDeclaredMethod("lambda$new$4", RangeMap.class, Pair.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$9 = ShardingRangeMap.class.getDeclaredMethod("lambda$new$5", RangeMap.class, Pair.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$8 = ShardingRangeMap.class.getDeclaredMethod("lambda$new$6", Map.Entry.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$7 = ShardingRangeMap.class.getDeclaredMethod("lambda$new$7", RangeMap.class, Pair.class, Pair.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$6 = ShardingRangeMap.class.getDeclaredMethod("lambda$new$8", RangeMap.class, Pair.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$5 = ShardingRangeMap.class.getDeclaredMethod("lambda$new$9", RangeMap.class, Pair.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$4 = ShardingRangeMap.class.getDeclaredMethod("lambda$new$10", Map.Entry.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$3 = ShardingRangeMap.class.getDeclaredMethod("lambda$get$11", OracleShardingKey.class, RangeMap.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$2 = ShardingRangeMap.class.getDeclaredMethod("lambda$get$12", OracleShardingKey.class, RangeMap.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$1 = ShardingRangeMap.class.getDeclaredMethod("get", OracleShardingKey.class, OracleShardingKey.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$0 = ShardingRangeMap.class.getDeclaredMethod("combine", List[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
    }
}

