/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nt;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketOption;
import java.net.UnknownHostException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import javax.net.SocketFactory;
import jdk.net.Sockets;
import oracle.jdbc.OracleHostnameResolver;
import oracle.jdbc.diagnostics.SecuredLogger;
import oracle.jdbc.driver.DMSFactory;
import oracle.jdbc.internal.CompletionStageUtil;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.internal.NetStat;
import oracle.jdbc.logging.annotations.Blind;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.jdbc.logging.annotations.PropertiesBlinder;
import oracle.net.jdbc.nl.NLException;
import oracle.net.jdbc.nl.NVFactory;
import oracle.net.jdbc.nl.NVNavigator;
import oracle.net.jdbc.nl.NVPair;
import oracle.net.ns.NetException;
import oracle.net.ns.SQLnetDef;
import oracle.net.nt.AsyncOutboundTimeoutHandler;
import oracle.net.nt.ConnOption;
import oracle.net.nt.DownHostsCache;
import oracle.net.nt.MetricsEnabledSocketFactory;
import oracle.net.nt.NTAdapter;
import oracle.net.nt.NetStatImpl;
import oracle.net.nt.SocketChannelWrapper;
import oracle.net.nt.TcpMultiplexer;
import oracle.net.nt.TimeoutInterruptHandler;
import oracle.net.nt.TimeoutSocketChannel;

public class TcpNTAdapter
implements NTAdapter {
    static final boolean DEBUG = false;
    private static final int[] SUPPORTED_SOCKET_OPTIONS = new int[]{0, 1, 33, 34, 35};
    private static Proxy DEFAULT_SOCKS_PROXY = null;
    protected final SecuredLogger securedLogger;
    private final String addressInfo;
    private final OracleHostnameResolver hostnameResolver;
    NetStatImpl netStat = null;
    Boolean useNio;
    int port;
    String host;
    String protocol;
    String uri;
    NVNavigator nav;
    NVPair nvpAddr;
    protected SocketChannelWrapper socketChannel;
    Iterator<InetAddress> inetAddresses = null;
    protected Socket socket;
    protected int sockTimeout;
    protected final Properties socketOptions;
    protected Proxy proxy = null;
    protected boolean isRemoteDNS = true;
    protected int connectTimeout = 0;
    private final ConnOption connOption;
    SocketFactory sockFactory;
    private volatile boolean isRegisteredEver = false;
    private static Hashtable<String, InetAddress[]> inetaddressesCache;
    private static Hashtable<String, Integer> circularOffsets;
    private static final Monitor CIRCULAR_OFFSETS_MONITOR;

    public TcpNTAdapter(String string, @Blind(value=PropertiesBlinder.class) Properties properties, OracleHostnameResolver oracleHostnameResolver, ConnOption connOption) throws NLException {
        this.connOption = connOption;
        this.socketOptions = properties;
        this.addressInfo = string;
        this.hostnameResolver = oracleHostnameResolver;
        this.useNio = Boolean.parseBoolean((String)properties.get(20));
        this.isRemoteDNS = Boolean.parseBoolean((String)properties.getOrDefault((Object)39, "false"));
        this.connectTimeout = Integer.parseInt((String)properties.getOrDefault((Object)2, "0"));
        this.securedLogger = null;
        this.netStat = new NetStatImpl();
        this.initializeAddressValues(string);
        this.initializeProxy();
    }

    private void initializeAddressValues(String string) throws NLException {
        this.nav = new NVNavigator();
        this.nvpAddr = new NVFactory().createNVPair(string);
        NVPair nVPair = this.nav.findNVPair(this.nvpAddr, "HOST");
        NVPair nVPair2 = this.nav.findNVPair(this.nvpAddr, "PORT");
        NVPair nVPair3 = this.nav.findNVPair(this.nvpAddr, "PROTOCOL");
        if (nVPair == null) {
            throw new NLException("NoNVPair-04614", "HOST");
        }
        this.host = nVPair.getAtom();
        if (nVPair2 != null) {
            try {
                this.port = Integer.parseInt(nVPair2.getAtom());
            }
            catch (Exception exception) {
                throw (NLException)new NLException(new NetException(116).getMessage()).initCause(exception);
            }
        } else {
            this.port = 1521;
        }
        if (this.port < 0 || this.port > 65535) {
            throw new NLException(new NetException(116).getMessage());
        }
        if (nVPair3 != null) {
            this.protocol = nVPair3.getAtom();
        }
    }

    protected void initializeProxy() {
        this.proxy = this.socketOptions.containsKey(36) && this.socketOptions.containsKey(37) ? new Proxy(Proxy.Type.SOCKS, new InetSocketAddress((String)this.socketOptions.get(36), Integer.parseInt((String)this.socketOptions.get(37)))) : DEFAULT_SOCKS_PROXY;
    }

    @Override
    public void connect(DMSFactory.DMSNoun dMSNoun) throws IOException, InterruptedIOException {
        this.sockFactory = new MetricsEnabledSocketFactory(dMSNoun);
        if (this.isRemoteDNS && this.proxy != null) {
            this.doRemoteDNSLookupConnect(dMSNoun);
        } else {
            this.doLocalDNSLookupConnect(dMSNoun);
        }
        this.setSocketOptions();
    }

    protected void doLocalDNSLookupConnect(DMSFactory.DMSNoun dMSNoun) throws IOException, InterruptedIOException {
        if (this.inetAddresses == null) {
            this.inetAddresses = this.resolveInetAddresses();
        }
        while (true) {
            InetAddress inetAddress = this.inetAddresses.next();
            try {
                this.establishSocket(new InetSocketAddress(inetAddress, this.port), dMSNoun);
            }
            catch (InterruptedIOException interruptedIOException) {
                DownHostsCache.getInstance().markDownHost(inetAddress, this.port);
                throw interruptedIOException;
            }
            catch (IOException iOException) {
                DownHostsCache.getInstance().markDownHost(inetAddress, this.port);
                if (this.inetAddresses.hasNext()) continue;
                this.resetInetAddress();
                throw iOException;
                if (this.inetAddresses.hasNext()) continue;
            }
            break;
        }
    }

    protected void doRemoteDNSLookupConnect(DMSFactory.DMSNoun dMSNoun) throws IOException, InterruptedIOException {
        InetSocketAddress inetSocketAddress = InetSocketAddress.createUnresolved(this.host, this.port);
        this.establishSocket(inetSocketAddress, dMSNoun);
    }

    private byte[] prepareTcpFastOpenDataAndGet() throws UnsupportedEncodingException, NetException {
        byte[] byArray = null;
        if (SQLnetDef.isTcpFastOpenEnabled((String)this.socketOptions.get(109))) {
            byArray = this.getTFOBytes(this.connOption.getConnectData());
            if (byArray == null) {
                byArray = this.getTFOBytes(this.connOption.getOriginalConnOption().getConnectData());
            }
            if (byArray != null) {
                this.connOption.setConnectData(new String(byArray));
            }
        }
        return byArray;
    }

    private byte[] getTFOBytes(String string) throws NetException {
        if (string == null || string.isEmpty()) {
            return null;
        }
        try {
            NVPair nVPair;
            NVPair nVPair2 = new NVFactory().createNVPair(string);
            NVNavigator nVNavigator = new NVNavigator();
            NVPair nVPair3 = nVNavigator.findNVPair(nVPair2, "CONNECT_DATA");
            if (nVPair3 == null) {
                return null;
            }
            NVPair nVPair4 = nVPair = nVNavigator.findNVPair(nVPair3, "USE_TCP_FAST_OPEN") != null ? nVNavigator.findNVPair(nVPair3, "USE_TCP_FAST_OPEN") : nVNavigator.findNVPair(nVPair3, "TFO");
            if (nVPair == null) {
                nVPair3.addListElement(new NVPair("USE_TCP_FAST_OPEN", "yes"));
            } else {
                nVPair.setAtom("yes");
            }
            String string2 = nVPair2.toString();
            return string2.getBytes("ASCII");
        }
        catch (Exception exception) {
            throw new NetException(102);
        }
    }

    protected void establishSocket(InetSocketAddress inetSocketAddress, DMSFactory.DMSNoun dMSNoun) throws IOException, InterruptedIOException {
        long l2 = System.currentTimeMillis();
        try {
            if (this.useNio.booleanValue()) {
                this.socketChannel = new TimeoutSocketChannel(inetSocketAddress, this.connectTimeout, this.netStat, this.proxy, this.securedLogger, this.prepareTcpFastOpenDataAndGet());
                this.socket = this.socketChannel.socket();
            } else {
                this.socket = this.sockFactory.createSocket();
                this.socket.connect(inetSocketAddress, this.connectTimeout);
            }
            this.setReadTimeoutIfRequired(this.socketOptions);
        }
        catch (TimeoutInterruptHandler.IOReadTimeoutException iOReadTimeoutException) {
            this.trySocketClose();
            throw new IOException(this.describeConnectionFailure(iOReadTimeoutException, l2, inetSocketAddress), iOReadTimeoutException);
        }
        catch (InterruptedIOException interruptedIOException) {
            this.trySocketClose();
            InterruptedIOException interruptedIOException2 = new InterruptedIOException(this.describeConnectionFailure(interruptedIOException, l2, inetSocketAddress));
            interruptedIOException2.initCause(interruptedIOException);
            throw interruptedIOException2;
        }
        catch (IOException iOException) {
            this.trySocketClose();
            throw new IOException(this.describeConnectionFailure(iOException, l2, inetSocketAddress), iOException);
        }
    }

    private void trySocketClose() {
        try {
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String describeConnectionFailure(IOException iOException, long l2, InetSocketAddress inetSocketAddress) {
        return String.format("%s, socket connect lapse %d ms. %s %d %s %s %s %s", iOException.getMessage(), System.currentTimeMillis() - l2, inetSocketAddress.getHostString(), this.port, this.proxy == null ? "" : "Proxy = " + this.proxy.toString(), this.connectTimeout, this.inetAddresses, this.useNio);
    }

    @Override
    public CompletionStage<Void> connectAsync(DMSFactory.DMSNoun dMSNoun, AsyncOutboundTimeoutHandler asyncOutboundTimeoutHandler, Executor executor) {
        if (!this.useNio.booleanValue()) {
            return CompletionStageUtil.failedStage(new IOException("Asynchronous connection is not supported when oracle.jdbc.javaNetNio=false"));
        }
        if (this.proxy != null) {
            return CompletionStageUtil.failedStage(new IOException("Asynchronous connection is not supported with proxies"));
        }
        this.sockFactory = new MetricsEnabledSocketFactory(dMSNoun);
        try {
            if (this.inetAddresses == null) {
                this.inetAddresses = this.resolveInetAddresses();
            }
        }
        catch (UnknownHostException unknownHostException) {
            return CompletionStageUtil.failedStage(unknownHostException);
        }
        return this.chainAsyncConnectionAttempts(asyncOutboundTimeoutHandler, executor).thenApply(CompletionStageUtil.normalCompletionHandler(void_ -> {
            this.setSocketOptions();
            return void_;
        }));
    }

    private final CompletionStage<Void> chainAsyncConnectionAttempts(AsyncOutboundTimeoutHandler asyncOutboundTimeoutHandler, Executor executor) {
        InetAddress inetAddress = this.inetAddresses.next();
        InetSocketAddress inetSocketAddress = new InetSocketAddress(inetAddress, this.port);
        long l2 = System.currentTimeMillis();
        this.netStat = new NetStatImpl();
        return TimeoutSocketChannel.openAsync(inetSocketAddress, this.connectTimeout, this.netStat, this.securedLogger, asyncOutboundTimeoutHandler, executor).thenApply(CompletionStageUtil.normalCompletionHandler(timeoutSocketChannel -> {
            this.socketChannel = timeoutSocketChannel;
            this.socket = this.socketChannel.socket();
            this.setReadTimeoutIfRequired(this.socketOptions);
            return true;
        })).exceptionally(CompletionStageUtil.exceptionalCompletionHandler(IOException.class, iOException -> {
            this.trySocketClose();
            DownHostsCache.getInstance().markDownHost(inetAddress, this.port);
            if (this.inetAddresses.hasNext()) {
                return false;
            }
            String string = this.describeConnectionFailure((IOException)iOException, l2, inetSocketAddress);
            this.resetInetAddress();
            IOException iOException2 = new IOException(string, iOException);
            throw iOException2;
        })).thenCompose(bl -> bl != false ? CompletionStageUtil.VOID_COMPLETED_FUTURE : this.chainAsyncConnectionAttempts(asyncOutboundTimeoutHandler, executor));
    }

    protected final Iterator<InetAddress> resolveInetAddresses() throws UnknownHostException {
        InetAddress[] inetAddressArray = null;
        inetAddressArray = this.hostnameResolver != null ? this.hostnameResolver.getAllByName(this.host) : InetAddress.getAllByName(this.host);
        boolean bl = Boolean.parseBoolean((String)this.socketOptions.get(18));
        if (bl && inetAddressArray.length > 1) {
            inetAddressArray = TcpNTAdapter.getAddressesInCircularOrder(this.host, inetAddressArray);
        }
        DownHostsCache.getInstance().reorderAddresses(inetAddressArray, this.port);
        return new InetAddressIterator(inetAddressArray);
    }

    @Override
    public final boolean hasMoreInetAddresses() {
        return this.inetAddresses != null && this.inetAddresses.hasNext();
    }

    @Override
    public final void resetInetAddress() {
        this.inetAddresses = null;
    }

    @Override
    public NetStat getNetStat() {
        return this.netStat;
    }

    final void setSocketOptions() throws IOException {
        for (int n2 : SUPPORTED_SOCKET_OPTIONS) {
            Integer n3 = n2;
            String string = (String)this.socketOptions.get(n3);
            if (string == null) continue;
            this.setOption(n2, string);
        }
    }

    @Override
    public void disconnect() throws IOException {
        try {
            if (this.useNio.booleanValue()) {
                this.socketChannel.disconnect();
            } else if (this.socket != null && !this.socket.isClosed()) {
                this.socket.close();
            }
        }
        finally {
            this.socket = null;
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.socket.getInputStream();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.socket.getOutputStream();
    }

    @Override
    public void setOption(int n2, Object object) throws IOException, NetException {
        if (this.isClosed()) {
            throw new NetException(200);
        }
        switch (n2) {
            case 0: {
                this.setTcpNoDelay((String)object);
                break;
            }
            case 1: {
                this.setTcpKeepAlive((String)object);
                break;
            }
            case 3: 
            case 101: {
                this.setTcpReadTimeout((String)object);
                break;
            }
            case 33: {
                this.setTcpKeepAliveIdleTime((String)object);
                break;
            }
            case 34: {
                this.setTcpKeepAliveProbeInterval((String)object);
                break;
            }
            case 35: {
                this.setTcpKeepAliveProbeCount((String)object);
                break;
            }
        }
    }

    private final void setTcpNoDelay(String string) throws IOException {
        this.socket.setTcpNoDelay(string.equals("YES"));
    }

    private final void setTcpKeepAlive(String string) throws IOException {
        if (string.equals("YES")) {
            this.socket.setKeepAlive(true);
        }
    }

    private final void setTcpReadTimeout(String string) throws IOException {
        this.sockTimeout = Integer.parseInt(string);
        if (!this.useNio.booleanValue()) {
            this.socket.setSoTimeout(this.sockTimeout);
        } else {
            this.socketChannel.setSoTimeout(this.sockTimeout);
        }
    }

    private final void setTcpKeepAliveIdleTime(String string) throws IOException {
        this.setSocketOption(this.getSocketOptionByNameAndType("TCP_KEEPIDLE", Integer.class), Integer.valueOf(string));
    }

    private final void setTcpKeepAliveProbeInterval(String string) throws IOException {
        this.setSocketOption(this.getSocketOptionByNameAndType("TCP_KEEPINTERVAL", Integer.class), Integer.valueOf(string));
    }

    private final void setTcpKeepAliveProbeCount(String string) throws IOException {
        this.setSocketOption(this.getSocketOptionByNameAndType("TCP_KEEPCOUNT", Integer.class), Integer.valueOf(string));
    }

    private final <T> SocketOption<T> getSocketOptionByNameAndType(String string, Class<T> clazz) throws IOException {
        Set<SocketOption<?>> set = this.useNio != false ? this.socketChannel.supportedOptions() : Sockets.supportedOptions(this.socket.getClass());
        SocketOption socketOption2 = set.stream().filter(socketOption -> string.equals(socketOption.name())).findFirst().orElseThrow(() -> new IOException("Socket option " + string + " is not supported by SocketChannels opened in this JVM"));
        if (!socketOption2.type().equals(clazz)) {
            throw new IOException("Unexpected type for socket option " + string + ". SocketOption.type() to returns " + socketOption2.type() + " Expected type is: " + clazz);
        }
        return socketOption2;
    }

    private final <T> void setSocketOption(SocketOption<T> socketOption, T t2) throws IOException {
        if (this.useNio.booleanValue()) {
            this.socketChannel.setOption((SocketOption)socketOption, (Object)t2);
        } else {
            Sockets.setOption(this.socket, socketOption, t2);
        }
    }

    @Override
    public Object getOption(int n2) throws IOException, NetException {
        if (this.isClosed()) {
            throw new NetException(200);
        }
        switch (n2) {
            case 101: {
                return "" + this.sockTimeout;
            }
            case 3: {
                if (!this.useNio.booleanValue()) {
                    return Integer.toString(this.socket.getSoTimeout());
                }
                return this.socketChannel.getSoTimeout();
            }
        }
        return null;
    }

    @Override
    public void abort() throws NetException, IOException {
        if (this.socket != null) {
            try {
                this.socket.setSoLinger(true, 0);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.socket.close();
        }
        this.abortTcpMultiplexerRegistration();
    }

    private final void abortTcpMultiplexerRegistration() {
        if (!this.useNio.booleanValue()) {
            return;
        }
        if (this.socketChannel == null) {
            return;
        }
        if (!this.isRegisteredEver) {
            return;
        }
        this.cancelNonBlockingRegistration(new IOException("Connection aborted"));
    }

    @Override
    public void sendUrgentByte(int n2) throws IOException {
        this.socket.sendUrgentData(n2);
    }

    @Override
    public boolean isCharacteristicUrgentSupported() throws IOException {
        try {
            return !this.socket.getOOBInline();
        }
        catch (IOException iOException) {
            return false;
        }
    }

    @Override
    public void setReadTimeoutIfRequired(@Blind(value=PropertiesBlinder.class) Properties properties) throws IOException, NetException {
        String string = (String)properties.get("oracle.net.READ_TIMEOUT");
        if (string == null) {
            string = (String)properties.get(3);
        }
        if (string == null) {
            string = "0";
        }
        this.setOption(3, string);
    }

    public String getAddressInfo() {
        return this.addressInfo;
    }

    @DisableTrace
    public String toString() {
        return "host=" + this.host + ", port=" + this.port + "\n    socket_timeout=" + this.sockTimeout + ", socketOptions=" + this.socketOptions.toString() + "\n    socket=" + this.socket;
    }

    static final InetAddress[] getAddressesInCircularOrder(String string, InetAddress[] inetAddressArray) {
        try (Monitor.CloseableLock closeableLock = CIRCULAR_OFFSETS_MONITOR.acquireCloseableLock();){
            InetAddress[] inetAddressArray2 = inetaddressesCache.get(string);
            Integer n2 = circularOffsets.get(string);
            if (inetAddressArray2 == null || !TcpNTAdapter.areEquals(inetAddressArray2, inetAddressArray)) {
                n2 = new Integer(0);
                inetAddressArray2 = inetAddressArray;
                inetaddressesCache.put(string, inetAddressArray);
                circularOffsets.put(string, n2);
            }
            InetAddress[] inetAddressArray3 = TcpNTAdapter.getCopyAddresses(inetAddressArray2, n2);
            circularOffsets.put(string, new Integer((n2 + 1) % inetAddressArray2.length));
            InetAddress[] inetAddressArray4 = inetAddressArray3;
            return inetAddressArray4;
        }
    }

    private static final boolean areEquals(InetAddress[] inetAddressArray, InetAddress[] inetAddressArray2) {
        if (inetAddressArray.length != inetAddressArray2.length) {
            return false;
        }
        for (int i2 = 0; i2 < inetAddressArray.length; ++i2) {
            if (inetAddressArray[i2].equals(inetAddressArray2[i2])) continue;
            return false;
        }
        return true;
    }

    private static final InetAddress[] getCopyAddresses(InetAddress[] inetAddressArray, int n2) {
        InetAddress[] inetAddressArray2 = new InetAddress[inetAddressArray.length];
        for (int i2 = 0; i2 < inetAddressArray.length; ++i2) {
            inetAddressArray2[i2] = inetAddressArray[(i2 + n2) % inetAddressArray.length];
        }
        return inetAddressArray2;
    }

    private final boolean isClosed() {
        if (this.socket == null) {
            return true;
        }
        return this.socket.isClosed();
    }

    @Override
    public boolean isConnectionSocketKeepAlive() throws SocketException {
        return this.socket.getKeepAlive();
    }

    @Override
    public InetAddress getInetAddress() {
        return this.socket.getInetAddress();
    }

    @Override
    public SocketChannel getSocketChannel() {
        return this.socketChannel;
    }

    @Override
    public NTAdapter.NetworkAdapterType getNetworkAdapterType() {
        return NTAdapter.NetworkAdapterType.TCP;
    }

    @Override
    public final void registerForNonBlockingRead(Consumer<Throwable> consumer) throws IOException {
        this.isRegisteredEver = true;
        this.socketChannel.registerForNonBlockingRead(consumer);
    }

    @Override
    public final void registerForNonBlockingWrite(Consumer<Throwable> consumer) throws IOException {
        this.isRegisteredEver = true;
        this.socketChannel.registerForNonBlockingWrite(consumer);
    }

    @Override
    public final void cancelNonBlockingRegistration(Throwable throwable) {
        TcpMultiplexer.cancelRegistration(this.socketChannel.getUnderlyingChannel(), throwable);
    }

    /*
     * Loose catch block
     */
    @Override
    public final boolean awaitWriteReadiness(long l2) throws IOException {
        SocketChannel socketChannel = SocketChannelWrapper.unwrap(this.getSocketChannel());
        if (socketChannel == null) {
            throw new ClosedChannelException();
        }
        boolean bl = socketChannel.isBlocking();
        try {
            try (Selector selector = Selector.open();){
                socketChannel.configureBlocking(false);
                socketChannel.register(selector, 4);
                boolean bl2 = 0 != selector.select(l2);
                return bl2;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            socketChannel.configureBlocking(bl);
        }
    }

    @Override
    @Blind
    public Properties getSqlNetOptions() {
        return (Properties)this.socketOptions.clone();
    }

    static {
        try {
            String string = System.getProperty("socksProxyHost", null);
            if (string != null) {
                DEFAULT_SOCKS_PROXY = new Proxy(Proxy.Type.SOCKS, new InetSocketAddress(string, Integer.parseInt(System.getProperty("socksProxyPort", "1080"))));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        inetaddressesCache = new Hashtable();
        circularOffsets = new Hashtable();
        CIRCULAR_OFFSETS_MONITOR = Monitor.newInstance();
    }

    private final class InetAddressIterator
    implements Iterator<InetAddress> {
        private final InetAddress[] addresses;
        private int addressIndex = 0;

        private InetAddressIterator(InetAddress[] inetAddressArray) {
            this.addresses = inetAddressArray;
        }

        @Override
        public boolean hasNext() {
            return this.addressIndex < this.addresses.length;
        }

        @Override
        public InetAddress next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.addresses[this.addressIndex++];
        }

        public String toString() {
            return "(" + this.addressIndex + "/" + this.addresses.length + ")";
        }
    }
}

