/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nt;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.SocketChannel;
import java.util.TimerTask;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import oracle.jdbc.diagnostics.SecuredLogger;
import oracle.jdbc.internal.CompletionStageUtil;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.net.nt.AsyncOutboundTimeoutHandler;
import oracle.net.nt.NetStatImpl;
import oracle.net.nt.ProxyHelper;
import oracle.net.nt.SocketChannelWrapper;
import oracle.net.nt.TcpFastOpen;
import oracle.net.nt.TcpMultiplexer;
import oracle.net.nt.TimeoutInterruptHandler;

class TimeoutSocketChannel
extends SocketChannelWrapper {
    private int soTimeout = 0;
    TimeoutInterruptHandler.InterruptTask interruptTask;
    NetStatImpl netStat = null;
    private final SecuredLogger securedLogger;
    private final Proxy proxy;
    private final InetSocketAddress serverAddress;
    private volatile boolean isTimeoutExpired = false;
    private byte[] tcpFastOpenBytes;

    private TimeoutSocketChannel(InetSocketAddress inetSocketAddress, NetStatImpl netStatImpl, Proxy proxy, SecuredLogger securedLogger) {
        super((SocketChannel)null);
        this.serverAddress = inetSocketAddress;
        this.securedLogger = securedLogger;
        this.netStat = netStatImpl;
        this.proxy = proxy;
    }

    public TimeoutSocketChannel(InetSocketAddress inetSocketAddress, int n2, NetStatImpl netStatImpl, Proxy proxy, SecuredLogger securedLogger, byte[] byArray) throws IOException, InterruptedIOException, TimeoutInterruptHandler.IOReadTimeoutException {
        this(inetSocketAddress, netStatImpl, proxy, securedLogger);
        this.tcpFastOpenBytes = byArray;
        this.connect(inetSocketAddress, n2);
    }

    private void connect(InetSocketAddress inetSocketAddress, int n2) throws IOException, InterruptedIOException, TimeoutInterruptHandler.IOReadTimeoutException {
        this.scheduleInterrupt(n2, false);
        try {
            if (this.proxy == null) {
                this.socketChannel = SocketChannel.open(this.getSocketAddress(inetSocketAddress));
            } else {
                this.socketChannel = SocketChannel.open(this.getSocketAddress(this.proxy.address()));
                ProxyHelper.connectViaProxy(this.proxy, this.serverAddress, this.socketChannel);
            }
            this.socketChannel.configureBlocking(true);
        }
        finally {
            this.cancelTimeout();
        }
    }

    private SocketAddress getSocketAddress(SocketAddress socketAddress) throws IOException {
        if (this.tcpFastOpenBytes == null) {
            return socketAddress;
        }
        return TcpFastOpen.setTcpFastOpenBytes((InetSocketAddress)socketAddress, this.tcpFastOpenBytes);
    }

    static CompletionStage<TimeoutSocketChannel> openAsync(InetSocketAddress inetSocketAddress, int n2, NetStatImpl netStatImpl, SecuredLogger securedLogger, AsyncOutboundTimeoutHandler asyncOutboundTimeoutHandler, Executor executor) {
        TimeoutSocketChannel timeoutSocketChannel = new TimeoutSocketChannel(inetSocketAddress, netStatImpl, null, securedLogger);
        return timeoutSocketChannel.connectAsync(n2, asyncOutboundTimeoutHandler, executor).thenApply(void_ -> timeoutSocketChannel);
    }

    private final CompletionStage<Void> connectAsync(int n2, AsyncOutboundTimeoutHandler asyncOutboundTimeoutHandler, Executor executor) {
        Object object;
        if (this.proxy != null) {
            return CompletionStageUtil.failedStage(new IOException("Asynchronous proxy connection is not supported"));
        }
        try {
            object = SocketChannel.open();
            asyncOutboundTimeoutHandler.setChannel((SocketChannel)object);
            this.socketChannel = object;
            this.socketChannel.configureBlocking(false);
            if (this.socketChannel.connect(this.serverAddress)) {
                this.socketChannel.configureBlocking(true);
                return CompletionStageUtil.completedStage(null);
            }
        }
        catch (IOException iOException) {
            return CompletionStageUtil.failedStage(iOException);
        }
        object = new AsyncConnectTask(executor);
        ((AsyncConnectTask)object).start();
        CompletionStage completionStage = ((AsyncConnectTask)object).getConnectStage();
        if (n2 > 0) {
            TimerTask timerTask = TimeoutInterruptHandler.scheduleTask(() -> TimeoutSocketChannel.lambda$connectAsync$1((AsyncConnectTask)object), n2);
            return completionStage.whenComplete((void_, throwable) -> timerTask.cancel());
        }
        return completionStage;
    }

    void setNetStat(NetStatImpl netStatImpl) {
        this.netStat = netStatImpl;
    }

    @Override
    public void disconnect() throws IOException {
        try {
            if (this.socketChannel != null) {
                this.socketChannel.close();
            }
        }
        finally {
            this.cleanup();
        }
    }

    @Override
    public void setSoTimeout(int n2) {
        this.soTimeout = n2;
    }

    @Override
    public int getSoTimeout() {
        return this.soTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(ByteBuffer byteBuffer) throws IOException {
        this.scheduleInterrupt(this.getSoTimeout(), true);
        int n2 = -1;
        try {
            n2 = this.socketChannel.read(byteBuffer);
            if (this.netStat != null) {
                this.netStat.incrementBytesReceived(n2);
            }
        }
        catch (ClosedByInterruptException closedByInterruptException) {
            this.handleInterrupt();
        }
        finally {
            this.cancelTimeout();
        }
        return n2;
    }

    @Override
    public long read(ByteBuffer[] byteBufferArray, int n2, int n3) throws IOException {
        throw new IOException("Unsupported feature");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int write(ByteBuffer byteBuffer) throws IOException {
        this.scheduleInterrupt(this.getSoTimeout(), false);
        try {
            if (this.socketChannel == null) {
                throw new IOException("Socket channel is closed");
            }
            int n2 = this.socketChannel.write(byteBuffer);
            if (this.netStat != null) {
                this.netStat.incrementBytesSent(n2);
            }
            int n3 = n2;
            return n3;
        }
        catch (ClosedByInterruptException closedByInterruptException) {
            this.handleInterrupt();
        }
        finally {
            this.cancelTimeout();
        }
        return -1;
    }

    @Override
    public long write(ByteBuffer[] byteBufferArray, int n2, int n3) throws IOException {
        throw new IOException("Unsupported feature");
    }

    @DisableTrace
    public String toString() {
        return "TimeoutSocketChannel[" + this.socket().toString() + "]";
    }

    private void scheduleInterrupt(int n2, boolean bl) {
        if (n2 > 0) {
            this.interruptTask = TimeoutInterruptHandler.scheduleInterrupt(TimeoutInterruptHandler.InterruptTaskType.SO_TIMEOUT, n2, Thread.currentThread(), this, bl);
        }
    }

    private final void interruptNow(boolean bl) {
        this.interruptTask = bl ? new TimeoutInterruptHandler.InterruptTask(Thread.currentThread(), Integer.MAX_VALUE, this) : new TimeoutInterruptHandler.InterruptTask(Thread.currentThread(), Integer.MAX_VALUE, null);
        this.interruptTask.run();
    }

    private void handleInterrupt() throws InterruptedIOException, TimeoutInterruptHandler.IOReadTimeoutException {
        Thread.interrupted();
        try {
            this.disconnect();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.interruptTask != null && this.interruptTask.isInterrupted()) {
            throw new TimeoutInterruptHandler.IOReadTimeoutException("Socket read timed out");
        }
        throw new InterruptedIOException("Socket read interrupted");
    }

    private void cleanup() {
        this.socketChannel = null;
    }

    private void cancelTimeout() {
        if (this.interruptTask != null) {
            TimeoutInterruptHandler.cancelInterrupt(TimeoutInterruptHandler.InterruptTaskType.SO_TIMEOUT, Thread.currentThread());
            if (this.interruptTask.isInterrupted()) {
                Thread.interrupted();
            }
            this.interruptTask = null;
        }
    }

    @Override
    final void registerForNonBlockingRead(Consumer<Throwable> consumer) throws IOException {
        SocketChannel socketChannel = this.requireOpenChannel();
        if (this.soTimeout > 0) {
            AtomicBoolean atomicBoolean = new AtomicBoolean(false);
            TimerTask timerTask = this.scheduleRegistrationCancel(socketChannel, this.soTimeout, atomicBoolean);
            try {
                TcpMultiplexer.registerForReadEvent(socketChannel, throwable -> {
                    timerTask.cancel();
                    consumer.accept((Throwable)throwable);
                });
                atomicBoolean.set(true);
            }
            catch (IOException iOException) {
                timerTask.cancel();
                throw iOException;
            }
        } else {
            TcpMultiplexer.registerForReadEvent(socketChannel, consumer);
        }
    }

    @Override
    final void registerForNonBlockingWrite(Consumer<Throwable> consumer) throws IOException {
        SocketChannel socketChannel = this.requireOpenChannel();
        if (this.soTimeout > 0) {
            AtomicBoolean atomicBoolean = new AtomicBoolean(false);
            TimerTask timerTask = this.scheduleRegistrationCancel(socketChannel, this.soTimeout, atomicBoolean);
            try {
                TcpMultiplexer.registerForWriteEvent(socketChannel, throwable -> {
                    timerTask.cancel();
                    consumer.accept((Throwable)throwable);
                });
                atomicBoolean.set(true);
            }
            catch (IOException iOException) {
                timerTask.cancel();
                throw iOException;
            }
        } else {
            TcpMultiplexer.registerForWriteEvent(socketChannel, consumer);
        }
    }

    private TimerTask scheduleRegistrationCancel(SocketChannel socketChannel, int n2, AtomicBoolean atomicBoolean) {
        return TimeoutInterruptHandler.scheduleTask(() -> {
            while (!atomicBoolean.get() && !Thread.currentThread().isInterrupted()) {
            }
            this.isTimeoutExpired = true;
            TcpMultiplexer.cancelRegistration(socketChannel, null);
        }, n2);
    }

    private static /* synthetic */ void lambda$connectAsync$1(AsyncConnectTask asyncConnectTask) {
        asyncConnectTask.setTimeoutExpired();
    }

    static {
        TcpFastOpen.init();
    }

    private class AsyncConnectTask
    implements Consumer<Throwable> {
        private final Executor asyncExecutor;
        private final Monitor cancellationLock = Monitor.newInstance();
        private final CompletableFuture<Void> connectFuture = new CompletableFuture();
        private boolean isTimeoutExpired = false;

        private AsyncConnectTask(Executor executor) {
            this.asyncExecutor = executor;
        }

        private void start() {
            try {
                TcpMultiplexer.registerForConnectEvent(TimeoutSocketChannel.this.socketChannel, this);
            }
            catch (IOException iOException) {
                this.connectFuture.completeExceptionally(iOException);
            }
        }

        @Override
        public void accept(Throwable throwable) {
            this.asyncExecutor.execute(() -> this.handleReadiness(throwable));
        }

        private final void handleReadiness(Throwable throwable) {
            try (Monitor.CloseableLock closeableLock = this.cancellationLock.acquireCloseableLock();){
                if (throwable != null) {
                    this.connectFuture.completeExceptionally(throwable);
                } else if (!this.isTimeoutExpired) {
                    TimeoutSocketChannel.this.socketChannel.configureBlocking(false);
                    if (TimeoutSocketChannel.this.socketChannel.finishConnect()) {
                        TimeoutSocketChannel.this.socketChannel.configureBlocking(true);
                        this.connectFuture.complete(null);
                    } else {
                        TcpMultiplexer.registerForConnectEvent(TimeoutSocketChannel.this.socketChannel, this);
                    }
                }
            }
            catch (IOException iOException) {
                this.connectFuture.completeExceptionally(iOException);
            }
        }

        private final void setTimeoutExpired() {
            this.isTimeoutExpired = true;
            try (Monitor.CloseableLock closeableLock = this.cancellationLock.acquireCloseableLock();){
                TimeoutInterruptHandler.IOReadTimeoutException iOReadTimeoutException = new TimeoutInterruptHandler.IOReadTimeoutException("Socket connect timed out");
                this.asyncExecutor.execute(() -> this.connectFuture.completeExceptionally(iOReadTimeoutException));
                try {
                    TcpMultiplexer.cancelRegistration(TimeoutSocketChannel.this.socketChannel, iOReadTimeoutException);
                    TimeoutSocketChannel.this.socketChannel.close();
                }
                catch (IOException iOException) {
                    this.connectFuture.completeExceptionally(iOReadTimeoutException);
                }
            }
        }

        private final CompletionStage<Void> getConnectStage() {
            return this.connectFuture;
        }
    }
}

