@echo off 
REM ====================================================================== 
REM This batch file uninstalls components in an Oracle Instant Client Home 
REM ====================================================================== 
 
 
goto :ParseArgs 
 
 
 
REM ************************ 
REM UNINSTALL ALL COMPONENTS 
REM ************************ 
:UninstallAll 
 
call :odp.net4 %1 %2 
call :odpm %1 %2 
call :asp.net4 %1 %2 
call :oledb %1 %2 
call :oledbolap %1 %2 
call :oramts %1 %2 
call :basic %1 %2 
 
del /f bin\oracle.key  2>nul  2>nul
del /f oracle.key  2>nul  2>nul
del /f install.log  2>nul  2>nul
del /f configure.bat  2>nul  2>nul
del /f unconfigure.bat  2>nul  2>nul
del /f network\admin\sample\tnsnames.ora  2>nul  2>nul
del /f network\admin\sample\sqlnet.ora  2>nul  2>nul
rmdir bin 2>nul 
rmdir network\admin\sample 2>nul 
rmdir network\admin 2>nul 
rmdir network 2>nul 
 
goto :EOF 
 
 
 
 
REM **************************** 
REM UNINSTALL ASPNET Providers 4 
REM **************************** 
 
:asp.net4 
 
REM proceed only if component is installed 
if EXIST asp.net\bin\4\Oracle.Web.dll ( 
 
echo ******************************************* >> uninstall.log 
echo Uninstalling Oracle Providers for ASP.NET 4 >> uninstall.log 
echo ******************************************* >> uninstall.log 
 
call unconfigure.bat asp.net4 %2 
 
del /f asp.net\bin\4\Oracle.Web.dll  2>nul
del /f asp.net\bin\4\OraProvCfg.exe  2>nul
REM SQL files are common to both asp.net and asp.net 4 
REM Remove only if asp.net is not present 
if NOT EXIST asp.net\bin\2.x\Oracle.Web.dll ( 
del /f asp.net\SQL\InstallAllOracleASPNETProviders.sql  2>nul
del /f asp.net\SQL\InstallOracleASPNETCommon.sql  2>nul
del /f asp.net\SQL\InstallOracleASPNETCommonSP.plb  2>nul
del /f asp.net\SQL\InstallOracleMembership.sql  2>nul
del /f asp.net\SQL\InstallOracleMembershipSP.plb  2>nul
del /f asp.net\SQL\InstallOraclePersonalization.sql  2>nul
del /f asp.net\SQL\InstallOraclePersonalizationSP.plb  2>nul
del /f asp.net\SQL\InstallOracleProfile.sql  2>nul
del /f asp.net\SQL\InstallOracleProfileSP.plb  2>nul
del /f asp.net\SQL\InstallOracleRoles.sql  2>nul
del /f asp.net\SQL\InstallOracleRolesSP.plb  2>nul
del /f asp.net\SQL\InstallOracleSessionState.sql  2>nul
del /f asp.net\SQL\InstallOracleSessionStateSP.plb  2>nul
del /f asp.net\SQL\InstallOracleSiteMap.sql  2>nul
del /f asp.net\SQL\InstallOracleSiteMapSP.plb  2>nul
del /f asp.net\SQL\InstallOracleWebEvents.sql  2>nul
del /f asp.net\SQL\InstallOracleWebEventsSP.plb  2>nul
del /f asp.net\SQL\UninstallAllOracleASPNETProviders.sql  2>nul
del /f asp.net\SQL\UninstallOracleASPNETCommon.sql  2>nul
del /f asp.net\SQL\UninstallOracleMembership.sql  2>nul
del /f asp.net\SQL\UninstallOraclePersonalization.sql  2>nul
del /f asp.net\SQL\UninstallOracleProfile.sql  2>nul
del /f asp.net\SQL\UninstallOracleRoles.sql  2>nul
del /f asp.net\SQL\UninstallOracleSessionState.sql  2>nul
del /f asp.net\SQL\UninstallOracleSiteMap.sql  2>nul
del /f asp.net\SQL\UninstallOracleWebEvents.sql  2>nul
) 
rmdir asp.net\bin\4 2>nul 
rmdir asp.net\sql 2>nul 
rmdir asp.net\bin 2>nul 
rmdir asp.net 2>nul 
 
echo.>> uninstall.log 
echo ****************************************** >> uninstall.log 
echo Oracle Providers for ASP.NET 4 uninstalled >> uninstall.log 
echo ****************************************** >> uninstall.log 
echo.>> uninstall.log 
) 
 
REM echo ASP.NET Providers 4 are now uninstalled in an Oracle Instant Client Home. 
 
goto :EOF 
 
 
 
 
 
 
REM ******************* 
REM UNINSTALL ODP.NET 4 
REM ******************* 
 
:odp.net4 
 
REM proceed only if component is installed 
if EXIST odp.net\bin\4\Oracle.DataAccess.dll ( 
 
echo ******************************************** >> uninstall.log 
echo Uninstalling Oracle Data Provider for .NET 4 >> uninstall.log 
echo ******************************************** >> uninstall.log 
 
call unconfigure.bat odp.net4 %2 %MACHINE_WIDE_UNCONFIG% 
 
del /f odp.net\bin\4\Oracle.DataAccess.dll  2>nul
del /f odp.net\bin\4\OraProvCfg.exe  2>nul
del /f odp.net\PerfCounters\register_odpu_perfmon_counters.ps1  2>nul
del /f odp.net\PerfCounters\unregister_odpu_perfmon_counters.ps1  2>nul
del /f odp.net\PublisherPolicy\4\Policy.4.112.Oracle.DataAccess.config  2>nul
del /f odp.net\PublisherPolicy\4\Policy.4.112.Oracle.DataAccess.dll  2>nul
del /f odp.net\PublisherPolicy\4\Policy.4.121.Oracle.DataAccess.config  2>nul
del /f odp.net\PublisherPolicy\4\Policy.4.121.Oracle.DataAccess.dll  2>nul
del /f odp.net\PublisherPolicy\4\Policy.4.122.Oracle.DataAccess.config  2>nul
del /f odp.net\PublisherPolicy\4\Policy.4.122.Oracle.DataAccess.dll  2>nul
del /f bin\OraOps.dll  2>nul
rmdir odp.net\PublisherPolicy\4 2>nul 
rmdir odp.net\bin\4 2>nul 
rmdir odp.net\PublisherPolicy 2>nul 
rmdir odp.net\PerfCounters 2>nul 
rmdir odp.net\bin 2>nul 
rmdir odp.net 2>nul 
rmdir bin 2>nul 
 
echo.>> uninstall.log 
echo ******************************************* >> uninstall.log 
echo Oracle Data Provider for .NET 4 uninstalled >> uninstall.log 
echo ******************************************* >> uninstall.log 
echo.>> uninstall.log 
) 
 
REM echo ODP.NET 4 now uninstalled in an Oracle Instant Client Home. 
 
goto :EOF 
 
 
 
 
 
 
REM ************** 
REM UNINSTALL ODPM 
REM ************** 
 
:odpm 
 
REM proceed only if component is installed 
if EXIST odp.net\managed\common\Oracle.ManagedDataAccess.dll ( 
 
echo ********************************************************** >> uninstall.log 
echo Uninstalling Oracle Data Provider for .NET, Managed Driver >> uninstall.log 
echo ********************************************************** >> uninstall.log 
 
call unconfigure.bat odpm %2 %MACHINE_WIDE_UNCONFIG% 
 
del /f odp.net\managed\common\Oracle.ManagedDataAccess.dll  2>nul
del /f odp.net\managed\PublisherPolicy\4\Policy.4.121.Oracle.ManagedDataAccess.config  2>nul
del /f odp.net\managed\PublisherPolicy\4\Policy.4.121.Oracle.ManagedDataAccess.dll  2>nul
del /f odp.net\managed\PublisherPolicy\4\Policy.4.122.Oracle.ManagedDataAccess.config  2>nul
del /f odp.net\managed\PublisherPolicy\4\Policy.4.122.Oracle.ManagedDataAccess.dll  2>nul
del /f odp.net\managed\x64\configure.bat  2>nul
del /f odp.net\managed\x64\Oracle.ManagedDataAccessIOP.dll  2>nul
del /f odp.net\managed\x64\OraProvCfg.exe  2>nul
del /f odp.net\managed\x64\unconfigure.bat  2>nul
del /f odp.net\managed\x86\configure.bat  2>nul
del /f odp.net\managed\x86\Oracle.ManagedDataAccessIOP.dll  2>nul
del /f odp.net\managed\x86\OraProvCfg.exe  2>nul
del /f odp.net\managed\x86\unconfigure.bat  2>nul
del /f odp.net\PerfCounters\register_odpm_perfmon_counters.ps1  2>nul
del /f odp.net\PerfCounters\unregister_odpm_perfmon_counters.ps1  2>nul
rmdir odp.net\managed\PublisherPolicy\4 2>nul 
rmdir odp.net\managed\x86 2>nul 
rmdir odp.net\managed\x64 2>nul 
rmdir odp.net\managed\PublisherPolicy 2>nul 
rmdir odp.net\managed\common 2>nul 
rmdir odp.net\PerfCounters 2>nul 
rmdir odp.net\managed 2>nul 
rmdir odp.net 2>nul 
 
echo.>> uninstall.log 
echo ********************************************************* >> uninstall.log 
echo Oracle Data Provider for .NET, Managed Driver uninstalled >> uninstall.log 
echo ********************************************************* >> uninstall.log 
echo.>> uninstall.log 
) 
 
REM echo ODP.NET 4 now uninstalled in an Oracle Instant Client Home. 
 
goto :EOF 
 
 
 
 
 
 
REM *************** 
REM UNINSTALL OLEDB 
REM *************** 
 
:oledb 
 
REM proceed only if component is installed 
if EXIST bin\OraOLEDB.dll ( 
 
echo *************************************** >> uninstall.log 
echo Uninstalling Oracle Provider for OLE DB >> uninstall.log 
echo *************************************** >> uninstall.log 
 
call unconfigure.bat oledb %2 
 
del /f OraOledbIC.dll  2>nul
del /f bin\OraOLEDB.dll  2>nul
del /f bin\OraOLEDB.tlb  2>nul
del /f bin\OraOLEDBd.dll  2>nul
del /f bin\oraoledbe.dll  2>nul
del /f bin\oraoledbf.dll  2>nul
del /f bin\OraOLEDBgmr.dll  2>nul
del /f bin\oraoledbi.dll  2>nul
del /f bin\OraOLEDBja.dll  2>nul
del /f bin\OraOLEDBko.dll  2>nul
del /f bin\oraoledbptb.dll  2>nul
del /f bin\OraOLEDBpus.dll  2>nul
del /f bin\OraOLEDBrfc.dll  2>nul
del /f bin\OraOLEDBrmc.dll  2>nul
del /f bin\OraOLEDBrst.dll  2>nul
del /f bin\OraOLEDBus.dll  2>nul
del /f bin\OraOLEDButl.dll  2>nul
del /f bin\oraoledbzhs.dll  2>nul
del /f bin\oraoledbzht.dll  2>nul
rmdir bin 2>nul 
 
echo.>> uninstall.log 
echo ************************************** >> uninstall.log 
echo Oracle Provider for OLE DB uninstalled >> uninstall.log 
echo ************************************** >> uninstall.log 
echo.>> uninstall.log 
) 
 
REM echo OLEDB now uninstalled from an Oracle Instant Client Home. 
 
goto :EOF 
 
 
 
 
 
 
REM ******************** 
REM UNINSTALL OLEDB OLAP 
REM ******************** 
 
:oledbolap 
 
REM proceed only if component is installed 
if EXIST bin\OraOLEDBOLAP.dll ( 
 
echo ******************************************** >> uninstall.log 
echo Uninstalling Oracle Provider for OLE DB OLAP >> uninstall.log 
echo ******************************************** >> uninstall.log 
 
call unconfigure.bat oledbolap %2 
 
del /f OraOledbOlapIC.dll  2>nul
del /f bin\OraOLEDBOLAP.dll  2>nul
del /f bin\OraOLEDBOLAPcst.dll  2>nul
del /f bin\OraOLEDBOLAPpus.dll  2>nul
del /f bin\OraOLEDBOLAPrfc.dll  2>nul
del /f bin\OraOLEDBOLAPrmc.dll  2>nul
del /f bin\OraOLEDBOLAPrst.dll  2>nul
del /f bin\OraOLEDBOLAPus.dll  2>nul
del /f bin\OraOLEDBOLAPutl.dll  2>nul
rmdir bin 2>nul 
 
echo.>> uninstall.log 
echo ******************************************* >> uninstall.log 
echo Oracle Provider for OLE DB OLAP uninstalled >> uninstall.log 
echo ******************************************* >> uninstall.log 
echo.>> uninstall.log 
) 
 
REM echo OLEDB OLAP now uninstalled from an Oracle Instant Client Home. 
 
goto :EOF 
 
 
 
 
 
 
REM **************** 
REM UNINSTALL ORAMTS 
REM **************** 
 
:oramts 
 
REM proceed only if component is installed 
if EXIST bin\oramts.dll ( 
 
echo ************************************ >> uninstall.log 
echo Uninstalling Oracle Services for MTS >> uninstall.log 
echo ************************************ >> uninstall.log 
 
call unconfigure.bat oramts %2 %MACHINE_WIDE_UNCONFIG% 
 
del /f bin\omtsreco.exe  2>nul
del /f bin\omtsrecoeentd.dll  2>nul
del /f bin\omtsrecoeente.dll  2>nul
del /f bin\omtsrecoeentf.dll  2>nul
del /f bin\omtsrecoeventd.dll  2>nul
del /f bin\omtsrecoevente.dll  2>nul
del /f bin\omtsrecoevntd.dll  2>nul
del /f bin\omtsrecoevnte.dll  2>nul
del /f bin\omtsrecoevntf.dll  2>nul
del /f bin\omtsrecoevnti.dll  2>nul
del /f bin\omtsrecoevntja.dll  2>nul
del /f bin\omtsrecoevntko.dll  2>nul
del /f bin\omtsrecoevntptb.dll  2>nul
del /f bin\omtsrecoevntus.dll  2>nul
del /f bin\omtsrecoevntzhs.dll  2>nul
del /f bin\omtsrecoevntzht.dll  2>nul
del /f bin\omtsrecomsgus.dll  2>nul
del /f bin\oramts.dll  2>nul
del /f bin\oramtsus.dll  2>nul
del /f oramts\admin\oramtsadmin.sql  2>nul
del /f oramts\admin\prvtoramts.plb  2>nul
del /f oramts\admin\utl_oramts.sql  2>nul
del /f oramts\doc\readme.txt  2>nul
del /f oramts\install\genreg.bat  2>nul
del /f oramts\mesg\omtsus.msb  2>nul
rmdir oramts\trace 2>nul 
rmdir oramts\mesg 2>nul 
rmdir oramts\install 2>nul 
rmdir oramts\doc 2>nul 
rmdir oramts\admin 2>nul 
rmdir oramts 2>nul 
rmdir bin 2>nul 
 
echo.>> uninstall.log 
echo *********************************** >> uninstall.log 
echo Oracle Services for MTS uninstalled >> uninstall.log 
echo *********************************** >> uninstall.log 
echo.>> uninstall.log 
) 
 
REM echo ORAMTS now uninstalled from an Oracle Instant Client Home. 
 
goto :EOF 
 
 
 
 
 
 
REM ************************************* 
REM UNINSTALL Basic Oracle Instant Client 
REM ************************************* 
 
:basic 
 
REM proceed only if component is installed 
if EXIST oci.dll ( 
 
echo **************************************** >> uninstall.log 
echo Uninstalling Basic Oracle Instant Client >> uninstall.log 
echo **************************************** >> uninstall.log 
 
call unconfigure.bat basic %2 %MACHINE_WIDE_UNCONFIG% 
 
del /f adrci.exe  2>nul
del /f adrci.sym  2>nul
del /f BASIC_LICENSE  2>nul
del /f BASIC_README  2>nul
del /f genezi.exe  2>nul
del /f genezi.sym  2>nul
del /f oci.dll  2>nul
del /f oci.sym  2>nul
del /f ocijdbc21.dll  2>nul
del /f ocijdbc21.sym  2>nul
del /f ociw32.dll  2>nul
del /f ociw32.sym  2>nul
del /f ojdbc11.jar  2>nul
del /f ojdbc8.jar  2>nul
del /f oramysql.dll  2>nul
del /f oramysql.sym  2>nul
del /f orannzsbb.dll  2>nul
del /f orannzsbb.sym  2>nul
del /f oraocci21.dll  2>nul
del /f oraocci21.sym  2>nul
del /f oraocci21d.dll  2>nul
del /f oraocci21d.sym  2>nul
del /f oraociei.dll  2>nul
del /f oraociei.sym  2>nul
del /f orasql.dll  2>nul
del /f orasql.sym  2>nul
del /f ucp.jar  2>nul
del /f ucp11.jar  2>nul
del /f uidrvci.exe  2>nul
del /f uidrvci.sym  2>nul
del /f xstreams.jar  2>nul
del /f network\admin\README  2>nul
rmdir network\admin 2>nul 
rmdir network 2>nul 
 
echo.>> uninstall.log 
echo *************************************** >> uninstall.log 
echo Basic Oracle Instant Client uninstalled >> uninstall.log 
echo *************************************** >> uninstall.log 
echo.>> uninstall.log 
) 
 
REM echo Basic Oracle Instant Client is now uninstalled in an Oracle Instant Client Home. 
 
goto :EOF 
 
 
 
 
 
 
REM ======================= 
REM Parse Script Arguments 
REM ======================= 
:ParseArgs 
if /i {%1} == {} goto :Usage 
if /i {%2} == {} goto :Usage 
if /i {%1} == {-h} goto :Usage 
if /i {%1} == {-help} goto :Usage 
 
REM unconfigure machine wide or not - default is false 
set MACHINE_WIDE_UNCONFIG=false 
if /i {%3} == {true} set MACHINE_WIDE_UNCONFIG=true 
 
if /i {%1} == {basic}     goto :basic 
if /i {%1} == {odp.net4}  goto :odp.net4 
if /i {%1} == {odpm}  goto :odpm 
if /i {%1} == {asp.net4}  goto :asp.net4 
if /i {%1} == {oledb}     goto :oledb 
if /i {%1} == {oledbolap} goto :oledbolap 
if /i {%1} == {oramts}    goto :oramts 
if /i {%1} == {all}       goto :UninstallAll 
 
 
goto :Usage 
 
 
:Usage 
echo. 
echo Usage: 
echo   uninstall.bat component_name oracle_home_name [machine_wide_unconfiguration] 
echo   or 
echo   uninstall.bat component_name oracle_home_path [machine_wide_unconfiguration] 
echo. 
echo Example: 
echo   uninstall.bat all       myhome           (uninstall all components and do not unconfigure at machine wide level) 
echo   uninstall.bat odp.net4  myhome     true  (uninstall ODP.NET 4 and unconfigure at machine wide level) 
echo   uninstall.bat odpm      myhome           (uninstall ODP.NET Managed Provider) 
echo   uninstall.bat asp.net4  myhome           (uninstall ASP.NET Providers 4) 
echo   uninstall.bat oledb     c:\oracle        (uninstall OraOLEDB) 
echo   uninstall.bat oledbolap c:\oracle        (uninstall OraOLEDB OLAP) 
echo   uninstall.bat oramts    c:\oracle        (uninstall ORAMTS) 
echo   uninstall.bat basic     myhome           (uninstall Oracle Instant Client) 
echo. 
echo NOTE: By default, machine_wide_unconfiguration=false. 
goto :EOF 
