/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.common;

import java.lang.reflect.Executable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.pool.OraclePooledConnection;
import oracle.jdbc.xa.client.OracleXAConnection;
import oracle.ucp.ConnectionHarvestingCallback;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.UniversalPooledConnection;
import oracle.ucp.UniversalPooledConnectionStatus;
import oracle.ucp.admin.UniversalConnectionPoolManagerBase;
import oracle.ucp.common.Clock;
import oracle.ucp.common.CoreConnection;
import oracle.ucp.common.ONSDriver;
import oracle.ucp.common.Service;
import oracle.ucp.common.ServiceMember;
import oracle.ucp.common.Topology;
import oracle.ucp.common.UniversalPooledConnectionImpl;
import oracle.ucp.jdbc.JDBCConnectionRetrievalInfo;
import oracle.ucp.jdbc.oracle.OracleUniversalPooledConnection;
import oracle.ucp.logging.ClioSupport;
import oracle.ucp.util.TaskHandle;
import oracle.ucp.util.TaskManagerException;
import oracle.ucp.util.UCPTaskBase;

public class CoreConnectionImpl
implements CoreConnection {
    private static final long CLOSE_TIMEOUT = 5000L;
    private static final short DB_VERSION_122 = 12200;
    private final Service service;
    private final UniversalPooledConnection upc;
    private final Properties props;
    private ServiceMember serviceMember;
    private boolean replayable = false;
    private AtomicBoolean pendingClose = new AtomicBoolean(false);
    private final Topology connectionSource;
    private final Semaphore acSemaphore = new Semaphore(1);
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;
    private static Executable $$$methodRef$$$32;
    private static Logger $$$loggerRef$$$32;
    private static Executable $$$methodRef$$$33;
    private static Logger $$$loggerRef$$$33;
    private static Executable $$$methodRef$$$34;
    private static Logger $$$loggerRef$$$34;
    private static Executable $$$methodRef$$$35;
    private static Logger $$$loggerRef$$$35;
    private static Executable $$$methodRef$$$36;
    private static Logger $$$loggerRef$$$36;
    private static Executable $$$methodRef$$$37;
    private static Logger $$$loggerRef$$$37;
    private static Executable $$$methodRef$$$38;
    private static Logger $$$loggerRef$$$38;
    private static Executable $$$methodRef$$$39;
    private static Logger $$$loggerRef$$$39;
    private static Executable $$$methodRef$$$40;
    private static Logger $$$loggerRef$$$40;
    private static Executable $$$methodRef$$$41;
    private static Logger $$$loggerRef$$$41;
    private static Executable $$$methodRef$$$42;
    private static Logger $$$loggerRef$$$42;

    static CoreConnection create(Service service, Object delegate) throws UniversalConnectionPoolException {
        return new CoreConnectionImpl(service, delegate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoreConnectionImpl(Service service, Object delegate) throws UniversalConnectionPoolException {
        this.service = Objects.requireNonNull(service);
        this.connectionSource = Objects.requireNonNull(this.service.connectionSource());
        this.upc = (UniversalPooledConnection)Objects.requireNonNull(delegate);
        this.props = this.upc.getDatabaseConnectionProperties();
        this.serviceMember = new ServiceMember(this.props, service);
        ClioSupport.ilogFinest(null, null, null, null, "about to create: " + this.connStats());
        try {
            ONSDriver onsDrvr;
            service.setName(this.serviceMember.service());
            service.setContainerName(this.fetchContainerName());
            service.placement.addAll(this.fetchServicePlacement());
            String onsConfig = this.connectionSource.getONSConfig();
            if (null == onsConfig || "".equals(onsConfig)) {
                onsConfig = this.props.getProperty("AUTH_ONS_CONFIG");
            }
            if (this.connectionSource.failoverEnabled()) {
                ClioSupport.ilogFinest(null, null, null, null, "failover enabled - about to start ONS");
                try {
                    onsDrvr = this.connectionSource.onsDriver(onsConfig);
                    if (onsDrvr != null) {
                        service.failoverDriver.start(onsDrvr);
                        String serviceName = this.serviceMember.service();
                        if (null != serviceName) {
                            service.loadBalancer.start(onsDrvr, serviceName);
                        }
                    }
                }
                catch (Throwable e) {
                    ClioSupport.ilogWarning(null, null, null, null, "failed to start ONS with the following exception: " + Arrays.toString(e.getStackTrace()));
                }
                finally {
                    ClioSupport.ilogFinest(null, null, null, null, "attempted to start ONS");
                }
            }
            this.serviceMember = service.insertMember(this.serviceMember);
            this.serviceMember.activeCount.incrementAndGet();
            this.serviceMember.serviceRef.lbStats.onOpened();
            this.serviceMember.lbStats.onOpened();
            this.connectionSource.totalCount().incrementAndGet();
            this.serviceMember.serviceRef.activeCount.incrementAndGet();
            this.connectionSource.totalCount(this.upc.getConnectionRetrievalInfo()).incrementAndGet();
            if (this.connectionSource.isDataDependentRoutingEnabled()) {
                onsDrvr = this.connectionSource.onsDriver(onsConfig);
                service.routingCache().startEventHandler(onsDrvr);
                service.routingCache().onConnectionCreation((Connection)this.getPhysicalConnection(), this.cri());
            }
            service.onRegister();
        }
        finally {
            ClioSupport.ilogFinest(null, null, null, null, "created: " + this.connStats());
        }
    }

    @Override
    public void makeAvailable() {
        this.upc.heartbeat();
        this.upc.setAvailableStartTime();
        try {
            this.upc.removeConnectionHarvestingCallback();
        }
        catch (UniversalConnectionPoolException e) {
            ClioSupport.ilogThrowing(null, null, null, null, e);
        }
        if (this.upc.setAvailable()) {
            long delta = Clock.clock() - this.upc.getBorrowedStartTime();
            this.serviceMember.serviceRef.lbStats.onReturned(delta);
            this.serviceMember.lbStats.onReturned(delta);
            this.serviceMember.borrowedCount.decrementAndGet();
            this.connectionSource.borrowedCount().decrementAndGet();
            this.serviceMember.serviceRef.borrowedCount.decrementAndGet();
            this.connectionSource.cumulativeConnectionUseTime().addAndGet(delta);
            this.connectionSource.borrowedCount(this.upc.getConnectionRetrievalInfo()).decrementAndGet();
        }
    }

    @Override
    public void makeUnavailable() {
        this.upc.heartbeat();
        this.upc.setBorrowedStartTime();
        if (this.upc.setBorrowed()) {
            this.serviceMember.lbStats.onBorrowed(this.serviceMember.borrowedCount.incrementAndGet());
            this.serviceMember.serviceRef.lbStats.onBorrowed(this.connectionSource.borrowedCount().incrementAndGet());
            this.serviceMember.serviceRef.borrowedCount.incrementAndGet();
            this.connectionSource.borrowedCount(this.upc.getConnectionRetrievalInfo()).incrementAndGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void markReconnecting() {
        block11: {
            if (this.normal()) {
                String origInst = this.serviceMember().name();
                try {
                    this.acSemaphore.acquire();
                    if (origInst == null || !origInst.equals(this.serviceMember().name())) break block11;
                    try {
                        this.upc.setStatus(UniversalPooledConnectionStatus.STATUS_RECONNECTING);
                    }
                    catch (UniversalConnectionPoolException e) {
                        ClioSupport.ilogThrowing(null, null, null, null, e);
                    }
                    finally {
                        this.abort();
                        this.close();
                    }
                }
                catch (InterruptedException e) {
                    ClioSupport.ilogThrowing(null, null, null, null, e);
                }
                finally {
                    this.acSemaphore.release();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reinitialize() {
        try {
            this.acSemaphore.acquire();
            boolean avail = this.available();
            ServiceMember oldInst = this.serviceMember();
            Properties props = this.upc.getDatabaseConnectionProperties();
            this.serviceMember = new ServiceMember(props, this.service);
            this.serviceMember = this.service.insertMember(this.serviceMember);
            this.serviceMember.activeCount.incrementAndGet();
            if (!avail) {
                this.serviceMember.borrowedCount.incrementAndGet();
            }
            this.serviceMember.lbStats.onOpened();
            this.serviceMember.serviceRef.lbStats.onOpened();
            oldInst.activeCount.decrementAndGet();
            oldInst.lbStats.onClosed();
            oldInst.serviceRef.lbStats.onClosed();
            if (!avail) {
                oldInst.borrowedCount.decrementAndGet();
            }
            try {
                this.upc.setStatus(UniversalPooledConnectionStatus.STATUS_NORMAL);
            }
            catch (UniversalConnectionPoolException e) {
                ClioSupport.ilogThrowing(null, null, null, null, e);
            }
        }
        catch (InterruptedException e) {
            ClioSupport.ilogThrowing(null, null, null, null, e);
        }
        finally {
            this.acSemaphore.release();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean repurpose(ConnectionRetrievalInfo newCri) {
        if (!(this.cri() instanceof JDBCConnectionRetrievalInfo)) {
            return false;
        }
        if (!(newCri instanceof JDBCConnectionRetrievalInfo)) {
            return false;
        }
        if (!(this.cri() instanceof JDBCConnectionRetrievalInfo)) {
            return false;
        }
        if (this.closed()) return false;
        if (!this.valid()) {
            return false;
        }
        OracleConnection oConn = (OracleConnection)this.getPhysicalConnection();
        if (oConn == null) {
            return false;
        }
        JDBCConnectionRetrievalInfo repurposeCri = (JDBCConnectionRetrievalInfo)newCri;
        String repurposeSvcName = repurposeCri.getServiceName();
        JDBCConnectionRetrievalInfo connCri = (JDBCConnectionRetrievalInfo)this.cri();
        if (!repurposeCri.equals(connCri.getCopyWithService(repurposeSvcName))) {
            return false;
        }
        try (Statement stmt = oConn.createStatement();){
            Service newSvc = this.connectionSource.service(repurposeSvcName);
            String setContainerStr = "alter session set container=" + newSvc.containerName() + " service=\"" + newSvc.name() + "\"";
            stmt.execute(setContainerStr);
            String newContainerName = this.fetchContainerName();
            Properties connProps = this.upc.getDatabaseConnectionProperties();
            String newServiceName = connProps.getProperty("SERVICE_NAME");
            if (!newSvc.name().equalsIgnoreCase(newServiceName) && !newSvc.containerName().equalsIgnoreCase(newContainerName)) {
                ClioSupport.ilogWarning(null, null, null, null, "Repurposing connection from service " + this.serviceName() + "to service " + newSvc.name() + "failed");
                boolean bl2 = false;
                return bl2;
            }
            ClioSupport.ilogFinest(null, null, null, null, "Repurposed connection from service " + this.serviceName() + "to service " + newSvc.name());
            if (this.getDelegate() instanceof OracleUniversalPooledConnection) {
                OracleUniversalPooledConnection jdbcConn = (OracleUniversalPooledConnection)this.getDelegate();
                jdbcConn.setPdbSessionInitialized(false);
                this.connectionSource.totalCount(connCri).decrementAndGet();
                ConnectionRetrievalInfo repurposedCri = repurposeCri.getCopyWithService(newServiceName).getCopyWithNoLabels();
                jdbcConn.setConnectionRetrievalInfo(repurposedCri);
                this.connectionSource.totalCount(repurposedCri).incrementAndGet();
            }
            this.serviceMember.activeCount.decrementAndGet();
            this.serviceMember.lbStats.onClosed();
            this.serviceMember.serviceRef.activeCount.decrementAndGet();
            this.serviceMember.serviceRef.lbStats.onClosed();
            this.serviceMember = new ServiceMember(connProps, newSvc);
            this.serviceMember = newSvc.insertMember(this.serviceMember);
            this.serviceMember.activeCount.incrementAndGet();
            newSvc.lbStats.onOpened();
            this.serviceMember.lbStats.onOpened();
            newSvc.activeCount.incrementAndGet();
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            ClioSupport.ilogThrowing(null, null, null, null, e);
            return false;
        }
    }

    private String connStats() {
        String totalStats = "(borrowed=" + this.connectionSource.borrowedCount().get() + ", total=" + this.connectionSource.totalCount().get() + ")";
        String serviceStats = "(service=" + this.service.name() + ", borrowed=" + this.service.borrowedCount.get() + ", total=" + this.service.activeCount.get() + ")";
        String serviceMemberStats = "(serviceMember:" + this.service.getAllMembers().toString() + ")";
        return totalStats + ", " + serviceStats + ", " + serviceMemberStats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        block20: {
            try {
                boolean reconnecting;
                block19: {
                    UniversalPooledConnectionStatus current;
                    ClioSupport.ilogFinest(null, null, null, null, "about to close: " + this.connStats());
                    do {
                        if (UniversalPooledConnectionStatus.STATUS_CLOSED.equals(current = ((UniversalPooledConnectionImpl)this.upc).m_status.get()) && ((UniversalPooledConnectionImpl)this.upc).m_status.compareAndSet(current, UniversalPooledConnectionStatus.STATUS_CLOSED)) {
                            return;
                        }
                        if (!UniversalPooledConnectionStatus.STATUS_RECONNECTING.equals(current) || !((UniversalPooledConnectionImpl)this.upc).m_status.compareAndSet(current, UniversalPooledConnectionStatus.STATUS_RECONNECTING)) continue;
                        reconnecting = true;
                        break block19;
                    } while (!((UniversalPooledConnectionImpl)this.upc).m_status.compareAndSet(current, UniversalPooledConnectionStatus.STATUS_CLOSED));
                    reconnecting = false;
                }
                if (!this.available() && !reconnecting) {
                    long delta = Clock.clock() - this.upc.getBorrowedStartTime();
                    this.serviceMember.serviceRef.lbStats.onReturned(delta);
                    this.serviceMember.lbStats.onReturned(delta);
                    this.serviceMember.borrowedCount.decrementAndGet();
                    this.serviceMember.serviceRef.borrowedCount.decrementAndGet();
                    this.connectionSource.borrowedCount().decrementAndGet();
                    this.connectionSource.borrowedCount(this.upc.getConnectionRetrievalInfo()).decrementAndGet();
                    this.connectionSource.cumulativeConnectionUseTime().addAndGet(delta);
                    try {
                        if (this.connectionSource.isDataDependentRoutingEnabled()) {
                            this.service.routingCache().onConnectionReturn((Connection)this.getPhysicalConnection());
                        }
                    }
                    catch (SQLException e) {
                        ClioSupport.ilogWarning(null, null, null, null, Arrays.toString(e.getStackTrace()));
                    }
                }
                if (this.connectionSource.isDataDependentRoutingEnabled()) {
                    this.service.routingCache().onConnectionClosure((Connection)this.getPhysicalConnection());
                }
                if (!reconnecting) {
                    this.serviceMember.activeCount.decrementAndGet();
                    this.serviceMember.serviceRef.activeCount.decrementAndGet();
                    this.serviceMember.serviceRef.lbStats.onClosed();
                    this.serviceMember.lbStats.onClosed();
                    this.connectionSource.totalCount().decrementAndGet();
                    this.connectionSource.totalCount(this.upc.getConnectionRetrievalInfo()).decrementAndGet();
                    this.connectionSource.connectionsClosed().incrementAndGet();
                }
                if (this.pendingClose.compareAndSet(true, false)) {
                    this.serviceMember.pendingCloseCount.decrementAndGet();
                    this.serviceMember.serviceRef.pendingCloseCount.decrementAndGet();
                }
                if (this.bad() || this.reconnecting()) {
                    this.abort();
                    break block20;
                }
                try {
                    TaskHandle<Object> submittedTask = UniversalConnectionPoolManagerBase.getTaskManager().submitTask(new UCPTaskBase<Object>(){
                        private static Executable $$$methodRef$$$0;
                        private static Logger $$$loggerRef$$$0;
                        private static Executable $$$methodRef$$$1;
                        private static Logger $$$loggerRef$$$1;

                        @Override
                        public void run() {
                            ((UniversalPooledConnectionImpl)CoreConnectionImpl.this.upc).closeNoStatsUpdate();
                        }

                        static {
                            try {
                                $$$methodRef$$$1 = 1.class.getDeclaredConstructor(CoreConnectionImpl.class);
                            }
                            catch (Throwable throwable) {}
                            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                            try {
                                $$$methodRef$$$0 = 1.class.getDeclaredMethod("run", new Class[0]);
                            }
                            catch (Throwable throwable) {}
                            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                        }
                    });
                    if (submittedTask != null) {
                        submittedTask.get(5000L);
                        submittedTask.getTask().release();
                    } else {
                        ClioSupport.ilogWarning(null, null, null, null, "task submission failed");
                    }
                    if (!this.closed()) {
                        ((UniversalPooledConnectionImpl)this.upc).m_status.set(UniversalPooledConnectionStatus.STATUS_BAD);
                        this.abort();
                        break block20;
                    }
                    ((UniversalPooledConnectionImpl)this.upc).m_status.set(UniversalPooledConnectionStatus.STATUS_CLOSED);
                }
                catch (TaskManagerException e) {
                    ClioSupport.ilogThrowing(null, null, null, null, e);
                }
            }
            finally {
                ClioSupport.ilogFinest(null, null, null, null, "closed: " + this.connStats());
            }
        }
    }

    @Override
    public void cleanupToHarvest() {
        try {
            ConnectionHarvestingCallback callback = this.upc.getConnectionHarvestingCallback();
            if (callback != null) {
                callback.cleanup();
            }
        }
        catch (UniversalConnectionPoolException e) {
            ClioSupport.ilogThrowing(null, null, null, null, e);
        }
    }

    @Override
    public boolean reconnecting() {
        return UniversalPooledConnectionStatus.STATUS_RECONNECTING.equals(this.upc.getStatus());
    }

    @Override
    public void markCloseOnReturn() {
        try {
            this.upc.setStatus(UniversalPooledConnectionStatus.STATUS_CLOSE_ON_RETURN);
        }
        catch (UniversalConnectionPoolException e) {
            ClioSupport.ilogThrowing(null, null, null, null, e);
        }
        if (this.pendingClose.compareAndSet(false, true)) {
            this.serviceMember.pendingCloseCount.incrementAndGet();
            this.serviceMember.serviceRef.pendingCloseCount.incrementAndGet();
        }
    }

    @Override
    public void markToReplace() {
        try {
            this.upc.setStatus(UniversalPooledConnectionStatus.STATUS_REPLACE_ON_RETURN);
        }
        catch (UniversalConnectionPoolException e) {
            ClioSupport.ilogThrowing(null, null, null, null, e);
        }
        if (this.pendingClose.compareAndSet(false, true)) {
            this.serviceMember.pendingCloseCount.incrementAndGet();
            this.serviceMember.serviceRef.pendingCloseCount.incrementAndGet();
        }
    }

    @Override
    public ConnectionRetrievalInfo cri() {
        return this.upc.getConnectionRetrievalInfo();
    }

    @Override
    public Object getDelegate() {
        return this.upc;
    }

    @Override
    public boolean available() {
        return this.upc.isAvailable();
    }

    @Override
    public void abort() {
        ClioSupport.ilogFinest(null, null, null, null, "abort");
        this.upc.abort();
        this.serviceMember.serviceRef.lbStats.onAborted();
        this.serviceMember.lbStats.onAborted();
        ClioSupport.ilogFinest(null, null, null, null, "aborted");
    }

    @Override
    public long lastAccessedTime() {
        return this.upc.getLastAccessedTime();
    }

    @Override
    public boolean reusable() {
        return this.upc.isReusable();
    }

    @Override
    public boolean valid() {
        return this.upc.isValid();
    }

    @Override
    public boolean closed() {
        return UniversalPooledConnectionStatus.STATUS_CLOSED.equals(this.upc.getStatus());
    }

    @Override
    public boolean bad() {
        return UniversalPooledConnectionStatus.STATUS_BAD.equals(this.upc.getStatus());
    }

    @Override
    public void markBad() {
        try {
            this.upc.setStatus(UniversalPooledConnectionStatus.STATUS_BAD);
        }
        catch (UniversalConnectionPoolException e) {
            ClioSupport.ilogThrowing(null, null, null, null, e);
        }
    }

    @Override
    public boolean normal() {
        return UniversalPooledConnectionStatus.STATUS_NORMAL.equals(this.upc.getStatus());
    }

    @Override
    public boolean markedToReplace() {
        return UniversalPooledConnectionStatus.STATUS_REPLACE_ON_RETURN.equals(this.upc.getStatus());
    }

    @Override
    public boolean markedCloseOnReturn() {
        return UniversalPooledConnectionStatus.STATUS_CLOSE_ON_RETURN.equals(this.upc.getStatus());
    }

    @Override
    public ServiceMember serviceMember() {
        if (null == this.serviceMember || null == this.serviceMember.name()) {
            throw new IllegalStateException();
        }
        return this.serviceMember;
    }

    @Override
    public void handleTimeout() {
        this.upc.handleTimeout();
    }

    @Override
    public int labelingCost(Properties reqLabels) {
        return this.upc.labelingCost(reqLabels);
    }

    @Override
    public boolean isReplayable() {
        return this.replayable;
    }

    @Override
    public void setReplayable(boolean replayable) {
        this.replayable = replayable;
    }

    @Override
    public String serviceName() {
        return this.serviceMember.service();
    }

    @Override
    public void onError(int oraErrorNumber) {
        UniversalPooledConnectionImpl upc = (UniversalPooledConnectionImpl)this.getDelegate();
        this.service.routingCache().onError(oraErrorNumber, upc.getBorrowCRI(), this.serviceMember());
    }

    @Override
    public void onInsert() {
        ((UniversalPooledConnectionImpl)this.getDelegate()).onInsert();
    }

    @Override
    public void onRetrieve() {
        ((UniversalPooledConnectionImpl)this.getDelegate()).onRetrieve();
    }

    @Override
    public void onBorrow(ConnectionRetrievalInfo cri) throws UniversalConnectionPoolException {
        try {
            if (this.connectionSource.isDataDependentRoutingEnabled()) {
                this.service.routingCache().onConnectionBorrow((Connection)this.getPhysicalConnection(), cri);
            }
            if (this.connectionSource.isMultitenantDatabase() && this.upc instanceof OracleUniversalPooledConnection) {
                ((OracleUniversalPooledConnection)this.upc).initPdbSession(cri);
            }
            this.openProxySession(cri);
        }
        catch (SQLException e) {
            throw new UniversalConnectionPoolException(e.getMessage(), e);
        }
    }

    @Override
    public void onReturn() throws UniversalConnectionPoolException {
        try {
            if (this.service.connectionSource().isDataDependentRoutingEnabled()) {
                this.service.routingCache().onConnectionReturn((Connection)this.getPhysicalConnection());
            }
            this.closeProxySession();
        }
        catch (SQLException e) {
            throw new UniversalConnectionPoolException(e.getMessage(), e);
        }
        try {
            if (this.upc.isOracle()) {
                OracleConnection oConn = (OracleConnection)this.getPhysicalConnection();
                if (oConn == null) {
                    return;
                }
                EnumSet tstate = oConn.getTransactionState();
                if (tstate.contains(OracleConnection.TransactionState.TRANSACTION_STARTED)) {
                    oConn.commit();
                }
            }
        }
        catch (SQLException e) {
            ClioSupport.ilogThrowing(null, null, null, null, e);
        }
    }

    @Override
    public Object getPhysicalConnection() {
        block7: {
            Object delegate = Objects.requireNonNull(this.getDelegate());
            if (!(delegate instanceof UniversalPooledConnection)) {
                return null;
            }
            try {
                UniversalPooledConnection upc = (UniversalPooledConnection)delegate;
                Object conn = upc.getPhysicalConnection();
                if (upc.isOracle()) {
                    if (conn instanceof OracleConnection) {
                        return conn;
                    }
                    if (conn instanceof OracleXAConnection) {
                        return ((OracleXAConnection)conn).getPhysicalHandle();
                    }
                    if (conn instanceof OraclePooledConnection) {
                        return ((OraclePooledConnection)conn).getConnection();
                    }
                    break block7;
                }
                return conn;
            }
            catch (SQLException e) {
                ClioSupport.ilogThrowing(null, null, null, null, e);
            }
        }
        return null;
    }

    private void openProxySession(ConnectionRetrievalInfo borrowCri) throws SQLException {
        if (!(borrowCri instanceof JDBCConnectionRetrievalInfo)) {
            return;
        }
        if (!this.upc.isOracle()) {
            return;
        }
        OracleConnection oConn = (OracleConnection)this.getPhysicalConnection();
        if (oConn == null) {
            return;
        }
        if (oConn.isProxySession()) {
            return;
        }
        JDBCConnectionRetrievalInfo jdbcCri = (JDBCConnectionRetrievalInfo)borrowCri;
        Properties newProxyProps = jdbcCri.getProxyProperties();
        if (newProxyProps == null) {
            return;
        }
        int proxyType = jdbcCri.getProxyType();
        ClioSupport.ilogFinest(null, null, null, null, " Opening proxy session with Properties = " + newProxyProps);
        oConn.openProxySession(proxyType, newProxyProps);
        ConnectionRetrievalInfo newConnCri = jdbcCri.getCopyWithNewProxyProperties(proxyType, newProxyProps);
        this.upc.setConnectionRetrievalInfo(newConnCri);
    }

    private void closeProxySession() throws SQLException {
        if (!this.upc.isOracle()) {
            return;
        }
        OracleConnection oConn = (OracleConnection)this.getPhysicalConnection();
        ConnectionRetrievalInfo cri = this.upc.getConnectionRetrievalInfo();
        if (!(cri instanceof JDBCConnectionRetrievalInfo)) {
            return;
        }
        JDBCConnectionRetrievalInfo jdbcCri = (JDBCConnectionRetrievalInfo)cri;
        if (jdbcCri.getProxyProperties() == null) {
            return;
        }
        if (oConn == null) {
            return;
        }
        oConn.close(1);
        this.upc.setConnectionRetrievalInfo(jdbcCri.getCopyWithNewProxyProperties(-1, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String fetchContainerName() {
        if (!this.connectionSource.isMultitenantDatabase()) {
            return "";
        }
        OracleConnection oConn = (OracleConnection)this.getPhysicalConnection();
        if (oConn == null) {
            return "";
        }
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = oConn.createStatement();
            String updateStr = "select sys_context('userenv','con_name') from dual";
            rs = stmt.executeQuery("select sys_context('userenv','con_name') from dual");
            if (rs.next()) {
                String string = rs.getString(1);
                return string;
            }
        }
        catch (SQLException e) {
            ClioSupport.ilogThrowing(null, null, null, null, e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException e) {
                ClioSupport.ilogThrowing(null, null, null, null, e);
            }
        }
        return "";
    }

    private Set<String> fetchServicePlacement() {
        if (!this.upc.isOracle()) {
            return new HashSet<String>();
        }
        OracleConnection oConn = (OracleConnection)this.getPhysicalConnection();
        HashSet<String> instances = new HashSet<String>();
        instances.add(this.serviceMember().name());
        if (!this.connectionSource.isMultitenantDatabase()) {
            return instances;
        }
        if (oConn == null) {
            return instances;
        }
        try {
            if (oConn.getVersionNumber() < 12200 || !this.connectionSource.isShareable()) {
                return instances;
            }
            String sql = "select dbms_service_prvt.get_topology('" + this.serviceName() + "') from dual";
            try (Statement stmt = oConn.createStatement();
                 ResultSet rs = stmt.executeQuery(sql);){
                String instancesStr = "";
                if (rs.next()) {
                    instancesStr = rs.getString(1);
                }
                if (instancesStr != null && instancesStr.length() > 0) {
                    for (String instName : instancesStr.split(",")) {
                        instances.add(instName);
                    }
                }
            }
        }
        catch (SQLException e) {
            ClioSupport.ilogThrowing(null, null, null, null, e);
        }
        return instances;
    }

    static {
        try {
            $$$methodRef$$$42 = CoreConnectionImpl.class.getDeclaredConstructor(Service.class, Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$42 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$41 = CoreConnectionImpl.class.getDeclaredMethod("access$000", CoreConnectionImpl.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$41 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$40 = CoreConnectionImpl.class.getDeclaredMethod("fetchServicePlacement", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$40 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$39 = CoreConnectionImpl.class.getDeclaredMethod("fetchContainerName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$39 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$38 = CoreConnectionImpl.class.getDeclaredMethod("closeProxySession", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$38 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$37 = CoreConnectionImpl.class.getDeclaredMethod("openProxySession", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$37 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$36 = CoreConnectionImpl.class.getDeclaredMethod("getPhysicalConnection", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$36 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$35 = CoreConnectionImpl.class.getDeclaredMethod("onReturn", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$35 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$34 = CoreConnectionImpl.class.getDeclaredMethod("onBorrow", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$34 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$33 = CoreConnectionImpl.class.getDeclaredMethod("onRetrieve", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$33 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$32 = CoreConnectionImpl.class.getDeclaredMethod("onInsert", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$32 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$31 = CoreConnectionImpl.class.getDeclaredMethod("onError", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$30 = CoreConnectionImpl.class.getDeclaredMethod("serviceName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$29 = CoreConnectionImpl.class.getDeclaredMethod("setReplayable", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$28 = CoreConnectionImpl.class.getDeclaredMethod("isReplayable", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$27 = CoreConnectionImpl.class.getDeclaredMethod("labelingCost", Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$26 = CoreConnectionImpl.class.getDeclaredMethod("handleTimeout", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$25 = CoreConnectionImpl.class.getDeclaredMethod("serviceMember", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$24 = CoreConnectionImpl.class.getDeclaredMethod("markedCloseOnReturn", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$23 = CoreConnectionImpl.class.getDeclaredMethod("markedToReplace", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$22 = CoreConnectionImpl.class.getDeclaredMethod("normal", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$21 = CoreConnectionImpl.class.getDeclaredMethod("markBad", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$20 = CoreConnectionImpl.class.getDeclaredMethod("bad", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$19 = CoreConnectionImpl.class.getDeclaredMethod("closed", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$18 = CoreConnectionImpl.class.getDeclaredMethod("valid", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$17 = CoreConnectionImpl.class.getDeclaredMethod("reusable", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$16 = CoreConnectionImpl.class.getDeclaredMethod("lastAccessedTime", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$15 = CoreConnectionImpl.class.getDeclaredMethod("abort", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$14 = CoreConnectionImpl.class.getDeclaredMethod("available", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$13 = CoreConnectionImpl.class.getDeclaredMethod("getDelegate", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$12 = CoreConnectionImpl.class.getDeclaredMethod("cri", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$11 = CoreConnectionImpl.class.getDeclaredMethod("markToReplace", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$10 = CoreConnectionImpl.class.getDeclaredMethod("markCloseOnReturn", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$9 = CoreConnectionImpl.class.getDeclaredMethod("reconnecting", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$8 = CoreConnectionImpl.class.getDeclaredMethod("cleanupToHarvest", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$7 = CoreConnectionImpl.class.getDeclaredMethod("close", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$6 = CoreConnectionImpl.class.getDeclaredMethod("connStats", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$5 = CoreConnectionImpl.class.getDeclaredMethod("repurpose", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$4 = CoreConnectionImpl.class.getDeclaredMethod("reinitialize", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$3 = CoreConnectionImpl.class.getDeclaredMethod("markReconnecting", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$2 = CoreConnectionImpl.class.getDeclaredMethod("makeUnavailable", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$1 = CoreConnectionImpl.class.getDeclaredMethod("makeAvailable", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$0 = CoreConnectionImpl.class.getDeclaredMethod("create", Service.class, Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
    }
}

