/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.common;

import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ucp.AbandonedConnectionTimeoutCallback;
import oracle.ucp.ConnectionHarvestingCallback;
import oracle.ucp.ConnectionLabelingCallback;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.TimeToLiveConnectionTimeoutCallback;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.UniversalPooledConnection;
import oracle.ucp.UniversalPooledConnectionStatus;
import oracle.ucp.admin.UniversalConnectionPoolManagerBase;
import oracle.ucp.common.Clock;
import oracle.ucp.common.CoreConnection;
import oracle.ucp.common.Counter;
import oracle.ucp.common.UniversalConnectionPoolBase;
import oracle.ucp.logging.ClioSupport;
import oracle.ucp.logging.annotations.DefaultLogger;
import oracle.ucp.logging.annotations.Feature;
import oracle.ucp.logging.annotations.Supports;
import oracle.ucp.util.TaskHandle;
import oracle.ucp.util.TaskManagerException;
import oracle.ucp.util.UCPErrorHandler;
import oracle.ucp.util.UCPTaskBase;
import oracle.ucp.util.Util;

@DefaultLogger(value="oracle.ucp.common")
@Supports(value={Feature.CHECK_IN, Feature.CHECK_OUT, Feature.CONN_CONSTRUCTION, Feature.CONN_DESTRUCTION, Feature.LABELING})
class UniversalPooledConnectionImpl
implements UniversalPooledConnection {
    static final String loggerName = "oracle.ucp.common";
    private static final Logger logger;
    private final UniversalConnectionPoolBase m_connectionPool;
    private final Object m_connection;
    private final AtomicReference<ConnectionRetrievalInfo> m_connectionRetrievalInfo = new AtomicReference<Object>(null);
    private ConnectionRetrievalInfo borrowCRI;
    AtomicReference<UniversalPooledConnectionStatus> m_status = new AtomicReference<UniversalPooledConnectionStatus>(UniversalPooledConnectionStatus.STATUS_NORMAL);
    private volatile long lastAccessedTime = Clock.clock();
    private boolean m_sqlWithQueryTimeoutInProgress = false;
    private volatile long availableStartTime = Clock.clock();
    private volatile long borrowedStartTime = Clock.clock();
    private final AtomicLong m_connectionReuseTimestamp = new AtomicLong(Clock.clock());
    private volatile int connectionReuseCounter = 0;
    private final AtomicBoolean m_isHarvestable = new AtomicBoolean(true);
    private AtomicReference<ConnectionHarvestingCallback> m_harvestingCallback = new AtomicReference<Object>(null);
    private AtomicReference<AbandonedConnectionTimeoutCallback> m_abandonedConnCallback = new AtomicReference<Object>(null);
    private AtomicReference<TimeToLiveConnectionTimeoutCallback> m_ttlConnCallback = new AtomicReference<Object>(null);
    private final AtomicLong m_lastConnectionValidationTime = new AtomicLong(0L);
    private final AtomicBoolean wasBorrowed = new AtomicBoolean(false);
    private final ReentrantLock labeledConnectionsCountLock = new ReentrantLock();
    protected final Semaphore validitySemaphore = new Semaphore(1);
    private AtomicBoolean available = new AtomicBoolean(true);
    private static final boolean selfTunerEnabled;
    private AtomicReference<CoreConnection> delegator = new AtomicReference<Object>(null);
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;
    private static Executable $$$methodRef$$$32;
    private static Logger $$$loggerRef$$$32;
    private static Executable $$$methodRef$$$33;
    private static Logger $$$loggerRef$$$33;
    private static Executable $$$methodRef$$$34;
    private static Logger $$$loggerRef$$$34;
    private static Executable $$$methodRef$$$35;
    private static Logger $$$loggerRef$$$35;
    private static Executable $$$methodRef$$$36;
    private static Logger $$$loggerRef$$$36;
    private static Executable $$$methodRef$$$37;
    private static Logger $$$loggerRef$$$37;
    private static Executable $$$methodRef$$$38;
    private static Logger $$$loggerRef$$$38;
    private static Executable $$$methodRef$$$39;
    private static Logger $$$loggerRef$$$39;
    private static Executable $$$methodRef$$$40;
    private static Logger $$$loggerRef$$$40;
    private static Executable $$$methodRef$$$41;
    private static Logger $$$loggerRef$$$41;
    private static Executable $$$methodRef$$$42;
    private static Logger $$$loggerRef$$$42;
    private static Executable $$$methodRef$$$43;
    private static Logger $$$loggerRef$$$43;
    private static Executable $$$methodRef$$$44;
    private static Logger $$$loggerRef$$$44;
    private static Executable $$$methodRef$$$45;
    private static Logger $$$loggerRef$$$45;
    private static Executable $$$methodRef$$$46;
    private static Logger $$$loggerRef$$$46;
    private static Executable $$$methodRef$$$47;
    private static Logger $$$loggerRef$$$47;
    private static Executable $$$methodRef$$$48;
    private static Logger $$$loggerRef$$$48;
    private static Executable $$$methodRef$$$49;
    private static Logger $$$loggerRef$$$49;
    private static Executable $$$methodRef$$$50;
    private static Logger $$$loggerRef$$$50;
    private static Executable $$$methodRef$$$51;
    private static Logger $$$loggerRef$$$51;
    private static Executable $$$methodRef$$$52;
    private static Logger $$$loggerRef$$$52;
    private static Executable $$$methodRef$$$53;
    private static Logger $$$loggerRef$$$53;
    private static Executable $$$methodRef$$$54;
    private static Logger $$$loggerRef$$$54;
    private static Executable $$$methodRef$$$55;
    private static Logger $$$loggerRef$$$55;
    private static Executable $$$methodRef$$$56;
    private static Logger $$$loggerRef$$$56;
    private static Executable $$$methodRef$$$57;
    private static Logger $$$loggerRef$$$57;
    private static Executable $$$methodRef$$$58;
    private static Logger $$$loggerRef$$$58;

    UniversalPooledConnectionImpl(UniversalConnectionPoolBase connectionPool, Object connection, ConnectionRetrievalInfo connectionRetrievalInfo) throws UniversalConnectionPoolException {
        if (null == connectionPool) {
            UCPErrorHandler.throwUniversalConnectionPoolException(54);
        }
        if (null == connection) {
            UCPErrorHandler.throwUniversalConnectionPoolException(264);
        }
        if (null == connectionRetrievalInfo) {
            UCPErrorHandler.throwUniversalConnectionPoolException(4);
        }
        this.m_connectionPool = connectionPool;
        this.m_connection = connection;
        this.m_connectionRetrievalInfo.set(connectionRetrievalInfo);
        this.m_isHarvestable.set(true);
        this.m_connectionPool.getNeverUsedConnectionsCounter().getCounter(connectionRetrievalInfo).incrementAndGet();
    }

    @Override
    public Object getPhysicalConnection() {
        return this.m_connection;
    }

    @Override
    public ConnectionRetrievalInfo getConnectionRetrievalInfo() {
        return this.m_connectionRetrievalInfo.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setConnectionRetrievalInfo(ConnectionRetrievalInfo newCri) {
        this.labeledConnectionsCountLock.lock();
        try {
            ConnectionRetrievalInfo oldCri = this.m_connectionRetrievalInfo.getAndSet(newCri);
            Properties oldLabels = oldCri.getLabels();
            Properties newLabels = newCri.getLabels();
            boolean wasLabeled = null != oldLabels && !oldLabels.isEmpty();
            boolean becameLabeled = null != newLabels && !newLabels.isEmpty();
            Counter counter = this.m_connectionPool.labeledConnectionsCount;
            if (wasLabeled) {
                if (!becameLabeled) {
                    counter.decrementAndGet();
                }
            } else if (becameLabeled) {
                counter.incrementAndGet();
            }
        }
        finally {
            this.labeledConnectionsCountLock.unlock();
        }
        this.m_connectionPool.clearWFPTree();
    }

    ConnectionRetrievalInfo getBorrowCRI() {
        return this.borrowCRI;
    }

    void setBorrowCRI(ConnectionRetrievalInfo borrowCRI) {
        this.borrowCRI = borrowCRI;
    }

    @Override
    public void heartbeat() {
        this.lastAccessedTime = Clock.clock();
    }

    @Override
    public void setSqlWithQueryTimeoutInProgress(boolean sqlWithQueryTimeoutInProgress) {
        this.m_sqlWithQueryTimeoutInProgress = sqlWithQueryTimeoutInProgress;
    }

    @Override
    public boolean isSqlWithQueryTimeoutInProgress() {
        return this.m_sqlWithQueryTimeoutInProgress;
    }

    @Override
    public boolean isValid() {
        boolean status = false;
        try {
            status = this.isValid(this.m_connectionPool.getConnectionValidationTimeout());
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValid(long timeout) throws SQLException {
        try {
            this.validitySemaphore.acquire();
            boolean bl = this.isValidHelper(timeout);
            return bl;
        }
        catch (InterruptedException e) {
            ClioSupport.ilogThrowing(null, null, null, null, e);
            boolean bl = true;
            return bl;
        }
        finally {
            this.validitySemaphore.release();
        }
    }

    private boolean isValidHelper(long timeout) throws SQLException {
        UniversalPooledConnectionStatus _status;
        TaskHandle<Object> submittedTask = null;
        UniversalPooledConnectionStatus status = this.getStatus();
        if (timeout < 0L) {
            UCPErrorHandler.throwSQLException(67, null);
        }
        if (this.m_connectionPool != null && (status.equals(UniversalPooledConnectionStatus.STATUS_NORMAL) || status.equals(UniversalPooledConnectionStatus.STATUS_CLOSE_ON_RETURN) || status.equals(UniversalPooledConnectionStatus.STATUS_REPLACE_ON_RETURN))) {
            try {
                ClioSupport.ilogFinest(null, null, null, null, "starting");
                submittedTask = UniversalConnectionPoolManagerBase.getTaskManager().submitTask(new UCPTaskBase<Object>(){
                    private static Executable $$$methodRef$$$0;
                    private static Logger $$$loggerRef$$$0;
                    private static Executable $$$methodRef$$$1;
                    private static Logger $$$loggerRef$$$1;

                    @Override
                    public void run() {
                        UniversalPooledConnectionImpl.this.validate();
                    }

                    static {
                        try {
                            $$$methodRef$$$1 = 1.class.getDeclaredConstructor(UniversalPooledConnectionImpl.class);
                        }
                        catch (Throwable throwable) {}
                        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                        try {
                            $$$methodRef$$$0 = 1.class.getDeclaredMethod("run", new Class[0]);
                        }
                        catch (Throwable throwable) {}
                        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                    }
                });
                if (submittedTask != null) {
                    submittedTask.get(timeout * 1000L);
                    submittedTask.getTask().release();
                } else {
                    ClioSupport.ilogFinest(null, null, null, null, "failed");
                }
            }
            catch (TaskManagerException e) {
                ClioSupport.ilogThrowing(null, null, null, null, e);
                if (e.getCause() instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                this.markBadAndCancel(submittedTask);
            }
        }
        return !(_status = this.getStatus()).equals(UniversalPooledConnectionStatus.STATUS_CLOSED) && !_status.equals(UniversalPooledConnectionStatus.STATUS_BAD) && !_status.equals(UniversalPooledConnectionStatus.STATUS_RECONNECTING);
    }

    void markBadAndCancel(TaskHandle<?> submittedTask) {
        this.setStatus(UniversalPooledConnectionStatus.STATUS_BAD, "The connection is deemed invalid");
        if (submittedTask != null) {
            submittedTask.getTask().release();
        }
    }

    @Override
    public void validate() {
    }

    @Override
    public long getLastNetworkAccessTime() {
        return 0L;
    }

    @Override
    public long getLastAccessedTime() {
        return this.lastAccessedTime;
    }

    @Override
    public UniversalPooledConnectionStatus getStatus() {
        return this.m_status.get();
    }

    @Override
    public void setStatus(UniversalPooledConnectionStatus status) throws UniversalConnectionPoolException {
        UniversalPooledConnectionStatus oldStatus;
        if (null == status) {
            UCPErrorHandler.throwUniversalConnectionPoolException(152);
        }
        if (logger.getLevel() == Level.FINEST) {
            ClioSupport.ilogFinest(null, null, null, null, " about to set status=" + status + " fpr conn=" + this);
        }
        while (!UniversalPooledConnectionStatus.STATUS_CLOSED.equals(oldStatus = this.getStatus()) && !this.m_status.compareAndSet(oldStatus, status)) {
        }
    }

    public void setStatus(UniversalPooledConnectionStatus status, String msg) {
        try {
            this.setStatus(status);
        }
        catch (UniversalConnectionPoolException e) {
            ClioSupport.ilogFinest(null, null, null, null, "failed");
        }
    }

    @Override
    public long getAvailableStartTime() {
        return this.availableStartTime;
    }

    @Override
    public void setAvailableStartTime() {
        this.availableStartTime = Clock.clock();
    }

    @Override
    public long getBorrowedStartTime() {
        return this.borrowedStartTime;
    }

    @Override
    public void setBorrowedStartTime() {
        this.borrowedStartTime = Clock.clock();
    }

    @Override
    public long getLastConnectionValidationTime() {
        return this.m_lastConnectionValidationTime.get();
    }

    @Override
    public void setLastConnectionValidationTime(long lastConnectionValidationTime) {
        this.m_lastConnectionValidationTime.set(lastConnectionValidationTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void applyConnectionLabel(String key, String value) throws UniversalConnectionPoolException {
        boolean clearWfpTree;
        UniversalPooledConnectionStatus status = this.getStatus();
        if (!(status.equals(UniversalPooledConnectionStatus.STATUS_NORMAL) || status.equals(UniversalPooledConnectionStatus.STATUS_CLOSE_ON_RETURN) || status.equals(UniversalPooledConnectionStatus.STATUS_REPLACE_ON_RETURN))) {
            UCPErrorHandler.throwUniversalConnectionPoolException(154);
        }
        if (key == null || key.equals("")) {
            UCPErrorHandler.throwUniversalConnectionPoolException(153);
        }
        this.labeledConnectionsCountLock.lock();
        try {
            ConnectionRetrievalInfo cri = this.m_connectionRetrievalInfo.get();
            Properties labels = cri.getLabels();
            clearWfpTree = null == labels ? true : !labels.containsKey(key);
            boolean wasLabeled = null != labels && !labels.isEmpty();
            cri.addLabel(key, value);
            if (!wasLabeled) {
                this.m_connectionPool.labeledConnectionsCount.incrementAndGet();
            }
        }
        finally {
            this.labeledConnectionsCountLock.unlock();
        }
        if (clearWfpTree) {
            this.m_connectionPool.clearWFPTree();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeConnectionLabel(String key) throws UniversalConnectionPoolException {
        boolean clearWfpTree;
        UniversalPooledConnectionStatus status = this.getStatus();
        if (!(status.equals(UniversalPooledConnectionStatus.STATUS_NORMAL) || status.equals(UniversalPooledConnectionStatus.STATUS_CLOSE_ON_RETURN) || status.equals(UniversalPooledConnectionStatus.STATUS_REPLACE_ON_RETURN))) {
            UCPErrorHandler.throwUniversalConnectionPoolException(154);
        }
        if (null == key || key.equals("")) {
            UCPErrorHandler.throwUniversalConnectionPoolException(153);
        }
        this.labeledConnectionsCountLock.lock();
        try {
            boolean nowLabeled;
            ConnectionRetrievalInfo cri = this.m_connectionRetrievalInfo.get();
            Properties labels = cri.getLabels();
            clearWfpTree = null == labels ? false : labels.containsKey(key);
            boolean wasLabeled = null != labels && !labels.isEmpty();
            cri.removeLabel(key);
            labels = cri.getLabels();
            boolean bl = nowLabeled = null != labels && !labels.isEmpty();
            if (wasLabeled && !nowLabeled) {
                this.m_connectionPool.labeledConnectionsCount.decrementAndGet();
            }
        }
        finally {
            this.labeledConnectionsCountLock.unlock();
        }
        if (clearWfpTree) {
            this.m_connectionPool.clearWFPTree();
        }
    }

    void onInsert() {
        this.labeledConnectionsCountLock.lock();
        try {
            ConnectionRetrievalInfo cri = this.m_connectionRetrievalInfo.get();
            Properties labels = cri.getLabels();
            if (null != labels && !labels.isEmpty()) {
                this.m_connectionPool.labeledConnectionsCount.incrementAndGet();
            }
        }
        finally {
            this.labeledConnectionsCountLock.unlock();
        }
    }

    void onRetrieve() {
        this.labeledConnectionsCountLock.lock();
        try {
            ConnectionRetrievalInfo cri = this.m_connectionRetrievalInfo.get();
            Properties labels = cri.getLabels();
            if (null != labels && !labels.isEmpty()) {
                this.m_connectionPool.labeledConnectionsCount.decrementAndGet();
            }
        }
        finally {
            this.labeledConnectionsCountLock.unlock();
        }
    }

    @Override
    public Properties getConnectionLabels() throws UniversalConnectionPoolException {
        UniversalPooledConnectionStatus status = this.getStatus();
        if (!(status.equals(UniversalPooledConnectionStatus.STATUS_NORMAL) || status.equals(UniversalPooledConnectionStatus.STATUS_CLOSE_ON_RETURN) || status.equals(UniversalPooledConnectionStatus.STATUS_REPLACE_ON_RETURN))) {
            UCPErrorHandler.throwUniversalConnectionPoolException(154);
        }
        return this.m_connectionRetrievalInfo.get().getLabels();
    }

    @Override
    public Properties getUnmatchedConnectionLabels(Properties requestedLabels) throws UniversalConnectionPoolException {
        UniversalPooledConnectionStatus status = this.getStatus();
        if (!(status.equals(UniversalPooledConnectionStatus.STATUS_NORMAL) || status.equals(UniversalPooledConnectionStatus.STATUS_CLOSE_ON_RETURN) || status.equals(UniversalPooledConnectionStatus.STATUS_REPLACE_ON_RETURN))) {
            UCPErrorHandler.throwUniversalConnectionPoolException(154);
        }
        Properties storedLabels = this.m_connectionRetrievalInfo.get().getLabels();
        if (requestedLabels == null || requestedLabels.isEmpty()) {
            if (storedLabels != null && !storedLabels.isEmpty()) {
                UCPErrorHandler.throwUniversalConnectionPoolException(93);
            } else {
                return null;
            }
        }
        Properties unmatchedLabels = new Properties();
        if (storedLabels == null || storedLabels.isEmpty()) {
            unmatchedLabels.putAll((Map<?, ?>)requestedLabels);
            return unmatchedLabels;
        }
        Iterator<Map.Entry<Object, Object>> itr = requestedLabels.entrySet().iterator();
        Set<Map.Entry<Object, Object>> storedLabelSet = storedLabels.entrySet();
        while (itr.hasNext()) {
            Map.Entry<Object, Object> label = itr.next();
            String key = (String)label.getKey();
            String value = (String)label.getValue();
            if (storedLabelSet.contains(label)) continue;
            unmatchedLabels.setProperty(key, value);
        }
        return unmatchedLabels.isEmpty() ? null : unmatchedLabels;
    }

    @Override
    public void setConnectionHarvestable(boolean isConnectionHarvestable) throws UniversalConnectionPoolException {
        UniversalPooledConnectionStatus status = this.getStatus();
        if (!(status.equals(UniversalPooledConnectionStatus.STATUS_NORMAL) || status.equals(UniversalPooledConnectionStatus.STATUS_CLOSE_ON_RETURN) || status.equals(UniversalPooledConnectionStatus.STATUS_REPLACE_ON_RETURN))) {
            UCPErrorHandler.throwUniversalConnectionPoolException(154);
        }
        this.m_isHarvestable.set(isConnectionHarvestable);
    }

    @Override
    public boolean isConnectionHarvestable() {
        return this.m_isHarvestable.get();
    }

    @Override
    public void registerConnectionHarvestingCallback(ConnectionHarvestingCallback cbk) throws UniversalConnectionPoolException {
        UniversalPooledConnectionStatus status = this.getStatus();
        if (!(status.equals(UniversalPooledConnectionStatus.STATUS_NORMAL) || status.equals(UniversalPooledConnectionStatus.STATUS_CLOSE_ON_RETURN) || status.equals(UniversalPooledConnectionStatus.STATUS_REPLACE_ON_RETURN))) {
            UCPErrorHandler.throwUniversalConnectionPoolException(154);
        }
        if (!this.m_harvestingCallback.compareAndSet(null, cbk)) {
            UCPErrorHandler.throwUniversalConnectionPoolException(155);
        }
    }

    @Override
    public void removeConnectionHarvestingCallback() {
        this.m_harvestingCallback.set(null);
    }

    @Override
    public ConnectionHarvestingCallback getConnectionHarvestingCallback() {
        return this.m_harvestingCallback.get();
    }

    @Override
    public void registerAbandonedConnectionTimeoutCallback(AbandonedConnectionTimeoutCallback cbk) throws UniversalConnectionPoolException {
        UniversalPooledConnectionStatus status = this.getStatus();
        if (!(status.equals(UniversalPooledConnectionStatus.STATUS_NORMAL) || status.equals(UniversalPooledConnectionStatus.STATUS_CLOSE_ON_RETURN) || status.equals(UniversalPooledConnectionStatus.STATUS_REPLACE_ON_RETURN))) {
            UCPErrorHandler.throwUniversalConnectionPoolException(154);
        }
        if (!this.m_abandonedConnCallback.compareAndSet(null, cbk)) {
            UCPErrorHandler.throwUniversalConnectionPoolException(156);
        }
    }

    @Override
    public void removeAbandonedConnectionTimeoutCallback() {
        this.m_abandonedConnCallback.set(null);
    }

    @Override
    public AbandonedConnectionTimeoutCallback getAbandonedConnectionTimeoutCallback() {
        return this.m_abandonedConnCallback.get();
    }

    @Override
    public void registerTimeToLiveConnectionTimeoutCallback(TimeToLiveConnectionTimeoutCallback cbk) throws UniversalConnectionPoolException {
        UniversalPooledConnectionStatus status = this.getStatus();
        if (!(status.equals(UniversalPooledConnectionStatus.STATUS_NORMAL) || status.equals(UniversalPooledConnectionStatus.STATUS_CLOSE_ON_RETURN) || status.equals(UniversalPooledConnectionStatus.STATUS_REPLACE_ON_RETURN))) {
            UCPErrorHandler.throwUniversalConnectionPoolException(154);
        }
        if (!this.m_ttlConnCallback.compareAndSet(null, cbk)) {
            UCPErrorHandler.throwUniversalConnectionPoolException(157);
        }
    }

    @Override
    public void removeTimeToLiveConnectionTimeoutCallback() {
        this.m_ttlConnCallback.set(null);
    }

    @Override
    public TimeToLiveConnectionTimeoutCallback getTimeToLiveConnectionTimeoutCallback() {
        return this.m_ttlConnCallback.get();
    }

    private int getConnectionReuseCounter() {
        return this.connectionReuseCounter;
    }

    private long getConnectionReuseTimestamp() {
        return this.m_connectionReuseTimestamp.get();
    }

    @Override
    public boolean isReusable() {
        int countToGiveUp;
        long timeToGiveUp;
        long reuseTime = this.m_connectionPool.getMaxConnectionReuseTime();
        if (reuseTime > 0L && (timeToGiveUp = this.getConnectionReuseTimestamp() + reuseTime * 1000L) <= Clock.clock()) {
            return false;
        }
        int reuseCount = this.m_connectionPool.getMaxConnectionReuseCount();
        return reuseCount <= 0 || (countToGiveUp = this.getConnectionReuseCounter()) < reuseCount;
    }

    @Override
    public void close() {
        this.delegator.get().close();
    }

    void closeNoStatsUpdate() {
        try {
            Object physicalConnection = this.getPhysicalConnection();
            if (null != physicalConnection) {
                this.m_connectionPool.getConnectionFactoryAdapter().closeConnection(physicalConnection);
            }
        }
        catch (UniversalConnectionPoolException e) {
            ClioSupport.ilogThrowing(null, null, null, null, e);
        }
    }

    @Override
    public void abort() {
    }

    @Override
    public void handleTimeout() {
    }

    @Override
    public boolean isAvailable() {
        return this.available.get();
    }

    @Override
    public boolean setAvailable() {
        return this.setAvailable(true);
    }

    @Override
    public boolean setBorrowed() {
        return this.setAvailable(false);
    }

    private boolean setAvailable(boolean available) {
        boolean wasSet = this.available.compareAndSet(!available, available);
        if (wasSet) {
            if (available) {
                ++this.m_connectionPool.cumulativeReturnedConnectionsCount;
                if (selfTunerEnabled) {
                    this.m_connectionPool.insertToBorrowedHistogram(this.getConnectionRetrievalInfo(), Clock.clock() - this.getBorrowedStartTime());
                }
            } else {
                ++this.connectionReuseCounter;
                ++this.m_connectionPool.cumulativeBorrowedConnectionsCount;
                this.m_connectionPool.m_peakBorrowedConnectionsCount.update(this.m_connectionPool.getBorrowedConnectionsCount());
                if (selfTunerEnabled) {
                    this.m_connectionPool.insertToAvailableHistogram(this.getConnectionRetrievalInfo(), Clock.clock() - this.getAvailableStartTime());
                }
                if (this.wasBorrowed.compareAndSet(false, true)) {
                    this.m_connectionPool.getNeverUsedConnectionsCounter().getCounter(this.getConnectionRetrievalInfo()).decrementAndGet();
                }
            }
        }
        return wasSet;
    }

    @Override
    public int labelingCost(Properties labels) {
        int totalCount;
        Properties connLabels = this.m_connectionRetrievalInfo.get().getLabels();
        if (null == labels) {
            return null == connLabels ? 0 : Integer.MAX_VALUE;
        }
        ConnectionLabelingCallback callback = this.m_connectionPool.getConnectionLabelingCallback();
        if (null == callback) {
            return 0;
        }
        int cost = callback.cost(labels, null == connLabels ? new Properties() : connLabels);
        if (cost >= this.m_connectionPool.getConnectionLabelingHighCost() && ((totalCount = this.m_connectionPool.getTotalConnectionsCount()) < this.m_connectionPool.getHighCostConnectionReuseThreshold() || totalCount < this.m_connectionPool.getMinPoolSize())) {
            return Integer.MAX_VALUE;
        }
        return cost;
    }

    @Override
    public void plugDelegator(CoreConnection delegator) {
        if (!this.delegator.compareAndSet(null, delegator)) {
            throw new IllegalStateException("delegator was already plugged");
        }
    }

    @Override
    public CoreConnection getDelegator() {
        CoreConnection connection = this.delegator.get();
        if (null == connection) {
            throw new IllegalStateException("delegator was not plugged yet");
        }
        return connection;
    }

    public String getService() {
        return "";
    }

    @Override
    public Properties getDatabaseConnectionProperties() {
        return new Properties();
    }

    @Override
    public boolean isOracle() {
        return this.m_connectionPool.isOraclePool();
    }

    static {
        try {
            $$$methodRef$$$58 = UniversalPooledConnectionImpl.class.getDeclaredConstructor(UniversalConnectionPoolBase.class, Object.class, ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$58 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$57 = UniversalPooledConnectionImpl.class.getDeclaredMethod("isOracle", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$57 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$56 = UniversalPooledConnectionImpl.class.getDeclaredMethod("getDatabaseConnectionProperties", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$56 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$55 = UniversalPooledConnectionImpl.class.getDeclaredMethod("getService", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$55 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$54 = UniversalPooledConnectionImpl.class.getDeclaredMethod("getDelegator", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$54 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$53 = UniversalPooledConnectionImpl.class.getDeclaredMethod("plugDelegator", CoreConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$53 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$52 = UniversalPooledConnectionImpl.class.getDeclaredMethod("labelingCost", Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$52 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$51 = UniversalPooledConnectionImpl.class.getDeclaredMethod("setAvailable", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$51 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$50 = UniversalPooledConnectionImpl.class.getDeclaredMethod("setBorrowed", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$50 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$49 = UniversalPooledConnectionImpl.class.getDeclaredMethod("setAvailable", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$49 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$48 = UniversalPooledConnectionImpl.class.getDeclaredMethod("isAvailable", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$48 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$47 = UniversalPooledConnectionImpl.class.getDeclaredMethod("handleTimeout", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$47 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$46 = UniversalPooledConnectionImpl.class.getDeclaredMethod("abort", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$46 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$45 = UniversalPooledConnectionImpl.class.getDeclaredMethod("closeNoStatsUpdate", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$45 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$44 = UniversalPooledConnectionImpl.class.getDeclaredMethod("close", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$44 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$43 = UniversalPooledConnectionImpl.class.getDeclaredMethod("isReusable", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$43 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$42 = UniversalPooledConnectionImpl.class.getDeclaredMethod("getConnectionReuseTimestamp", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$42 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$41 = UniversalPooledConnectionImpl.class.getDeclaredMethod("getConnectionReuseCounter", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$41 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$40 = UniversalPooledConnectionImpl.class.getDeclaredMethod("getTimeToLiveConnectionTimeoutCallback", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$40 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$39 = UniversalPooledConnectionImpl.class.getDeclaredMethod("removeTimeToLiveConnectionTimeoutCallback", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$39 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$38 = UniversalPooledConnectionImpl.class.getDeclaredMethod("registerTimeToLiveConnectionTimeoutCallback", TimeToLiveConnectionTimeoutCallback.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$38 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$37 = UniversalPooledConnectionImpl.class.getDeclaredMethod("getAbandonedConnectionTimeoutCallback", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$37 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$36 = UniversalPooledConnectionImpl.class.getDeclaredMethod("removeAbandonedConnectionTimeoutCallback", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$36 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$35 = UniversalPooledConnectionImpl.class.getDeclaredMethod("registerAbandonedConnectionTimeoutCallback", AbandonedConnectionTimeoutCallback.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$35 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$34 = UniversalPooledConnectionImpl.class.getDeclaredMethod("getConnectionHarvestingCallback", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$34 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$33 = UniversalPooledConnectionImpl.class.getDeclaredMethod("removeConnectionHarvestingCallback", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$33 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$32 = UniversalPooledConnectionImpl.class.getDeclaredMethod("registerConnectionHarvestingCallback", ConnectionHarvestingCallback.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$32 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$31 = UniversalPooledConnectionImpl.class.getDeclaredMethod("isConnectionHarvestable", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$30 = UniversalPooledConnectionImpl.class.getDeclaredMethod("setConnectionHarvestable", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$29 = UniversalPooledConnectionImpl.class.getDeclaredMethod("getUnmatchedConnectionLabels", Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$28 = UniversalPooledConnectionImpl.class.getDeclaredMethod("getConnectionLabels", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$27 = UniversalPooledConnectionImpl.class.getDeclaredMethod("onRetrieve", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$26 = UniversalPooledConnectionImpl.class.getDeclaredMethod("onInsert", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$25 = UniversalPooledConnectionImpl.class.getDeclaredMethod("removeConnectionLabel", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$24 = UniversalPooledConnectionImpl.class.getDeclaredMethod("applyConnectionLabel", String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$23 = UniversalPooledConnectionImpl.class.getDeclaredMethod("setLastConnectionValidationTime", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$22 = UniversalPooledConnectionImpl.class.getDeclaredMethod("getLastConnectionValidationTime", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$21 = UniversalPooledConnectionImpl.class.getDeclaredMethod("setBorrowedStartTime", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$20 = UniversalPooledConnectionImpl.class.getDeclaredMethod("getBorrowedStartTime", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$19 = UniversalPooledConnectionImpl.class.getDeclaredMethod("setAvailableStartTime", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$18 = UniversalPooledConnectionImpl.class.getDeclaredMethod("getAvailableStartTime", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$17 = UniversalPooledConnectionImpl.class.getDeclaredMethod("setStatus", UniversalPooledConnectionStatus.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$16 = UniversalPooledConnectionImpl.class.getDeclaredMethod("setStatus", UniversalPooledConnectionStatus.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$15 = UniversalPooledConnectionImpl.class.getDeclaredMethod("getStatus", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$14 = UniversalPooledConnectionImpl.class.getDeclaredMethod("getLastAccessedTime", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$13 = UniversalPooledConnectionImpl.class.getDeclaredMethod("getLastNetworkAccessTime", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$12 = UniversalPooledConnectionImpl.class.getDeclaredMethod("validate", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$11 = UniversalPooledConnectionImpl.class.getDeclaredMethod("markBadAndCancel", TaskHandle.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$10 = UniversalPooledConnectionImpl.class.getDeclaredMethod("isValidHelper", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$9 = UniversalPooledConnectionImpl.class.getDeclaredMethod("isValid", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$8 = UniversalPooledConnectionImpl.class.getDeclaredMethod("isValid", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$7 = UniversalPooledConnectionImpl.class.getDeclaredMethod("isSqlWithQueryTimeoutInProgress", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$6 = UniversalPooledConnectionImpl.class.getDeclaredMethod("setSqlWithQueryTimeoutInProgress", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$5 = UniversalPooledConnectionImpl.class.getDeclaredMethod("heartbeat", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$4 = UniversalPooledConnectionImpl.class.getDeclaredMethod("setBorrowCRI", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$3 = UniversalPooledConnectionImpl.class.getDeclaredMethod("getBorrowCRI", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$2 = UniversalPooledConnectionImpl.class.getDeclaredMethod("setConnectionRetrievalInfo", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$1 = UniversalPooledConnectionImpl.class.getDeclaredMethod("getConnectionRetrievalInfo", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$0 = UniversalPooledConnectionImpl.class.getDeclaredMethod("getPhysicalConnection", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        logger = Logger.getLogger(loggerName);
        selfTunerEnabled = Util.isSelfTunerEnabled();
    }
}

