@echo off
REM ========================================================================
REM This batch file unconfigures components in an Oracle Instant Client Home
REM ========================================================================

goto :ParseArgs

REM **************************
REM UNCONFIGURE ALL COMPONENTS
REM **************************
:UnconfigureAll
call :odp.net20 %1 %ohname%
call :odp.net4 %1 %ohname%
call :odpm %1 %ohname%
call :asp.net %1 %ohname%
call :asp.net4 %1 %ohname%
call :oledb %1 %ohname%
call :oledbolap %1 %ohname%
call :oramts %1 %ohname%
call :basic %1 %ohname%
goto :EOF


REM ****************************
REM UNCONFIGURE ASPNET Providers
REM ****************************

:asp.net

echo ****************************************** >> uninstall.log
echo Unconfiguring Oracle Providers for ASP.NET >> uninstall.log
echo ****************************************** >> uninstall.log

echo Delete the registry entry to remove managed assembly in the Add Reference Dialog box in VS.NET >> uninstall.log
reg delete "HKEY_LOCAL_MACHINE\SOFTWARE\Wow6432Node\Microsoft\.NETFramework\v2.0.50727\AssemblyFoldersEx\Oracle.Web" /f >> uninstall.log

echo.>> uninstall.log
echo ***************************************** >> uninstall.log
echo Oracle Providers for ASP.NET unconfigured >> uninstall.log
echo ***************************************** >> uninstall.log
echo.>> uninstall.log

REM echo ASP.NET Providers are now unconfigured.


goto :EOF



REM ******************************
REM UNCONFIGURE ASPNET Providers 4
REM ******************************

:asp.net4

echo ******************************************** >> uninstall.log
echo Unconfiguring Oracle Providers for ASP.NET 4 >> uninstall.log
echo ******************************************** >> uninstall.log

echo Delete the registry entry to remove managed assembly in the Add Reference Dialog box in VS.NET >> uninstall.log
reg delete "HKEY_LOCAL_MACHINE\SOFTWARE\Wow6432Node\Microsoft\.NETFramework\v4.0.30319\AssemblyFoldersEx\Oracle.Web" /f >> uninstall.log

echo.>> uninstall.log
echo ******************************************* >> uninstall.log
echo Oracle Providers for ASP.NET 4 unconfigured >> uninstall.log
echo ******************************************* >> uninstall.log
echo.>> uninstall.log

REM echo ASP.NET Providers 4 are now unconfigured.


goto :EOF




REM ***********************
REM UNCONFIGURE ODP.NET 2.0
REM ***********************

:odp.net20

echo *********************************************** >> uninstall.log
echo Unconfiguring Oracle Data Provider for .NET 2.0 >> uninstall.log
echo *********************************************** >> uninstall.log


REM remove registry entries for ODP.NET 2.x
echo Windows Registry Editor Version 5.00                     >  "%BATCH_DIR%"\odp.net.reg
echo [-HKEY_LOCAL_MACHINE\SOFTWARE\Oracle\ODP.NET\2.122.19.1]  >> "%BATCH_DIR%"\odp.net.reg
	
REM regedit /s "%BATCH_DIR%\odp.net.reg"
reg import "%BATCH_DIR%\odp.net.reg" /reg:64 1>NUL 2>NUL
del /q "%BATCH_DIR%\odp.net.reg"

echo Delete the registry entry to remove managed assembly in the Add Reference Dialog box in VS.NET >> uninstall.log
reg delete "HKEY_LOCAL_MACHINE\SOFTWARE\Wow6432Node\Microsoft\.NETFramework\v2.0.50727\AssemblyFoldersEx\ODP.Net" /f >> uninstall.log

echo.>> uninstall.log
echo ********************************************** >> uninstall.log
echo Oracle Data Provider for .NET 2.0 unconfigured >> uninstall.log
echo ********************************************** >> uninstall.log
echo.>> uninstall.log

REM echo ODP.NET 2.x is now unconfigured.
goto :EOF



REM *********************
REM UNCONFIGURE ODP.NET 4
REM *********************

:odp.net4

echo ********************************************* >> uninstall.log
echo Unconfiguring Oracle Data Provider for .NET 4 >> uninstall.log
echo ********************************************* >> uninstall.log

if {%MACHINE_WIDE_UNCFG%} == {true} (

REM remove odp section handler from machine.config for Framework 4
"%BATCH_DIR%odp.net\bin\4\OraProvCfg.exe" /action:unconfig /product:odp /frameworkversion:v4.0.30319 /providerpath:"%BATCH_DIR%odp.net\bin\4\Oracle.DataAccess.dll" >> uninstall.log

REM remove the odp 4 assembly from the GAC
"%BATCH_DIR%odp.net\bin\4\OraProvCfg.exe" /action:ungac /providerpath:"Oracle.DataAccess, Version=4.122.19.1,processorArchitecture=AMD64" >> uninstall.log

)

REM remove registry entries for ODP.NET 4
echo Windows Registry Editor Version 5.00                     >  "%BATCH_DIR%"\odp.net.reg
echo [-HKEY_LOCAL_MACHINE\SOFTWARE\Oracle\ODP.NET\4.122.19.1] >> "%BATCH_DIR%"\odp.net.reg
	
REM regedit /s "%BATCH_DIR%\odp.net.reg"
reg import "%BATCH_DIR%\odp.net.reg" /reg:64 1>NUL 2>NUL
del /q "%BATCH_DIR%\odp.net.reg"

echo Delete the registry entry to remove managed assembly in the Add Reference Dialog box in VS.NET >> uninstall.log
reg delete "HKEY_LOCAL_MACHINE\SOFTWARE\Wow6432Node\Microsoft\.NETFramework\v4.0.30319\AssemblyFoldersEx\ODP.Net" /f >> uninstall.log
reg delete "HKEY_LOCAL_MACHINE\SOFTWARE\Wow6432Node\Microsoft\.NETFramework\v4.0.30319\AssemblyFoldersEx\Oracle.DataAccess.EntityFramework6" /f >> uninstall.log

echo.>> uninstall.log
echo ******************************************** >> uninstall.log
echo Oracle Data Provider for .NET 4 unconfigured >> uninstall.log
echo ******************************************** >> uninstall.log
echo.>> uninstall.log

REM echo ODP.NET 4 is now unconfigured.
goto :EOF


:odpm

echo *********************************************************** >> uninstall.log
echo Unconfiguring Oracle Data Provider for .NET, Managed Driver >> uninstall.log
echo *********************************************************** >> uninstall.log

REM Unconfigure ODP.NET Managed Provider
pushd %BATCH_DIR%\odp.net\managed\x64
call unconfigure.bat %MACHINE_WIDE_UNCFG% >> "%BATCH_DIR%"\uninstall.log
popd


echo.>> uninstall.log
echo ********************************************************** >> uninstall.log
echo Oracle Data Provider for .NET, Managed Driver unconfigured >> uninstall.log
echo ********************************************************** >> uninstall.log
echo.>> uninstall.log

REM echo Oracle Data Provider for .NET, Managed Driver is now unconfigured.
goto :EOF



REM ***************************
REM UNCONFIGURE OLEDB 
REM ***************************

:oledb

echo **************************************** >> uninstall.log
echo Unconfiguring Oracle Provider for OLE DB >> uninstall.log
echo **************************************** >> uninstall.log

REM Add <Oracle Home> to the PATH environment variable
set PATH=%BATCH_DIR%;%BATCH_DIR%bin;%PATH%

REM Unregister the OLEDB provider
regsvr32 /s /u "%BATCH_DIR%bin\OraOLEDB19.dll"

REM remove OLEDB registry entries
echo Windows Registry Editor Version 5.00                     >  "%BATCH_DIR%"\oledb.reg
echo [HKEY_LOCAL_MACHINE\SOFTWARE\Oracle\KEY_%ohname%]              >> "%BATCH_DIR%"\oledb.reg
echo "OLEDB"=-                                                >> "%BATCH_DIR%"\oledb.reg
echo [-HKEY_LOCAL_MACHINE\SOFTWARE\Oracle\KEY_%ohname%\OLEDB]       >> "%BATCH_DIR%"\oledb.reg
	
REM regedit /s "%BATCH_DIR%\oledb.reg"
reg import "%BATCH_DIR%\oledb.reg" /reg:64 1>NUL 2>NUL
del     /q "%BATCH_DIR%\oledb.reg"

echo.>> uninstall.log
echo *************************************** >> uninstall.log
echo Oracle Provider for OLE DB unconfigured >> uninstall.log
echo *************************************** >> uninstall.log
echo.>> uninstall.log

REM echo OLEDB Provider are now unconfigured.


goto :EOF


REM **********************
REM UNCONFIGURE OLEDB OLAP
REM **********************

:oledbolap

echo ********************************************* >> uninstall.log
echo Unconfiguring Oracle Provider for OLE DB OLAP >> uninstall.log
echo ********************************************* >> uninstall.log

REM Add <Oracle Home> to the PATH environment variable
set PATH=%BATCH_DIR%;%BATCH_DIR%bin;%PATH%

REM Unregister the OLEDB OLAP provider
regsvr32 /s /u "%BATCH_DIR%bin\OraOLEDBOLAP.dll"

REM remove OLEDB OLAP registry entries
echo Windows Registry Editor Version 5.00                     >  "%BATCH_DIR%"\oldebolap.reg
echo [HKEY_LOCAL_MACHINE\SOFTWARE\Oracle\KEY_%ohname%]              >> "%BATCH_DIR%"\oldebolap.reg
echo "OLEDBOLAP"=-                                                >> "%BATCH_DIR%"\oldebolap.reg
	
REM regedit /s "%BATCH_DIR%\oldebolap.reg"
reg import "%BATCH_DIR%\oldebolap.reg" /reg:64 1>NUL 2>NUL
del     /q "%BATCH_DIR%\oldebolap.reg"

echo.>> uninstall.log
echo ******************************************** >> uninstall.log
echo Oracle Provider for OLE DB OLAP unconfigured >> uninstall.log
echo ******************************************** >> uninstall.log
echo.>> uninstall.log

REM echo OLEDB OLAP Provider are now unconfigured.


goto :EOF



REM ******************
REM UNCONFIGURE ORAMTS 
REM ******************

:oramts

echo ************************************* >> uninstall.log
echo Unconfiguring Oracle Services for MTS >> uninstall.log
echo ************************************* >> uninstall.log

rem set some local env vars used by genreg, etc.
set reg_file=%temp%\clean_registry.reg
set mts_svcname=Oracle%ohname%MTSRecoveryService

echo Deleting %mts_svcname% .... >> uninstall.log
sc.exe stop   %mts_svcname% > NUL 2>&1
sc.exe delete %mts_svcname% >> uninstall.log

echo Cleaning up registry entries for OraMTS .... >> uninstall.log
call "%BATCH_DIR%"\oramts\install\genreg.bat deinstall %ohname% > %reg_file%
REM regedit -s %reg_file%
reg import %reg_file% /reg:64 1>NUL 2>NUL
echo Registry entries for OraMTS cleaned up successfully >> uninstall.log

del %reg_file%

echo.>> uninstall.log
echo ************************************ >> uninstall.log
echo Oracle Services for MTS unconfigured >> uninstall.log
echo ************************************ >> uninstall.log
echo.>> uninstall.log

REM echo ORAMTS is now unconfigured.


goto :EOF


:basic

echo **************************** >> uninstall.log
echo Unconfiguring Instant Client >> uninstall.log
echo **************************** >> uninstall.log

REM remove IC registry entries
echo Windows Registry Editor Version 5.00                         >  "%BATCH_DIR%"\common.reg
echo [-HKEY_LOCAL_MACHINE\SOFTWARE\Oracle\KEY_%ohname%]           >> "%BATCH_DIR%"\common.reg

REM regedit /s "%BATCH_DIR%\common.reg"
reg import "%BATCH_DIR%\common.reg" /reg:64 1>NUL 2>NUL
del /q "%BATCH_DIR%\common.reg"

echo.>> uninstall.log
echo *************************** >> uninstall.log
echo Instant Client unconfigured >> uninstall.log
echo *************************** >> uninstall.log
echo.>> uninstall.log

REM echo Instant Client is now unconfigured.
goto :EOF



REM =======================
REM Parse Script Arguments
REM =======================
:ParseArgs
if /i {%1} == {} goto :Usage
if /i {%2} == {} goto :Usage
if /i {%1} == {-h} goto :Usage
if /i {%1} == {-help} goto :Usage

set FILE=%~pf0
if not exist "%FILE%" goto :eof
set BATCH_DIR=%~pd0

REM unconfigure machine wide or not - default is false
set MACHINE_WIDE_UNCFG=false
if /i {%3} == {true} set MACHINE_WIDE_UNCFG=true

set ohname=%2

if EXIST %2\oracle.key goto :get_oraclehomename
goto :continue

:get_oraclehomename
for /f "delims=_ tokens=1,*" %%i in ('type %ohname%\oracle.key') do set ohname=%%j

:continue

if /i {%1} == {odp.net20} goto :odp.net20
if /i {%1} == {odp.net2}  goto :odp.net20
if /i {%1} == {odp.net4}  goto :odp.net4
if /i {%1} == {odp.net4}  goto :odp.net4
if /i {%1} == {odpm}      goto :odpm
if /i {%1} == {asp.net}   goto :asp.net
if /i {%1} == {asp.net2}  goto :asp.net
if /i {%1} == {asp.net4}  goto :asp.net4
if /i {%1} == {oledb}     goto :oledb
if /i {%1} == {oledbolap} goto :oledbolap
if /i {%1} == {oramts}    goto :oramts
if /i {%1} == {basic}     goto :basic
if /i {%1} == {all}       goto :UnconfigureAll
goto :Usage



:Usage
echo.
echo Usage:
echo   unconfigure.bat component_name oracle_home_name [machine_wide_unconfiguration]
echo   or
echo   unconfigure.bat component_name oracle_home_path [machine_wide_unconfiguration]
echo.
echo Example:
echo   unconfigure.bat all       myhome           (unconfigure all components, do not unconfigure at machine level)
echo   unconfigure.bat odp.net2  myhome           (unconfigure ODP.NET 2)
echo   unconfigure.bat odp.net4  myhome     true  (unconfigure ODP.NET 4, unconfigure at machine level)
echo   unconfigure.bat odpm      myhome           (unconfigure ODP.NET Managed Provider)
echo   unconfigure.bat asp.net2  myhome           (unconfigure ASP.NET Providers 2)
echo   unconfigure.bat asp.net4  myhome           (unconfigure ASP.NET Providers 4)
echo   unconfigure.bat oledb     c:\oracle        (unconfigure OLEDB Providers)
echo   unconfigure.bat oledbolap c:\oracle        (unconfigure OLEDB OLAP Providers)
echo   unconfigure.bat oramts    c:\oracle        (unconfigure ORAMTS)
echo   unconfigure.bat basic     c:\oracle        (unconfigure Oracle Instant Client)
echo.
echo NOTE: By default, machine_wide_unconfiguration=false.
goto :EOF
