@echo off

REM ======================================================================
REM This batch file configures components in an Oracle Instant Client Home
REM ======================================================================

goto :ParseArgs

REM ************************
REM CONFIGURE ALL COMPONENTS
REM ************************
:ConfigureAll
call :odp.net20
call :odp.net4
call :odpm
call :asp.net
call :asp.net4
call :oledb
call :oledbolap
call :oramts
goto :EOF


REM **************************
REM CONFIGURE ASPNET Providers
REM **************************

:asp.net

REM echo Please wait... configuring Oracle Providers for ASP.NET

echo **************************************** >> install.log
echo Configuring Oracle Providers for ASP.NET >> install.log
echo **************************************** >> install.log

echo Create a registry entry to add managed assembly in the Add Reference Dialog box in VS.NET >> install.log
reg add "HKEY_LOCAL_MACHINE\SOFTWARE\%ODAC_CFG_PREFIX%Microsoft\.NETFramework\v2.0.50727\AssemblyFoldersEx\Oracle.Web" /ve /t REG_SZ /d %BAT_DIR_NO_TRAILING_SLASH%\asp.net\bin\2.x /f >> install.log

echo.>> install.log
echo *************************************** >> install.log
echo Oracle Providers for ASP.NET configured >> install.log
echo *************************************** >> install.log
echo.>> install.log

REM echo Oracle Providers for ASP.NET configured in an Oracle Instant Client Home.

if {%DEPENDENT%} == {true} (
goto :odp.net20
) else (
goto :EOF
)



REM ****************************
REM CONFIGURE ASPNET Providers 4
REM ****************************

:asp.net4

REM echo Please wait... configuring Oracle Providers for ASP.NET 4

echo ****************************************** >> install.log
echo Configuring Oracle Providers for ASP.NET 4 >> install.log
echo ****************************************** >> install.log


echo Create a registry entry to add managed assembly in the Add Reference Dialog box in VS.NET >> install.log
reg add "HKEY_LOCAL_MACHINE\SOFTWARE\%ODAC_CFG_PREFIX%Microsoft\.NETFramework\v4.0.30319\AssemblyFoldersEx\Oracle.Web" /ve /t REG_SZ /d %BAT_DIR_NO_TRAILING_SLASH%\asp.net\bin\4 /f >> install.log

echo.>> install.log
echo ***************************************** >> install.log
echo Oracle Providers for ASP.NET 4 configured >> install.log
echo ***************************************** >> install.log
echo.>> install.log

REM echo Oracle Providers for ASP.NET 4 configured in an Oracle Instant Client Home.

if {%DEPENDENT%} == {true} (
goto :odpm
) else (
goto :EOF
)



REM *********************
REM CONFIGURE ODP.NET 2.0
REM *********************

:odp.net20

REM echo Please wait... configuring Oracle Data Provider for .NET 2.0

echo ********************************************* >> install.log
echo Configuring Oracle Data Provider for .NET 2.0 >> install.log
echo ********************************************* >> install.log


REM setup registry entries for ODP.NET 2.x
echo Windows Registry Editor Version 5.00                                     >  "%HOME_DIR_NO_TRAILING_SLASH%\odp.net.reg"
echo [HKEY_LOCAL_MACHINE\SOFTWARE\%ODAC_CFG_PREFIX%Oracle\ODP.NET]            >> "%HOME_DIR_NO_TRAILING_SLASH%\odp.net.reg"
echo [HKEY_LOCAL_MACHINE\SOFTWARE\%ODAC_CFG_PREFIX%Oracle\ODP.NET\2.122.19.1] >> "%HOME_DIR_NO_TRAILING_SLASH%\odp.net.reg"
echo "DllPath"="%HOME_DIR2%bin"                                               >> "%HOME_DIR_NO_TRAILING_SLASH%\odp.net.reg"

regedit /s "%HOME_DIR_NO_TRAILING_SLASH%\odp.net.reg"
del /q "%HOME_DIR_NO_TRAILING_SLASH%\odp.net.reg"

echo Delete the old registry entry to add managed assembly in the Add Reference Dialog box in VS.NET >> install.log
reg query HKEY_LOCAL_MACHINE\SOFTWARE\%ODAC_CFG_PREFIX%Microsoft\.NETFramework\v2.0.50727\AssemblyFoldersEx\Oracle.DataAccess\ 1>NUL 2>NUL
if %ERRORLEVEL% EQU 0 (
reg delete "HKEY_LOCAL_MACHINE\SOFTWARE\%ODAC_CFG_PREFIX%Microsoft\.NETFramework\v2.0.50727\AssemblyFoldersEx\Oracle.DataAccess" /f 1>NUL 2>NUL
)


echo Create a registry entry to add managed assembly in the Add Reference Dialog box in VS.NET >> install.log
reg add "HKEY_LOCAL_MACHINE\SOFTWARE\%ODAC_CFG_PREFIX%Microsoft\.NETFramework\v2.0.50727\AssemblyFoldersEx\ODP.Net" /ve /t REG_SZ /d %BAT_DIR_NO_TRAILING_SLASH%\odp.net\bin\2.x /f >> install.log

echo.>> install.log
echo ******************************************** >> install.log
echo Oracle Data Provider for .NET 2.0 configured >> install.log
echo ******************************************** >> install.log
echo.>> install.log
REM echo Oracle Data Provider for .NET 2.0 configured in an Oracle Instant Client Home.

goto :EOF



REM *******************
REM CONFIGURE ODP.NET 4
REM *******************

:odp.net4

REM echo Please wait... configuring Oracle Data Provider for .NET 4

echo ******************************************* >> install.log
echo Configuring Oracle Data Provider for .NET 4 >> install.log
echo ******************************************* >> install.log

if {%MACHINE_WIDE_CFG%} == {true} (

REM Enter the odp 4 assembly in the GAC
"%HOME_DIR%odp.net\bin\4\OraProvCfg.exe" /action:gac /providerpath:"%HOME_DIR%odp.net\bin\4\Oracle.DataAccess.dll" >> install.log

REM configure machine.config for Framework 4 with proper section handler
"%HOME_DIR%odp.net\bin\4\OraProvCfg.exe" /action:config /product:odp /frameworkversion:v4.0.30319 /providerpath:"%HOME_DIR%odp.net\bin\4\Oracle.DataAccess.dll" >> install.log

)

REM setup registry entries for ODP.NET 4
echo Windows Registry Editor Version 5.00                                     >  "%HOME_DIR_NO_TRAILING_SLASH%\odp.net.reg"
echo [HKEY_LOCAL_MACHINE\SOFTWARE\%ODAC_CFG_PREFIX%Oracle\ODP.NET]            >> "%HOME_DIR_NO_TRAILING_SLASH%\odp.net.reg"
echo [HKEY_LOCAL_MACHINE\SOFTWARE\%ODAC_CFG_PREFIX%Oracle\ODP.NET\4.122.19.1] >> "%HOME_DIR_NO_TRAILING_SLASH%\odp.net.reg"
echo "DllPath"="%HOME_DIR2%bin"                                               >> "%HOME_DIR_NO_TRAILING_SLASH%\odp.net.reg"

regedit /s "%HOME_DIR_NO_TRAILING_SLASH%\odp.net.reg"
del /q "%HOME_DIR_NO_TRAILING_SLASH%\odp.net.reg"

echo Delete the old registry entry to add managed assembly in the Add Reference Dialog box in VS.NET >> install.log
reg query HKEY_LOCAL_MACHINE\SOFTWARE\%ODAC_CFG_PREFIX%Microsoft\.NETFramework\v4.0.30319\AssemblyFoldersEx\Oracle.DataAccess\ 1>NUL 2>NUL
if %ERRORLEVEL% EQU 0 (
reg delete "HKEY_LOCAL_MACHINE\SOFTWARE\%ODAC_CFG_PREFIX%Microsoft\.NETFramework\v4.0.30319\AssemblyFoldersEx\Oracle.DataAccess" /f 1>NUL 2>NUL
)

echo Create a registry entry to add managed assembly in the Add Reference Dialog box in VS.NET >> install.log
reg add "HKEY_LOCAL_MACHINE\SOFTWARE\%ODAC_CFG_PREFIX%Microsoft\.NETFramework\v4.0.30319\AssemblyFoldersEx\ODP.Net" /ve /t REG_SZ /d %BAT_DIR_NO_TRAILING_SLASH%\odp.net\bin\4 /f >> install.log
reg add "HKEY_LOCAL_MACHINE\SOFTWARE\%ODAC_CFG_PREFIX%Microsoft\.NETFramework\v4.0.30319\AssemblyFoldersEx\Oracle.DataAccess.EntityFramework6" /ve /t REG_SZ /d %BAT_DIR_NO_TRAILING_SLASH%\odp.net\bin\4\EF6 /f >> install.log

echo.>> install.log
echo ****************************************** >> install.log
echo Oracle Data Provider for .NET 4 configured >> install.log
echo ****************************************** >> install.log
echo.>> install.log
REM echo Oracle Data Provider for .NET configured in an Oracle Instant Client Home.


goto :EOF



:odpm

REM echo Please wait... configuring Oracle Data Provider for .NET, Managed Driver

echo ********************************************************* >> install.log
echo Configuring Oracle Data Provider for .NET, Managed Driver >> install.log
echo ********************************************************* >> install.log


REM Configure ODP.NET Managed Provider
pushd %BAT_DIR_NO_TRAILING_SLASH%\odp.net\managed\x86
REM using %TNS_ARG% instead of %5 to workaround issue where tns_admin not being passed
REM to managed configure.bat below is using %5
call configure.bat %MACHINE_WIDE_CFG% %TNS_ARG% >> %BAT_DIR_NO_TRAILING_SLASH%\install.log
popd


echo.>> install.log
echo ********************************************* >> install.log
echo Oracle Data Provider for .NET, Managed Driver >> install.log
echo ********************************************* >> install.log
echo.>> install.log
REM echo Oracle Data Provider for .NET configured in an Oracle Instant Client Home.


goto :EOF



REM *********************
REM CONFIGURE OLEDB
REM *********************

:oledb

REM echo Please wait... configuring Oracle Provider for OLEDB

echo ************************************** >> install.log
echo Configuring Oracle Provider for OLE DB >> install.log
echo ************************************** >> install.log

REM Add <Oracle Home> to the PATH environment variable
set PATH=%HOME_DIR_NO_TRAILING_SLASH%;%HOME_DIR_NO_TRAILING_SLASH%\bin;%PATH%

REM Register OraOLEDB DLL in the registry
echo Register OraOLEDB DLL >> install.log
regsvr32 /s "%HOME_DIR_NO_TRAILING_SLASH%\bin\OraOLEDB19.dll"

REM setup registry entries for OLEDB
echo Windows Registry Editor Version 5.00                               >  "%HOME_DIR_NO_TRAILING_SLASH%\oledb.reg"
echo [HKEY_LOCAL_MACHINE\SOFTWARE\%ODAC_CFG_PREFIX%Oracle\KEY_%2]       >> "%HOME_DIR_NO_TRAILING_SLASH%\oledb.reg"
echo "OLEDB"="%HOME_DIR2_NO_TRAILING_SLASH%\\oledb\\mesg"               >> "%HOME_DIR_NO_TRAILING_SLASH%\oledb.reg"
echo [HKEY_LOCAL_MACHINE\SOFTWARE\%ODAC_CFG_PREFIX%Oracle\KEY_%2\OLEDB] >> "%HOME_DIR_NO_TRAILING_SLASH%\oledb.reg"
echo "DisableRetClause"="1"                                            >> "%HOME_DIR_NO_TRAILING_SLASH%\oledb.reg"

regedit /s "%HOME_DIR_NO_TRAILING_SLASH%\oledb.reg"
del /q "%HOME_DIR_NO_TRAILING_SLASH%\oledb.reg"

echo.>> install.log
echo ************************************* >> install.log
echo Oracle Provider for OLE DB configured >> install.log
echo ************************************* >> install.log
echo.>> install.log
REM echo Oracle Provider for OLEDB configured in an Oracle Instant Client Home.

goto :EOF



REM ********************
REM CONFIGURE OLEDB OLAP
REM ********************

:oledbolap

REM echo Please wait... configuring Oracle Provider for OLEDB for OLAP

echo *********************************************** >> install.log
echo Configuring Oracle Provider for OLE DB for OLAP >> install.log
echo *********************************************** >> install.log

REM Add <Oracle Home> to the PATH environment variable
set PATH=%HOME_DIR_NO_TRAILING_SLASH%;%HOME_DIR_NO_TRAILING_SLASH%\bin;%PATH%

REM Register OraOLEDBOLAP DLL in the registry
echo Register OraOLEDBOLAP DLL >> install.log
regsvr32 /s "%HOME_DIR_NO_TRAILING_SLASH%\bin\OraOLEDBOLAP.dll"

REM setup registry entries for OLEDBOLAP
echo Windows Registry Editor Version 5.00                               >  "%HOME_DIR_NO_TRAILING_SLASH%\oledbolap.reg"
echo [HKEY_LOCAL_MACHINE\SOFTWARE\%ODAC_CFG_PREFIX%Oracle\KEY_%2]       >> "%HOME_DIR_NO_TRAILING_SLASH%\oledbolap.reg"
echo "OLEDBOLAP"="%HOME_DIR2_NO_TRAILING_SLASH%\\oledbolap\\mesg"       >> "%HOME_DIR_NO_TRAILING_SLASH%\oledbolap.reg"

regedit /s "%HOME_DIR_NO_TRAILING_SLASH%\oledbolap.reg"
del /q "%HOME_DIR_NO_TRAILING_SLASH%\oledbolap.reg"

echo.>> install.log
echo ************************************* >> install.log
echo Oracle Provider for OLE DB for OLAP configured >> install.log
echo ************************************* >> install.log
echo.>> install.log
REM echo Oracle Provider for OLEDB for OLAP configured in an Oracle Instant Client Home.

goto :EOF



REM ****************
REM CONFIGURE ORAMTS
REM ****************

:oramts

REM echo Please wait... configuring Oracle Services for MTS

echo *********************************** >> install.log
echo Configuring Oracle Services for MTS >> install.log
echo *********************************** >> install.log

REM Add <Oracle Home> to the PATH environment variable
set PATH=%HOME_DIR_NO_TRAILING_SLASH%;%HOME_DIR_NO_TRAILING_SLASH%\bin;%PATH%

REM configure.bat will be run from the destination orcl_home dir
REM after oramts files have been copied over in the destination orcl_home dir

set src_dir=%HOME_DIR%
set dst_dir=%HOME_DIR%

set reco_username=%userdomain%\%username%
REM set some local env vars used by genreg, etc.
set orcl_home=%dst_dir%
set reco_port=2030
set reco_host=%computername%
set reco_password=
set reco_username=LocalSystem
set mts_svcname=Oracle%2MTSRecoveryService

REM The quotes have to be escaped to create service with something like  below. 
REM "C:\Program Files (x86)\odacmts1\bin\omtsreco.exe" Oracleodacmts1MTSRecoveryService
set svc_binary="\"%orcl_home%bin\omtsreco.exe\" %mts_svcname%"

set inst_dir=%HOME_DIR_NO_TRAILING_SLASH%\oramts\install
set reg_file="%temp%\setup_reg.reg"

REM echo creating OracleMTSRecoveryService ....
sc.exe stop   %mts_svcname% > NUL 2>&1
sc.exe delete %mts_svcname% > NUL 2>&1

REM need to have space after = in below, do not remove the space
sc.exe create %mts_svcname% binpath= %svc_binary%  start= auto obj= "NT AUTHORITY\LOCAL SERVICE" DisplayName= %mts_svcname% >> install.log
REM OracleMTSRecoveryService was successfully created with the LOCAL SERVICE
REM account as the logon account. Make sure to change the logon  credentials 
REM of this service using the "services" administration tool. Please read the
REM README.TXT under %orcl_home%\oramts\doc.

REM creating registry entries for OraMTS ....
call "%inst_dir%\genreg.bat" install %2 > %reg_file%
regedit -s %reg_file%
REM echo created registry entries for OraMTS successfully

REM echo starting OracleMTSRecoveryService ...
REM net start  OracleMTSRecoveryService
REM echo started OracleMTSRecoveryService successfully

del %reg_file%

echo.>> install.log
echo ********************************** >> install.log
echo Oracle Services for MTS configured >> install.log
echo ********************************** >> install.log
echo.>> install.log
echo.
REM echo Oracle Services for MTS configured in an Oracle Instant Client Home.

goto :EOF



REM =======================
REM Parse Script Arguments
REM =======================
:ParseArgs
if /i {%1} == {} goto :Usage
if /i {%2} == {} goto :Usage
if /i {%1} == {-h} goto :Usage
if /i {%1} == {-help} goto :Usage

set FILE=%~pf0
if not exist "%FILE%" goto :eof

REM sample variable values
REM BAT_DIR="C:\Program Files\odac\"
REM BAT_DIR_NO_TRAILING_SLASH="C:\Program Files\odac"

REM REG_DIR="C:\\Program Files\\odac\\"
REM REG_DIR_NO_TRAILING_SLASH="C:\\Program Files\\odac"

REM HOME_DIR=C:\Program Files\odac\
REM HOME_DIR2=C:\\Program Files\\odac\\
REM HOME_DIR2_NO_TRAILING_SLASH=C:\\Program Files\\odac
REM HOME_DIR_NO_TRAILING_SLASH=C:\Program Files\odac

REM OH Path with quotes to support spaces in the path
set BAT_DIR="%~pd0"
set REG_DIR=%BAT_DIR:\=\\%

set BAT_DIR_NO_TRAILING_SLASH="%~pd0"
set BAT_DIR_NO_TRAILING_SLASH=%BAT_DIR_NO_TRAILING_SLASH:~0,-2%"
set REG_DIR_NO_TRAILING_SLASH=%BAT_DIR_NO_TRAILING_SLASH:\=\\%

REM OH Path without quotes
set HOME_DIR=%~pd0
set HOME_DIR2=%HOME_DIR:\=\\%

set HOME_DIR_NO_TRAILING_SLASH=%~pd0
set HOME_DIR_NO_TRAILING_SLASH=%HOME_DIR_NO_TRAILING_SLASH:~0,-1%
set HOME_DIR2_NO_TRAILING_SLASH=%HOME_DIR_NO_TRAILING_SLASH:\=\\%

REM determine if the configuration is on a 32-bit or 64-bit OS
set ODAC_CFG_PREFIX=Wow6432Node\
if (%PROCESSOR_ARCHITECTURE%) == (x86) if (%PROCESSOR_ARCHITEW6432%) == () set ODAC_CFG_PREFIX=

REM configure dependencies or not - default is true
REM note that this option really only applies to asp.net component
set DEPENDENT=true
if /i {%3} == {false} set DEPENDENT=false

REM configure machine wide or not - default is false
set MACHINE_WIDE_CFG=false
if /i {%4} == {true} set MACHINE_WIDE_CFG=true

set TNS_ARG=%5
set SET_TNS=false
if {%5} NEQ {} (
  set SET_TNS=true
)

REM ODPM and ASPM does not require IC related configuration
set set_common_IC_reg_entries=true
if /i {%1} EQU {odpm} set set_common_IC_reg_entries=false
if /i {%1} EQU {asp.net4} set set_common_IC_reg_entries=false

REM ODPM does not require IC related configuration
if {%set_common_IC_reg_entries%} == {true} (

REM setup common registry entries
echo Windows Registry Editor Version 5.00                         >  "%HOME_DIR_NO_TRAILING_SLASH%\common.reg"
echo [HKEY_LOCAL_MACHINE\SOFTWARE\%ODAC_CFG_PREFIX%Oracle\KEY_%2] >> "%HOME_DIR_NO_TRAILING_SLASH%\common.reg"
echo "ORACLE_HOME"=%REG_DIR_NO_TRAILING_SLASH%                    >> "%HOME_DIR_NO_TRAILING_SLASH%\common.reg"
echo "ORACLE_HOME_NAME"="%2"                                      >> "%HOME_DIR_NO_TRAILING_SLASH%\common.reg"
echo "ORACLE_GROUP_NAME"="Oracle - %2"                            >> "%HOME_DIR_NO_TRAILING_SLASH%\common.reg"
echo "NLS_LANG"="AMERICAN_AMERICA.WE8MSWIN1252"                   >> "%HOME_DIR_NO_TRAILING_SLASH%\common.reg"

regedit /s "%HOME_DIR%common.reg"
del /q "%HOME_DIR%common.reg"

if {%SET_TNS%} == {true} (
REM add TNS_ADMIN as below and not part of above regedit to fix Bug 34340300 and 34309562.
reg add "HKEY_LOCAL_MACHINE\SOFTWARE\%ODAC_CFG_PREFIX%Oracle\KEY_%2" /v TNS_ADMIN /t REG_SZ /d %5 /f 1>NUL 2>NUL
)

REM not all components create bin dir and copy files over
if EXIST "%HOME_DIR%bin\*.*" (
 echo SOFTWARE\%ODAC_CFG_PREFIX%ORACLE\KEY_%2> %BAT_DIR%bin\oracle.key
)
echo SOFTWARE\%ODAC_CFG_PREFIX%ORACLE\KEY_%2> %BAT_DIR%oracle.key

)

REM Basic Instant Client does not require any additional configuration
REM other than the common configuration done above
if /i {%1} == {basic}     goto :EOF
if /i {%1} == {odp.net20} goto :odp.net20
if /i {%1} == {odp.net2}  goto :odp.net20
if /i {%1} == {odp.net4}  goto :odp.net4
if /i {%1} == {asp.net}   goto :asp.net
if /i {%1} == {asp.net2}  goto :asp.net
if /i {%1} == {asp.net4}  goto :asp.net4
if /i {%1} == {oledb}     goto :oledb
if /i {%1} == {oledbolap} goto :oledbolap
if /i {%1} == {odpm}      goto :odpm
if /i {%1} == {oramts}    goto :oramts
if /i {%1} == {all}       goto :ConfigureAll
goto :Usage



:Usage
echo.
echo Usage:
echo   configure.bat component_name oracle_home_name [configure_dependents] [machine_wide_configuration] [tns_admin_location]
echo.
echo Example:
echo   configure.bat all       myhome true              (configure all components, do not configure at the machine level)
echo   configure.bat odp.net2  myhome true              (configure ODP.NET 2 and dependent components)
echo   configure.bat odp.net4  myhome true true c:\tns  (configure ODP.NET 4 at the machine level, set TNS_ADMIN to c:\tns)
echo   configure.bat odpm      myhome                   (configure ODP.NET Managed Provider)
echo   configure.bat asp.net2  myhome true              (configure ASP.NET Providers 2 and its dependent components)
echo   configure.bat asp.net4  myhome true              (configure ASP.NET Providers 4 and its dependent components)
echo   configure.bat oledb     myhome                   (configure OLEDB)
echo   configure.bat oledbolap myhome                   (configure OLEDB OLAP)
echo   configure.bat oramts    myhome                   (configure ORAMTS)
echo   configure.bat basic     myhome                   (configure Oracle Instant Client)
echo.
echo NOTE: By default, configure_dependents=true and machine_wide_configuration=false.
echo.
echo NOTE: In order to specify tns_admin_location, machine_wide_configuration and configure_dependents have to be specified.
goto :EOF
