/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.routing;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import oracle.ucp.common.ServiceMember;
import oracle.ucp.routing.InstanceSet;

class DestinationMap {
    private final ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock(true);
    private final ReentrantReadWriteLock.ReadLock rLock = this.rwLock.readLock();
    private final ReentrantReadWriteLock.WriteLock wLock = this.rwLock.writeLock();
    private final NavigableMap<Integer, InstanceSet> instsPerPriority = new TreeMap<Integer, InstanceSet>((o1, o2) -> o1 - o2);
    private final Map<ServiceMember, Integer> priorityPerInstance = new HashMap<ServiceMember, Integer>();
    private final AtomicReference<Set<ServiceMember>> allInstancesSnapshot = new AtomicReference<Set<ServiceMember>>(Collections.unmodifiableSet(new HashSet<ServiceMember>(this.priorityPerInstance.keySet())));

    DestinationMap() {
    }

    void add(ServiceMember inst, int priority) {
        if (null == inst) {
            throw new IllegalArgumentException();
        }
        this.wLock.lock();
        try {
            this.instsPerPriority.computeIfAbsent(priority, p -> new InstanceSet()).add(inst);
            this.priorityPerInstance.put(inst, priority);
            this.allInstancesSnapshot.set(Collections.unmodifiableSet(new HashSet<ServiceMember>(this.priorityPerInstance.keySet())));
        }
        finally {
            this.wLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(ServiceMember inst) {
        if (null == inst) {
            throw new IllegalArgumentException();
        }
        this.wLock.lock();
        try {
            Integer priority = this.priorityPerInstance.remove(inst);
            if (null != priority) {
                InstanceSet insts = this.instsPerPriority.getOrDefault(priority, InstanceSet.EMPTY);
                insts.remove(inst);
            }
            this.allInstancesSnapshot.set(Collections.unmodifiableSet(new HashSet<ServiceMember>(this.priorityPerInstance.keySet())));
        }
        finally {
            this.wLock.unlock();
        }
    }

    InstanceSet getHighestPriorityInstances() {
        this.rLock.lock();
        try {
            InstanceSet instanceSet = this.instsPerPriority.isEmpty() ? new InstanceSet() : this.instsPerPriority.firstEntry().getValue();
            return instanceSet;
        }
        finally {
            this.rLock.unlock();
        }
    }

    boolean contains(ServiceMember inst) {
        if (null == inst) {
            throw new IllegalArgumentException();
        }
        this.rLock.lock();
        try {
            boolean bl = this.priorityPerInstance.containsKey(inst);
            return bl;
        }
        finally {
            this.rLock.unlock();
        }
    }

    int getPriority(ServiceMember inst) {
        if (null == inst) {
            throw new IllegalArgumentException();
        }
        this.rLock.lock();
        try {
            int n = this.priorityPerInstance.getOrDefault(inst, -1);
            return n;
        }
        finally {
            this.rLock.unlock();
        }
    }

    Set<ServiceMember> allInstances() {
        return this.allInstancesSnapshot.get();
    }
}

