/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.pool;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.StatementEventListener;
import javax.transaction.xa.XAResource;
import oracle.jdbc.OracleShardingKey;
import oracle.jdbc.diagnostics.CommonDiagnosable;
import oracle.jdbc.diagnostics.Diagnosable;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleCloseCallback;
import oracle.jdbc.driver.OracleDriver;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.Blind;

public class OraclePooledConnection
implements oracle.jdbc.datasource.OraclePooledConnection,
Serializable,
Monitor,
Diagnosable {
    static final long serialVersionUID = -203725628718322873L;
    public static final String url_string = "connection_url";
    public static final String pool_auto_commit_string = "pool_auto_commit";
    public static final String object_type_map = "obj_type_map";
    public static final String transaction_isolation = "trans_isolation";
    public static final String statement_cache_size = "stmt_cache_size";
    public static final String isClearMetaData = "stmt_cache_clear_metadata";
    public static final String ImplicitStatementCachingEnabled = "ImplicitStatementCachingEnabled";
    public static final String ExplicitStatementCachingEnabled = "ExplicitStatementCachingEnabled";
    public static final String LoginTimeout = "LoginTimeout";
    public static final String connect_auto_commit_string = "connect_auto_commit";
    public static final String implicit_caching_enabled = "implicit_cache_enabled";
    public static final String explicit_caching_enabled = "explict_cache_enabled";
    public static final String connection_properties_string = "connection_properties";
    public static final String event_listener_string = "event_listener";
    public static final String sql_exception_string = "sql_exception";
    public static final String close_callback_string = "close_callback";
    public static final String private_data = "private_data";
    static final int CONNECTION_CLOSED_EVENT = 101;
    static final int CONNECTION_ERROROCCURED_EVENT = 102;
    private Hashtable eventListeners = null;
    private SQLException sqlException = null;
    protected boolean autoCommit = true;
    protected transient OracleConnection logicalHandle = null;
    protected transient OracleConnection physicalConn = null;
    protected transient OracleConnection replayConn = null;
    private Hashtable connectionProperty = null;
    public int closeOption = 0;
    private OracleCloseCallback closeCallback = null;
    private Object privateData = null;
    protected transient OracleDriver oracleDriver = new OracleDriver();
    boolean localTxnCommitOnClose = false;
    private final Monitor.CloseableLock monitorLock = Monitor.newDefaultLock();
    public static final String NO_IMPLICIT_BEGIN_REQUEST_PROPERTY = "oracle.jdbc.noImplicitBeginRequest";

    public OraclePooledConnection() {
        this((Connection)null);
    }

    public OraclePooledConnection(String url) throws SQLException {
        Connection conn = this.oracleDriver.connect(url, new Properties());
        if (conn == null) {
            throw (SQLException)DatabaseError.createSqlException(67).fillInStackTrace();
        }
        this.initialize(conn);
    }

    public OraclePooledConnection(String url, String user, @Blind String passwd) throws SQLException {
        Properties props = new Properties();
        props.put("user", user);
        props.put("password", passwd);
        Connection conn = this.oracleDriver.connect(url, props);
        if (conn == null) {
            throw (SQLException)DatabaseError.createSqlException(67).fillInStackTrace();
        }
        this.initialize(conn);
    }

    public OraclePooledConnection(Connection pc) {
        this.initialize(pc);
    }

    public OraclePooledConnection(Connection pc, boolean ac) {
        this(pc);
        this.autoCommit = ac;
    }

    private void initialize(Connection pc) {
        this.physicalConn = (OracleConnection)pc;
        this.eventListeners = new Hashtable(10);
        this.closeCallback = null;
        this.privateData = null;
    }

    @Override
    public void addConnectionEventListener(ConnectionEventListener cel) {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            if (this.eventListeners == null) {
                this.sqlException = new SQLException("Listener Hashtable Null");
            } else {
                this.eventListeners.put(cel, cel);
            }
        }
    }

    @Override
    public void close() throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            if (this.closeCallback != null) {
                this.closeCallback.beforeClose(this.physicalConn, this.privateData);
            }
            if (this.physicalConn != null) {
                try {
                    this.physicalConn.close();
                }
                catch (SQLException ea) {
                    this.debug(Level.WARNING, SecurityLabel.UNKNOWN, "oracle.jdbc.pool.OraclePooledConnection", "close", "Closing physical connection: " + String.valueOf(this.physicalConn) + " hit exception: " + ea.getMessage(), null, ea);
                }
                this.physicalConn = null;
            }
            if (this.closeCallback != null) {
                this.closeCallback.afterClose(this.privateData);
            }
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            if (this.physicalConn == null) {
                this.sqlException = new SQLException("Physical Connection doesn't exist");
                this.callListener(102);
                throw (SQLException)DatabaseError.createSqlException(8).fillInStackTrace();
            }
            try {
                if (this.logicalHandle != null) {
                    this.logicalHandle.closeInternal(false);
                }
                OracleConnection pconn = this.replayConn != null ? this.replayConn : this.physicalConn;
                this.logicalHandle = (OracleConnection)pconn.getLogicalConnection(this, this.autoCommit);
                String propVal = OraclePooledConnection.getSystemProperty(NO_IMPLICIT_BEGIN_REQUEST_PROPERTY, "false");
                if (propVal.equalsIgnoreCase("false") && !pconn.isDRCPEnabled()) {
                    pconn.beginRequest();
                }
            }
            catch (SQLException se) {
                this.sqlException = se;
                this.callListener(102);
                throw (SQLException)DatabaseError.createSqlException(8, "OraclePooledConnection.getConnection() - SQLException Ocurred:" + se.getMessage()).fillInStackTrace();
            }
            OracleConnection oracleConnection = this.logicalHandle;
            return oracleConnection;
        }
    }

    private static String getSystemProperty(String str, String defaultValue) {
        if (str != null) {
            final String fstr = str;
            final String fdefaultValue = defaultValue;
            final String[] rets = new String[]{defaultValue};
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    rets[0] = System.getProperty(fstr, fdefaultValue);
                    return null;
                }
            });
            return rets[0];
        }
        return defaultValue;
    }

    @Override
    public Connection getLogicalHandle() throws SQLException {
        return this.logicalHandle;
    }

    public Connection getPhysicalHandle() throws SQLException {
        return this.replayConn != null ? this.replayConn : this.physicalConn;
    }

    @Override
    @Deprecated
    public void setLastAccessedTime(long lastAccessedTime) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public long getLastAccessedTime() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void registerImplicitCacheConnectionEventListener(ConnectionEventListener cel) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void registerCloseCallback(OracleCloseCallback occ, Object privData) {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.closeCallback = occ;
            this.privateData = privData;
        }
    }

    @Override
    public void removeConnectionEventListener(ConnectionEventListener cel) {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            if (this.eventListeners == null) {
                this.sqlException = new SQLException("Listener Hashtable Null");
            } else {
                this.eventListeners.remove(cel);
            }
        }
    }

    public void logicalClose() {
        this.logicalClose(true);
    }

    public void logicalClose(boolean isUsable) {
        this.callListener(isUsable ? 101 : 102);
    }

    private void callListener(int callcode) {
        this.debug(Level.FINER, SecurityLabel.UNKNOWN, "oracle.jdbc.pool.OraclePooledConnection", "callListener", "(callCode = {0}): eventListeners = {1}", (String)null, (Throwable)null, (Object)callcode, (Object)this.eventListeners);
        if (this.eventListeners == null) {
            return;
        }
        Enumeration listeners = this.eventListeners.keys();
        ConnectionEvent ce = new ConnectionEvent(this, this.sqlException);
        while (listeners.hasMoreElements()) {
            ConnectionEventListener listKey = (ConnectionEventListener)listeners.nextElement();
            ConnectionEventListener cev = (ConnectionEventListener)this.eventListeners.get(listKey);
            if (callcode == 101) {
                cev.connectionClosed(ce);
                continue;
            }
            if (callcode != 102) continue;
            cev.connectionErrorOccurred(ce);
        }
    }

    public void setStmtCacheSize(int size) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.setStmtCacheSize(size, false);
        }
    }

    public void setStmtCacheSize(int size, boolean clearMetaData) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            if (size < 0) {
                throw (SQLException)DatabaseError.createSqlException(68).fillInStackTrace();
            }
            if (this.physicalConn != null) {
                this.physicalConn.setStmtCacheSize(size, clearMetaData);
            }
        }
    }

    public int getStmtCacheSize() {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            if (this.physicalConn != null) {
                int n = this.physicalConn.getStmtCacheSize();
                return n;
            }
            int n = 0;
            return n;
        }
    }

    @Override
    public void setStatementCacheSize(int size) throws SQLException {
        if (this.physicalConn != null) {
            this.physicalConn.setStatementCacheSize(size);
        }
    }

    @Override
    public int getStatementCacheSize() throws SQLException {
        this.debug(Level.FINER, SecurityLabel.UNKNOWN, "oracle.jdbc.pool.OraclePooledConnection", "getStatementCacheSize", "physicalConn= " + String.valueOf(this.physicalConn), null, null);
        if (this.physicalConn != null) {
            return this.physicalConn.getStatementCacheSize();
        }
        return 0;
    }

    @Override
    public void setImplicitCachingEnabled(boolean cache) throws SQLException {
        this.debug(Level.FINER, SecurityLabel.UNKNOWN, "oracle.jdbc.pool.OraclePooledConnection", "setImplicitCachingEnabled", "cache= " + cache + ", physicalConn=" + String.valueOf(this.physicalConn), null, null);
        if (this.physicalConn != null) {
            this.physicalConn.setImplicitCachingEnabled(cache);
        }
    }

    @Override
    public boolean getImplicitCachingEnabled() throws SQLException {
        this.debug(Level.FINER, SecurityLabel.UNKNOWN, "oracle.jdbc.pool.OraclePooledConnection", "getImplicitCachingEnabled", "physicalConn = " + String.valueOf(this.physicalConn), null, null);
        if (this.physicalConn != null) {
            return this.physicalConn.getImplicitCachingEnabled();
        }
        return false;
    }

    @Override
    public void setExplicitCachingEnabled(boolean cache) throws SQLException {
        this.debug(Level.FINER, SecurityLabel.UNKNOWN, "oracle.jdbc.pool.OraclePooledConnection", "setExplicitCachingEnabled", "cache= " + cache + ", physicalConn = " + String.valueOf(this.physicalConn), null, null);
        if (this.physicalConn != null) {
            this.physicalConn.setExplicitCachingEnabled(cache);
        }
    }

    @Override
    public boolean getExplicitCachingEnabled() throws SQLException {
        this.debug(Level.FINER, SecurityLabel.UNKNOWN, "oracle.jdbc.pool.OraclePooledConnection", "getExplicitCachingEnabled", "physicalConn = " + String.valueOf(this.physicalConn), null, null);
        if (this.physicalConn != null) {
            return this.physicalConn.getExplicitCachingEnabled();
        }
        return false;
    }

    @Override
    public void purgeImplicitCache() throws SQLException {
        this.debug(Level.FINER, SecurityLabel.UNKNOWN, "oracle.jdbc.pool.OraclePooledConnection", "purgeImplicitCache()", "physicalConn = " + String.valueOf(this.physicalConn), null, null);
        if (this.physicalConn != null) {
            this.physicalConn.purgeImplicitCache();
        }
    }

    @Override
    public void purgeExplicitCache() throws SQLException {
        this.debug(Level.FINER, SecurityLabel.UNKNOWN, "oracle.jdbc.pool.OraclePooledConnection", "purgeExplicitCache()", "physicalConn = " + String.valueOf(this.physicalConn), null, null);
        if (this.physicalConn != null) {
            this.physicalConn.purgeExplicitCache();
        }
    }

    @Override
    public PreparedStatement getStatementWithKey(String key) throws SQLException {
        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, "oracle.jdbc.pool.OraclePooledConnection", "getStatementWithKey", "physicalConn = " + String.valueOf(this.physicalConn), null, null);
        if (this.physicalConn != null) {
            return this.physicalConn.getStatementWithKey(key);
        }
        return null;
    }

    @Override
    public CallableStatement getCallWithKey(String key) throws SQLException {
        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, "oracle.jdbc.pool.OraclePooledConnection", "getCallWithKey", "physicalConn = " + String.valueOf(this.physicalConn), null, null);
        if (this.physicalConn != null) {
            return this.physicalConn.getCallWithKey(key);
        }
        return null;
    }

    public boolean isStatementCacheInitialized() {
        if (this.physicalConn != null) {
            return this.physicalConn.isStatementCacheInitialized();
        }
        return false;
    }

    public final void setProperties(Hashtable prop) {
        this.connectionProperty = prop;
    }

    @Override
    public XAResource getXAResource() throws SQLException {
        throw (SQLException)DatabaseError.createUnsupportedFeatureSqlException().fillInStackTrace();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        try {
            this.physicalConn.getPropertyForPooledConnection(this);
            if (this.eventListeners != null) {
                this.connectionProperty.put(event_listener_string, this.eventListeners);
            }
            if (this.sqlException != null) {
                this.connectionProperty.put(sql_exception_string, this.sqlException);
            }
            this.connectionProperty.put(pool_auto_commit_string, "" + this.autoCommit);
            if (this.closeCallback != null) {
                this.connectionProperty.put(close_callback_string, this.closeCallback);
            }
            if (this.privateData != null) {
                this.connectionProperty.put(private_data, this.privateData);
            }
            out.writeObject(this.connectionProperty);
            this.physicalConn.close();
        }
        catch (SQLException ea) {
            this.debug(Level.WARNING, SecurityLabel.UNKNOWN, "oracle.jdbc.pool.OraclePooledConnection", "writeObject", "writing object hit exception: " + ea.getMessage(), null, ea);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException, SQLException {
        in.defaultReadObject();
        this.connectionProperty = (Hashtable)in.readObject();
        try {
            Properties prop = (Properties)this.connectionProperty.get(connection_properties_string);
            String l_url = prop.getProperty(url_string);
            this.oracleDriver = new OracleDriver();
            Connection conn = this.oracleDriver.connect(l_url, prop);
            this.initialize(conn);
            this.eventListeners = (Hashtable)this.connectionProperty.get(event_listener_string);
            this.sqlException = (SQLException)this.connectionProperty.get(sql_exception_string);
            this.autoCommit = ((String)this.connectionProperty.get(pool_auto_commit_string)).equals("true");
            this.closeCallback = (OracleCloseCallback)this.connectionProperty.get(close_callback_string);
            this.privateData = this.connectionProperty.get(private_data);
            Map l_map = (Map)this.connectionProperty.get(object_type_map);
            if (l_map != null) {
                ((OracleConnection)conn).setTypeMap(l_map);
            }
            String l_tmp = prop.getProperty(transaction_isolation);
            conn.setTransactionIsolation(Integer.parseInt(l_tmp));
            l_tmp = prop.getProperty(statement_cache_size);
            int l_statementCacheSize = Integer.parseInt(l_tmp);
            if (l_statementCacheSize != -1) {
                this.setStatementCacheSize(l_statementCacheSize);
                l_tmp = prop.getProperty(implicit_caching_enabled);
                if (l_tmp != null && l_tmp.equalsIgnoreCase("true")) {
                    this.setImplicitCachingEnabled(true);
                } else {
                    this.setImplicitCachingEnabled(false);
                }
                l_tmp = prop.getProperty(explicit_caching_enabled);
                if (l_tmp != null && l_tmp.equalsIgnoreCase("true")) {
                    this.setExplicitCachingEnabled(true);
                } else {
                    this.setExplicitCachingEnabled(false);
                }
            }
            this.physicalConn.setAutoCommit(((String)prop.get(connect_auto_commit_string)).equals("true"));
        }
        catch (Exception ea) {
            this.debug(Level.WARNING, SecurityLabel.UNKNOWN, "oracle.jdbc.pool.OraclePooledConnection", "readObject", "reading object hit exception: " + ea.getMessage(), null, ea);
        }
    }

    @Override
    public void addStatementEventListener(StatementEventListener listener) {
    }

    @Override
    public void removeStatementEventListener(StatementEventListener listener) {
    }

    public void setConnection(OracleConnection rconn) throws SQLException {
        this.physicalConn = rconn;
    }

    @Override
    public boolean setShardingKeyIfValid(OracleShardingKey shardingKey, OracleShardingKey superShardingKey, int timeout) throws SQLException {
        return this.physicalConn.setShardingKeyIfValid(shardingKey, superShardingKey, timeout);
    }

    @Override
    public void setShardingKey(OracleShardingKey shardingKey, OracleShardingKey superShardingKey) throws SQLException {
        this.physicalConn.setShardingKey(shardingKey, superShardingKey);
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }

    @Override
    public final Monitor.CloseableLock getMonitorLock() {
        return this.monitorLock;
    }

    @Override
    public Diagnosable getDiagnosable() {
        return CommonDiagnosable.getInstance();
    }
}

