/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.url.parser;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import oracle.net.url.common.MalformedURLException;

public class ExtendedPropertiesParser {
    private static final char EXT_DOUBLE_QT = '\"';
    private static final char EXT_KEY_VAL_SEP = '=';
    private static final char EXT_PARAM_SEP = '&';
    private static final char EXT_ESCAPE_CHAR = '\\';
    private char[] urlChars;
    private int currentPosition = 0;
    private final Map<String, String> properties;

    ExtendedPropertiesParser(char[] urlChars, int offset) throws MalformedURLException {
        this.urlChars = urlChars;
        this.currentPosition = offset;
        this.properties = new LinkedHashMap<String, String>();
        this.parse();
    }

    Properties getProperties() {
        Properties props = new Properties();
        props.putAll(this.properties);
        return props;
    }

    private void parse() throws MalformedURLException {
        while (!this.isEOS()) {
            String key = this.parseLiteral('=');
            if (key == null || key.isEmpty()) {
                this.throwParseFailure("Connection property name cannot be empty");
            }
            this.ignoreWhitespaces();
            if (this.urlChars[this.currentPosition] != '=') {
                this.throwParseFailure("Invalid character. Expected '='");
            }
            ++this.currentPosition;
            String value = this.parseLiteral('&');
            if (value == null || value.isEmpty()) {
                this.throwParseFailure("Connection property value cannot be empty");
            }
            this.properties.put(key, value);
            this.ignoreWhitespaces();
            if (!this.isEOS() && this.urlChars[this.currentPosition] != '&') {
                this.throwParseFailure("Invalid character. Expected '&'");
            }
            ++this.currentPosition;
        }
    }

    private String parseLiteral(char delimiter) throws MalformedURLException {
        this.ignoreWhitespaces();
        if (!this.isEOS() && this.urlChars[this.currentPosition] == '\"') {
            return this.parseQuotedLiteral();
        }
        StringBuilder tknBuilder = new StringBuilder();
        while (!this.isEOS() && this.urlChars[this.currentPosition] != delimiter) {
            if (Character.isWhitespace(this.urlChars[this.currentPosition])) {
                if (this.isTrailingWhitespace(delimiter)) {
                    this.ignoreWhitespaces();
                    break;
                }
                this.throwParseFailure("Invalid whitespace");
            } else {
                tknBuilder.append(this.urlChars[this.currentPosition]);
            }
            ++this.currentPosition;
        }
        return tknBuilder.toString();
    }

    private String parseQuotedLiteral() throws MalformedURLException {
        int startIndex = this.currentPosition++;
        StringBuilder tknBuilder = new StringBuilder();
        while (!this.isEOS()) {
            char curChar = this.urlChars[this.currentPosition];
            if (curChar == '\\') {
                if (this.currentPosition + 1 < this.urlChars.length && ExtendedPropertiesParser.isValidEscapeChar(this.urlChars[this.currentPosition + 1])) {
                    tknBuilder.append(this.urlChars[++this.currentPosition]);
                    continue;
                }
                this.throwParseFailure("Invalid escape sequence");
                continue;
            }
            if (curChar == '\"') {
                ++this.currentPosition;
                return tknBuilder.toString();
            }
            tknBuilder.append(this.urlChars[this.currentPosition++]);
        }
        throw new MalformedURLException("Quoted literal at " + startIndex + " is not closed.");
    }

    private boolean ignoreWhitespaces() {
        while (!this.isEOS() && Character.isWhitespace(this.urlChars[this.currentPosition])) {
            ++this.currentPosition;
        }
        return this.currentPosition >= this.urlChars.length;
    }

    private boolean isTrailingWhitespace(char delimiter) {
        char ch = this.peekNextNonWhitespaceChar();
        return ch == delimiter || ch == '\u0000';
    }

    private char peekNextNonWhitespaceChar() {
        for (int pos = this.currentPosition + 1; pos < this.urlChars.length; ++pos) {
            if (Character.isWhitespace(this.urlChars[pos])) {
                continue;
            }
            return this.urlChars[pos];
        }
        return '\u0000';
    }

    private boolean isEOS() {
        return this.currentPosition >= this.urlChars.length;
    }

    private static boolean isValidEscapeChar(char currentChar) {
        return currentChar == '\\' || currentChar == '\"';
    }

    private void throwParseFailure(String msg) throws MalformedURLException {
        throw new MalformedURLException(msg, new String(this.urlChars), this.currentPosition);
    }
}

