/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import oracle.jdbc.diagnostics.CommonDiagnosable;
import oracle.jdbc.diagnostics.Diagnosable;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.GeneratedPhysicalConnection;
import oracle.jdbc.driver.ShardingConnectionUtil;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.logging.annotations.Blind;
import oracle.ucp.admin.UniversalConnectionPoolManagerImpl;
import oracle.ucp.jdbc.PoolDataSource;
import oracle.ucp.jdbc.PoolDataSourceFactory;

public class AbstractTrueCacheConnectionPools
implements Diagnosable {
    private static final String CLASS_NAME = AbstractTrueCacheConnectionPools.class.getName();
    private static final Monitor trueCacheConnectionUtilLock = Monitor.newInstance();
    static ConcurrentHashMap<Integer, TrueCachePoolDataSourceEntry> trueCacheDatabasePoolDataSourceMap = new ConcurrentHashMap();
    static Diagnosable diagnosable = CommonDiagnosable.getInstance();

    static TrueCachePoolDataSourceEntry getTrueCacheDatabasePoolDataSource(String url, @Blind(value=GeneratedPhysicalConnection.ConnectionPropertiesBlinder.class) Properties info, boolean readOnly, String tcServiceName) throws SQLException {
        try (Monitor.CloseableLock lock = trueCacheConnectionUtilLock.acquireCloseableLock();){
            int key = AbstractTrueCacheConnectionPools.calculateConnectionInfoHashKey(url, info, readOnly);
            TrueCachePoolDataSourceEntry trueCacheDatabasePoolDatasourceEntry = null;
            if (trueCacheDatabasePoolDataSourceMap.containsKey(key)) {
                TrueCachePoolDataSourceEntry trueCachePoolDataSourceEntry = trueCacheDatabasePoolDatasourceEntry = trueCacheDatabasePoolDataSourceMap.get(key);
                return trueCachePoolDataSourceEntry;
            }
            PoolDataSource trueCacheDatabasePoolDatasource = PoolDataSourceFactory.getPoolDataSource();
            trueCacheDatabasePoolDatasource.setURL(url);
            trueCacheDatabasePoolDatasource.setConnectionFactoryClassName("oracle.jdbc.datasource.impl.OracleDataSource");
            if (readOnly) {
                trueCacheDatabasePoolDatasource.setConnectionProperty("oracle.jdbc.targetServiceName", tcServiceName);
            }
            trueCacheDatabasePoolDatasource.setConnectionProperties(info);
            trueCacheDatabasePoolDatasource.setConnectionWaitTimeout(0);
            trueCacheDatabasePoolDatasource.setCreateConnectionInBorrowThread(true);
            trueCacheDatabasePoolDatasource.setValidateConnectionOnBorrow(true);
            trueCacheDatabasePoolDatasource.setInactiveConnectionTimeout(120);
            trueCacheDatabasePoolDatasource.setMaxPoolSize(Integer.MAX_VALUE);
            trueCacheDatabasePoolDatasourceEntry = new TrueCachePoolDataSourceEntry(trueCacheDatabasePoolDatasource);
            trueCacheDatabasePoolDataSourceMap.put(key, trueCacheDatabasePoolDatasourceEntry);
            diagnosable.trace(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "getTrueCacheDatabasePoolDataSource", "create new pool datasource with key={0}, readOnly={1}", null, null, key, readOnly);
            TrueCachePoolDataSourceEntry trueCachePoolDataSourceEntry = trueCacheDatabasePoolDatasourceEntry;
            return trueCachePoolDataSourceEntry;
        }
    }

    static PoolDataSource getDataSource(String url, Properties info, boolean readOnly, String tcServiceName) throws SQLException {
        return AbstractTrueCacheConnectionPools.getTrueCacheDatabasePoolDataSource(url, info, readOnly, tcServiceName).getPds();
    }

    static int calculateConnectionInfoHashKey(String url, @Blind(value=GeneratedPhysicalConnection.ConnectionPropertiesBlinder.class) Properties info, boolean readOnly) {
        String dmsName = info.getProperty("DMSName");
        info.remove("DMSName");
        int hashKey = ShardingConnectionUtil.calculateConnectionInfoHashKey(url, info);
        if (readOnly) {
            hashKey = 31 * hashKey + Boolean.hashCode(readOnly);
        }
        if (dmsName != null) {
            info.put("DMSName", dmsName);
        }
        return hashKey;
    }

    static void destroyAllPools() {
        try {
            for (TrueCachePoolDataSourceEntry entry : trueCacheDatabasePoolDataSourceMap.values()) {
                UniversalConnectionPoolManagerImpl.getUniversalConnectionPoolManager().destroyConnectionPool(entry.getPds().getConnectionPoolName());
            }
            trueCacheDatabasePoolDataSourceMap.clear();
        }
        catch (Exception e) {
            diagnosable.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "destroyAllPools", "True cache connection pools could not be destroyed due to error: {0}", (String)null, (Throwable)null, (Object)e.getMessage());
        }
    }

    protected static final class TrueCachePoolDataSourceEntry {
        private PoolDataSource pds;

        public TrueCachePoolDataSourceEntry(PoolDataSource pds) {
            this.pds = pds;
        }

        public PoolDataSource getPds() {
            return this.pds;
        }
    }
}

