/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import javax.sql.PooledConnection;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.UniversalPooledConnection;
import oracle.ucp.UniversalPooledConnectionStatus;
import oracle.ucp.common.FailoverableUniversalPooledConnectionBase;
import oracle.ucp.jdbc.JDBCConnectionPool;

public class JDBCUniversalPooledConnection
extends FailoverableUniversalPooledConnectionBase {
    static final String CLASS_NAME = JDBCUniversalPooledConnection.class.getName();
    private final JDBCConnectionPool m_cp;
    protected final ReentrantLock lock = new ReentrantLock();
    private int m_maxStatements = 0;

    public JDBCUniversalPooledConnection(JDBCConnectionPool connectionPool, Object connection, ConnectionRetrievalInfo connectionRetrievalInfo, boolean connectionFailoverEnabled) throws UniversalConnectionPoolException {
        super(connectionPool, connection, connectionRetrievalInfo, connectionFailoverEnabled);
        this.m_cp = connectionPool;
    }

    @Override
    public void validate(UniversalPooledConnection.ValidationType validationType, int timeout) {
        boolean isValid;
        String strSql = this.m_cp.getSQLForValidateConnection();
        boolean bl = isValid = strSql != null && !strSql.equals("") ? this.validateConnectionWithSQL(strSql, timeout) : this.validateConnectionWithoutSQL(timeout);
        if (!isValid) {
            this.setStatus(UniversalPooledConnectionStatus.STATUS_BAD, "connection is invalid");
        }
    }

    @Override
    public CompletionStage<Void> validateAsync(UniversalPooledConnection.ValidationType validationType, int timeout, Executor executor) {
        throw new NoSuchMethodError("asynchronous validation is not supported in generic JDBC");
    }

    private boolean validateConnectionWithSQL(String sqlExpression, int timeout) {
        boolean bl;
        block10: {
            Connection conn;
            try {
                conn = this.getSQLConnection(this.getPhysicalConnection());
            }
            catch (SQLException e) {
                this.trace(Level.WARNING, CLASS_NAME, "validateConnectionWithSQL", "", null, e, new Object[0]);
                return false;
            }
            Statement stmt = conn.createStatement();
            try {
                stmt.setQueryTimeout(timeout);
                stmt.execute(sqlExpression);
                bl = true;
                if (stmt == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    this.trace(Level.WARNING, CLASS_NAME, "validateConnectionWithSQL", "", null, e, new Object[0]);
                    return false;
                }
            }
            stmt.close();
        }
        return bl;
    }

    private boolean validateConnectionWithoutSQL(int timeout) {
        try {
            return this.getSQLConnection(this.getPhysicalConnection()).isValid(timeout);
        }
        catch (SQLException e) {
            this.trace(Level.WARNING, CLASS_NAME, "validateConnectionWithoutSQL", "", null, e, new Object[0]);
            return false;
        }
    }

    public Connection getSQLConnection(Object physicalConnection) throws SQLException {
        if (physicalConnection instanceof Connection) {
            return (Connection)physicalConnection;
        }
        if (physicalConnection instanceof PooledConnection) {
            return ((PooledConnection)physicalConnection).getConnection();
        }
        return null;
    }

    @Override
    protected void initFailoverParameters() throws UniversalConnectionPoolException {
    }

    public int getMaxStatements() {
        return this.m_maxStatements;
    }

    public void setMaxStatements(int maxStatements) throws SQLException {
        this.lock.lock();
        try {
            this.m_maxStatements = maxStatements;
        }
        finally {
            this.lock.unlock();
        }
    }
}

