/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.SQLException;
import oracle.sql.CharacterSet;

abstract class CharacterSetFactory {
    public static final short DEFAULT_CHARSET = -1;
    public static final short ASCII_CHARSET = 1;
    public static final short ISO_LATIN_1_CHARSET = 31;
    public static final short UNICODE_1_CHARSET = 870;
    public static final short UNICODE_2_CHARSET = 871;

    CharacterSetFactory() {
    }

    public abstract CharacterSet make(int var1);

    public static void main(String[] argv) {
        CharacterSet unicode = CharacterSet.make(871);
        int[] charSets = new int[]{1, 31, 870, 871};
        for (int idX = 0; idX < charSets.length; ++idX) {
            CharacterSet cs = CharacterSet.make(charSets[idX]);
            Object longString = "longlonglonglong";
            longString = (String)longString + (String)longString + (String)longString + (String)longString;
            longString = (String)longString + (String)longString + (String)longString + (String)longString;
            longString = (String)longString + (String)longString + (String)longString + (String)longString;
            longString = (String)longString + (String)longString + (String)longString + (String)longString;
            String[] testStrings = new String[]{"abc", "ab?c", "XYZ", longString};
            for (int idS = 0; idS < testStrings.length; ++idS) {
                boolean ok;
                block12: {
                    String testString = testStrings[idS];
                    Object shortString = testString;
                    if (testString.length() > 16) {
                        shortString = ((String)shortString).substring(0, 16) + "...";
                    }
                    System.out.println("testing " + String.valueOf(cs) + " against <" + (String)shortString + ">");
                    ok = true;
                    try {
                        byte[] utf;
                        byte[] rawWithoutReplacement;
                        String withoutReplacement;
                        byte[] raw = cs.convertWithReplacement(testString);
                        String withReplacement = cs.toStringWithReplacement(raw, 0, raw.length);
                        raw = cs.convert(withReplacement);
                        String roundTrip = cs.toString(raw, 0, raw.length);
                        if (!withReplacement.equals(roundTrip)) {
                            System.out.println("    FAILED roundTrip " + roundTrip);
                            ok = false;
                        }
                        if (cs.isLossyFrom(unicode)) {
                            try {
                                byte[] bad = cs.convert(testString);
                                String badString = cs.toString(bad, 0, bad.length);
                                if (!badString.equals(roundTrip)) {
                                    System.out.println("    FAILED roundtrip, no throw");
                                }
                                break block12;
                            }
                            catch (SQLException bad) {}
                            break block12;
                        }
                        if (!roundTrip.equals(testString)) {
                            System.out.println("    FAILED roundTrip " + roundTrip);
                            ok = false;
                        }
                        if (!(withoutReplacement = cs.toString(rawWithoutReplacement = cs.convert(unicode, utf = unicode.convert(testString), 0, utf.length), 0, rawWithoutReplacement.length)).equals(testString)) {
                            System.out.println("    FAILED withoutReplacement " + withoutReplacement);
                            ok = false;
                        }
                    }
                    catch (Exception ex) {
                        System.out.println("    FAILED with Exception " + String.valueOf(ex));
                    }
                }
                if (!ok) continue;
                System.out.println("    PASSED " + (cs.isLossyFrom(unicode) ? "LOSSY" : ""));
            }
        }
    }
}

