/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.pool;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Level;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleDriver;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.Blind;
import oracle.jdbc.logging.annotations.PropertiesBlinder;
import oracle.jdbc.oci.OracleOCIConnection;
import oracle.jdbc.pool.OracleDataSource;

public class OracleOCIConnectionPool
extends OracleDataSource {
    private static final String CLASS_NAME = OracleOCIConnectionPool.class.getName();
    public OracleOCIConnection m_connection_pool;
    public static final String IS_CONNECTION_POOLING = "is_connection_pooling";
    private int m_conn_min_limit = 0;
    private int m_conn_max_limit = 0;
    private int m_conn_increment = 0;
    private int m_conn_active_size = 0;
    private int m_conn_pool_size = 0;
    private int m_conn_timeout = 0;
    private String m_conn_nowait = "false";
    private int m_is_transactions_distributed = 0;
    public static final String CONNPOOL_OBJECT = "connpool_object";
    public static final String CONNPOOL_LOGON_MODE = "connection_pool";
    public static final String CONNECTION_POOL = "connection_pool";
    public static final String CONNPOOL_CONNECTION = "connpool_connection";
    public static final String CONNPOOL_PROXY_CONNECTION = "connpool_proxy_connection";
    public static final String CONNPOOL_ALIASED_CONNECTION = "connpool_alias_connection";
    public static final String PROXY_USER_NAME = "proxy_user_name";
    public static final String PROXY_DISTINGUISHED_NAME = "proxy_distinguished_name";
    public static final String PROXY_CERTIFICATE = "proxy_certificate";
    public static final String PROXY_ROLES = "proxy_roles";
    public static final String PROXY_NUM_ROLES = "proxy_num_roles";
    public static final String PROXY_PASSWORD = "proxy_password";
    public static final String PROXYTYPE = "proxytype";
    public static final String PROXYTYPE_USER_NAME = "proxytype_user_name";
    public static final String PROXYTYPE_DISTINGUISHED_NAME = "proxytype_distinguished_name";
    public static final String PROXYTYPE_CERTIFICATE = "proxytype_certificate";
    public static final String CONNECTION_ID = "connection_id";
    public static final String CONNPOOL_MIN_LIMIT = "connpool_min_limit";
    public static final String CONNPOOL_MAX_LIMIT = "connpool_max_limit";
    public static final String CONNPOOL_INCREMENT = "connpool_increment";
    public static final String CONNPOOL_ACTIVE_SIZE = "connpool_active_size";
    public static final String CONNPOOL_POOL_SIZE = "connpool_pool_size";
    public static final String CONNPOOL_TIMEOUT = "connpool_timeout";
    public static final String CONNPOOL_NOWAIT = "connpool_nowait";
    public static final String CONNPOOL_IS_POOLCREATED = "connpool_is_poolcreated";
    public static final String TRANSACTIONS_DISTRIBUTED = "transactions_distributed";
    private Hashtable m_lconnections = null;
    private Lifecycle lifecycle = Lifecycle.NEW;
    private OracleDriver m_oracleDriver = new OracleDriver();
    protected int m_stmtCacheSize = 0;
    protected boolean m_stmtClearMetaData = false;

    private void ensureOpen() throws SQLException {
        if (this.lifecycle == Lifecycle.NEW) {
            this.createConnectionPool(null);
        }
        if (this.lifecycle != Lifecycle.OPEN) {
            throw (SQLException)DatabaseError.createSqlException(8).fillInStackTrace();
        }
    }

    public OracleOCIConnectionPool(String us, @Blind String p, String url, @Blind(value=PropertiesBlinder.class) Properties info) throws SQLException {
        this();
        this.setURL(url);
        this.setUser(us);
        this.setPassword(p);
        this.createConnectionPool(info);
    }

    public OracleOCIConnectionPool(String us, @Blind String p, String url) throws SQLException {
        this();
        this.setURL(url);
        this.setUser(us);
        this.setPassword(p);
        this.createConnectionPool(null);
    }

    public OracleOCIConnectionPool() throws SQLException {
        this.isOracleDataSource = false;
        this.m_lconnections = new Hashtable(10);
        this.setDriverType("oci8");
    }

    @Override
    public Connection getConnection() throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            Connection conn;
            this.ensureOpen();
            Connection connection = conn = this.getConnection(this.user, this.password != null ? this.password.get() : null);
            return connection;
        }
    }

    @Override
    public Connection getConnection(String us, @Blind String p) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.ensureOpen();
            Properties info = this.connectionProperties != null ? new Properties(this.connectionProperties) : new Properties();
            info.put(IS_CONNECTION_POOLING, "true");
            if (us != null) {
                info.put("user", us);
            }
            if (p != null) {
                info.put("password", p);
            }
            info.put("connection_pool", CONNPOOL_CONNECTION);
            info.put(CONNPOOL_OBJECT, this.m_connection_pool);
            OracleOCIConnection conn = (OracleOCIConnection)this.m_oracleDriver.connect(this.url, info);
            if (conn == null) {
                throw (SQLException)DatabaseError.createSqlException(67).fillInStackTrace();
            }
            conn.setStmtCacheSize(this.m_stmtCacheSize, this.m_stmtClearMetaData);
            this.m_lconnections.put(conn, conn);
            conn.setConnectionPool(this);
            OracleOCIConnection oracleOCIConnection = conn;
            return oracleOCIConnection;
        }
    }

    @Override
    public Reference getReference() throws NamingException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            Reference ref = new Reference(this.getClass().getName(), "oracle.jdbc.pool.OracleDataSourceFactory", null);
            super.addRefProperties(ref);
            ref.add(new StringRefAddr(CONNPOOL_MIN_LIMIT, String.valueOf(this.m_conn_min_limit)));
            ref.add(new StringRefAddr(CONNPOOL_MAX_LIMIT, String.valueOf(this.m_conn_max_limit)));
            ref.add(new StringRefAddr(CONNPOOL_INCREMENT, String.valueOf(this.m_conn_increment)));
            ref.add(new StringRefAddr(CONNPOOL_ACTIVE_SIZE, String.valueOf(this.m_conn_active_size)));
            ref.add(new StringRefAddr(CONNPOOL_POOL_SIZE, String.valueOf(this.m_conn_pool_size)));
            ref.add(new StringRefAddr(CONNPOOL_TIMEOUT, String.valueOf(this.m_conn_timeout)));
            ref.add(new StringRefAddr(CONNPOOL_NOWAIT, this.m_conn_nowait));
            ref.add(new StringRefAddr(CONNPOOL_IS_POOLCREATED, String.valueOf(this.isPoolCreated())));
            ref.add(new StringRefAddr(TRANSACTIONS_DISTRIBUTED, String.valueOf(this.isDistributedTransEnabled())));
            Reference reference = ref;
            return reference;
        }
    }

    public OracleConnection getProxyConnection(String proxytype, @Blind(value=PropertiesBlinder.class) Properties prop) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.ensureOpen();
            if (PROXYTYPE_USER_NAME.equals(proxytype)) {
                prop.put("user", prop.getProperty(PROXY_USER_NAME));
            } else if (PROXYTYPE_DISTINGUISHED_NAME.equals(proxytype)) {
                prop.put("user", prop.getProperty(PROXY_DISTINGUISHED_NAME));
            } else if (PROXYTYPE_CERTIFICATE.equals(proxytype)) {
                prop.put("user", String.valueOf(prop.getProperty(PROXY_USER_NAME)));
            } else {
                throw (SQLException)DatabaseError.createSqlException(107, "null properties").fillInStackTrace();
            }
            prop.put(IS_CONNECTION_POOLING, "true");
            prop.put(PROXYTYPE, proxytype);
            String[] proxyRoles = (String[])prop.get(PROXY_ROLES);
            if (proxyRoles != null) {
                prop.put(PROXY_NUM_ROLES, new Integer(proxyRoles.length));
            } else {
                prop.put(PROXY_NUM_ROLES, new Integer(0));
            }
            prop.put("connection_pool", CONNPOOL_PROXY_CONNECTION);
            prop.put(CONNPOOL_OBJECT, this.m_connection_pool);
            OracleOCIConnection conn = (OracleOCIConnection)this.m_oracleDriver.connect(this.url, prop);
            if (conn == null) {
                throw (SQLException)DatabaseError.createSqlException(67).fillInStackTrace();
            }
            conn.setStmtCacheSize(this.m_stmtCacheSize, this.m_stmtClearMetaData);
            this.m_lconnections.put(conn, conn);
            conn.setConnectionPool(this);
            OracleOCIConnection oracleOCIConnection = conn;
            return oracleOCIConnection;
        }
    }

    public OracleConnection getAliasedConnection(byte[] conId) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "getAliasedConnection", "(conId[]=", String.valueOf(conId) + ")", null, null);
            this.ensureOpen();
            Properties info = new Properties();
            info.put(IS_CONNECTION_POOLING, "true");
            info.put(CONNECTION_ID, conId);
            info.put("connection_pool", CONNPOOL_ALIASED_CONNECTION);
            info.put(CONNPOOL_OBJECT, this.m_connection_pool);
            OracleOCIConnection conn = (OracleOCIConnection)this.m_oracleDriver.connect(this.url, info);
            if (conn == null) {
                throw (SQLException)DatabaseError.createSqlException(67).fillInStackTrace();
            }
            conn.setStmtCacheSize(this.m_stmtCacheSize, this.m_stmtClearMetaData);
            this.m_lconnections.put(conn, conn);
            conn.setConnectionPool(this);
            OracleOCIConnection oracleOCIConnection = conn;
            return oracleOCIConnection;
        }
    }

    public void close() throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            if (this.lifecycle != Lifecycle.OPEN) {
                return;
            }
            this.lifecycle = Lifecycle.CLOSING;
            Iterator iter = this.m_lconnections.values().iterator();
            while (iter.hasNext()) {
                OracleOCIConnection conn = (OracleOCIConnection)iter.next();
                if (conn != null && conn != this.m_connection_pool) {
                    conn.close();
                }
                iter.remove();
            }
            this.m_connection_pool.close();
            this.lifecycle = Lifecycle.CLOSED;
        }
    }

    public void setPoolConfig(@Blind(value=PropertiesBlinder.class) Properties prop) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            if (prop == null) {
                throw (SQLException)DatabaseError.createSqlException(106, "null properties").fillInStackTrace();
            }
            if (!this.isPoolCreated()) {
                this.createConnectionPool(prop);
            } else {
                Properties info = new Properties();
                this.checkPoolConfig(prop, info);
                int[] p = new int[6];
                OracleOCIConnectionPool.readPoolConfig(info, p);
                this.m_connection_pool.setConnectionPoolInfo(p[0], p[1], p[2], p[3], p[4], p[5]);
            }
            this.storePoolProperties();
        }
    }

    public static void readPoolConfig(int minLimit, int maxLimit, int increment, int timeout, boolean nowait, boolean transactionsDistributed, int[] p) {
        for (int i = 0; i < 6; ++i) {
            p[i] = 0;
        }
        p[0] = minLimit;
        p[1] = maxLimit;
        p[2] = increment;
        p[3] = timeout;
        if (nowait) {
            p[4] = 1;
        }
        if (transactionsDistributed) {
            p[5] = 1;
        }
    }

    public static void readPoolConfig(@Blind(value=PropertiesBlinder.class) Properties info, int[] p) {
        String value = info.getProperty(CONNPOOL_MIN_LIMIT);
        if (value != null) {
            p[0] = Integer.parseInt(value);
        }
        if ((value = info.getProperty(CONNPOOL_MAX_LIMIT)) != null) {
            p[1] = Integer.parseInt(value);
        }
        if ((value = info.getProperty(CONNPOOL_INCREMENT)) != null) {
            p[2] = Integer.parseInt(value);
        }
        if ((value = info.getProperty(CONNPOOL_TIMEOUT)) != null) {
            p[3] = Integer.parseInt(value);
        }
        if ((value = info.getProperty(CONNPOOL_NOWAIT)) != null && value.equalsIgnoreCase("true")) {
            p[4] = 1;
        }
        if ((value = info.getProperty(TRANSACTIONS_DISTRIBUTED)) != null && value.equalsIgnoreCase("true")) {
            p[5] = 1;
        }
    }

    private void checkPoolConfig(@Blind(value=PropertiesBlinder.class) Properties pc_in, @Blind(value=PropertiesBlinder.class) Properties pc_out) throws SQLException {
        String dist_txn = (String)pc_in.get(TRANSACTIONS_DISTRIBUTED);
        String conn_nowait = (String)pc_in.get(CONNPOOL_NOWAIT);
        if (dist_txn != null && !dist_txn.equalsIgnoreCase("true") || conn_nowait != null && !conn_nowait.equalsIgnoreCase("true") || pc_in.get(CONNPOOL_MIN_LIMIT) == null || pc_in.get(CONNPOOL_MAX_LIMIT) == null || pc_in.get(CONNPOOL_INCREMENT) == null || Integer.decode((String)pc_in.get(CONNPOOL_MIN_LIMIT)) < 0 || Integer.decode((String)pc_in.get(CONNPOOL_MAX_LIMIT)) < 0 || Integer.decode((String)pc_in.get(CONNPOOL_INCREMENT)) < 0) {
            throw (SQLException)DatabaseError.createSqlException(106, "").fillInStackTrace();
        }
        Enumeration<?> e = pc_in.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = pc_in.getProperty(key);
            if (TRANSACTIONS_DISTRIBUTED.equals(key) || CONNPOOL_NOWAIT.equals(key)) {
                pc_out.put(key, "true");
                continue;
            }
            pc_out.put(key, value);
        }
    }

    private void storePoolProperties() throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            Properties info = this.getPoolConfig();
            this.m_conn_min_limit = Integer.decode(info.getProperty(CONNPOOL_MIN_LIMIT));
            this.m_conn_max_limit = Integer.decode(info.getProperty(CONNPOOL_MAX_LIMIT));
            this.m_conn_increment = Integer.decode(info.getProperty(CONNPOOL_INCREMENT));
            this.m_conn_active_size = Integer.decode(info.getProperty(CONNPOOL_ACTIVE_SIZE));
            this.m_conn_pool_size = Integer.decode(info.getProperty(CONNPOOL_POOL_SIZE));
            this.m_conn_timeout = Integer.decode(info.getProperty(CONNPOOL_TIMEOUT));
            this.m_conn_nowait = info.getProperty(CONNPOOL_NOWAIT);
        }
    }

    @Blind(value=PropertiesBlinder.class)
    public Properties getPoolConfig() throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.ensureOpen();
            Properties info = this.m_connection_pool.getConnectionPoolInfo();
            info.put(CONNPOOL_IS_POOLCREATED, String.valueOf(this.isPoolCreated()));
            Properties properties = info;
            return properties;
        }
    }

    public int getActiveSize() throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            int res;
            this.ensureOpen();
            Properties info = this.m_connection_pool.getConnectionPoolInfo();
            String value = info.getProperty(CONNPOOL_ACTIVE_SIZE);
            int n = res = Integer.decode(value).intValue();
            return n;
        }
    }

    public int getPoolSize() throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            int res;
            this.ensureOpen();
            Properties info = this.m_connection_pool.getConnectionPoolInfo();
            String value = info.getProperty(CONNPOOL_POOL_SIZE);
            int n = res = Integer.decode(value).intValue();
            return n;
        }
    }

    public int getTimeout() throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            int res;
            this.ensureOpen();
            Properties info = this.m_connection_pool.getConnectionPoolInfo();
            String value = info.getProperty(CONNPOOL_TIMEOUT);
            int n = res = Integer.decode(value).intValue();
            return n;
        }
    }

    public String getNoWait() throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.ensureOpen();
            Properties info = this.m_connection_pool.getConnectionPoolInfo();
            String string = info.getProperty(CONNPOOL_NOWAIT);
            return string;
        }
    }

    public int getMinLimit() throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            int res;
            this.ensureOpen();
            Properties info = this.m_connection_pool.getConnectionPoolInfo();
            String value = info.getProperty(CONNPOOL_MIN_LIMIT);
            int n = res = Integer.decode(value).intValue();
            return n;
        }
    }

    public int getMaxLimit() throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            int res;
            this.ensureOpen();
            Properties info = this.m_connection_pool.getConnectionPoolInfo();
            String value = info.getProperty(CONNPOOL_MAX_LIMIT);
            int n = res = Integer.decode(value).intValue();
            return n;
        }
    }

    public int getConnectionIncrement() throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            int res;
            this.ensureOpen();
            Properties info = this.m_connection_pool.getConnectionPoolInfo();
            String value = info.getProperty(CONNPOOL_INCREMENT);
            int n = res = Integer.decode(value).intValue();
            return n;
        }
    }

    public boolean isDistributedTransEnabled() {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            if (this.m_is_transactions_distributed == 1) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    private void createConnectionPool(@Blind(value=PropertiesBlinder.class) Properties poolConfig) throws SQLException {
        if (this.lifecycle != Lifecycle.NEW) {
            return;
        }
        Properties info = new Properties();
        if (poolConfig != null) {
            this.checkPoolConfig(poolConfig, info);
        }
        info.put(IS_CONNECTION_POOLING, "true");
        if (this.user != null) {
            info.put("user", this.user);
        }
        if (this.password != null) {
            info.put("password", this.password.get());
        }
        info.put("connection_pool", "connection_pool");
        if (this.getURL() == null) {
            this.makeURL();
        }
        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "createConnectionPool", "-  User:" + this.user + "URL:" + this.getURL(), null, null);
        this.m_connection_pool = (OracleOCIConnection)this.m_oracleDriver.connect(this.url, info);
        if (this.m_connection_pool == null) {
            throw (SQLException)DatabaseError.createSqlException(67).fillInStackTrace();
        }
        this.m_connection_pool.setConnectionPool(this);
        this.m_lconnections.put(this.m_connection_pool, this.m_connection_pool);
        this.lifecycle = Lifecycle.OPEN;
        this.storePoolProperties();
        if (poolConfig != null && "true".equalsIgnoreCase(poolConfig.getProperty(TRANSACTIONS_DISTRIBUTED))) {
            this.m_is_transactions_distributed = 1;
        }
    }

    public boolean isPoolCreated() {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            boolean bl = this.lifecycle == Lifecycle.OPEN;
            return bl;
        }
    }

    public void connectionClosed(OracleOCIConnection conn) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            if (this.lifecycle != Lifecycle.CLOSING && this.m_lconnections.remove(conn) == null) {
                throw (SQLException)DatabaseError.createSqlException(1, "internal OracleOCIConnectionPool error").fillInStackTrace();
            }
        }
    }

    public void setStmtCacheSize(int size) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.setStmtCacheSize(size, false);
        }
    }

    public void setStmtCacheSize(int size, boolean clearMetaData) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            if (size < 0) {
                throw (SQLException)DatabaseError.createSqlException(68).fillInStackTrace();
            }
            this.m_stmtCacheSize = size;
            this.m_stmtClearMetaData = clearMetaData;
        }
    }

    public int getStmtCacheSize() {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            int n = this.m_stmtCacheSize;
            return n;
        }
    }

    public boolean isStmtCacheEnabled() {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            if (this.m_stmtCacheSize > 0) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    @Override
    protected OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }

    private static enum Lifecycle {
        NEW,
        OPEN,
        CLOSING,
        CLOSED;

    }
}

