/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Struct;
import java.util.Map;
import oracle.jdbc.OracleData;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.Representation;
import oracle.jdbc.driver.TypeAccessor;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;
import oracle.sql.Datum;
import oracle.sql.JAVA_STRUCT;
import oracle.sql.OPAQUE;
import oracle.sql.ORAData;
import oracle.sql.OpaqueDescriptor;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;
import oracle.sql.TypeDescriptor;
import oracle.xdb.XMLType;

class NamedTypeAccessor
extends TypeAccessor {
    static final int MAXLENGTH = -1;

    NamedTypeAccessor(OracleStatement stmt, String typeName, short form, int external_type, boolean isOutBind, boolean isStoredInBindData) throws SQLException {
        super(Representation.NAMED_TYPE, stmt, -1, isStoredInBindData);
        this.init(stmt, 109, 109, form, isOutBind);
        this.initForDataAccess(external_type, 0, typeName);
    }

    NamedTypeAccessor(OracleStatement stmt, int max_len, boolean nullable, int flags, int precision, int scale, long contflag, int total_elems, short form, String typeName) throws SQLException {
        super(Representation.NAMED_TYPE, stmt, -1, false);
        this.init(stmt, 109, 109, form, false);
        this.initForDescribe(109, max_len, nullable, flags, precision, scale, contflag, total_elems, form, typeName);
        this.initForDataAccess(0, max_len, typeName);
    }

    NamedTypeAccessor(OracleStatement stmt, int max_len, boolean nullable, int flags, int precision, int scale, long contflag, int total_elems, short form, String typeName, OracleType otype) throws SQLException {
        super(Representation.NAMED_TYPE, stmt, -1, false);
        this.init(stmt, 109, 109, form, false);
        this.describeOtype = otype;
        this.initForDescribe(109, max_len, nullable, flags, precision, scale, contflag, total_elems, form, typeName);
        this.internalOtype = otype;
        this.initForDataAccess(0, max_len, typeName);
    }

    @Override
    final OracleType otypeFromName(String typeName) throws SQLException {
        if (!this.outBind) {
            return TypeDescriptor.getTypeDescriptor(typeName, this.statement.connection).getPickler();
        }
        if (this.externalType == 2003) {
            return ArrayDescriptor.createDescriptor(typeName, (Connection)this.statement.connection).getOracleTypeCOLLECTION();
        }
        if (this.externalType == 2007 || this.externalType == 2009) {
            return OpaqueDescriptor.createDescriptor(typeName, (Connection)this.statement.connection).getPickler();
        }
        return StructDescriptor.createDescriptor(typeName, (Connection)this.statement.connection).getOracleTypeADT();
    }

    @Override
    void initForDataAccess(int external_type, int max_len, String typeName) throws SQLException {
        super.initForDataAccess(external_type, max_len, typeName);
        this.byteLength = this.statement.connection.namedTypeAccessorByteLen;
    }

    @Override
    Object getObject(int currentRow) throws SQLException {
        return this.getObject(currentRow, this.statement.connection.getTypeMap());
    }

    @Override
    Object getObject(int currentRow, Map<String, Class<?>> map) throws SQLException {
        if (this.isNull(currentRow)) {
            return null;
        }
        if (this.externalType == 0) {
            Datum named_obj = this.getOracleObject(currentRow);
            if (named_obj == null) {
                return null;
            }
            if (named_obj instanceof STRUCT) {
                return ((STRUCT)named_obj).toJdbc((Map)map);
            }
            if (named_obj instanceof OPAQUE) {
                Object obj = ((OPAQUE)named_obj).toJdbc(map);
                return obj;
            }
            if (named_obj instanceof ARRAY) {
                return ((ARRAY)named_obj).toJdbc(map);
            }
            return named_obj.toJdbc();
        }
        switch (this.externalType) {
            case 2008: {
                map = null;
            }
            case 2000: 
            case 2002: 
            case 2003: 
            case 2007: {
                Datum named_obj = this.getOracleObject(currentRow);
                if (named_obj == null) {
                    return null;
                }
                if (named_obj instanceof STRUCT) {
                    return ((STRUCT)named_obj).toJdbc((Map)map);
                }
                if (named_obj instanceof ARRAY) {
                    return ((ARRAY)named_obj).toJdbc(map);
                }
                return named_obj.toJdbc();
            }
            case 2009: {
                Datum named_obj = this.getOracleObject(currentRow);
                if (named_obj == null) {
                    return null;
                }
                try {
                    return (SQLXML)((Object)named_obj);
                }
                catch (ClassCastException classCastException) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
                }
            }
        }
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
    }

    @Override
    Datum getOracleObject(int currentRow) throws SQLException {
        if (this.isNull(currentRow)) {
            return null;
        }
        byte[] data = this.pickledBytes(currentRow);
        if (data == null || data.length == 0) {
            return null;
        }
        PhysicalConnection conn = this.statement.connection;
        OracleTypeADT otype = (OracleTypeADT)this.internalOtype;
        TypeDescriptor desc = TypeDescriptor.getTypeDescriptor(this.internalTypeName == null ? otype.getFullName() : this.internalTypeName, conn, data, 0L);
        switch (desc.getTypeCode()) {
            case 2003: {
                return new ARRAY((ArrayDescriptor)desc, data, conn);
            }
            case 2002: {
                return new STRUCT((StructDescriptor)desc, data, conn);
            }
            case 2009: {
                return XMLFactory.createXML(new OPAQUE((OpaqueDescriptor)desc, data, conn));
            }
            case 2007: {
                return new OPAQUE((OpaqueDescriptor)desc, data, conn);
            }
            case 2008: {
                return new JAVA_STRUCT((StructDescriptor)desc, data, conn);
            }
        }
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1).fillInStackTrace();
    }

    @Override
    OracleData getOracleData(int currentRow) throws SQLException {
        try {
            return (OracleData)this.getObject(currentRow);
        }
        catch (ClassCastException ex) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
        }
    }

    @Override
    ORAData getORAData(int currentRow) throws SQLException {
        try {
            return (ORAData)this.getObject(currentRow);
        }
        catch (ClassCastException ex) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
        }
    }

    @Override
    ARRAY getARRAY(int currentRow) throws SQLException {
        try {
            return (ARRAY)this.getOracleObject(currentRow);
        }
        catch (ClassCastException ex) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
        }
    }

    @Override
    STRUCT getSTRUCT(int currentRow) throws SQLException {
        try {
            return (STRUCT)this.getOracleObject(currentRow);
        }
        catch (ClassCastException ex) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
        }
    }

    @Override
    Struct getStruct(int currentRow) throws SQLException {
        try {
            return (Struct)((Object)this.getOracleObject(currentRow));
        }
        catch (ClassCastException ex) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
        }
    }

    @Override
    OPAQUE getOPAQUE(int currentRow) throws SQLException {
        try {
            return (OPAQUE)this.getOracleObject(currentRow);
        }
        catch (ClassCastException ex) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
        }
    }

    @Override
    SQLXML getSQLXML(int currentRow) throws SQLException {
        try {
            OPAQUE opaque = (OPAQUE)this.getOracleObject(currentRow);
            if (opaque == null) {
                return null;
            }
            return (SQLXML)((Object)opaque);
        }
        catch (ClassCastException ex) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
        }
    }

    @Override
    String getString(int currentRow) throws SQLException {
        Datum datum = this.getOracleObject(currentRow);
        if (datum instanceof XMLType) {
            return ((XMLType)datum).getString();
        }
        return null;
    }

    private static class XMLFactory {
        private XMLFactory() {
        }

        static Datum createXML(OPAQUE opq) throws SQLException {
            return XMLType.createXML((OPAQUE)opq);
        }
    }
}

