/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.oauth;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.sql.SQLException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.function.Supplier;
import oracle.jdbc.AccessToken;
import oracle.jdbc.driver.oauth.AccessTokenCache;
import oracle.jdbc.driver.oauth.OpaqueAccessToken;
import oracle.jdbc.internal.OpaquePrivateKey;
import oracle.jdbc.internal.OpaqueString;
import oracle.jdbc.logging.annotations.Blind;
import oracle.sql.json.OracleJsonException;
import oracle.sql.json.OracleJsonFactory;
import oracle.sql.json.OracleJsonNumber;
import oracle.sql.json.OracleJsonValue;

public final class JsonWebToken
extends OpaqueAccessToken {
    private JsonWebToken(@Blind OpaqueString token, OffsetDateTime expiration, @Blind OpaquePrivateKey opaquePrivateKey) {
        super(token, expiration, opaquePrivateKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Blind
    static JsonWebToken fromOciFile(Path path) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException, SQLException {
        char[] tokenChars = JsonWebToken.readTokenFile(path.resolve("token"));
        try {
            OffsetDateTime expiration = JsonWebToken.parseExp(tokenChars);
            JsonWebToken jsonWebToken = new JsonWebToken(OpaqueString.newOpaqueString(tokenChars), expiration, OpaquePrivateKey.fromPemFile(path.resolve("oci_db_key.pem")));
            return jsonWebToken;
        }
        finally {
            Arrays.fill(tokenChars, '\u0000');
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Blind
    static JsonWebToken fromFile(Path path) throws IOException {
        char[] tokenChars = Files.isDirectory(path, new LinkOption[0]) ? JsonWebToken.readTokenFile(path.resolve("token")) : JsonWebToken.readTokenFile(path);
        try {
            OffsetDateTime expiration = JsonWebToken.parseExp(tokenChars);
            JsonWebToken jsonWebToken = new JsonWebToken(OpaqueString.newOpaqueString(tokenChars), expiration, null);
            return jsonWebToken;
        }
        finally {
            Arrays.fill(tokenChars, '\u0000');
        }
    }

    @Blind
    public static JsonWebToken createProofOfPossessionToken(@Blind char[] token, @Blind PrivateKey privateKey) throws NoSuchAlgorithmException, InvalidKeySpecException {
        return new JsonWebToken(OpaqueString.newOpaqueString((char[])token.clone()), JsonWebToken.parseExp(token), OpaquePrivateKey.fromPrivateKey(privateKey));
    }

    @Blind
    public static JsonWebToken createBearerToken(@Blind char[] token) {
        return new JsonWebToken(OpaqueString.newOpaqueString((char[])token.clone()), JsonWebToken.parseExp(token), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Blind
    private static char[] readTokenFile(Path path) throws IOException {
        JsonWebToken.requireValidSize(Files.size(path));
        byte[] fileBytes = Files.readAllBytes(path);
        try {
            Object object;
            Charset charset = JsonWebToken.detectCharacterSet(fileBytes);
            CharBuffer fileBuffer = charset.decode(ByteBuffer.wrap(fileBytes));
            ArrayList<CharBuffer> lines = new ArrayList<CharBuffer>(1);
            int length = JsonWebToken.splitLines(fileBuffer, lines);
            try {
                char[] tokenChars = new char[length];
                CharBuffer tokenBuffer = CharBuffer.wrap(tokenChars);
                for (CharBuffer line : lines) {
                    tokenBuffer.put(line);
                }
                object = tokenChars;
                fileBuffer.clear();
            }
            catch (Throwable throwable) {
                fileBuffer.clear();
                fileBuffer.put(new char[fileBuffer.remaining()]);
                throw throwable;
            }
            fileBuffer.put(new char[fileBuffer.remaining()]);
            return object;
        }
        finally {
            Arrays.fill(fileBytes, (byte)0);
        }
    }

    private static int splitLines(CharBuffer charBuffer, List<CharBuffer> lines) {
        int start;
        for (start = charBuffer.position(); start < charBuffer.limit() && JsonWebToken.isNewLine(charBuffer, start); ++start) {
        }
        int length = 0;
        for (int i = start; i < charBuffer.limit(); ++i) {
            if (!JsonWebToken.isNewLine(charBuffer, i)) continue;
            CharBuffer line = CharBuffer.wrap(charBuffer, start, i);
            length += line.remaining();
            lines.add(line);
            start = i + 1;
        }
        if (start < charBuffer.limit()) {
            CharBuffer line = CharBuffer.wrap(charBuffer, start, charBuffer.limit());
            length += line.remaining();
            lines.add(line);
        }
        return length;
    }

    private static boolean isNewLine(CharBuffer charBuffer, int position) {
        char charValue = charBuffer.get(position);
        return charValue == '\r' || charValue == '\n';
    }

    private static Charset detectCharacterSet(@Blind byte[] bytes) {
        int i;
        if (bytes == null || bytes.length == 0) {
            return StandardCharsets.UTF_8;
        }
        if (bytes.length % 2 != 0) {
            return StandardCharsets.UTF_8;
        }
        if (bytes[0] == -2 && bytes[1] == -1) {
            return StandardCharsets.UTF_16BE;
        }
        if (bytes[0] == -1 && bytes[1] == -2) {
            return StandardCharsets.UTF_16LE;
        }
        for (i = 0; i < bytes.length && bytes[i] == 0; i += 2) {
            if (i != bytes.length - 2) continue;
            return StandardCharsets.UTF_16BE;
        }
        for (i = 0; i < bytes.length && bytes[i + 1] == 0; i += 2) {
            if (i != bytes.length - 2) continue;
            return StandardCharsets.UTF_16LE;
        }
        return StandardCharsets.UTF_8;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static OffsetDateTime parseExp(@Blind char[] jwt) {
        OracleJsonValue exp;
        int end;
        int start;
        JsonWebToken.requireValidSize(jwt.length);
        for (start = 0; start < jwt.length && jwt[start] != '.'; ++start) {
        }
        if (++start > jwt.length) {
            throw new IllegalArgumentException("Failed to identify payload of JWT");
        }
        for (end = start; end < jwt.length && jwt[end] != '.'; ++end) {
        }
        if (end == jwt.length) {
            throw new IllegalArgumentException("Failed to identify payload of JWT");
        }
        byte[] base64Payload = new byte[end - start];
        try {
            for (int i = 0; i < base64Payload.length; ++i) {
                base64Payload[i] = (byte)jwt[i + start];
            }
            byte[] jsonPayload = Base64.getMimeDecoder().decode(base64Payload);
            try (ByteArrayInputStream inputStream = new ByteArrayInputStream(jsonPayload);){
                exp = (OracleJsonValue)new OracleJsonFactory().createJsonTextValue(inputStream).asJsonObject().get("exp");
            }
            catch (ClassCastException | OracleJsonException exception) {
                throw new IllegalArgumentException("JWT payload is not JSON", exception);
            }
            catch (IOException ioException) {
                throw new IllegalArgumentException("Failed to read JWT payload", ioException);
            }
            finally {
                Arrays.fill(jsonPayload, (byte)0);
            }
        }
        finally {
            Arrays.fill(base64Payload, (byte)0);
        }
        if (exp == null) {
            throw new IllegalArgumentException("JWT is missing an exp claim");
        }
        if (!(exp instanceof OracleJsonNumber)) {
            throw new IllegalArgumentException("JWT has an exp claim with a non-numeric value of type: " + (Object)((Object)exp.getOracleJsonType()));
        }
        return Instant.ofEpochSecond(exp.asJsonNumber().longValue()).atOffset(ZoneOffset.UTC);
    }

    private static void requireValidSize(long size) {
        if (size > 16000L) {
            throw new IllegalArgumentException("JWT of size " + size + " bytes exceeds the maximum accepted length of 16kb");
        }
    }

    public static AccessTokenCache<JsonWebToken> createCache(Supplier<? extends AccessToken> tokenSupplier) {
        return AccessTokenCache.create(() -> {
            AccessToken accessToken = (AccessToken)tokenSupplier.get();
            if (!(accessToken instanceof JsonWebToken)) {
                throw new IllegalArgumentException("token supplier has output an unrecognized object type: " + accessToken.getClass());
            }
            return (JsonWebToken)accessToken;
        });
    }
}

