/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import oracle.jdbc.driver.NTFDCNConnection;
import oracle.jdbc.driver.NTFJMSConnection;
import oracle.jdbc.driver.NTFJMSRegistration;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.internal.OpaqueString;

public class NTFJMSConnectionGroup
implements Monitor {
    ArrayList<NTFJMSConnection> jmsListenerConnections = new ArrayList();
    private HashMap<Long, Integer> jmsRegIdToJDBCRegId = new HashMap();
    private int noOfRegistrationsInThisGroup = 0;
    String uniqueIdentifier;
    private final Monitor.CloseableLock monitorLock = Monitor.newDefaultLock();
    static final int DEFAULT_MAX_NTF_CONNECTIONS = 16;
    private static int MAX_NTF_CONNECTIONS = 0;
    private static final Monitor MAX_NTF_CONNECTIONS_MONITOR = Monitor.newInstance();
    private int aliveConnections = 0;
    private HashMap<Long, NTFJMSRegistration> jmsRegIdToNtfReg = new HashMap();

    public static void setMaxNtfConnection(int maxConn) {
        try (Monitor.CloseableLock lock = MAX_NTF_CONNECTIONS_MONITOR.acquireCloseableLock();){
            if (maxConn <= 0) {
                maxConn = 16;
            }
            if (MAX_NTF_CONNECTIONS > 0) {
                return;
            }
            MAX_NTF_CONNECTIONS = maxConn;
        }
    }

    public static int getMaxNtfConnection() {
        if (MAX_NTF_CONNECTIONS == 0) {
            return 16;
        }
        return MAX_NTF_CONNECTIONS;
    }

    NTFJMSConnectionGroup(String uniqueIdentifier) {
        this.uniqueIdentifier = uniqueIdentifier;
    }

    void checkNCloseActiveRegistrations() {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            if (this.noOfRegistrationsInThisGroup == 0) {
                if (!this.jmsListenerConnections.isEmpty()) {
                    for (NTFJMSConnection listenerConnection : this.jmsListenerConnections) {
                        if (listenerConnection == null) continue;
                        listenerConnection.prepareForClose();
                        --this.aliveConnections;
                    }
                    for (NTFJMSConnection listenerConnection : this.jmsListenerConnections) {
                        try {
                            listenerConnection.join();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    this.jmsListenerConnections.clear();
                }
                PhysicalConnection.ntfManager.removeJMSConnectionGroup(this.uniqueIdentifier);
            }
        }
    }

    void startJMSListenerConnection(String instanceName, String serviceName, String userName, OpaqueString password, Properties connectionProps, ArrayList<String> listenerAddresses, String jmsConnectionId, int numberOfRegistrations) {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            assert (jmsConnectionId != null) : "jmsConnectionId is null";
            String connClass = "notify" + jmsConnectionId;
            NTFJMSConnection jmsListenerConnection = new NTFJMSConnection(jmsConnectionId, listenerAddresses, instanceName, serviceName, userName, password, connectionProps, connClass, numberOfRegistrations);
            this.jmsListenerConnections.add(jmsListenerConnection);
            jmsListenerConnection.setDaemon(true);
            jmsListenerConnection.setName(NTFDCNConnection.class.getName() + " thread");
            jmsListenerConnection.start();
            ++this.aliveConnections;
        }
    }

    void decrementNumberOfRegistrations() {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            --this.noOfRegistrationsInThisGroup;
        }
    }

    NTFJMSConnection getNTFJMSConnection(int numberOfNewRegistrations) {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.noOfRegistrationsInThisGroup += numberOfNewRegistrations;
            if (this.noOfRegistrationsInThisGroup > NTFJMSConnectionGroup.getMaxNtfConnection()) {
                int minimumRegistrations = this.noOfRegistrationsInThisGroup;
                NTFJMSConnection connectionWithMinimumRegistrations = this.jmsListenerConnections.get(0);
                for (NTFJMSConnection listenerConnection : this.jmsListenerConnections) {
                    int numberOfRegistrationsInConnection = listenerConnection.getNumberOfRegistrations();
                    if (numberOfRegistrationsInConnection >= minimumRegistrations) continue;
                    connectionWithMinimumRegistrations = listenerConnection;
                    minimumRegistrations = numberOfRegistrationsInConnection;
                }
                connectionWithMinimumRegistrations.incrementNumberOfRegistrations(numberOfNewRegistrations);
                NTFJMSConnection nTFJMSConnection = connectionWithMinimumRegistrations;
                return nTFJMSConnection;
            }
            NTFJMSConnection nTFJMSConnection = null;
            return nTFJMSConnection;
        }
    }

    void resetRegistrationNumbers(int nbOfRegistration, NTFJMSConnection ntfJMSConnection) {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.noOfRegistrationsInThisGroup -= nbOfRegistration;
            if (ntfJMSConnection != null) {
                ntfJMSConnection.decrementNumberOfRegistrations(nbOfRegistration);
            }
        }
    }

    void raiseException() {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            --this.aliveConnections;
            if (this.aliveConnections == 0) {
                NTFJMSRegistration ntfReg = null;
                Iterator<Long> regIdIter = this.jmsRegIdToNtfReg.keySet().iterator();
                while (regIdIter.hasNext()) {
                    ntfReg = this.jmsRegIdToNtfReg.get(regIdIter.next());
                    try {
                        ntfReg.raiseException(1);
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    void addNtfRegistrationByRegId(long jmsRegId, NTFJMSRegistration ntfReg) {
        this.jmsRegIdToNtfReg.put(jmsRegId, ntfReg);
    }

    NTFJMSRegistration getNtfRegistrationByRegId(long jmsRegId) {
        return this.jmsRegIdToNtfReg.get(jmsRegId);
    }

    NTFJMSRegistration removeNtfRegistrationByRegId(long jmsRegId) {
        return this.jmsRegIdToNtfReg.remove(jmsRegId);
    }

    void stopNTFJMSConnection(String jmsConnectionId) {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            if (jmsConnectionId == null || jmsConnectionId.length() == 0) {
                return;
            }
            for (NTFJMSConnection listenerConnection : this.jmsListenerConnections) {
                if (listenerConnection == null || !jmsConnectionId.equals(listenerConnection.getJMSConnectionId())) continue;
                listenerConnection.decrementNumberOfRegistrations(1);
                if (listenerConnection.getNumberOfRegistrations() <= 0) {
                    listenerConnection.setNeedToBeClosed(true);
                }
                break;
            }
        }
    }

    @Override
    public final Monitor.CloseableLock getMonitorLock() {
        return this.monitorLock;
    }
}

