/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.cli.urlbuilder;

import java.lang.reflect.Field;
import java.sql.DriverPropertyInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Scanner;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OracleDriverPropertyInfo;
import oracle.jdbc.driver.OracleDriver;
import oracle.jdbc.driver.cli.AbstractCommand;
import oracle.jdbc.driver.cli.CommandContext;
import oracle.jdbc.driver.cli.Option;
import oracle.jdbc.driver.cli.urlbuilder.AddressInfo;
import oracle.jdbc.driver.cli.urlbuilder.ConnectionOptionsHandler;
import oracle.jdbc.driver.cli.urlbuilder.ConnectionOptionsIntegrator;
import oracle.jdbc.driver.cli.urlbuilder.ConnectionStringBuilder;
import oracle.jdbc.driver.cli.urlbuilder.DescriptionInfo;
import oracle.jdbc.driver.cli.urlbuilder.EZConnectAddressInfo;
import oracle.jdbc.driver.cli.urlbuilder.UrlValidator;
import oracle.net.resolver.EZConnectResolver;

public class BuildUrlCommand
extends AbstractCommand {
    DriverPropertyInfo[] extractedProperties;
    Map<String, String> propertiesToKeys = this.mapPropertiesToKeys(OracleConnection.class);
    private ConnectionOptionsIntegrator optionsIntegrator = new ConnectionOptionsIntegrator();

    @Override
    public String getName() {
        return "build-url";
    }

    @Override
    public String getShortUsage() {
        return "Build a connection url";
    }

    @Override
    public String getLongUsage() {
        return "  It enters interactive mode where you are prompted question to build a connection url";
    }

    @Override
    public List<Option> getExpectedOptions() {
        Option help = new Option("help", "h", "Show help message", false, 1);
        return Arrays.asList(help);
    }

    @Override
    public void execute(CommandContext context) {
        if (context.hasOption("help")) {
            this.printCommandHelp(context.getCommandPrefix());
            return;
        }
        Scanner scanner = new Scanner(System.in);
        String urlStringType = this.promptUrlStringType(scanner);
        if (urlStringType.equalsIgnoreCase("EZConnect")) {
            this.buildEZConnect(scanner);
        } else {
            this.buildConnectDescriptor(scanner);
        }
    }

    private boolean reviewDescriptionList(Scanner scanner, String protocol, List<DescriptionInfo> descriptions, List<String> additionalProperties) {
        int i;
        System.out.println("\n=== Review Your Inputs ===");
        System.out.println("Protocol: " + protocol);
        System.out.println("Using DESCRIPTION_LIST with " + descriptions.size() + " descriptions:");
        for (i = 0; i < descriptions.size(); ++i) {
            DescriptionInfo desc = descriptions.get(i);
            System.out.println("  Description " + (i + 1) + ":");
            for (AddressInfo addr : desc.addresses) {
                System.out.println("    Address: " + addr.protocol.toUpperCase() + " " + addr.host + ":" + addr.port);
            }
            System.out.println("    " + (desc.serviceType.equals("sid") ? "SID: " : "Service Name: ") + desc.service);
            if (!desc.hasAdvancedOptions()) continue;
            System.out.println("    Advanced Connection Options: " + ConnectionOptionsHandler.formatOptionsForReview(desc.getAdvancedOptions()));
        }
        if (!additionalProperties.isEmpty()) {
            System.out.println("Additional Properties: ");
            for (i = 0; i < additionalProperties.size(); ++i) {
                System.out.println("   " + (i + 1) + ". " + additionalProperties.get(i));
            }
        }
        while (true) {
            System.out.print("\nAre these details correct? [y/n]: ");
            String confirmation = scanner.nextLine().trim();
            if (confirmation.equalsIgnoreCase("y") || confirmation.equalsIgnoreCase("n")) {
                return confirmation.equalsIgnoreCase("y");
            }
            System.out.println("Invalid input. Please enter 'y' for yes or 'n' for no.");
        }
    }

    private String promptUrlStringType(Scanner scanner) {
        while (true) {
            System.out.print("Enter url string type (ConnectDescriptor / EZConnect) [default: ConnectDescriptor]: ");
            String urlStringType = scanner.nextLine().trim();
            if (urlStringType.isEmpty()) {
                return "ConnectDescriptor";
            }
            if (urlStringType.equalsIgnoreCase("ConnectDescriptor") || urlStringType.equalsIgnoreCase("EZConnect")) {
                return urlStringType;
            }
            System.out.println("Invalid type. Please enter 'ConnectDescriptor' or 'EZConnect'.");
        }
    }

    private String promptProtocol(Scanner scanner) {
        while (true) {
            System.out.print("Enter protocol (tcp/tcps/beq) [default: tcps]: ");
            String protocol = scanner.nextLine().trim();
            if (protocol.isEmpty()) {
                return "tcps";
            }
            if (protocol.equalsIgnoreCase("tcp") || protocol.equalsIgnoreCase("tcps") || protocol.equalsIgnoreCase("beq")) {
                return protocol;
            }
            System.out.println("Invalid protocol. Please enter 'tcp', 'tcps', or 'beq'.");
        }
    }

    private boolean promptUseDescriptionList(Scanner scanner) {
        while (true) {
            System.out.print("Do you want to use multiple descriptions (DESCRIPTION_LIST)? [y/n, default: n]: ");
            String response = scanner.nextLine().trim();
            if (response.isEmpty()) {
                return false;
            }
            if (response.equalsIgnoreCase("y")) {
                return true;
            }
            if (response.equalsIgnoreCase("n")) {
                return false;
            }
            System.out.println("Invalid input. Please enter 'y' for yes or 'n' for no.");
        }
    }

    private List<DescriptionInfo> promptMultipleDescriptions(Scanner scanner) {
        ArrayList<DescriptionInfo> descriptions = new ArrayList<DescriptionInfo>();
        int descriptionCount = 1;
        while (true) {
            boolean addAnother;
            System.out.println("\n--- Description " + descriptionCount + " ---");
            List<AddressInfo> addresses = this.promptAddressesWithProtocols(scanner);
            String serviceType = this.promptServiceType(scanner);
            String service = serviceType.equals("sid") ? this.promptSid(scanner) : this.promptServiceName(scanner);
            DescriptionInfo descInfo = new DescriptionInfo(addresses, serviceType, service);
            descriptions.add(descInfo);
            while (true) {
                System.out.print("Would you like to add another description? [y/n]: ");
                String input = scanner.nextLine().trim().toLowerCase();
                if (input.isEmpty() || input.equals("n")) {
                    addAnother = false;
                    break;
                }
                if (input.equals("y")) {
                    addAnother = true;
                    break;
                }
                System.out.println("Invalid input. Please enter 'y' or 'n'.");
            }
            if (!addAnother) break;
            ++descriptionCount;
        }
        return descriptions;
    }

    static boolean promptBoolean(Scanner scanner, String message, boolean defaultValue) {
        String defaultStr = defaultValue ? "y" : "n";
        while (true) {
            System.out.print(message + " [y/n, default: " + defaultStr + "]: ");
            String response = scanner.nextLine().trim();
            if (response.isEmpty()) {
                return defaultValue;
            }
            if (response.equalsIgnoreCase("y")) {
                return true;
            }
            if (response.equalsIgnoreCase("n")) {
                return false;
            }
            System.out.println("Invalid input. Please enter 'y' for yes or 'n' for no.");
        }
    }

    private List<String> promptHostsAndPorts(Scanner scanner) {
        ArrayList<String> hostsAndPorts = new ArrayList<String>();
        String defaultHost = "localhost:1521";
        while (true) {
            System.out.printf("Enter host and port (format: hostname:port) [default: %s]: ", defaultHost);
            String hostAndPort = scanner.nextLine().trim();
            if (hostAndPort.isEmpty()) {
                hostAndPort = defaultHost;
            }
            if (!hostAndPort.matches("^[^:]+(:\\d+)?$")) {
                System.out.println("Invalid format. Please enter in the format 'hostname:port'.");
                continue;
            }
            String[] parts = hostAndPort.split(":");
            String host = parts[0];
            int port = parts.length > 1 ? Integer.parseInt(parts[1]) : 1521;
            hostsAndPorts.add(hostAndPort);
            if (hostsAndPorts.size() == 0) continue;
            System.out.print("Would you like to add another host and port? [y/n]: ");
            if (!scanner.nextLine().trim().equalsIgnoreCase("y")) break;
        }
        return hostsAndPorts;
    }

    private String promptOracleHome(Scanner scanner) {
        while (true) {
            System.out.print("Enter ORACLE_HOME (e.g., /var/lib/oracle/dbhome): ");
            String oracleHome = scanner.nextLine().trim();
            if (!oracleHome.isEmpty()) {
                return oracleHome;
            }
            System.out.println("ORACLE_HOME cannot be empty.");
        }
    }

    private String promptOracleSid(Scanner scanner) {
        while (true) {
            System.out.print("Enter ORACLE_SID: ");
            String oracleSid = scanner.nextLine().trim();
            if (!oracleSid.isEmpty()) {
                return oracleSid;
            }
            System.out.println("ORACLE_SID cannot be empty.");
        }
    }

    private String promptServiceType(Scanner scanner) {
        while (true) {
            System.out.print("Connect using Service Name or SID? [default: service]: ");
            String serviceType = scanner.nextLine().trim();
            if (serviceType.isEmpty()) {
                return "service";
            }
            if (serviceType.equalsIgnoreCase("sid") || serviceType.equalsIgnoreCase("service")) {
                return serviceType;
            }
            System.out.println("Invalid input. Please enter 'service' or 'sid'.");
        }
    }

    private String promptServiceName(Scanner scanner) {
        while (true) {
            System.out.print("Enter Service Name: ");
            String serviceName = scanner.nextLine().trim();
            if (!serviceName.isEmpty()) {
                return serviceName;
            }
            System.out.println("Service Name cannot be empty.");
        }
    }

    private String promptSid(Scanner scanner) {
        while (true) {
            System.out.print("Enter SID: ");
            String sid = scanner.nextLine().trim();
            if (!sid.isEmpty()) {
                return sid;
            }
            System.out.println("SID cannot be empty.");
        }
    }

    private List<String> promptAdditionalProperties(Scanner scanner, boolean isEzConnect) {
        ArrayList<String> propertiesList = new ArrayList<String>();
        Map<Integer, String> numberedProperties = null;
        boolean wantsProps = BuildUrlCommand.promptBoolean(scanner, "Would you like to add any additional connection properties (e.g., oracle.net.CONNECT_TIMEOUT)?", false);
        if (!wantsProps) {
            return propertiesList;
        }
        boolean isListed = BuildUrlCommand.promptBoolean(scanner, "Would you like to see a list of possible properties?", false);
        numberedProperties = isListed ? this.getPossibleProperties(true, isEzConnect) : this.getPossibleProperties(false, isEzConnect);
        while (true) {
            String propertyKey;
            if (isListed) {
                System.out.print("Enter a property number or name, or leave blank to finish (add -h after the property for documentation): ");
            } else {
                System.out.print("Enter a property name, or leave blank to finish (add -h after the property for documentation): ");
            }
            String userInput = scanner.nextLine().trim();
            if (userInput.isEmpty()) break;
            boolean isHelp = userInput.endsWith("-h");
            if (isHelp) {
                userInput = userInput.substring(0, userInput.length() - 2).trim();
            }
            if ((propertyKey = this.getPropertyKeyFromInput(userInput, numberedProperties)) == null) {
                System.out.println("Invalid input. Please enter a valid property number or name.");
                continue;
            }
            if (isHelp) {
                System.out.println(this.getPropertyDetails(propertyKey));
            }
            System.out.print(propertyKey + " = (Leave empty to skip): ");
            String propertyValue = scanner.nextLine().trim();
            if (propertyValue.isEmpty()) {
                System.out.println("Skipping property: " + propertyKey);
                continue;
            }
            Optional<String> validationMessage = UrlValidator.validateUserInput(propertyKey, propertyValue, this.getExtractedProperties());
            if (validationMessage.isPresent()) {
                System.out.println(validationMessage.get());
                continue;
            }
            BuildUrlCommand.putOrReplace(propertiesList, propertyKey, propertyValue);
        }
        return propertiesList;
    }

    private static void putOrReplace(List<String> props, String key, String value) {
        String kv = key + "=" + value;
        for (int i = 0; i < props.size(); ++i) {
            String p = props.get(i);
            int eq = p.indexOf(61);
            if (eq <= 0 || !p.substring(0, eq).equalsIgnoreCase(key)) continue;
            props.set(i, kv);
            return;
        }
        props.add(kv);
    }

    private static void mergeKeyValues(List<String> into, List<String> from) {
        for (String kv : from) {
            int eq = kv.indexOf(61);
            if (eq <= 0) continue;
            String k = kv.substring(0, eq);
            String v = kv.substring(eq + 1);
            BuildUrlCommand.putOrReplace(into, k, v);
        }
    }

    private String getPropertyKeyFromInput(String input, Map<Integer, String> numberedProperties) {
        try {
            int propertyIndex = Integer.parseInt(input);
            return numberedProperties.get(propertyIndex);
        }
        catch (NumberFormatException e) {
            for (String prop : numberedProperties.values()) {
                if (!prop.equalsIgnoreCase(input)) continue;
                return prop;
            }
            return null;
        }
    }

    private String getPropertyDetails(String property) {
        for (DriverPropertyInfo propInfo : this.getExtractedProperties()) {
            if (!propInfo.name.equals(property)) continue;
            return propInfo.description != null ? propInfo.description : "No description available.";
        }
        return "Property not found.";
    }

    public DriverPropertyInfo[] getExtractedProperties() {
        if (this.extractedProperties == null) {
            try {
                this.extractedProperties = new OracleDriver().getPropertyInfo("", null);
                this.extractedProperties = (DriverPropertyInfo[])Arrays.stream(new OracleDriver().getPropertyInfo(null, null)).filter(prop -> prop instanceof OracleDriverPropertyInfo && ((OracleDriverPropertyInfo)prop).accessMode != null && ((OracleDriverPropertyInfo)prop).accessMode % 2 == 1).filter(prop -> prop instanceof OracleDriverPropertyInfo && !((OracleDriverPropertyInfo)prop).isDeprecated).toArray(DriverPropertyInfo[]::new);
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
                this.extractedProperties = new DriverPropertyInfo[0];
            }
        }
        return this.extractedProperties;
    }

    public Map<Integer, String> getPossibleProperties(boolean withPrint, boolean isEzConnect) {
        HashMap<Integer, String> numberedProperties = new HashMap<Integer, String>();
        int index = 1;
        if (withPrint && isEzConnect) {
            System.out.println("\n=== EZConnect Related Properties ===");
        }
        Map<String, String> ezConnectPropertiesMap = EZConnectResolver.validAliases();
        if (isEzConnect) {
            for (Map.Entry<String, String> entry : ezConnectPropertiesMap.entrySet()) {
                String property = entry.getKey();
                String value = entry.getValue();
                if (withPrint) {
                    if (!value.isEmpty()) {
                        System.out.println(index + ". " + property + " (" + value + ")");
                    } else {
                        System.out.println(index + ". " + property);
                    }
                }
                numberedProperties.put(index++, property);
            }
        }
        if (withPrint) {
            System.out.println("\n=== JDBC Related Properties ===");
        }
        Arrays.sort(this.getExtractedProperties(), new Comparator<DriverPropertyInfo>(){

            @Override
            public int compare(DriverPropertyInfo o1, DriverPropertyInfo o2) {
                return o1.name.toLowerCase().compareTo(o2.name.toLowerCase());
            }
        });
        for (DriverPropertyInfo property : this.getExtractedProperties()) {
            String defaultValue;
            Object propertyLine = "";
            String term = System.getenv("TERM");
            String string = defaultValue = property.value != null ? property.value : null;
            if (term != null) {
                String url = "https://docs.oracle.com/en/database/oracle/oracle-database/23/jajdb/oracle/jdbc/OracleConnection.html#" + this.propertiesToKeys.get(property.name);
                String clickableLink = "\u001b]8;;" + url + "\u001b\\" + property.name + "\u001b]8;;\u001b\\";
                propertyLine = index + ". " + clickableLink;
            } else {
                propertyLine = index + ". " + property.name;
            }
            if (defaultValue != null) {
                propertyLine = (String)propertyLine + " (" + defaultValue + ")";
            }
            if (withPrint) {
                System.out.println((String)propertyLine);
            }
            numberedProperties.put(index++, property.name);
        }
        if (withPrint) {
            System.out.println("===========================");
        }
        return numberedProperties;
    }

    private boolean reviewInputs(Scanner scanner, String protocol, List<String> hostsAndPorts, String serviceType, String service, List<String> additionalProperties, String oracleHome, String oracleSid) {
        System.out.println("\n=== Review Your Inputs ===");
        if (protocol.equalsIgnoreCase("beq")) {
            System.out.println("1. ORACLE_HOME: " + oracleHome);
            System.out.println("2. ORACLE_SID: " + oracleSid);
        } else {
            System.out.println("1. Host(s): " + String.join((CharSequence)", ", hostsAndPorts));
            System.out.println("2. " + (serviceType.equals("sid") ? "SID: " : "Service Name: ") + service);
        }
        if (!additionalProperties.isEmpty()) {
            System.out.println("3. Additional Properties: ");
            for (int i = 0; i < additionalProperties.size(); ++i) {
                System.out.println("   " + (i + 1) + ". " + additionalProperties.get(i));
            }
        }
        while (true) {
            System.out.print("\nAre these details correct? [y/n]: ");
            String confirmation = scanner.nextLine().trim();
            if (confirmation.equalsIgnoreCase("y") || confirmation.equalsIgnoreCase("n")) {
                return confirmation.equalsIgnoreCase("y");
            }
            System.out.println("Invalid input. Please enter 'y' for yes or 'n' for no.");
        }
    }

    private int promptFieldToEdit(Scanner scanner, String protocol) {
        System.out.println("\nWhich field would you like to edit? (Enter number): ");
        if (protocol.equalsIgnoreCase("beq")) {
            System.out.println("1. ORACLE_HOME");
            System.out.println("2. ORACLE_SID");
            System.out.println("3. Additional Properties");
        } else {
            System.out.println("1. Host(s)");
            System.out.println("2. Service Name");
            System.out.println("3. Additional Properties");
        }
        System.out.print("Enter choice: ");
        try {
            return Integer.parseInt(scanner.nextLine().trim());
        }
        catch (NumberFormatException e) {
            System.out.println("Invalid input. Please enter a number corresponding to a field.");
            return -1;
        }
    }

    private Map<String, String> mapPropertiesToKeys(Class<?> clazz) {
        Field[] fields;
        HashMap<String, String> propertiesToKeys = new HashMap<String, String>();
        for (Field field : fields = clazz.getDeclaredFields()) {
            if (field.getType() != String.class || !field.getName().startsWith("CONNECTION_PROPERTY_")) continue;
            try {
                String fieldValue = (String)field.get(null);
                propertiesToKeys.put(fieldValue, field.getName());
            }
            catch (IllegalAccessException e) {
                System.err.println(e.getMessage());
            }
        }
        return propertiesToKeys;
    }

    private List<AddressInfo> promptAddressesWithProtocols(Scanner scanner) {
        ArrayList<AddressInfo> addresses = new ArrayList<AddressInfo>();
        int addressCount = 1;
        while (true) {
            System.out.println("\n--- Address " + addressCount + " ---");
            String protocol = "";
            while (true) {
                System.out.print("Enter protocol for this address (tcp/tcps) [default: tcps]: ");
                protocol = scanner.nextLine().trim();
                if (protocol.isEmpty()) {
                    protocol = "tcps";
                }
                if (protocol.equals("tcp") || protocol.equals("tcps")) break;
                System.out.println("Invalid protocol");
            }
            System.out.print("Enter host name [default: localhost]: ");
            String host = scanner.nextLine().trim();
            if (host.isEmpty()) {
                host = "localhost";
            }
            int portInt = this.promptSinglePortInt(scanner);
            String port = String.valueOf(portInt);
            AddressInfo addrInfo = new AddressInfo(protocol, host, port);
            addresses.add(addrInfo);
            System.out.print("Would you like to add another address? [y/n]: ");
            if (!scanner.nextLine().trim().equalsIgnoreCase("y")) break;
            ++addressCount;
        }
        return addresses;
    }

    private void promptAndVerifyConnection(Scanner scanner, String ezConnectString) {
        while (true) {
            System.out.print("Would you like to verify if this connection URL is accessible? [y/n]: ");
            String userResponse = scanner.nextLine().trim().toLowerCase();
            if (userResponse.equals("y")) {
                String err = UrlValidator.isOracleDB(ezConnectString);
                if (err.isEmpty()) {
                    System.out.println("The connection URL is accessible.");
                    break;
                }
                System.out.println("The connection URL is not accessible: " + err);
                break;
            }
            if (userResponse.equals("n")) {
                System.out.println("Skipping connection verification.");
                break;
            }
            System.out.println("Invalid value");
        }
    }

    private void buildEZConnect(Scanner scanner) {
        String protocol = "";
        while (true) {
            System.out.print("Enter protocol (tcp/tcps) [default: tcp]: ");
            protocol = scanner.nextLine().trim();
            if (protocol.isEmpty()) {
                protocol = "tcp";
            }
            if (protocol.equals("tcp") || protocol.equals("tcps")) break;
            System.out.println("Invalid protocol");
        }
        boolean multipleAddressLists = BuildUrlCommand.promptBoolean(scanner, "Do you want to add multiple address lists?", false);
        ArrayList<EZConnectAddressInfo> addressInfos = new ArrayList<EZConnectAddressInfo>();
        if (multipleAddressLists) {
            int listCount = 1;
            while (true) {
                String listName = "list" + listCount;
                System.out.println("\n--- Address List " + listCount + " ---");
                int addrCount = 1;
                while (true) {
                    System.out.println("Address " + addrCount + ":");
                    String host = this.promptSingleHost(scanner);
                    int port = this.promptSinglePortInt(scanner);
                    addressInfos.add(new EZConnectAddressInfo(host, port, listName));
                    System.out.print("Add another address to this list? [y/n]: ");
                    if (!scanner.nextLine().trim().equalsIgnoreCase("y")) break;
                    ++addrCount;
                }
                System.out.print("Add another address list? [y/n]: ");
                if (scanner.nextLine().trim().equalsIgnoreCase("y")) {
                    ++listCount;
                    continue;
                }
                break;
            }
        } else {
            int addrCount = 1;
            while (true) {
                if (addrCount > 1) {
                    System.out.println("Address " + addrCount + ":");
                }
                String host = this.promptSingleHost(scanner);
                int port = this.promptSinglePortInt(scanner);
                addressInfos.add(new EZConnectAddressInfo(host, port, null));
                if (addrCount == 1) {
                    System.out.print("Add another address? [y/n]: ");
                    if (!scanner.nextLine().trim().equalsIgnoreCase("y")) {
                        break;
                    }
                } else {
                    System.out.print("Add another address? [y/n]: ");
                    if (!scanner.nextLine().trim().equalsIgnoreCase("y")) break;
                }
                ++addrCount;
            }
        }
        String serviceName = this.promptServiceName(scanner);
        System.out.print("Enter instance name (optional): ");
        String instanceName = scanner.nextLine().trim();
        System.out.println("Select server mode:");
        System.out.println("1. DEDICATED");
        System.out.println("2. SHARED");
        System.out.println("3. POOLED");
        String serverMode = null;
        block22: while (true) {
            System.out.print("Enter choice (1-3) [or leave empty for database default]: ");
            String serverModeChoice = scanner.nextLine().trim();
            if (serverModeChoice.isEmpty()) break;
            switch (serverModeChoice) {
                case "1": {
                    serverMode = "dedicated";
                    break block22;
                }
                case "2": {
                    serverMode = "shared";
                    break block22;
                }
                case "3": {
                    serverMode = "pooled";
                    break block22;
                }
                default: {
                    System.out.println("Invalid input. Please enter valid value, or leave empty.");
                    break;
                }
            }
        }
        List<String> additionalProperties = this.promptAdditionalProperties(scanner, true);
        boolean confirmed = false;
        block23: while (!confirmed) {
            confirmed = this.reviewEZConnectInputs(scanner, protocol, addressInfos, serviceName, instanceName, serverMode, additionalProperties);
            if (confirmed) continue;
            System.out.println("\nWhat would you like to edit?");
            System.out.println("1. Protocol");
            System.out.println("2. Addresses");
            System.out.println("3. Service information");
            System.out.println("4. Additional properties");
            System.out.print("Enter choice: ");
            try {
                int fieldToEdit = Integer.parseInt(scanner.nextLine().trim());
                block11 : switch (fieldToEdit) {
                    case 1: {
                        while (true) {
                            System.out.print("Enter protocol (tcp/tcps) [default: tcp]: ");
                            protocol = scanner.nextLine().trim();
                            if (protocol.isEmpty()) {
                                protocol = "tcp";
                            }
                            if (protocol.equals("tcp")) continue block23;
                            if (protocol.equals("tcps")) break block11;
                            System.out.println("Invalid protocol");
                        }
                    }
                    case 2: {
                        addressInfos.clear();
                        multipleAddressLists = BuildUrlCommand.promptBoolean(scanner, "Do you want to add multiple address lists?", false);
                        break;
                    }
                    case 3: {
                        serviceName = this.promptServiceName(scanner);
                        System.out.print("Enter instance name (optional): ");
                        instanceName = scanner.nextLine().trim();
                        break;
                    }
                    case 4: {
                        List<String> updated = this.promptAdditionalProperties(scanner, true);
                        if (updated.isEmpty()) continue block23;
                        BuildUrlCommand.mergeKeyValues(additionalProperties, updated);
                        break;
                    }
                    default: {
                        System.out.println("Invalid choice. Please choose a valid field.");
                    }
                }
            }
            catch (NumberFormatException e) {
                System.out.println("Invalid input. Please enter a valid number.");
            }
        }
        String ezConnectString = ConnectionStringBuilder.generateEZConnect(protocol, addressInfos, serviceName, instanceName, serverMode, additionalProperties);
        System.out.println("Generated EZConnect String:");
        System.out.println(ezConnectString);
        this.promptAndVerifyConnection(scanner, ezConnectString);
    }

    private void buildConnectDescriptor(Scanner scanner) {
        String protocol = this.promptProtocol(scanner);
        if (protocol.equalsIgnoreCase("beq")) {
            String oracleHome = this.promptOracleHome(scanner);
            String oracleSid = this.promptOracleSid(scanner);
            List<String> additionalProperties = this.promptAdditionalProperties(scanner, false);
            boolean confirmed = false;
            block19: while (!confirmed) {
                confirmed = this.reviewInputs(scanner, protocol, null, "sid", oracleSid, additionalProperties, oracleHome, oracleSid);
                if (confirmed) continue;
                int fieldToEdit = this.promptFieldToEdit(scanner, protocol);
                switch (fieldToEdit) {
                    case 1: {
                        oracleHome = this.promptOracleHome(scanner);
                        continue block19;
                    }
                    case 2: {
                        oracleSid = this.promptOracleSid(scanner);
                        continue block19;
                    }
                    case 3: {
                        List<String> updated = this.promptAdditionalProperties(scanner, false);
                        if (updated.isEmpty()) continue block19;
                        BuildUrlCommand.mergeKeyValues(additionalProperties, updated);
                        continue block19;
                    }
                }
                System.out.println("Invalid choice. Please choose a valid field.");
            }
            String connectionString = ConnectionStringBuilder.generate(protocol, null, "sid", oracleSid, additionalProperties, null, oracleHome, oracleSid);
            System.out.println("Generated Connection String:");
            System.out.println(connectionString);
            this.promptAndVerifyConnection(scanner, connectionString);
        } else {
            boolean useDescriptionList = this.promptUseDescriptionList(scanner);
            if (useDescriptionList) {
                List<DescriptionInfo> descriptions = this.promptMultipleDescriptions(scanner);
                this.optionsIntegrator.promptAndAttachOptionsForDescriptions(scanner, descriptions);
                List<String> additionalProperties = this.promptAdditionalProperties(scanner, false);
                boolean confirmed = false;
                block20: while (!confirmed) {
                    confirmed = this.reviewDescriptionList(scanner, protocol, descriptions, additionalProperties);
                    if (confirmed) continue;
                    System.out.println("\nWhat would you like to edit?");
                    System.out.println("1. Description configurations");
                    System.out.println("2. Additional properties");
                    System.out.print("Enter choice: ");
                    try {
                        int fieldToEdit = Integer.parseInt(scanner.nextLine().trim());
                        switch (fieldToEdit) {
                            case 1: {
                                descriptions = this.promptMultipleDescriptions(scanner);
                                continue block20;
                            }
                            case 2: {
                                List<String> updated = this.promptAdditionalProperties(scanner, false);
                                if (updated.isEmpty()) continue block20;
                                BuildUrlCommand.mergeKeyValues(additionalProperties, updated);
                                continue block20;
                            }
                        }
                        System.out.println("Invalid choice. Please choose a valid field.");
                    }
                    catch (NumberFormatException e) {
                        System.out.println("Invalid input. Please enter a valid number.");
                    }
                }
                String connectionString = ConnectionStringBuilder.generateWithDescriptionList(descriptions, additionalProperties);
                System.out.println("Generated Connection String:");
                System.out.println(connectionString);
                this.promptAndVerifyConnection(scanner, connectionString);
            } else {
                List<AddressInfo> addresses = this.promptAddressesWithProtocols(scanner);
                String serviceType = this.promptServiceType(scanner);
                String service = serviceType.equals("sid") ? this.promptSid(scanner) : this.promptServiceName(scanner);
                DescriptionInfo description = new DescriptionInfo(addresses, serviceType, service);
                this.optionsIntegrator.promptAndAttachOptions(scanner, description);
                List<String> additionalProperties = this.promptAdditionalProperties(scanner, false);
                boolean confirmed = false;
                block21: while (!confirmed) {
                    confirmed = this.reviewAddressesWithProtocols(scanner, addresses, serviceType, service, additionalProperties, description.getAdvancedOptions());
                    if (confirmed) continue;
                    System.out.println("\nWhat would you like to edit?");
                    System.out.println("1. Addresses");
                    System.out.println("2. Service information");
                    System.out.println("3. Additional properties");
                    System.out.println("4. Advanced connection options");
                    System.out.print("Enter choice: ");
                    try {
                        int fieldToEdit = Integer.parseInt(scanner.nextLine().trim());
                        switch (fieldToEdit) {
                            case 1: {
                                addresses = this.promptAddressesWithProtocols(scanner);
                                description.setAddresses(addresses);
                                continue block21;
                            }
                            case 2: {
                                serviceType = this.promptServiceType(scanner);
                                service = serviceType.equals("sid") ? this.promptSid(scanner) : this.promptServiceName(scanner);
                                description.setServiceType(serviceType);
                                description.setService(service);
                                continue block21;
                            }
                            case 3: {
                                List<String> updated = this.promptAdditionalProperties(scanner, false);
                                if (updated.isEmpty()) continue block21;
                                BuildUrlCommand.mergeKeyValues(additionalProperties, updated);
                                continue block21;
                            }
                            case 4: {
                                this.optionsIntegrator.promptAndAttachOptions(scanner, description);
                                continue block21;
                            }
                        }
                        System.out.println("Invalid choice. Please choose a valid field.");
                    }
                    catch (NumberFormatException e) {
                        System.out.println("Invalid input. Please enter a valid number.");
                    }
                }
                String connectionString = ConnectionStringBuilder.generate(addresses, serviceType, service, additionalProperties, description.getAdvancedOptions(), null, null);
                System.out.println("Generated Connection String:");
                System.out.println(connectionString);
                this.promptAndVerifyConnection(scanner, connectionString);
            }
        }
    }

    private boolean reviewEZConnectInputs(Scanner scanner, String protocol, List<EZConnectAddressInfo> addressInfos, String serviceName, String instanceName, String serverMode, List<String> additionalProperties) {
        System.out.println("\n=== Review Your Inputs ===");
        System.out.println("Protocol: " + protocol);
        System.out.println("Addresses:");
        HashMap addressLists = new HashMap();
        for (EZConnectAddressInfo eZConnectAddressInfo : addressInfos) {
            if (eZConnectAddressInfo.listName != null) {
                if (!addressLists.containsKey(eZConnectAddressInfo.listName)) {
                    addressLists.put(eZConnectAddressInfo.listName, new ArrayList());
                }
                ((List)addressLists.get(eZConnectAddressInfo.listName)).add(eZConnectAddressInfo);
                continue;
            }
            System.out.println("  " + eZConnectAddressInfo.host + ":" + eZConnectAddressInfo.port);
        }
        for (Map.Entry entry : addressLists.entrySet()) {
            System.out.println("  Address List: " + (String)entry.getKey());
            for (EZConnectAddressInfo addr : (List)entry.getValue()) {
                System.out.println("    " + addr.host + ":" + addr.port);
            }
        }
        System.out.println("Service Name: " + serviceName);
        if (instanceName != null && !instanceName.isEmpty()) {
            System.out.println("Instance Name: " + instanceName);
        }
        System.out.println("Server Mode: " + (serverMode != null ? serverMode : "default"));
        if (!additionalProperties.isEmpty()) {
            System.out.println("Additional Properties: ");
            for (int i = 0; i < additionalProperties.size(); ++i) {
                System.out.println("   " + (i + 1) + ". " + additionalProperties.get(i));
            }
        }
        while (true) {
            System.out.print("\nAre these details correct? [y/n]: ");
            String confirmation = scanner.nextLine().trim();
            if (confirmation.equalsIgnoreCase("y") || confirmation.equalsIgnoreCase("n")) {
                return confirmation.equalsIgnoreCase("y");
            }
            System.out.println("Invalid input. Please enter 'y' for yes or 'n' for no.");
        }
    }

    private String promptSingleHost(Scanner scanner) {
        while (true) {
            System.out.print("Enter host name [default: localhost]: ");
            String host = scanner.nextLine().trim();
            if (host.isEmpty()) {
                return "localhost";
            }
            if (host.matches("^[^:]+$")) {
                return host;
            }
            System.out.println("Invalid format. Please enter a valid hostname without port.");
        }
    }

    private int promptSinglePortInt(Scanner scanner) {
        while (true) {
            System.out.print("Enter port [default: 1521]: ");
            String portStr = scanner.nextLine().trim();
            if (portStr.isEmpty()) {
                return 1521;
            }
            try {
                int port = Integer.parseInt(portStr);
                if (port > 0 && port <= 65535) {
                    return port;
                }
                System.out.println("Port must be between 1 and 65535.");
                continue;
            }
            catch (NumberFormatException e) {
                System.out.println("Invalid port. Please enter a valid number.");
                continue;
            }
            break;
        }
    }

    private boolean reviewAddressesWithProtocols(Scanner scanner, List<AddressInfo> addresses, String serviceType, String service, List<String> additionalProperties, Map<String, String> advancedOptions) {
        int i;
        System.out.println("\n=== Review Your Inputs ===");
        System.out.println("Addresses:");
        for (i = 0; i < addresses.size(); ++i) {
            AddressInfo addr = addresses.get(i);
            System.out.println("  Address " + (i + 1) + ":");
            System.out.println("    Protocol: " + addr.protocol);
            System.out.println("    Host: " + addr.host);
            System.out.println("    Port: " + addr.port);
        }
        System.out.println((serviceType.equals("sid") ? "SID: " : "Service Name: ") + service);
        if (advancedOptions != null && !advancedOptions.isEmpty()) {
            System.out.println("Advanced Connection Options: " + ConnectionOptionsHandler.formatOptionsForReview(advancedOptions));
        }
        if (!additionalProperties.isEmpty()) {
            System.out.println("Additional Properties: ");
            for (i = 0; i < additionalProperties.size(); ++i) {
                System.out.println("   " + (i + 1) + ". " + additionalProperties.get(i));
            }
        }
        while (true) {
            System.out.print("\nAre these details correct? [y/n]: ");
            String confirmation = scanner.nextLine().trim();
            if (confirmation.equalsIgnoreCase("y") || confirmation.equalsIgnoreCase("n")) {
                return confirmation.equalsIgnoreCase("y");
            }
            System.out.println("Invalid input. Please enter 'y' for yes or 'n' for no.");
        }
    }
}

