/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.oauth;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.function.Supplier;
import java.util.logging.Level;
import oracle.jdbc.AccessToken;
import oracle.jdbc.diagnostics.Diagnosable;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.PasswordAuthentication;
import oracle.jdbc.driver.oauth.IamDataplaneClient;
import oracle.jdbc.driver.oauth.JsonWebToken;
import oracle.jdbc.driver.resource.DriverResources;
import oracle.jdbc.driver.resource.ResourceProvider;
import oracle.jdbc.driver.resource.ResourceType;
import oracle.jdbc.driver.utils.OracleWalletUtils;
import oracle.jdbc.driver.utils.WalletLocation;
import oracle.jdbc.internal.OpaqueString;
import oracle.jdbc.logging.annotations.Blind;
import oracle.jdbc.spi.AccessTokenProvider;
import oracle.sql.json.OracleJsonObject;
import oracle.sql.json.OracleJsonString;
import oracle.sql.json.OracleJsonValue;

public final class AccessTokenBuilder {
    private Supplier<? extends AccessToken> tokenSupplier;
    private String passwordAuthentication;
    private String userName;
    private OpaqueString password;
    private boolean isWalletLocationCredentials;
    private OpaqueString accessToken;
    private String tokenAuthentication;
    private String tokenLocation;
    private String ociIamUrl;
    private Properties tlsConfig;
    private String ociConfigFile;
    private String ociProfile;
    private String ociTenancy;
    private String ociCompartment;
    private String ociDatabase;
    private String azureDatabaseApplicationIdUri;
    private String tenantId;
    private String clientId;
    private OpaqueString clientSecret;
    private String clientCertificate;
    private OpaqueString clientCertificatePassword;
    private String redirectUri;
    private WalletLocation azureCredentials;
    private DriverResources driverResources;
    private AccessToken prebuiltToken;
    private final Diagnosable diagnosable;
    private static final String CLASS_NAME = AccessTokenBuilder.class.getName();

    public AccessTokenBuilder(Diagnosable diagnosable) {
        this.diagnosable = diagnosable;
    }

    public AccessTokenBuilder tokenSupplier(Supplier<? extends AccessToken> tokenSupplier) {
        this.tokenSupplier = tokenSupplier;
        return this;
    }

    public AccessTokenBuilder accessToken(OpaqueString accessToken) {
        this.accessToken = accessToken;
        return this;
    }

    public AccessTokenBuilder passwordAuthentication(String passwordAuthentication) {
        this.passwordAuthentication = passwordAuthentication;
        return this;
    }

    public AccessTokenBuilder userName(String userName) {
        this.userName = userName;
        return this;
    }

    public AccessTokenBuilder password(OpaqueString password) {
        this.password = password;
        return this;
    }

    public AccessTokenBuilder isWalletLocationCredentials(boolean isWalletLocationCredentials) {
        this.isWalletLocationCredentials = isWalletLocationCredentials;
        return this;
    }

    public AccessTokenBuilder tokenAuthentication(String tokenAuthentication) {
        this.tokenAuthentication = tokenAuthentication;
        return this;
    }

    public AccessTokenBuilder tokenLocation(String tokenLocation) {
        this.tokenLocation = tokenLocation;
        return this;
    }

    public AccessTokenBuilder ociIamUrl(String ociIamUrl) {
        this.ociIamUrl = ociIamUrl;
        return this;
    }

    public AccessTokenBuilder tlsConfig(Properties tlsConfig) {
        this.tlsConfig = tlsConfig;
        return this;
    }

    public AccessTokenBuilder ociConfigFile(String ociConfigFile) {
        this.ociConfigFile = ociConfigFile;
        return this;
    }

    public AccessTokenBuilder ociProfile(String ociProfile) {
        this.ociProfile = ociProfile;
        return this;
    }

    public AccessTokenBuilder ociTenancy(String ociTenancy) {
        this.ociTenancy = ociTenancy;
        return this;
    }

    public AccessTokenBuilder ociCompartment(String ociCompartment) {
        this.ociCompartment = ociCompartment;
        return this;
    }

    public AccessTokenBuilder ociDatabase(String ociDatabase) {
        this.ociDatabase = ociDatabase;
        return this;
    }

    public AccessTokenBuilder azureDatabaseApplicationIdUri(String azureDatabaseApplicationIdUri) {
        this.azureDatabaseApplicationIdUri = azureDatabaseApplicationIdUri;
        return this;
    }

    public AccessTokenBuilder tenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    public AccessTokenBuilder clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    public AccessTokenBuilder clientSecret(OpaqueString clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    public AccessTokenBuilder clientCertificate(String clientCertificate) {
        this.clientCertificate = clientCertificate;
        return this;
    }

    public AccessTokenBuilder clientCertificatePassword(OpaqueString clientCertificatePassword) {
        this.clientCertificatePassword = clientCertificatePassword;
        return this;
    }

    public AccessTokenBuilder redirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
        return this;
    }

    public AccessTokenBuilder driverResources(DriverResources driverResources) {
        this.driverResources = driverResources;
        return this;
    }

    public AccessTokenBuilder azureCredentials(WalletLocation azureCredentials) {
        this.azureCredentials = azureCredentials;
        return this;
    }

    public void prebuild() throws SQLException {
        this.prebuiltToken = this.build();
    }

    @Blind
    public AccessToken build() throws SQLException {
        if (this.prebuiltToken != null) {
            AccessToken token = this.prebuiltToken;
            this.prebuiltToken = null;
            return token;
        }
        AccessToken token = this.getToken();
        this.validateAzureToken(token);
        return token;
    }

    private AccessToken getToken() throws SQLException {
        boolean isPasswordConfigured;
        boolean isUserNameConfigured = this.userName != null && !this.userName.isEmpty();
        boolean bl = isPasswordConfigured = !OpaqueString.isNull(this.password) && !this.password.isEmpty();
        if (this.isWalletLocationCredentials || !isUserNameConfigured && !isPasswordConfigured) {
            if (this.tokenSupplier != null) {
                return this.getTokenFromSupplier();
            }
            if (!OpaqueString.isNull(this.accessToken)) {
                return this.getTokenFromProperty();
            }
            if (this.tokenAuthentication != null) {
                return this.getTokenFromTokenAuthentication();
            }
            if (this.driverResources != null && this.driverResources.isProviderConfigured(ResourceType.ACCESS_TOKEN)) {
                return this.getTokenFromProvider();
            }
        }
        if (!this.isWalletLocationCredentials && isUserNameConfigured && !isPasswordConfigured && TokenAuthentication.isInteractive(this.tokenAuthentication)) {
            return this.getTokenFromTokenAuthentication();
        }
        return this.getTokenFromPasswordAuthentication();
    }

    @Blind
    private AccessToken getTokenFromSupplier() throws SQLException {
        try {
            this.diagnosable.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "getTokenFromSupplier", "Getting access token from a Supplier<AccessToken>", null, null);
            AccessToken accessToken = this.tokenSupplier.get();
            if (accessToken != null) {
                return accessToken;
            }
            throw (SQLException)DatabaseError.createSqlException(null, 1718, "A null value was output by the Supplier configured with  OracleDataSource.setTokenSupplier(Supplier)").fillInStackTrace();
        }
        catch (RuntimeException runtimeException) {
            throw (SQLException)DatabaseError.createSqlException(null, 1718, "An exception was thrown by the Supplier configured with  OracleDataSource.setTokenSupplier(Supplier).", (Throwable)runtimeException).fillInStackTrace();
        }
    }

    @Blind
    private AccessToken getTokenFromProperty() throws SQLException {
        this.diagnosable.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "getTokenFromProperty", "Getting access token configured with oracle.jdbc.accessToken ", null, null);
        char[] clearText = this.accessToken.getChars();
        try {
            AccessToken accessToken = AccessToken.createJsonWebToken(clearText);
            return accessToken;
        }
        catch (Exception exception) {
            SQLException invalidConnectionProperty = DatabaseError.formatSqlException(null, 1721, null, exception, "[OMITTED]", "oracle.jdbc.accessToken");
            throw (SQLException)DatabaseError.createSqlException(null, 25707, invalidConnectionProperty.getMessage() + ": " + exception.getMessage(), (Throwable)invalidConnectionProperty).fillInStackTrace();
        }
        finally {
            Arrays.fill(clearText, '\u0000');
        }
    }

    private AccessToken getTokenFromTokenAuthentication() throws SQLException {
        TokenAuthentication tokenAuthentication = TokenAuthentication.parseProperty(this.tokenAuthentication);
        switch (tokenAuthentication) {
            case OCI_TOKEN: 
            case OAUTH: {
                return this.getTokenFromFile(tokenAuthentication);
            }
            case OCI_API_KEY: 
            case OCI_INSTANCE_PRINCIPAL: 
            case OCI_RESOURCE_PRINCIPAL: 
            case OCI_DELEGATION_TOKEN: 
            case OCI_INTERACTIVE: 
            case OCI_DEFAULT: {
                return this.getTokenFromOciPlugin(tokenAuthentication);
            }
            case AZURE_SERVICE_PRINCIPAL: 
            case AZURE_MANAGED_IDENTITY: 
            case AZURE_DEVICE_CODE: 
            case AZURE_INTERACTIVE: 
            case AZURE_DEFAULT: {
                return this.getTokenFromAzurePlugin(tokenAuthentication);
            }
        }
        throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)tokenAuthentication));
    }

    @Blind
    private AccessToken getTokenFromFile(TokenAuthentication authenticationMethod) throws SQLException {
        Path tokenPath;
        boolean isOciToken;
        this.diagnosable.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "getTokenFromFile", "Getting access token from the file system. tokenAuthentication={0}, tokenLocation={1}", (String)null, null, (Object)this.tokenAuthentication, (Object)this.tokenLocation);
        boolean bl = isOciToken = TokenAuthentication.OCI_TOKEN == authenticationMethod;
        if (!isOciToken && TokenAuthentication.OAUTH != authenticationMethod) {
            throw (SQLException)DatabaseError.formatSqlException(null, 1721, null, null, this.tokenAuthentication, "oracle.jdbc.tokenAuthentication").fillInStackTrace();
        }
        if (this.tokenLocation != null) {
            tokenPath = Paths.get(this.tokenLocation, new String[0]);
        } else if (isOciToken) {
            String userHome = System.getProperty("user.home");
            if (userHome == null) {
                throw (SQLException)DatabaseError.createSqlException(null, "System property \"user.home\" is not set. The default token location can not be resolved", 1718).fillInStackTrace();
            }
            tokenPath = Paths.get(userHome, ".oci", "db-token");
        } else {
            throw (SQLException)DatabaseError.formatSqlException(null, 1722, "This property must be set when oracle.jdbc.tokenAuthentication=" + this.tokenAuthentication, null, "oracle.jdbc.tokenLocation").fillInStackTrace();
        }
        try {
            return isOciToken ? JsonWebToken.fromOciFile(tokenPath) : JsonWebToken.fromFile(tokenPath);
        }
        catch (IOException ioException) {
            throw (SQLException)DatabaseError.createSqlException(null, 1718, "Connection property oracle.jdbc.tokenLocation locates a token file or private key file that can not be read.", (Throwable)ioException).fillInStackTrace();
        }
        catch (SQLException exception) {
            throw (SQLException)DatabaseError.createSqlException(null, 1718, "Connection property oracle.jdbc.tokenLocation locates a private key file that cannot be read.", (Throwable)exception).fillInStackTrace();
        }
        catch (GeneralSecurityException exception) {
            throw (SQLException)DatabaseError.createSqlException(null, 1718, "Connection property oracle.jdbc.tokenLocation locates a private key file that can not be read.", (Throwable)exception).fillInStackTrace();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw (SQLException)DatabaseError.createSqlException(null, 25707, "An invalid token was configured by connection property oracle.jdbc.tokenLocation", (Throwable)illegalArgumentException).fillInStackTrace();
        }
    }

    private AccessToken getTokenFromOciPlugin(TokenAuthentication tokenAuthentication) throws SQLException {
        this.diagnosable.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "getTokenFromOciPlugin", "Getting access token from the OCI token provider. tokenAuthentication={0}, ociTenancy={1}, ociCompartment={2}, ociDatabase={3}, ociConfigFile={4}, ociProfile={5}", (String)null, null, (Object)tokenAuthentication, (Object)this.ociTenancy, (Object)this.ociCompartment, (Object)this.ociDatabase, (Object)this.ociConfigFile, (Object)this.ociProfile);
        ResourceProvider.Builder<AccessTokenProvider, AccessToken> builder = ResourceProvider.builder("ojdbc-provider-oci-token", ResourceType.ACCESS_TOKEN).parameterValue("authenticationMethod", tokenAuthentication.parameterValue).parameterValue("scope", this.composeOciScope()).parameterValue("tenantId", this.ociTenancy).parameterValue("configFile", this.ociConfigFile).parameterValue("profile", this.ociProfile);
        if (tokenAuthentication.isInteractive()) {
            builder.parameterValue("username", this.userName);
        }
        return builder.build().getResource();
    }

    private String composeOciScope() throws SQLException {
        if (this.ociCompartment == null && this.ociDatabase != null) {
            throw (SQLException)DatabaseError.formatSqlException(null, 1722, "This property must be set when oracle.jdbc.ociDatabase is set.", null, "oracle.jdbc.ociCompartment").fillInStackTrace();
        }
        return "urn:oracle:db::id::" + (String)(this.ociCompartment == null ? "*" : (this.ociDatabase == null ? this.ociCompartment : this.ociCompartment + "::" + this.ociDatabase));
    }

    @Blind
    private AccessToken getTokenFromAzurePlugin(TokenAuthentication tokenAuthentication) throws SQLException {
        String clientId = this.clientId;
        OpaqueString clientSecret = this.clientSecret;
        if (this.azureCredentials != null && TokenAuthentication.AZURE_SERVICE_PRINCIPAL == tokenAuthentication && OpaqueString.isNull(clientSecret) && this.clientCertificate == null) {
            if (clientId == null) {
                throw (SQLException)DatabaseError.createSqlException(null, 1718, "A client ID must be configured when connection property oracle.jdbc.azureCredentials is configured.").fillInStackTrace();
            }
            this.diagnosable.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "getTokenFromAzurePlugin", "Reading client secret from wallet", null, null);
            clientSecret = OracleWalletUtils.getSecret(this.azureCredentials, null, "oracle.security.azure.credential." + clientId);
        } else if (this.isWalletLocationCredentials && TokenAuthentication.AZURE_SERVICE_PRINCIPAL == tokenAuthentication) {
            if (clientId == null) {
                this.diagnosable.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "getTokenFromAzurePlugin", "Using SEPS username as client ID.", null, null);
                clientId = this.userName;
            }
            if (OpaqueString.isNull(clientSecret) && this.clientCertificate == null) {
                this.diagnosable.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "getTokenFromAzurePlugin", "Using SEPS password as client secret.", null, null);
                clientSecret = this.password;
            }
        }
        this.diagnosable.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "getTokenFromAzurePlugin", "Getting access token from the Azure token provider. tokenAuthentication={0}, clientId={1}, isClientSecretConfigured={2}, clientCertificate={3}, isClientCertificatePasswordConfigured={4}, redirectUri={5}, tenantId={6}, azureDatabaseApplicationIdUri={7}", (String)null, null, (Object)tokenAuthentication, (Object)clientId, (Object)(!OpaqueString.isNull(clientSecret) ? 1 : 0), (Object)this.clientCertificate, (Object)(!OpaqueString.isNull(this.clientCertificatePassword) ? 1 : 0), (Object)this.redirectUri, (Object)this.tenantId, (Object)this.azureDatabaseApplicationIdUri);
        ResourceProvider.Builder<?, AccessToken> builder = this.createAzureTokenBuilder(tokenAuthentication.parameterValue).parameterValue("clientId", clientId).parameterValue("clientSecret", clientSecret).parameterValue("clientCertificatePath", this.clientCertificate).parameterValue("clientCertificatePassword", this.clientCertificatePassword).parameterValue("redirectUri", this.redirectUri);
        if (tokenAuthentication.isInteractive()) {
            builder.parameterValue("username", this.userName);
        }
        return builder.build().getResource();
    }

    private ResourceProvider.Builder<?, AccessToken> createAzureTokenBuilder(String authenticationMethod) throws SQLException {
        return ResourceProvider.builder("ojdbc-provider-azure-token", ResourceType.ACCESS_TOKEN).parameterValue("authenticationMethod", authenticationMethod).parameterValue("scope", this.composeAzureScope()).parameterValue("tenantId", this.tenantId);
    }

    private String composeAzureScope() throws SQLException {
        if (this.azureDatabaseApplicationIdUri == null) {
            throw (SQLException)DatabaseError.formatSqlException(null, 1722, "This property must be set when oracle.jdbc.tokenAuthentication is set to " + this.tokenAuthentication, null, "oracle.jdbc.azureDatabaseApplicationIdUri").fillInStackTrace();
        }
        return this.azureDatabaseApplicationIdUri + "/.default";
    }

    private AccessToken getTokenFromPasswordAuthentication() throws SQLException {
        PasswordAuthentication authenticationMethod = PasswordAuthentication.parseProperty(this.passwordAuthentication);
        switch (authenticationMethod) {
            case OCI_TOKEN: {
                return this.getTokenFromIam();
            }
            case AZURE_TOKEN: {
                this.diagnosable.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "getTokenFromPasswordAuthentication", "Getting access token from the Azure token provider using password authentication. clientId={0}, tenantId={1}, azureDatabaseApplicationIdUri={2}", (String)null, null, (Object)this.clientId, (Object)this.tenantId, (Object)this.azureDatabaseApplicationIdUri);
                return this.createAzureTokenBuilder("password").parameterValue("clientId", this.clientId).parameterValue("username", this.userName).parameterValue("password", this.password).build().getResource();
            }
        }
        return null;
    }

    @Blind
    private AccessToken getTokenFromIam() throws SQLException {
        if (this.ociIamUrl == null) {
            throw (SQLException)DatabaseError.formatSqlException(null, 1722, "This property must be set when oracle.jdbc.passwordAuthentication=" + String.valueOf((Object)PasswordAuthentication.OCI_TOKEN), null, "oracle.jdbc.ociIamUrl").fillInStackTrace();
        }
        if (this.ociTenancy == null) {
            throw (SQLException)DatabaseError.formatSqlException(null, 1722, "This property must be set when oracle.jdbc.passwordAuthentication=" + String.valueOf((Object)PasswordAuthentication.OCI_TOKEN), null, "oracle.jdbc.ociTenancy").fillInStackTrace();
        }
        if (this.ociDatabase != null && this.ociCompartment == null) {
            throw (SQLException)DatabaseError.formatSqlException(null, 1722, "This property must be set when oracle.jdbc.ociDatabase is set.", null, "oracle.jdbc.ociCompartment").fillInStackTrace();
        }
        if (this.userName == null) {
            throw (SQLException)DatabaseError.createSqlException(null, 1718, "A user name must be provided when connection property oracle.jdbc.passwordAuthentication=" + String.valueOf((Object)PasswordAuthentication.OCI_TOKEN)).fillInStackTrace();
        }
        if (this.password == null || this.password.isNull()) {
            throw (SQLException)DatabaseError.createSqlException(null, 1718, "A password must be provided when connection property oracle.jdbc.passwordAuthentication=" + String.valueOf((Object)PasswordAuthentication.OCI_TOKEN)).fillInStackTrace();
        }
        try {
            this.diagnosable.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "getTokenFromIam", "Getting access token from IAM using password authentication. ociIamUrl={0}, ociTenancy={1}, ociCompartment={2}, ociDatabase={3}", (String)null, null, (Object)this.ociIamUrl, (Object)this.ociTenancy, (Object)this.ociCompartment, (Object)this.ociDatabase);
            return IamDataplaneClient.requestBuilder().endPoint(this.ociIamUrl).tenancy(this.ociTenancy).compartment(this.ociCompartment).database(this.ociDatabase).user(this.userName).password(this.password).tlsConfig(this.tlsConfig).build();
        }
        catch (IOException ioException) {
            throw (SQLException)DatabaseError.createSqlException(null, 1718, "Failed to request a token from IAM endpoint: " + this.ociIamUrl + ", with tenant OCID: " + this.ociTenancy + (String)(this.ociCompartment == null ? "" : ", with compartment OCID: " + this.ociCompartment) + (String)(this.ociDatabase == null ? "" : ", with database OCID: " + this.ociDatabase), (Throwable)ioException).fillInStackTrace();
        }
    }

    @Blind
    private AccessToken getTokenFromProvider() throws SQLException {
        this.diagnosable.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "getTokenFromProvider", "Getting access token from AccessTokenProvider identified by oracle.jdbc.provider.accessToken", null, null);
        return this.driverResources.getResource(ResourceType.ACCESS_TOKEN);
    }

    private void validateAzureToken(AccessToken token) throws SQLException {
        try {
            if (!(token instanceof JsonWebToken)) {
                return;
            }
            OracleJsonObject claims = ((JsonWebToken)token).getClaims();
            OracleJsonValue iss = (OracleJsonValue)claims.get("iss");
            if (!(iss instanceof OracleJsonString)) {
                return;
            }
            if (!iss.asJsonString().getString().startsWith("https://login.microsoftonline.com/")) {
                return;
            }
            OracleJsonValue ver = (OracleJsonValue)claims.get("ver");
            if (!(ver instanceof OracleJsonString)) {
                return;
            }
            if (!ver.asJsonString().getString().equals("2.0")) {
                return;
            }
            if (claims.containsKey("roles") || claims.containsKey("upn") || claims.containsKey("azp")) {
                return;
            }
        }
        catch (Exception exception) {
            this.diagnosable.debug(Level.WARNING, SecurityLabel.KEYS, CLASS_NAME, "validateAzureToken", "Unable to validate token due to an unexpected exception", null, exception);
            return;
        }
        throw (SQLException)DatabaseError.createSqlException(null, 25725).fillInStackTrace();
    }

    static enum TokenAuthentication {
        OCI_TOKEN(null),
        OCI_API_KEY("config-file"),
        OCI_INSTANCE_PRINCIPAL("instance-principal"),
        OCI_RESOURCE_PRINCIPAL("resource-principal"),
        OCI_DELEGATION_TOKEN("cloud-shell"),
        OCI_INTERACTIVE("interactive"),
        OCI_DEFAULT("auto-detect"),
        OAUTH(null),
        AZURE_SERVICE_PRINCIPAL("service-principal"),
        AZURE_MANAGED_IDENTITY("managed-identity"),
        AZURE_DEVICE_CODE("device-code"),
        AZURE_INTERACTIVE("interactive"),
        AZURE_DEFAULT("auto-detect");

        private final String parameterValue;
        private static final Map<String, TokenAuthentication> PROPERTY_VALUES;

        private TokenAuthentication(String parameterValue) {
            this.parameterValue = parameterValue;
        }

        boolean isInteractive() {
            switch (this) {
                case OCI_INTERACTIVE: 
                case AZURE_DEVICE_CODE: 
                case AZURE_INTERACTIVE: {
                    return true;
                }
            }
            return false;
        }

        static boolean isInteractive(String propertyValue) {
            if (propertyValue == null) {
                return false;
            }
            TokenAuthentication tokenAuthentication = PROPERTY_VALUES.get(propertyValue);
            if (tokenAuthentication == null) {
                return false;
            }
            return tokenAuthentication.isInteractive();
        }

        static TokenAuthentication parseProperty(String propertyValue) throws SQLException {
            if (propertyValue == null) {
                return null;
            }
            TokenAuthentication tokenAuthentication = PROPERTY_VALUES.get(propertyValue);
            if (tokenAuthentication == null) {
                throw (SQLException)DatabaseError.formatSqlException(null, 1721, null, null, propertyValue, "oracle.jdbc.tokenAuthentication").fillInStackTrace();
            }
            return tokenAuthentication;
        }

        static {
            TreeMap<String, TokenAuthentication> propertyValues = new TreeMap<String, TokenAuthentication>(String.CASE_INSENSITIVE_ORDER);
            for (TokenAuthentication tokenAuthentication : TokenAuthentication.values()) {
                propertyValues.put(tokenAuthentication.name(), tokenAuthentication);
            }
            PROPERTY_VALUES = Collections.unmodifiableMap(propertyValues);
        }
    }
}

