/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.cli.urlbuilder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import oracle.jdbc.driver.cli.urlbuilder.AddressInfo;
import oracle.jdbc.driver.cli.urlbuilder.ConnectionOptionsHandler;
import oracle.jdbc.driver.cli.urlbuilder.DescriptionInfo;
import oracle.jdbc.driver.cli.urlbuilder.EZConnectAddressInfo;
import oracle.net.url.builder.ConnectDescriptorBuilder;
import oracle.net.url.builder.EZConnectBuilder;
import oracle.net.url.common.DriverType;

public class ConnectionStringBuilder {
    private static final ConnectionOptionsHandler optionsHandler = new ConnectionOptionsHandler();
    private static final Set<String> EZ_CONNECT_COMPATIBLE_OPTIONS = new HashSet<String>(Arrays.asList("CONNECT_TIMEOUT", "TRANSPORT_CONNECT_TIMEOUT", "RETRY_COUNT", "RETRY_DELAY", "SDU", "TDU", "ENABLE", "SERVER", "COMPRESSION"));

    public static String generate(List<AddressInfo> addresses, String serviceType, String service, List<String> additionalProperties, Map<String, String> advancedOptions, String oracleHome, String oracleSid) {
        boolean isBeq = false;
        isBeq = addresses != null && !addresses.isEmpty() ? addresses.stream().anyMatch(a -> a.protocol.equalsIgnoreCase("beq")) : oracleHome != null && oracleSid != null;
        boolean usingBeq = isBeq;
        ConnectDescriptorBuilder builder = ConnectDescriptorBuilder.create();
        builder.driverType(DriverType.THIN);
        builder.rootNode(ConnectDescriptorBuilder.DescriptionNode.class, description -> {
            if (advancedOptions != null && !advancedOptions.isEmpty()) {
                optionsHandler.applyConnectionOptions((ConnectDescriptorBuilder.DescriptionNode)description, advancedOptions);
            }
            if (usingBeq) {
                description.addChild(ConnectDescriptorBuilder.AddressNode.class, address -> {
                    address.param("PROTOCOL", "BEQ");
                    StringBuilder envsValue = new StringBuilder();
                    envsValue.append("ORACLE_HOME=").append(oracleHome).append(",ORACLE_SID=").append(oracleSid);
                    address.param("ENVS", envsValue.toString());
                });
                description.param("LOCAL", "YES");
            } else if (addresses != null) {
                if (addresses.size() > 1) {
                    description.addChild(ConnectDescriptorBuilder.AddressListNode.class, addressList -> {
                        for (AddressInfo addrInfo : addresses) {
                            addressList.addChild(ConnectDescriptorBuilder.AddressNode.class, address -> address.param("PROTOCOL", addrInfo.protocol.toUpperCase()).param("HOST", addrInfo.host).param("PORT", addrInfo.port));
                        }
                    });
                } else if (addresses.size() == 1) {
                    AddressInfo addrInfo = (AddressInfo)addresses.get(0);
                    description.addChild(ConnectDescriptorBuilder.AddressNode.class, address -> address.param("PROTOCOL", addrInfo.protocol.toUpperCase()).param("HOST", addrInfo.host).param("PORT", addrInfo.port));
                }
            }
            description.addChild(ConnectDescriptorBuilder.ConnectDataNode.class, connectData -> {
                if (serviceType.equalsIgnoreCase("sid")) {
                    connectData.param("SID", service);
                } else {
                    connectData.param("SERVICE_NAME", service);
                }
                if (advancedOptions != null) {
                    String instanceName;
                    String serverMode = (String)advancedOptions.get("SERVER");
                    if (serverMode != null) {
                        connectData.serverMode(serverMode);
                    }
                    if ((instanceName = (String)advancedOptions.get("INSTANCE_NAME")) != null) {
                        connectData.instanceName(instanceName);
                    }
                }
            });
        });
        Properties props = new Properties();
        for (String prop : additionalProperties) {
            String[] parts = prop.split("=", 2);
            if (parts.length != 2) continue;
            props.setProperty(parts[0], parts[1]);
        }
        builder.addProperties(props);
        return builder.build();
    }

    public static String generate(String protocol, List<String> hostsAndPorts, String serviceType, String service, List<String> additionalProperties, Map<String, String> advancedOptions, String oracleHome, String oracleSid) {
        if (protocol.equalsIgnoreCase("beq")) {
            return ConnectionStringBuilder.generate(null, serviceType, service, additionalProperties, advancedOptions, oracleHome, oracleSid);
        }
        ArrayList<AddressInfo> addresses = new ArrayList<AddressInfo>();
        if (hostsAndPorts != null) {
            for (String hostPort : hostsAndPorts) {
                String[] parts = hostPort.split(":");
                String host = parts[0];
                String port = parts.length > 1 ? parts[1] : "1521";
                addresses.add(new AddressInfo(protocol, host, port));
            }
        }
        return ConnectionStringBuilder.generate(addresses, serviceType, service, additionalProperties, advancedOptions, oracleHome, oracleSid);
    }

    public static String generateWithDescriptionList(List<DescriptionInfo> descriptions, List<String> additionalProperties) {
        ConnectDescriptorBuilder builder = ConnectDescriptorBuilder.create();
        builder.driverType(DriverType.THIN);
        builder.rootNode(ConnectDescriptorBuilder.DescriptionListNode.class, descriptionList -> {
            for (DescriptionInfo desc : descriptions) {
                descriptionList.addChild(ConnectDescriptorBuilder.DescriptionNode.class, description -> {
                    if (desc.hasAdvancedOptions()) {
                        optionsHandler.applyConnectionOptions((ConnectDescriptorBuilder.DescriptionNode)description, desc.getAdvancedOptions());
                    }
                    if (desc.addresses.size() > 1) {
                        description.addChild(ConnectDescriptorBuilder.AddressListNode.class, addressList -> {
                            for (AddressInfo addrInfo : desc.addresses) {
                                addressList.addChild(ConnectDescriptorBuilder.AddressNode.class, address -> address.param("PROTOCOL", addrInfo.protocol.toUpperCase()).param("HOST", addrInfo.host).param("PORT", addrInfo.port));
                            }
                        });
                    } else if (desc.addresses.size() == 1) {
                        AddressInfo addrInfo = desc.addresses.get(0);
                        description.addChild(ConnectDescriptorBuilder.AddressNode.class, address -> address.param("PROTOCOL", addrInfo.protocol.toUpperCase()).param("HOST", addrInfo.host).param("PORT", addrInfo.port));
                    }
                    description.addChild(ConnectDescriptorBuilder.ConnectDataNode.class, connectData -> {
                        if (desc.serviceType.equalsIgnoreCase("sid")) {
                            connectData.param("SID", desc.service);
                        } else {
                            connectData.param("SERVICE_NAME", desc.service);
                        }
                        Map<String, String> advancedOptions = desc.getAdvancedOptions();
                        if (advancedOptions != null) {
                            String instanceName;
                            String serverMode = advancedOptions.get("SERVER");
                            if (serverMode != null) {
                                connectData.serverMode(serverMode);
                            }
                            if ((instanceName = advancedOptions.get("INSTANCE_NAME")) != null) {
                                connectData.instanceName(instanceName);
                            }
                        }
                    });
                });
            }
        });
        Properties props = new Properties();
        for (String prop : additionalProperties) {
            String[] parts = prop.split("=", 2);
            if (parts.length != 2) continue;
            props.setProperty(parts[0], parts[1]);
        }
        builder.addProperties(props);
        return builder.build();
    }

    public static String generateEZConnect(String protocol, List<EZConnectAddressInfo> addressInfos, String serviceName, String instanceName, String serverMode, Map<String, String> advancedOptions, List<String> additionalProperties) {
        EZConnectBuilder builder = EZConnectBuilder.create();
        builder.driverType(DriverType.THIN);
        builder.protocol(protocol.toLowerCase());
        HashMap addressLists = new HashMap();
        for (EZConnectAddressInfo eZConnectAddressInfo : addressInfos) {
            if (eZConnectAddressInfo.listName != null) {
                if (!addressLists.containsKey(eZConnectAddressInfo.listName)) {
                    addressLists.put(eZConnectAddressInfo.listName, new ArrayList());
                }
                ((List)addressLists.get(eZConnectAddressInfo.listName)).add(eZConnectAddressInfo);
                continue;
            }
            builder.addAddress(eZConnectAddressInfo.host, eZConnectAddressInfo.port);
        }
        for (Map.Entry entry : addressLists.entrySet()) {
            for (EZConnectAddressInfo addr : (List)entry.getValue()) {
                builder.addAddressToList((String)entry.getKey(), addr.host, addr.port);
            }
        }
        builder.serviceName(serviceName);
        if (instanceName != null && !instanceName.isEmpty()) {
            builder.instance(instanceName);
        }
        if (serverMode != null && !serverMode.isEmpty()) {
            builder.serverMode(serverMode);
        }
        if (advancedOptions != null && !advancedOptions.isEmpty()) {
            for (Map.Entry entry : advancedOptions.entrySet()) {
                if (!ConnectionStringBuilder.isEZConnectCompatibleOption((String)entry.getKey())) continue;
                builder.addProperty((String)entry.getKey(), (String)entry.getValue());
            }
        }
        for (String string : additionalProperties) {
            String[] parts = string.split("=", 2);
            if (parts.length != 2) continue;
            builder.addProperty(parts[0], parts[1]);
        }
        return builder.build();
    }

    private static boolean isEZConnectCompatibleOption(String optionName) {
        return EZ_CONNECT_COMPATIBLE_OPTIONS.contains(optionName);
    }

    public static String generateEZConnect(String protocol, List<EZConnectAddressInfo> addressInfos, String serviceName, String instanceName, String serverMode, List<String> additionalProperties) {
        return ConnectionStringBuilder.generateEZConnect(protocol, addressInfos, serviceName, instanceName, serverMode, null, additionalProperties);
    }
}

