/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.cli;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import oracle.jdbc.driver.cli.Argument;
import oracle.jdbc.driver.cli.Command;
import oracle.jdbc.driver.cli.CommandContext;
import oracle.jdbc.driver.cli.Option;
import oracle.jdbc.driver.cli.ValuedOption;

public abstract class AbstractCommand
implements Command {
    @Override
    public String printCommandTemplate(String prefix) throws Exception {
        StringBuilder output = new StringBuilder();
        output.append(prefix).append(this.getName());
        for (Argument argument : this.getExpectedArguments()) {
            if (argument.isMandatory()) {
                output.append(" ").append(argument.getLabel());
                continue;
            }
            output.append(" [").append(argument.getLabel()).append("]");
        }
        for (Option option : this.getExpectedOptions()) {
            if (option instanceof ValuedOption) {
                ValuedOption valuedOption = (ValuedOption)option;
                if (valuedOption.isMandatory()) {
                    output.append(" --").append(valuedOption.getLongName()).append(" <").append(valuedOption.getValueLabel()).append(">");
                    continue;
                }
                output.append(" [--").append(valuedOption.getLongName()).append(" <").append(valuedOption.getValueLabel()).append(">]");
                continue;
            }
            if (option.getLongName().length() > 1) {
                if (option.isMandatory()) {
                    output.append(" --").append(option.getLongName());
                    continue;
                }
                output.append(" [--").append(option.getLongName()).append("]");
                continue;
            }
            if (option.isMandatory()) {
                output.append(" -").append(option.getShortName());
                continue;
            }
            output.append(" [-").append(option.getShortName()).append("]");
        }
        return output.toString();
    }

    @Override
    public void printCommandHelp(String prefix) {
        try {
            StringBuilder output = new StringBuilder();
            output.append("Usage: \n").append(this.printCommandTemplate(prefix)).append("\n\n").append(this.getLongUsage());
            System.out.println(output.toString());
        }
        catch (Exception e) {
            System.err.println("Undefined command: " + this.getName());
        }
    }

    @Override
    public void validateParameters(CommandContext context) throws Exception {
        Map<String, List<String>> parsedOptions = context.getOptions();
        List<String> parsedArguments = context.getArguments();
        if (parsedOptions.containsKey("help")) {
            return;
        }
        for (Option option : this.getExpectedOptions()) {
            List values = parsedOptions.getOrDefault(option.getLongName(), new ArrayList());
            if (option instanceof ValuedOption) {
                for (String value : values) {
                    ((ValuedOption)option).validateValue(value);
                }
            }
            if (option.isMandatory() && values.isEmpty()) {
                throw new Exception("Required option --" + option.getLongName() + " is missing.");
            }
            if (values.size() <= option.getMaxRepetitions()) continue;
            throw new Exception("Option --" + option.getLongName() + " exceeded maximum repetitions: " + option.getMaxRepetitions());
        }
        List<Argument> expectedArguments = this.getExpectedArguments();
        if (parsedArguments.size() < expectedArguments.size()) {
            throw new Exception("Missing required arguments. Expected " + expectedArguments.size() + " but got " + parsedArguments.size());
        }
        for (int i = 0; i < expectedArguments.size(); ++i) {
            Argument argument = expectedArguments.get(i);
            String parsedArgument = parsedArguments.get(i);
            if (argument.isMandatory() && parsedArgument == null) {
                throw new Exception("Missing required argument: " + argument.getLabel());
            }
            argument.validateValue(parsedArgument);
        }
    }
}

