/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.ByteOrder;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import oracle.jdbc.OracleType;
import oracle.jdbc.VectorMetaData;
import oracle.jdbc.diagnostics.CommonDiagnosable;
import oracle.jdbc.driver.ByteArray;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.SimpleByteArray;
import oracle.sql.VECTOR;

public final class VectorData {
    private static final int MAGIC_OFFSET = 0;
    private static final int VERSION_OFFSET = 1;
    private static final int FLAG1_OFFSET = 2;
    private static final int TYPE_OFFSET = 4;
    private static final int LENGTH_OFFSET = 5;
    private static final int NORM_OFFSET = 9;
    private static final byte LVECTOR_H_MAGIC = -37;
    private static final short LVECTOR_H_FLAG1_OPTIONAL = Short.MIN_VALUE;
    private static final short LVECTOR_H_FLAG1_LITENDIAN = 1;
    private static final short LVECTOR_H_FLAG1_NORM = 2;
    private static final short LVECTOR_H_FLAG1_UKDIM = 4;
    private static final short LVECTOR_H_FLAG1_IEEETYP = 8;
    private static final short LVECTOR_H_FLAG1_NORMSRC = 16;
    private static final short LVECTOR_H_FLAG1_SPARSE = 32;
    private static final byte LVECTOR_FLEX = 0;
    private static final byte LVECTOR_FLOAT16 = 1;
    private static final byte LVECTOR_FLOAT32 = 2;
    private static final byte LVECTOR_DOUBLE = 3;
    private static final byte LVECTOR_INT8 = 4;
    private static final byte LVECTOR_BINARY = 5;
    private static final int BUFFER_SIZE = 16384;

    private VectorData() {
    }

    public static <T> byte[] encode(T values, OracleType vectorType, boolean isComputingNorm) throws SQLException {
        Encoder<T> encoder = VectorData.getEncoder(values, vectorType.getVendorTypeNumber());
        int maximumByteLength = encoder.getMaximumByteLength(values);
        byte[] data = new byte[maximumByteLength];
        ByteArray byteArray = VectorData.wrapBytes(data);
        encoder.encode(values, isComputingNorm, byteArray);
        int encodedLength = (int)byteArray.getPosition();
        return encodedLength == data.length ? data : Arrays.copyOf(data, encodedLength);
    }

    static <T> Encoder<? super T> getEncoder(Object object, int vectorType) throws SQLException {
        if (object instanceof double[]) {
            switch (vectorType) {
                case -108: 
                case -105: {
                    return Float64Encoder.INSTANCE;
                }
                case -107: {
                    return Float32ConversionEncoder.DOUBLE_ENCODER;
                }
                case -106: {
                    return Int8ConversionEncoder.DOUBLE_ENCODER;
                }
            }
        } else if (object instanceof float[]) {
            switch (vectorType) {
                case -108: {
                    return Float64ConversionEncoder.FLOAT_ENCODER;
                }
                case -107: 
                case -105: {
                    return Float32Encoder.INSTANCE;
                }
                case -106: {
                    return Int8ConversionEncoder.FLOAT_ENCODER;
                }
            }
        } else if (object instanceof byte[]) {
            switch (vectorType) {
                case -108: {
                    return Float64ConversionEncoder.BYTE_ENCODER;
                }
                case -107: {
                    return Float32ConversionEncoder.BYTE_ENCODER;
                }
                case -106: 
                case -105: {
                    return Int8Encoder.INSTANCE;
                }
                case -109: {
                    return BinaryEncoder.INSTANCE;
                }
            }
        } else if (object instanceof long[]) {
            switch (vectorType) {
                case -108: {
                    return Float64ConversionEncoder.LONG_ENCODER;
                }
                case -107: {
                    return Float32ConversionEncoder.LONG_ENCODER;
                }
                case -106: {
                    return Int8ConversionEncoder.LONG_ENCODER;
                }
            }
        } else if (object instanceof int[]) {
            switch (vectorType) {
                case -108: {
                    return Float64ConversionEncoder.INT_ENCODER;
                }
                case -107: {
                    return Float32ConversionEncoder.INT_ENCODER;
                }
                case -106: {
                    return Int8ConversionEncoder.INT_ENCODER;
                }
            }
        } else if (object instanceof short[]) {
            switch (vectorType) {
                case -108: {
                    return Float64ConversionEncoder.SHORT_ENCODER;
                }
                case -107: {
                    return Float32ConversionEncoder.SHORT_ENCODER;
                }
                case -106: {
                    return Int8ConversionEncoder.SHORT_ENCODER;
                }
            }
        } else if (object instanceof boolean[]) {
            switch (vectorType) {
                case -108: {
                    return Float64ConversionEncoder.BOOLEAN_ENCODER;
                }
                case -107: {
                    return Float32ConversionEncoder.BOOLEAN_ENCODER;
                }
                case -106: {
                    return Int8ConversionEncoder.BOOLEAN_ENCODER;
                }
                case -109: 
                case -105: {
                    return BinaryConversionEncoder.BOOLEAN_ENCODER;
                }
            }
        } else if (object instanceof VECTOR.SparseDoubleArray) {
            switch (vectorType) {
                case -108: 
                case -105: {
                    return SparseEncoder.DOUBLE_TO_FLOAT64;
                }
                case -107: {
                    return NarrowingSparseEncoder.DOUBLE_TO_FLOAT32;
                }
                case -106: {
                    return NarrowingSparseEncoder.DOUBLE_TO_INT8;
                }
            }
        } else if (object instanceof VECTOR.SparseFloatArray) {
            switch (vectorType) {
                case -108: {
                    return SparseEncoder.FLOAT_TO_FLOAT64;
                }
                case -107: 
                case -105: {
                    return SparseEncoder.FLOAT_TO_FLOAT32;
                }
                case -106: {
                    return NarrowingSparseEncoder.FLOAT_TO_INT8;
                }
            }
        } else if (object instanceof VECTOR.SparseByteArray) {
            switch (vectorType) {
                case -108: {
                    return SparseEncoder.BYTE_TO_FLOAT64;
                }
                case -107: {
                    return SparseEncoder.BYTE_TO_FLOAT32;
                }
                case -106: 
                case -105: {
                    return SparseEncoder.BYTE_TO_INT8;
                }
            }
        } else if (object instanceof VECTOR.SparseBooleanArray) {
            switch (vectorType) {
                case -108: {
                    return SparseEncoder.BOOLEAN_TO_FLOAT64;
                }
                case -107: {
                    return SparseEncoder.BOOLEAN_TO_FLOAT32;
                }
                case -106: {
                    return SparseEncoder.BOOLEAN_TO_INT8;
                }
                case -109: 
                case -105: {
                    return SparseEncoder.BOOLEAN_TO_BINARY;
                }
            }
        }
        throw VectorData.unsupportedConversion(object.getClass(), OracleType.toOracleType(vectorType));
    }

    private static SQLException unsupportedConversion(OracleType fromSqlType, Class<?> toJavaClass) {
        return (SQLException)DatabaseError.createSqlException(null, 4, "Conversions of " + fromSqlType.toString() + " to " + toJavaClass.getSimpleName() + " are not supported. Supported conversions are specified in the SQL to Java Conversions section of the JavaDoc for oracle.jdbc.OracleType." + String.valueOf(fromSqlType)).fillInStackTrace();
    }

    private static SQLException unsupportedConversion(Class<?> fromJavaClass, OracleType toSqlType) {
        return (SQLException)DatabaseError.createSqlException(null, 4, "Conversions of " + fromJavaClass.getSimpleName() + " to " + toSqlType.toString() + " are not supported. Supported conversions are specified in the Java to SQL Conversions section of the JavaDoc for oracle.jdbc.OracleType." + String.valueOf(toSqlType)).fillInStackTrace();
    }

    public static OracleType decodeType(byte[] data) throws SQLException {
        VectorData.validateMagicNumber(data[0]);
        try {
            return VectorData.toOracleType(data[4]);
        }
        catch (RuntimeException runtimeException) {
            throw VectorData.unrecognizedData(runtimeException);
        }
    }

    public static OracleType toOracleType(byte typeCode) throws SQLException {
        switch (typeCode) {
            case 3: {
                return OracleType.VECTOR_FLOAT64;
            }
            case 2: {
                return OracleType.VECTOR_FLOAT32;
            }
            case 4: {
                return OracleType.VECTOR_INT8;
            }
            case 5: {
                return OracleType.VECTOR_BINARY;
            }
            case 0: {
                return OracleType.VECTOR;
            }
        }
        throw DatabaseError.createSqlException(null, 89, "Unrecognized vector type code: " + typeCode);
    }

    public static int decodeLength(byte[] data) throws SQLException {
        VectorData.validateMagicNumber(data[0]);
        try {
            return (data[5] & 0xFF) << 24 | (data[6] & 0xFF) << 16 | (data[7] & 0xFF) << 8 | data[8] & 0xFF;
        }
        catch (RuntimeException runtimeException) {
            throw VectorData.unrecognizedData(runtimeException);
        }
    }

    public static boolean isSparse(byte[] data) throws SQLException {
        try {
            return VectorData.isSparseFlagSet(VectorData.decodeFlag1(data));
        }
        catch (RuntimeException runtimeException) {
            throw VectorData.unrecognizedData(runtimeException);
        }
    }

    private static boolean isSparseFlagSet(short flag1) {
        return 0 != (flag1 & 0x20);
    }

    private static short decodeFlag1(byte[] data) {
        return (short)(data[2] << 8 | data[3] & 0xFF);
    }

    private static ByteArray wrapBytes(byte[] data) {
        return new SimpleByteArray(CommonDiagnosable.getInstance(), data);
    }

    public static <T> T decode(byte[] data, Class<T> decodedClass, boolean isIeeeReencode) throws SQLException {
        return VectorData.decode(new SimpleByteArray(CommonDiagnosable.getInstance(), data), decodedClass, isIeeeReencode);
    }

    static <T> T decode(ByteArray data, Class<T> decodedClass, boolean isIeeeReencode) throws SQLException {
        Decoder<?> ieeeDecoder;
        VectorData.validateMagicNumber(data.get());
        VectorData.validateVersion(data.get());
        long flag1Position = data.getPosition();
        short flag1 = VectorData.readFlag1(data);
        byte type = data.get();
        int length = data.getInt();
        if (VectorData.isNormBeforeValues(flag1)) {
            data.setPosition(data.getPosition() + 8L);
        }
        Decoder<?> decoder = VectorData.getDecoder(flag1, type);
        if (isIeeeReencode && (ieeeDecoder = decoder.toIeee(data, length)) != decoder) {
            decoder = ieeeDecoder;
            data.putShort(flag1Position, (short)(flag1 | 8));
        }
        return decoder.decode(data, length, decodedClass);
    }

    private static void validateMagicNumber(byte magicNumber) throws SQLException {
        if (magicNumber != -37) {
            throw VectorData.unrecognizedData("Possible data corruption. Unrecognized vector magic number: 0x" + Integer.toHexString(magicNumber & 0xFF));
        }
    }

    private static void validateVersion(byte version) throws SQLException {
        if (version < 0 || version > 2) {
            throw VectorData.unrecognizedData("Unrecognized vector version: " + version);
        }
    }

    private static short readFlag1(ByteArray data) throws SQLException {
        int flag1 = data.getShort();
        if ((flag1 & Short.MIN_VALUE) != 0) {
            throw VectorData.unrecognizedData("Unrecognized VECTOR flag: " + Integer.toHexString(flag1));
        }
        return (short)flag1;
    }

    private static boolean isNormBeforeValues(short flag1) {
        return VectorData.isNormFlagSet(flag1) || VectorData.isNormPaddingFlagSet(flag1);
    }

    private static boolean isNormFlagSet(short flag1) {
        return (flag1 & 2) != 0;
    }

    private static boolean isNormPaddingFlagSet(short flag1) {
        return (flag1 & 0x10) != 0;
    }

    private static SQLException unrecognizedData(String message) {
        return DatabaseError.createSqlException(null, 89, message);
    }

    private static SQLException unrecognizedData(RuntimeException runtimeException) {
        SQLException sqlException = VectorData.unrecognizedData("Unrecognized VECTOR encoding");
        sqlException.initCause(runtimeException);
        return sqlException;
    }

    private static Decoder<?> getDecoder(short flag1, byte typeCode) throws SQLException {
        Decoder decoder;
        switch (typeCode) {
            case 3: {
                decoder = Float64Decoder.getDecoder(flag1);
                break;
            }
            case 2: {
                decoder = Float32Decoder.getDecoder(flag1);
                break;
            }
            case 4: {
                decoder = Int8Decoder.getDecoder();
                break;
            }
            case 5: {
                decoder = BinaryDecoder.getDecoder();
                break;
            }
            default: {
                throw VectorData.unrecognizedData("Unrecognized vector type: " + typeCode);
            }
        }
        return VectorData.isSparseFlagSet(flag1) ? decoder.getSparseDecoder() : decoder;
    }

    private static ByteArray.NumberEncoding getNumberEncoding(short flag1) {
        boolean isLittleEndian;
        boolean isIeee = (flag1 & 8) != 0;
        boolean bl = isLittleEndian = (flag1 & 1) != 0;
        return isIeee ? (isLittleEndian ? ByteArray.NumberEncoding.IEEE_LITTLE_ENDIAN : ByteArray.NumberEncoding.IEEE_BIG_ENDIAN) : (isLittleEndian ? ByteArray.NumberEncoding.ORACLE_LITTLE_ENDIAN : ByteArray.NumberEncoding.ORACLE_BIG_ENDIAN);
    }

    private static int getFlag1FormatBits(ByteArray.NumberEncoding numberEncoding) {
        int flag1 = 0;
        if (numberEncoding.isIeee()) {
            flag1 |= 8;
        }
        if (numberEncoding.byteOrder() == ByteOrder.LITTLE_ENDIAN) {
            flag1 |= 1;
        }
        return flag1;
    }

    public static VECTOR.SparseDoubleArray createSparseDoubleArray(int length, int[] indices, double[] values) {
        VectorData.validateSparseArray(length, indices, values, DoubleArrayConverter.INSTANCE::getLength);
        return new SparseDoubleArrayImpl(length, indices, values);
    }

    public static VECTOR.SparseFloatArray createSparseFloatArray(int length, int[] indices, float[] values) {
        VectorData.validateSparseArray(length, indices, values, FloatArrayConverter.INSTANCE::getLength);
        return new SparseFloatArrayImpl(length, indices, values);
    }

    public static VECTOR.SparseByteArray createSparseByteArray(int length, int[] indices, byte[] values) {
        VectorData.validateSparseArray(length, indices, values, ByteArrayConverter.INSTANCE::getLength);
        return new SparseByteArrayImpl(length, indices, values);
    }

    public static VECTOR.SparseBooleanArray createSparseBooleanArray(int length, int[] indices) {
        VectorData.validateSparseArray(length, indices);
        return new SparseBooleanArrayImpl(length, indices);
    }

    public static VECTOR.SparseDoubleArray createSparseDoubleArray(double[] denseArray) {
        Objects.requireNonNull(denseArray, "denseArray is null");
        return DoubleArrayConverter.INSTANCE.toSparseDoubleArray((double[])denseArray.clone());
    }

    public static VECTOR.SparseFloatArray createSparseFloatArray(float[] denseArray) {
        Objects.requireNonNull(denseArray, "denseArray is null");
        return FloatArrayConverter.INSTANCE.toSparseFloatArray((float[])denseArray.clone());
    }

    public static VECTOR.SparseByteArray createSparseByteArray(byte[] denseArray) {
        Objects.requireNonNull(denseArray, "denseArray is null");
        return ByteArrayConverter.INSTANCE.toSparseByteArray((byte[])denseArray.clone());
    }

    public static VECTOR.SparseBooleanArray createSparseBooleanArray(boolean[] denseArray) {
        Objects.requireNonNull(denseArray, "denseArray is null");
        return BooleanArrayConverter.INSTANCE.toSparseBooleanArray(denseArray);
    }

    public static VECTOR.SparseBooleanArray createSparseBooleanArray(byte[] packedBitsArray) {
        Objects.requireNonNull(packedBitsArray, "denseArray is null");
        int length = packedBitsArray.length << 3;
        int[] indices = new int[length];
        int indicesLength = 0;
        for (int i = 0; i < packedBitsArray.length; ++i) {
            byte packedBits = packedBitsArray[i];
            int mask = 128;
            for (int j = 0; j < 8; ++j) {
                if (0 != (packedBits & mask)) {
                    indices[indicesLength++] = (i << 3) + j;
                }
                mask >>= 1;
            }
        }
        indices = Arrays.copyOf(indices, indicesLength);
        return new SparseBooleanArrayImpl(length, indices);
    }

    private static VECTOR.SparseFloatArray toSparseFloatArray(VECTOR.SparseDoubleArray sparseDoubleArray) {
        return VectorData.toSparseFloatArray(sparseDoubleArray, VECTOR.SparseDoubleArray::values, DoubleArrayConverter.INSTANCE);
    }

    private static <T extends VECTOR.SparseArray, U> VECTOR.SparseFloatArray toSparseFloatArray(T sparseArray, Function<T, U> getValuesFunction, ArrayConverter<U> converter) {
        int[] indices = sparseArray.indices();
        float[] values = converter.toFloatArray(getValuesFunction.apply(sparseArray));
        int sparseLength = 0;
        for (int i = 0; i < values.length; ++i) {
            float value = values[i];
            if (0.0f == value) continue;
            if (i != sparseLength) {
                values[sparseLength] = value;
                indices[sparseLength] = indices[i];
            }
            ++sparseLength;
        }
        if (sparseLength != indices.length) {
            indices = Arrays.copyOf(indices, sparseLength);
            values = Arrays.copyOf(values, sparseLength);
        }
        return new SparseFloatArrayImpl(sparseArray.length(), indices, values);
    }

    private static VECTOR.SparseByteArray toSparseByteArray(VECTOR.SparseDoubleArray sparseDoubleArray) {
        return VectorData.toSparseByteArray(sparseDoubleArray, VECTOR.SparseDoubleArray::values, DoubleArrayConverter.INSTANCE);
    }

    private static VECTOR.SparseByteArray toSparseByteArray(VECTOR.SparseFloatArray sparseFloatArray) {
        return VectorData.toSparseByteArray(sparseFloatArray, VECTOR.SparseFloatArray::values, FloatArrayConverter.INSTANCE);
    }

    private static <T extends VECTOR.SparseArray, U> VECTOR.SparseByteArray toSparseByteArray(T sparseArray, Function<T, U> getValuesFunction, ArrayConverter<U> converter) {
        int[] indices = sparseArray.indices();
        byte[] values = converter.toByteArray(getValuesFunction.apply(sparseArray));
        int sparseLength = 0;
        for (int i = 0; i < values.length; ++i) {
            byte value = values[i];
            if (0 == value) continue;
            if (i != sparseLength) {
                values[sparseLength] = value;
                indices[sparseLength] = indices[i];
            }
            ++sparseLength;
        }
        if (sparseLength != indices.length) {
            indices = Arrays.copyOf(indices, sparseLength);
            values = Arrays.copyOf(values, sparseLength);
        }
        return new SparseByteArrayImpl(sparseArray.length(), indices, values);
    }

    private static <T> void validateSparseArray(int length, int[] indices, T values, ToIntFunction<T> valuesLengthFunction) {
        VectorData.validateSparseArray(length, indices);
        Objects.requireNonNull(values, "values is null");
        int valuesLength = valuesLengthFunction.applyAsInt(values);
        if (valuesLength != indices.length) {
            throw new IllegalArgumentException("Values length " + valuesLength + " is not equal to indices length " + indices.length);
        }
    }

    private static void validateSparseArray(int length, int[] indices) {
        if (length < 0) {
            throw new IllegalArgumentException("length " + length + " is less than 0");
        }
        Objects.requireNonNull(indices, "indices is null");
        if (indices.length > 65535) {
            throw new IllegalArgumentException("indices length " + indices.length + " is greater than 65535");
        }
    }

    private static int getMaxDisplaySize(DecimalFormat decimalFormat) {
        int fractionDigits = decimalFormat.getMaximumFractionDigits();
        int integerDigits = decimalFormat.getMaximumIntegerDigits();
        return 1 + integerDigits + 1 + fractionDigits + 5;
    }

    public static int getMaxDisplaySize(VectorMetaData metaData) throws SQLException {
        int indicesLength;
        int valueCount;
        int valueDisplaySize;
        int vectorLength = metaData.length();
        if (vectorLength == -1) {
            vectorLength = 65535;
        }
        switch (metaData.type()) {
            case VECTOR: 
            case VECTOR_FLOAT64: {
                valueDisplaySize = Float64Decoder.MAX_DISPLAY_SIZE;
                valueCount = vectorLength;
                break;
            }
            case VECTOR_FLOAT32: {
                valueDisplaySize = Float32Decoder.MAX_DISPLAY_SIZE;
                valueCount = vectorLength;
                break;
            }
            case VECTOR_INT8: {
                valueDisplaySize = 4;
                valueCount = vectorLength;
                break;
            }
            case VECTOR_BINARY: {
                valueDisplaySize = 3;
                valueCount = (vectorLength + 7) / 8;
                break;
            }
            default: {
                throw DatabaseError.createSqlException(89, "Unrecognized type: " + String.valueOf(metaData.type()));
            }
        }
        int commaCount = valueCount - 1;
        int denseLength = 2 + commaCount + valueCount * valueDisplaySize;
        if (!metaData.isSparse()) {
            return denseLength;
        }
        if (vectorLength <= 10) {
            indicesLength = vectorLength;
        } else if (vectorLength <= 100) {
            indicesLength = 10 + (vectorLength - 10) * 2;
        } else if (vectorLength <= 1000) {
            indicesLength = 190 + (vectorLength - 100) * 3;
        } else if (vectorLength <= 10000) {
            indicesLength = 2890 + (vectorLength - 1000) * 4;
        } else {
            assert (vectorLength <= 65535) : "vectorLength=" + vectorLength;
            indicesLength = 38890 + (vectorLength - 10000) * 5;
        }
        return 2 + Integer.toString(vectorLength).length() + 1 + 2 + indicesLength + commaCount + (metaData.type() == OracleType.VECTOR_BINARY ? 0 : denseLength);
    }

    private static final class SparseBooleanArrayImpl
    extends SparseArrayImpl
    implements VECTOR.SparseBooleanArray {
        private SparseBooleanArrayImpl(int length, int[] indices) {
            super(length, indices);
        }

        @Override
        int valuesHashCode() {
            return 0;
        }

        @Override
        boolean valuesEquals(VECTOR.SparseArray sparseArray) {
            return sparseArray instanceof VECTOR.SparseBooleanArray;
        }
    }

    private static final class SparseByteArrayImpl
    extends SparseArrayImpl
    implements VECTOR.SparseByteArray {
        private final byte[] values;

        private SparseByteArrayImpl(int length, int[] indices, byte[] values) {
            super(length, indices);
            this.values = values;
        }

        @Override
        public byte[] values() {
            return this.values;
        }

        @Override
        int valuesHashCode() {
            return Arrays.hashCode(this.values);
        }

        @Override
        boolean valuesEquals(VECTOR.SparseArray sparseArray) {
            if (!(sparseArray instanceof VECTOR.SparseByteArray)) {
                return false;
            }
            VECTOR.SparseByteArray sparseByteArray = (VECTOR.SparseByteArray)sparseArray;
            return Arrays.equals(this.values, sparseByteArray.values());
        }
    }

    private static final class SparseFloatArrayImpl
    extends SparseArrayImpl
    implements VECTOR.SparseFloatArray {
        private final float[] values;

        private SparseFloatArrayImpl(int length, int[] indices, float[] values) {
            super(length, indices);
            this.values = values;
        }

        @Override
        public float[] values() {
            return this.values;
        }

        @Override
        int valuesHashCode() {
            return Arrays.hashCode(this.values);
        }

        @Override
        boolean valuesEquals(VECTOR.SparseArray sparseArray) {
            if (!(sparseArray instanceof VECTOR.SparseFloatArray)) {
                return false;
            }
            VECTOR.SparseFloatArray sparseFloatArray = (VECTOR.SparseFloatArray)sparseArray;
            return Arrays.equals(this.values, sparseFloatArray.values());
        }
    }

    private static final class SparseDoubleArrayImpl
    extends SparseArrayImpl
    implements VECTOR.SparseDoubleArray {
        private final double[] values;

        private SparseDoubleArrayImpl(int length, int[] indices, double[] values) {
            super(length, indices);
            this.values = values;
        }

        @Override
        public double[] values() {
            return this.values;
        }

        @Override
        int valuesHashCode() {
            return Arrays.hashCode(this.values);
        }

        @Override
        boolean valuesEquals(VECTOR.SparseArray sparseArray) {
            if (!(sparseArray instanceof VECTOR.SparseDoubleArray)) {
                return false;
            }
            VECTOR.SparseDoubleArray sparseDoubleArray = (VECTOR.SparseDoubleArray)sparseArray;
            return Arrays.equals(this.values, sparseDoubleArray.values());
        }
    }

    private static abstract class SparseArrayImpl
    implements VECTOR.SparseArray {
        private final int length;
        private final int[] indices;

        private SparseArrayImpl(int length, int[] indices) {
            this.length = length;
            this.indices = indices;
        }

        @Override
        public int length() {
            return this.length;
        }

        @Override
        public int[] indices() {
            return this.indices;
        }

        abstract int valuesHashCode();

        abstract boolean valuesEquals(VECTOR.SparseArray var1);

        @Override
        public String toString() {
            try {
                byte[] encoding = VectorData.encode(this, OracleType.VECTOR, false);
                return VectorData.decode(encoding, String.class, true);
            }
            catch (SQLException sqlException) {
                return "INVALID SPARSE ARRAY: " + sqlException.getMessage();
            }
        }

        public int hashCode() {
            int lengthIndicesHashCode = Arrays.deepHashCode(new Object[]{this.length, this.indices});
            int valuesHashCode = this.valuesHashCode();
            return 31 * lengthIndicesHashCode + valuesHashCode;
        }

        public boolean equals(Object object) {
            if (!(object instanceof VECTOR.SparseArray)) {
                return false;
            }
            VECTOR.SparseArray sparseArray = (VECTOR.SparseArray)object;
            if (this.length != sparseArray.length()) {
                return false;
            }
            if (!Arrays.equals(this.indices, sparseArray.indices())) {
                return false;
            }
            return this.valuesEquals(sparseArray);
        }
    }

    private static final class BooleanArrayConverter
    implements ArrayConverter<boolean[]> {
        private static final BooleanArrayConverter INSTANCE = new BooleanArrayConverter();

        private BooleanArrayConverter() {
        }

        @Override
        public int getLength(boolean[] array) {
            return array.length;
        }

        @Override
        public double getDouble(boolean[] array, int index) {
            return array[index] ? 1.0 : 0.0;
        }

        @Override
        public float getFloat(boolean[] array, int index) {
            return array[index] ? 1.0f : 0.0f;
        }

        @Override
        public byte getByte(boolean[] array, int index) {
            return array[index] ? (byte)1 : 0;
        }

        @Override
        public boolean getBoolean(boolean[] array, int index) {
            return array[index];
        }

        @Override
        public void swap(boolean[] array, int from, int to) {
            boolean toValue = array[to];
            array[to] = array[from];
            array[from] = toValue;
        }

        @Override
        public boolean[] copyOf(boolean[] array, int length) {
            return Arrays.copyOf(array, length);
        }
    }

    private static final class ByteArrayConverter
    implements ArrayConverter<byte[]> {
        private static final ByteArrayConverter INSTANCE = new ByteArrayConverter();

        private ByteArrayConverter() {
        }

        @Override
        public int getLength(byte[] array) {
            return array.length;
        }

        @Override
        public double getDouble(byte[] array, int index) {
            return array[index];
        }

        @Override
        public float getFloat(byte[] array, int index) {
            return array[index];
        }

        @Override
        public byte getByte(byte[] array, int index) {
            return array[index];
        }

        @Override
        public boolean getBoolean(byte[] array, int index) {
            return array[index] != 0;
        }

        @Override
        public void swap(byte[] array, int from, int to) {
            byte toValue = array[to];
            array[to] = array[from];
            array[from] = toValue;
        }

        @Override
        public byte[] copyOf(byte[] array, int length) {
            return Arrays.copyOf(array, length);
        }
    }

    private static final class ShortArrayConverter
    implements ArrayConverter<short[]> {
        private static final ShortArrayConverter INSTANCE = new ShortArrayConverter();

        private ShortArrayConverter() {
        }

        @Override
        public int getLength(short[] array) {
            return array.length;
        }

        @Override
        public double getDouble(short[] array, int index) {
            return array[index];
        }

        @Override
        public float getFloat(short[] array, int index) {
            return array[index];
        }

        @Override
        public byte getByte(short[] array, int index) {
            return (byte)array[index];
        }

        @Override
        public boolean getBoolean(short[] array, int index) {
            return array[index] != 0;
        }

        @Override
        public void swap(short[] array, int from, int to) {
            short toValue = array[to];
            array[to] = array[from];
            array[from] = toValue;
        }

        @Override
        public short[] copyOf(short[] array, int length) {
            return Arrays.copyOf(array, length);
        }
    }

    private static final class IntArrayConverter
    implements ArrayConverter<int[]> {
        private static final IntArrayConverter INSTANCE = new IntArrayConverter();

        private IntArrayConverter() {
        }

        @Override
        public int getLength(int[] array) {
            return array.length;
        }

        @Override
        public double getDouble(int[] array, int index) {
            return array[index];
        }

        @Override
        public float getFloat(int[] array, int index) {
            return array[index];
        }

        @Override
        public byte getByte(int[] array, int index) {
            return (byte)array[index];
        }

        @Override
        public boolean getBoolean(int[] array, int index) {
            return array[index] != 0;
        }

        @Override
        public void swap(int[] array, int from, int to) {
            int toValue = array[to];
            array[to] = array[from];
            array[from] = toValue;
        }

        @Override
        public int[] copyOf(int[] array, int length) {
            return Arrays.copyOf(array, length);
        }
    }

    private static final class LongArrayConverter
    implements ArrayConverter<long[]> {
        private static final LongArrayConverter INSTANCE = new LongArrayConverter();

        private LongArrayConverter() {
        }

        @Override
        public int getLength(long[] array) {
            return array.length;
        }

        @Override
        public double getDouble(long[] array, int index) {
            return array[index];
        }

        @Override
        public float getFloat(long[] array, int index) {
            return array[index];
        }

        @Override
        public byte getByte(long[] array, int index) {
            return (byte)array[index];
        }

        @Override
        public boolean getBoolean(long[] array, int index) {
            return array[index] != 0L;
        }

        @Override
        public void swap(long[] array, int from, int to) {
            long toValue = array[to];
            array[to] = array[from];
            array[from] = toValue;
        }

        @Override
        public long[] copyOf(long[] array, int length) {
            return Arrays.copyOf(array, length);
        }
    }

    private static final class FloatArrayConverter
    implements ArrayConverter<float[]> {
        private static final FloatArrayConverter INSTANCE = new FloatArrayConverter();

        private FloatArrayConverter() {
        }

        @Override
        public int getLength(float[] array) {
            return array.length;
        }

        @Override
        public double getDouble(float[] array, int index) {
            return array[index];
        }

        @Override
        public float getFloat(float[] array, int index) {
            return array[index];
        }

        @Override
        public byte getByte(float[] array, int index) {
            return (byte)array[index];
        }

        @Override
        public boolean getBoolean(float[] array, int index) {
            return array[index] != 0.0f;
        }

        @Override
        public void swap(float[] array, int from, int to) {
            float toValue = array[to];
            array[to] = array[from];
            array[from] = toValue;
        }

        @Override
        public float[] copyOf(float[] array, int length) {
            return Arrays.copyOf(array, length);
        }
    }

    private static final class DoubleArrayConverter
    implements ArrayConverter<double[]> {
        private static final DoubleArrayConverter INSTANCE = new DoubleArrayConverter();

        private DoubleArrayConverter() {
        }

        @Override
        public int getLength(double[] array) {
            return array.length;
        }

        @Override
        public double getDouble(double[] array, int index) {
            return array[index];
        }

        @Override
        public float getFloat(double[] array, int index) {
            return (float)array[index];
        }

        @Override
        public byte getByte(double[] array, int index) {
            return (byte)array[index];
        }

        @Override
        public boolean getBoolean(double[] array, int index) {
            return array[index] != 0.0;
        }

        @Override
        public void swap(double[] array, int from, int to) {
            double toValue = array[to];
            array[to] = array[from];
            array[from] = toValue;
        }

        @Override
        public double[] copyOf(double[] array, int length) {
            return Arrays.copyOf(array, length);
        }
    }

    private static interface ArrayConverter<T> {
        public int getLength(T var1);

        public double getDouble(T var1, int var2);

        public float getFloat(T var1, int var2);

        public byte getByte(T var1, int var2);

        public boolean getBoolean(T var1, int var2);

        public void swap(T var1, int var2, int var3);

        public T copyOf(T var1, int var2);

        default public T toDenseArray(int length, int[] indices, T values) {
            T denseArray = this.copyOf(values, length);
            for (int i = indices.length - 1; i >= 0; --i) {
                this.swap(denseArray, i, indices[i]);
            }
            return denseArray;
        }

        default public double[] toDoubleArray(T array) {
            if (array instanceof double[]) {
                return (double[])array;
            }
            double[] doubleArray = new double[this.getLength(array)];
            for (int i = 0; i < doubleArray.length; ++i) {
                doubleArray[i] = this.getDouble(array, i);
            }
            return doubleArray;
        }

        default public float[] toFloatArray(T array) {
            if (array instanceof float[]) {
                return (float[])array;
            }
            float[] floatArray = new float[this.getLength(array)];
            for (int i = 0; i < floatArray.length; ++i) {
                floatArray[i] = this.getFloat(array, i);
            }
            return floatArray;
        }

        default public byte[] toByteArray(T array) {
            if (array instanceof byte[]) {
                return (byte[])array;
            }
            byte[] byteArray = new byte[this.getLength(array)];
            for (int i = 0; i < byteArray.length; ++i) {
                byteArray[i] = this.getByte(array, i);
            }
            return byteArray;
        }

        default public int[] compactNonZeroValues(T array) {
            int denseLength = this.getLength(array);
            int[] indices = new int[denseLength];
            int sparseLength = 0;
            for (int i = 0; i < denseLength; ++i) {
                if (!this.getBoolean(array, i)) continue;
                indices[sparseLength] = i;
                this.swap(array, i, sparseLength);
                ++sparseLength;
            }
            return Arrays.copyOf(indices, sparseLength);
        }

        default public VECTOR.SparseDoubleArray toSparseDoubleArray(T denseArray) {
            int[] indices = this.compactNonZeroValues(denseArray);
            double[] values = this.toDoubleArray(this.copyOf(denseArray, indices.length));
            return new SparseDoubleArrayImpl(this.getLength(denseArray), indices, values);
        }

        default public VECTOR.SparseFloatArray toSparseFloatArray(T denseArray) {
            int length = this.getLength(denseArray);
            float[] values = this.toFloatArray(denseArray);
            int[] indices = FloatArrayConverter.INSTANCE.compactNonZeroValues(values);
            values = FloatArrayConverter.INSTANCE.copyOf(values, indices.length);
            return new SparseFloatArrayImpl(length, indices, values);
        }

        default public VECTOR.SparseByteArray toSparseByteArray(T denseArray) {
            int length = this.getLength(denseArray);
            byte[] values = this.toByteArray(denseArray);
            int[] indices = ByteArrayConverter.INSTANCE.compactNonZeroValues(values);
            values = ByteArrayConverter.INSTANCE.copyOf(values, indices.length);
            return new SparseByteArrayImpl(length, indices, values);
        }

        default public VECTOR.SparseBooleanArray toSparseBooleanArray(T denseArray) {
            int length = this.getLength(denseArray);
            int indicesLength = 0;
            int[] indices = new int[length];
            for (int i = 0; i < length; ++i) {
                if (!this.getBoolean(denseArray, i)) continue;
                indices[indicesLength++] = i;
            }
            indices = Arrays.copyOf(indices, indicesLength);
            return new SparseBooleanArrayImpl(length, indices);
        }
    }

    private static final class SparseBooleanValuesEncoder
    extends Encoder<VECTOR.SparseBooleanArray> {
        static final SparseBooleanValuesEncoder FLOAT64_ENCODER = new SparseBooleanValuesEncoder(Float64Encoder.INSTANCE, new double[]{1.0});
        static final SparseBooleanValuesEncoder FLOAT32_ENCODER = new SparseBooleanValuesEncoder(Float32Encoder.INSTANCE, new float[]{1.0f});
        static final SparseBooleanValuesEncoder INT8_ENCODER = new SparseBooleanValuesEncoder(Int8Encoder.INSTANCE, new byte[]{1});
        private final int valueByteLength;
        private final short flag1;
        private final byte[] oneEncoding;

        <T> SparseBooleanValuesEncoder(Encoder<T> dimensionEncoder, T one) {
            super(dimensionEncoder.version, dimensionEncoder.dimensionType);
            this.valueByteLength = dimensionEncoder.getMaximumValuesByteLength(one);
            this.flag1 = dimensionEncoder.getFlag1();
            SimpleByteArray dimensionByteArray = new SimpleByteArray(CommonDiagnosable.getInstance(), new byte[this.valueByteLength]);
            try {
                dimensionEncoder.encodeValues(one, dimensionByteArray);
            }
            catch (SQLException sqlException) {
                throw new IllegalStateException(sqlException);
            }
            this.oneEncoding = dimensionByteArray.bytes;
        }

        @Override
        short getFlag1() {
            return this.flag1;
        }

        @Override
        int getDimensionCount(VECTOR.SparseBooleanArray values) {
            return values.indices().length;
        }

        @Override
        int getMaximumValuesByteLength(VECTOR.SparseBooleanArray values) {
            return this.valueByteLength * values.indices().length;
        }

        @Override
        double computeNorm(VECTOR.SparseBooleanArray values) {
            return Math.sqrt(values.indices().length);
        }

        @Override
        void encodeValues(VECTOR.SparseBooleanArray values, ByteArray dataBuffer) throws SQLException {
            for (int i = 0; i < values.indices().length; ++i) {
                dataBuffer.put(this.oneEncoding);
            }
        }
    }

    private static final class NarrowingSparseEncoder<T extends VECTOR.SparseArray, U, R extends VECTOR.SparseArray>
    extends SparseEncoder<T, U> {
        private static final NarrowingSparseEncoder<VECTOR.SparseDoubleArray, double[], VECTOR.SparseFloatArray> DOUBLE_TO_FLOAT32 = new NarrowingSparseEncoder<VECTOR.SparseDoubleArray, double[], VECTOR.SparseFloatArray>(VECTOR.SparseDoubleArray::values, Float32ConversionEncoder.DOUBLE_ENCODER, x$0 -> VectorData.toSparseFloatArray(x$0), SparseEncoder.FLOAT_TO_FLOAT32);
        private static final NarrowingSparseEncoder<VECTOR.SparseDoubleArray, double[], VECTOR.SparseByteArray> DOUBLE_TO_INT8 = new NarrowingSparseEncoder<VECTOR.SparseDoubleArray, double[], VECTOR.SparseByteArray>(VECTOR.SparseDoubleArray::values, Int8ConversionEncoder.DOUBLE_ENCODER, x$0 -> VectorData.toSparseByteArray(x$0), SparseEncoder.BYTE_TO_INT8);
        private static final NarrowingSparseEncoder<VECTOR.SparseFloatArray, float[], VECTOR.SparseByteArray> FLOAT_TO_INT8 = new NarrowingSparseEncoder<VECTOR.SparseFloatArray, float[], VECTOR.SparseByteArray>(VECTOR.SparseFloatArray::values, Int8ConversionEncoder.FLOAT_ENCODER, x$0 -> VectorData.toSparseByteArray(x$0), SparseEncoder.BYTE_TO_INT8);
        private final Function<T, R> narrowingConversion;
        private final SparseEncoder<R, ?> narrowedSparseArrayEncoder;

        private NarrowingSparseEncoder(Function<T, U> getWideValuesFunction, Encoder<U> wideDimensionsEncoder, Function<T, R> conversionFunction, SparseEncoder<R, ?> narrowedSparseArrayEncoder) {
            super(getWideValuesFunction, wideDimensionsEncoder);
            this.narrowingConversion = conversionFunction;
            this.narrowedSparseArrayEncoder = narrowedSparseArrayEncoder;
        }

        @Override
        protected void encodeValues(T sparseArray, ByteArray dataBuffer) throws SQLException {
            this.narrowedSparseArrayEncoder.encodeValues((R)((VECTOR.SparseArray)this.narrowingConversion.apply(sparseArray)), dataBuffer);
        }
    }

    private static class SparseEncoder<T extends VECTOR.SparseArray, U>
    extends Encoder<T> {
        private static final SparseEncoder<VECTOR.SparseDoubleArray, double[]> DOUBLE_TO_FLOAT64 = new SparseEncoder<VECTOR.SparseDoubleArray, double[]>(VECTOR.SparseDoubleArray::values, Float64Encoder.INSTANCE);
        private static final SparseEncoder<VECTOR.SparseFloatArray, float[]> FLOAT_TO_FLOAT64 = new SparseEncoder<VECTOR.SparseFloatArray, float[]>(VECTOR.SparseFloatArray::values, Float64ConversionEncoder.FLOAT_ENCODER);
        private static final SparseEncoder<VECTOR.SparseByteArray, byte[]> BYTE_TO_FLOAT64 = new SparseEncoder<VECTOR.SparseByteArray, byte[]>(VECTOR.SparseByteArray::values, Float64ConversionEncoder.BYTE_ENCODER);
        private static final SparseEncoder<VECTOR.SparseBooleanArray, VECTOR.SparseBooleanArray> BOOLEAN_TO_FLOAT64 = new SparseEncoder(Function.identity(), SparseBooleanValuesEncoder.FLOAT64_ENCODER);
        private static final SparseEncoder<VECTOR.SparseFloatArray, float[]> FLOAT_TO_FLOAT32 = new SparseEncoder<VECTOR.SparseFloatArray, float[]>(VECTOR.SparseFloatArray::values, Float32Encoder.INSTANCE);
        private static final SparseEncoder<VECTOR.SparseByteArray, byte[]> BYTE_TO_FLOAT32 = new SparseEncoder<VECTOR.SparseByteArray, byte[]>(VECTOR.SparseByteArray::values, Float32ConversionEncoder.BYTE_ENCODER);
        private static final SparseEncoder<VECTOR.SparseBooleanArray, VECTOR.SparseBooleanArray> BOOLEAN_TO_FLOAT32 = new SparseEncoder(Function.identity(), SparseBooleanValuesEncoder.FLOAT32_ENCODER);
        private static final SparseEncoder<VECTOR.SparseByteArray, byte[]> BYTE_TO_INT8 = new SparseEncoder<VECTOR.SparseByteArray, byte[]>(VECTOR.SparseByteArray::values, Int8Encoder.INSTANCE);
        private static final SparseEncoder<VECTOR.SparseBooleanArray, VECTOR.SparseBooleanArray> BOOLEAN_TO_INT8 = new SparseEncoder(Function.identity(), SparseBooleanValuesEncoder.INT8_ENCODER);
        private static final SparseEncoder<VECTOR.SparseBooleanArray, byte[]> BOOLEAN_TO_BINARY = new SparseEncoder<VECTOR.SparseBooleanArray, byte[]>(sparseByteArray -> PhysicalConnection.EMPTY_BYTE_ARRAY, BinaryEncoder.INSTANCE);
        private final Function<T, U> getValuesFunction;
        protected final Encoder<U> dimensionsEncoder;
        private final short flag1;

        private SparseEncoder(Function<T, U> getValuesFunction, Encoder<U> dimensionsEncoder) {
            super((byte)2, dimensionsEncoder.dimensionType);
            this.getValuesFunction = getValuesFunction;
            this.dimensionsEncoder = dimensionsEncoder;
            this.flag1 = (short)(0x20 | dimensionsEncoder.getFlag1());
        }

        @Override
        final short getFlag1() {
            return this.flag1;
        }

        @Override
        final int getDimensionCount(T sparseArray) {
            return sparseArray.length();
        }

        @Override
        final int getMaximumValuesByteLength(T sparseArray) {
            U values = this.getValuesFunction.apply(sparseArray);
            return 2 + (sparseArray.indices().length << 2) + this.dimensionsEncoder.getMaximumValuesByteLength(values);
        }

        @Override
        final double computeNorm(T sparseArray) {
            U values = this.getValuesFunction.apply(sparseArray);
            return this.dimensionsEncoder.computeNorm(values);
        }

        @Override
        protected void encodeValues(T sparseArray, ByteArray dataBuffer) throws SQLException {
            int[] indices = sparseArray.indices();
            dataBuffer.putShort((short)indices.length);
            dataBuffer.putInts(indices);
            U values = this.getValuesFunction.apply(sparseArray);
            this.dimensionsEncoder.encodeValues(values, dataBuffer);
        }
    }

    static final class BinaryConversionEncoder<T>
    extends AbstractBinaryEncoder<T> {
        private static final BinaryConversionEncoder<boolean[]> BOOLEAN_ENCODER = new BinaryConversionEncoder<boolean[]>(BooleanArrayConverter.INSTANCE);
        private final ArrayConverter<T> converter;

        BinaryConversionEncoder(ArrayConverter<T> converter) {
            this.converter = converter;
        }

        @Override
        void encodeValues(T values, ByteArray data) throws SQLException {
            int bufferIndex;
            int length = this.getDimensionCount(values);
            int byteLength = length >> 3;
            int bufferSize = Math.min(byteLength, 16384);
            byte[] buffer = new byte[bufferSize];
            int bitIndex = 0;
            for (int byteIndex = 0; byteIndex < byteLength; byteIndex += bufferIndex) {
                bufferIndex = 0;
                while (bufferIndex < buffer.length && bitIndex < length) {
                    int bits = 0;
                    int mask = 128;
                    for (int b = 0; b < 8; ++b) {
                        if (this.converter.getBoolean(values, bitIndex++)) {
                            bits |= mask;
                        }
                        mask >>= 1;
                    }
                    buffer[bufferIndex++] = (byte)bits;
                }
                data.put(buffer);
            }
            if (bitIndex < length) {
                int bits = 0;
                int mask = 128;
                do {
                    if (this.converter.getBoolean(values, bitIndex++)) {
                        bits |= mask;
                    }
                    mask >>= 1;
                } while (bitIndex < length);
                data.put((byte)bits);
            }
        }

        @Override
        int getDimensionCount(T values) {
            return this.converter.getLength(values);
        }
    }

    private static final class BinaryEncoder
    extends AbstractBinaryEncoder<byte[]> {
        private static final BinaryEncoder INSTANCE = new BinaryEncoder();

        private BinaryEncoder() {
        }

        @Override
        void encodeValues(byte[] values, ByteArray data) throws SQLException {
            data.put(values);
        }

        @Override
        int getDimensionCount(byte[] values) {
            return values.length << 3;
        }
    }

    private static abstract class AbstractBinaryEncoder<T>
    extends Encoder<T> {
        AbstractBinaryEncoder() {
            super((byte)1, (byte)5);
        }

        @Override
        final short getFlag1() {
            return 16;
        }

        @Override
        final double computeNorm(T values) {
            return 0.0;
        }

        @Override
        final int getMaximumValuesByteLength(T values) {
            return this.getDimensionCount(values) + 7 >> 3;
        }
    }

    static final class Int8ConversionEncoder<T>
    extends AbstractInt8Encoder<T> {
        private static final Int8ConversionEncoder<double[]> DOUBLE_ENCODER = new Int8ConversionEncoder<double[]>(DoubleArrayConverter.INSTANCE);
        private static final Int8ConversionEncoder<float[]> FLOAT_ENCODER = new Int8ConversionEncoder<float[]>(FloatArrayConverter.INSTANCE);
        private static final Int8ConversionEncoder<long[]> LONG_ENCODER = new Int8ConversionEncoder<long[]>(LongArrayConverter.INSTANCE);
        private static final Int8ConversionEncoder<int[]> INT_ENCODER = new Int8ConversionEncoder<int[]>(IntArrayConverter.INSTANCE);
        private static final Int8ConversionEncoder<short[]> SHORT_ENCODER = new Int8ConversionEncoder<short[]>(ShortArrayConverter.INSTANCE);
        private static final Int8ConversionEncoder<boolean[]> BOOLEAN_ENCODER = new Int8ConversionEncoder<boolean[]>(BooleanArrayConverter.INSTANCE);
        private final ArrayConverter<T> converter;

        Int8ConversionEncoder(ArrayConverter<T> converter) {
            this.converter = converter;
        }

        @Override
        void encodeValues(T values, ByteArray data) throws SQLException {
            int length = this.getDimensionCount(values);
            for (int i = 0; i < length; ++i) {
                data.put(this.converter.getByte(values, i));
            }
        }

        @Override
        double computeNorm(T values) {
            int length = this.getDimensionCount(values);
            long squareSum = 0L;
            for (int i = 0; i < length; ++i) {
                byte value = this.converter.getByte(values, i);
                squareSum += (long)(value * value);
            }
            return Math.sqrt(squareSum);
        }

        @Override
        int getDimensionCount(T values) {
            return this.converter.getLength(values);
        }
    }

    private static final class Int8Encoder
    extends AbstractInt8Encoder<byte[]> {
        private static final Int8Encoder INSTANCE = new Int8Encoder();

        private Int8Encoder() {
        }

        @Override
        int getDimensionCount(byte[] values) {
            return values.length;
        }

        @Override
        void encodeValues(byte[] values, ByteArray data) throws SQLException {
            data.put(values);
        }

        @Override
        double computeNorm(byte[] values) {
            long squareSum = 0L;
            for (byte value : values) {
                squareSum += (long)(value * value);
            }
            return Math.sqrt(squareSum);
        }
    }

    private static abstract class AbstractInt8Encoder<T>
    extends Encoder<T> {
        AbstractInt8Encoder() {
            super((byte)0, (byte)4);
        }

        @Override
        final int getMaximumValuesByteLength(T values) {
            return this.getDimensionCount(values);
        }

        @Override
        final short getFlag1() {
            return 18;
        }
    }

    static final class Float32ConversionEncoder<T>
    extends AbstractFloat32Encoder<T> {
        private static final Float32ConversionEncoder<double[]> DOUBLE_ENCODER = new Float32ConversionEncoder<double[]>(DoubleArrayConverter.INSTANCE);
        private static final Float32ConversionEncoder<long[]> LONG_ENCODER = new Float32ConversionEncoder<long[]>(LongArrayConverter.INSTANCE);
        private static final Float32ConversionEncoder<int[]> INT_ENCODER = new Float32ConversionEncoder<int[]>(IntArrayConverter.INSTANCE);
        private static final Float32ConversionEncoder<short[]> SHORT_ENCODER = new Float32ConversionEncoder<short[]>(ShortArrayConverter.INSTANCE);
        private static final Float32ConversionEncoder<byte[]> BYTE_ENCODER = new Float32ConversionEncoder<byte[]>(ByteArrayConverter.INSTANCE);
        private static final Float32ConversionEncoder<boolean[]> BOOLEAN_ENCODER = new Float32ConversionEncoder<boolean[]>(BooleanArrayConverter.INSTANCE);
        private final ArrayConverter<T> converter;

        Float32ConversionEncoder(ArrayConverter<T> converter) {
            this.converter = converter;
        }

        @Override
        int getDimensionCount(T values) {
            return this.converter.getLength(values);
        }

        @Override
        void encodeValues(T values, ByteArray data) throws SQLException {
            int length = this.getDimensionCount(values);
            int bufferSize = Math.min(length, 4096);
            float[] buffer = new float[bufferSize];
            int valueIndex = 0;
            while (valueIndex < length) {
                int bufferIndex = 0;
                while (bufferIndex < buffer.length && valueIndex < length) {
                    buffer[bufferIndex++] = this.converter.getFloat(values, valueIndex++);
                }
                data.putFloats(buffer, 0, bufferIndex, NUMBER_ENCODING);
            }
        }

        @Override
        ArrayConverter<T> getArrayConverter() {
            return this.converter;
        }
    }

    private static final class Float32Encoder
    extends AbstractFloat32Encoder<float[]> {
        private static final Float32Encoder INSTANCE = new Float32Encoder();

        private Float32Encoder() {
        }

        @Override
        int getDimensionCount(float[] values) {
            return values.length;
        }

        @Override
        void encodeValues(float[] values, ByteArray data) throws SQLException {
            data.putFloats(values, NUMBER_ENCODING);
        }

        @Override
        ArrayConverter<float[]> getArrayConverter() {
            return FloatArrayConverter.INSTANCE;
        }
    }

    private static abstract class AbstractFloat32Encoder<T>
    extends Encoder<T> {
        AbstractFloat32Encoder() {
            super((byte)0, (byte)2);
        }

        @Override
        final int getMaximumValuesByteLength(T values) {
            return this.getDimensionCount(values) << 2;
        }

        @Override
        final short getFlag1() {
            return (short)(0x12 | VectorData.getFlag1FormatBits(NUMBER_ENCODING));
        }

        @Override
        final double computeNorm(T values) {
            ArrayConverter<T> converter = this.getArrayConverter();
            int length = converter.getLength(values);
            double squareSum = 0.0;
            for (int i = 0; i < length; ++i) {
                double value = converter.getDouble(values, i);
                squareSum += value * value;
            }
            return Math.sqrt(squareSum);
        }

        abstract ArrayConverter<T> getArrayConverter();
    }

    private static final class Float64ConversionEncoder<T>
    extends AbstractFloat64Encoder<T> {
        private static final Float64ConversionEncoder<float[]> FLOAT_ENCODER = new Float64ConversionEncoder<float[]>(FloatArrayConverter.INSTANCE);
        private static final Float64ConversionEncoder<long[]> LONG_ENCODER = new Float64ConversionEncoder<long[]>(LongArrayConverter.INSTANCE);
        private static final Float64ConversionEncoder<int[]> INT_ENCODER = new Float64ConversionEncoder<int[]>(IntArrayConverter.INSTANCE);
        private static final Float64ConversionEncoder<short[]> SHORT_ENCODER = new Float64ConversionEncoder<short[]>(ShortArrayConverter.INSTANCE);
        private static final Float64ConversionEncoder<byte[]> BYTE_ENCODER = new Float64ConversionEncoder<byte[]>(ByteArrayConverter.INSTANCE);
        private static final Float64ConversionEncoder<boolean[]> BOOLEAN_ENCODER = new Float64ConversionEncoder<boolean[]>(BooleanArrayConverter.INSTANCE);
        private final ArrayConverter<T> converter;

        Float64ConversionEncoder(ArrayConverter<T> converter) {
            this.converter = converter;
        }

        @Override
        int getDimensionCount(T values) {
            return this.converter.getLength(values);
        }

        @Override
        void encodeValues(T values, ByteArray data) throws SQLException {
            int length = this.getDimensionCount(values);
            int bufferSize = Math.min(length, 2048);
            double[] buffer = new double[bufferSize];
            int valueIndex = 0;
            while (valueIndex < length) {
                int bufferIndex = 0;
                while (bufferIndex < buffer.length && valueIndex < length) {
                    buffer[bufferIndex++] = this.converter.getDouble(values, valueIndex++);
                }
                data.putDoubles(buffer, 0, bufferIndex, NUMBER_ENCODING);
            }
        }

        @Override
        ArrayConverter<T> getArrayConverter() {
            return this.converter;
        }
    }

    private static final class Float64Encoder
    extends AbstractFloat64Encoder<double[]> {
        private static final Float64Encoder INSTANCE = new Float64Encoder();

        private Float64Encoder() {
        }

        @Override
        int getDimensionCount(double[] values) {
            return values.length;
        }

        @Override
        void encodeValues(double[] values, ByteArray data) throws SQLException {
            data.putDoubles(values, NUMBER_ENCODING);
        }

        @Override
        ArrayConverter<double[]> getArrayConverter() {
            return DoubleArrayConverter.INSTANCE;
        }
    }

    private static abstract class AbstractFloat64Encoder<T>
    extends Encoder<T> {
        AbstractFloat64Encoder() {
            super((byte)0, (byte)3);
        }

        @Override
        final int getMaximumValuesByteLength(T values) {
            return this.getDimensionCount(values) << 3;
        }

        @Override
        final short getFlag1() {
            return (short)(0x12 | VectorData.getFlag1FormatBits(NUMBER_ENCODING));
        }

        @Override
        final double computeNorm(T values) {
            ArrayConverter<T> converter = this.getArrayConverter();
            int length = converter.getLength(values);
            double squareSum = 0.0;
            for (int i = 0; i < length; ++i) {
                double value = converter.getDouble(values, i);
                squareSum += value * value;
            }
            return Math.sqrt(squareSum);
        }

        abstract ArrayConverter<T> getArrayConverter();
    }

    static abstract class Encoder<T> {
        protected static final ByteArray.NumberEncoding NUMBER_ENCODING = Encoder.getNumberEncoding();
        private final byte version;
        private final byte dimensionType;

        private static ByteArray.NumberEncoding getNumberEncoding() {
            String configuredEncoding = System.getProperty("oracle.jdbc.vectorEncoding");
            if (configuredEncoding == null) {
                return ByteArray.NumberEncoding.ORACLE_BIG_ENDIAN;
            }
            try {
                return ByteArray.NumberEncoding.valueOf(configuredEncoding);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                illegalArgumentException.printStackTrace();
                return ByteArray.NumberEncoding.ORACLE_BIG_ENDIAN;
            }
        }

        Encoder(byte version, byte dimensionType) {
            this.version = version;
            this.dimensionType = dimensionType;
        }

        final int getMaximumByteLength(T values) {
            return 17 + this.getMaximumValuesByteLength(values);
        }

        abstract int getMaximumValuesByteLength(T var1);

        final void encode(T values, boolean isComputingNorm, ByteArray data) throws SQLException {
            isComputingNorm &= this.dimensionType != 5;
            data.put((byte)-37);
            data.put(this.version);
            data.putShort(this.getFlag1());
            data.put(this.dimensionType);
            data.putInt(this.getDimensionCount(values));
            if (isComputingNorm) {
                data.putDouble(this.computeNorm(values), NUMBER_ENCODING);
            } else {
                data.putLong(0L);
            }
            this.encodeValues(values, data);
        }

        abstract short getFlag1();

        abstract double computeNorm(T var1);

        abstract void encodeValues(T var1, ByteArray var2) throws SQLException;

        abstract int getDimensionCount(T var1);
    }

    private static final class SparseBinaryDecoder
    extends Decoder<byte[]> {
        SparseBinaryDecoder() {
            super(OracleType.VECTOR_BINARY);
        }

        @Override
        byte[] decodePreferredArrayClass(ByteArray data, int length) throws SQLException {
            return this.decodeBytes(data, length);
        }

        @Override
        ArrayConverter<byte[]> preferredArrayConverter() {
            return ByteArrayConverter.INSTANCE;
        }

        @Override
        byte[] decodeBytes(ByteArray data, int length) throws SQLException {
            int[] indices = SparseDecoder.decodeIndices(data);
            byte[] packedBitArray = new byte[length >> 3];
            for (int index : indices) {
                int byteIndex;
                int bitIndex = index & 7;
                int packedBit = 128 >> bitIndex;
                int n = byteIndex = index >> 3;
                packedBitArray[n] = (byte)(packedBitArray[n] | packedBit);
            }
            return packedBitArray;
        }

        @Override
        boolean[] decodeBooleans(ByteArray data, int length) throws SQLException {
            int[] indices = SparseDecoder.decodeIndices(data);
            boolean[] booleans = new boolean[length];
            for (int index : indices) {
                booleans[index] = true;
            }
            return booleans;
        }

        @Override
        VECTOR.SparseBooleanArray decodeSparseBooleanArray(ByteArray data, int length) throws SQLException {
            int[] indices = SparseDecoder.decodeIndices(data);
            return new SparseBooleanArrayImpl(length, indices);
        }

        @Override
        String decodeString(ByteArray data, int length) throws SQLException {
            StringBuilder stringBuilder = new StringBuilder();
            SparseDecoder.decodeIndicesString(data, length, stringBuilder);
            return stringBuilder.append(']').toString();
        }

        @Override
        void discardValues(ByteArray data, int length) {
            SparseDecoder.discardIndices(data);
        }
    }

    private static final class SparseInt8Decoder
    extends SparseDecoder<byte[]> {
        SparseInt8Decoder(Int8Decoder dimensionsDecoder) {
            super(dimensionsDecoder);
        }
    }

    private static final class SparseFloat64Decoder
    extends SparseDecoder<double[]> {
        SparseFloat64Decoder(Float64Decoder dimensionsDecoder) {
            super(dimensionsDecoder);
        }

        @Override
        protected VECTOR.SparseFloatArray decodeSparseFloatArray(ByteArray data, int length) throws SQLException {
            return VectorData.toSparseFloatArray(this.decodeSparseDoubleArray(data, length));
        }

        @Override
        protected VECTOR.SparseByteArray decodeSparseByteArray(ByteArray data, int length) throws SQLException {
            return VectorData.toSparseByteArray(this.decodeSparseDoubleArray(data, length));
        }
    }

    private static final class SparseFloat32Decoder
    extends SparseDecoder<float[]> {
        SparseFloat32Decoder(Float32Decoder dimensionsDecoder) {
            super(dimensionsDecoder);
        }

        @Override
        protected VECTOR.SparseByteArray decodeSparseByteArray(ByteArray data, int length) throws SQLException {
            return VectorData.toSparseByteArray(this.decodeSparseFloatArray(data, length));
        }
    }

    private static class SparseDecoder<T>
    extends Decoder<T> {
        private final Decoder<T> dimensionsDecoder;

        private static <T> Decoder<T> getDecoder(Decoder<T> dimensionsDecoder) {
            if (dimensionsDecoder instanceof SparseDecoder) {
                return dimensionsDecoder;
            }
            Decoder sparseDecoder = dimensionsDecoder instanceof Float64Decoder ? new SparseFloat64Decoder((Float64Decoder)dimensionsDecoder) : (dimensionsDecoder instanceof Float32Decoder ? new SparseFloat32Decoder((Float32Decoder)dimensionsDecoder) : (dimensionsDecoder instanceof Int8Decoder ? new SparseInt8Decoder((Int8Decoder)dimensionsDecoder) : (dimensionsDecoder instanceof BinaryDecoder ? new SparseBinaryDecoder() : null)));
            SparseFloat64Decoder typedSparseDecoder = sparseDecoder;
            return typedSparseDecoder;
        }

        SparseDecoder(Decoder<T> dimensionsDecoder) {
            super(dimensionsDecoder.type);
            this.dimensionsDecoder = dimensionsDecoder;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        final Decoder<T> toIeee(ByteArray data, int length) throws SQLException {
            long position = data.getPosition();
            try {
                int indicesLength = SparseDecoder.discardIndices(data);
                Decoder<T> denseDecoder = this.dimensionsDecoder.toIeee(data, indicesLength);
                Decoder<T> decoder = denseDecoder.getSparseDecoder();
                return decoder;
            }
            finally {
                data.setPosition(position);
            }
        }

        @Override
        final boolean[] decodeBooleans(ByteArray data, int length) throws SQLException {
            int[] indices = SparseDecoder.decodeIndices(data);
            return BooleanArrayConverter.INSTANCE.toDenseArray(length, indices, this.dimensionsDecoder.decodeBooleans(data, indices.length));
        }

        @Override
        final byte[] decodeBytes(ByteArray data, int length) throws SQLException {
            int[] indices = SparseDecoder.decodeIndices(data);
            return ByteArrayConverter.INSTANCE.toDenseArray(length, indices, this.dimensionsDecoder.decodeBytes(data, indices.length));
        }

        @Override
        final short[] decodeShorts(ByteArray data, int length) throws SQLException {
            int[] indices = SparseDecoder.decodeIndices(data);
            return ShortArrayConverter.INSTANCE.toDenseArray(length, indices, this.dimensionsDecoder.decodeShorts(data, indices.length));
        }

        @Override
        final int[] decodeInts(ByteArray data, int length) throws SQLException {
            int[] indices = SparseDecoder.decodeIndices(data);
            return IntArrayConverter.INSTANCE.toDenseArray(length, indices, this.dimensionsDecoder.decodeInts(data, indices.length));
        }

        @Override
        final long[] decodeLongs(ByteArray data, int length) throws SQLException {
            int[] indices = SparseDecoder.decodeIndices(data);
            return LongArrayConverter.INSTANCE.toDenseArray(length, indices, this.dimensionsDecoder.decodeLongs(data, indices.length));
        }

        @Override
        final float[] decodeFloats(ByteArray data, int length) throws SQLException {
            int[] indices = SparseDecoder.decodeIndices(data);
            return FloatArrayConverter.INSTANCE.toDenseArray(length, indices, this.dimensionsDecoder.decodeFloats(data, indices.length));
        }

        @Override
        final double[] decodeDoubles(ByteArray data, int length) throws SQLException {
            int[] indices = SparseDecoder.decodeIndices(data);
            return DoubleArrayConverter.INSTANCE.toDenseArray(length, indices, this.dimensionsDecoder.decodeDoubles(data, indices.length));
        }

        @Override
        String decodeString(ByteArray data, int length) throws SQLException {
            StringBuilder stringBuilder = new StringBuilder();
            int indicesString = SparseDecoder.decodeIndicesString(data, length, stringBuilder);
            return stringBuilder.append(',').append(this.dimensionsDecoder.decodeString(data, indicesString)).append(']').toString();
        }

        static int decodeIndicesString(ByteArray data, int length, StringBuilder stringBuilder) {
            stringBuilder.append('[').append(length).append(',');
            stringBuilder.append('[');
            int indicesLength = data.getShort();
            for (int i = 0; i < indicesLength; ++i) {
                int value = data.getInt();
                if (i > 0) {
                    stringBuilder.append(',');
                }
                stringBuilder.append(value);
            }
            stringBuilder.append(']');
            return indicesLength;
        }

        @Override
        final T decodePreferredArrayClass(ByteArray data, int length) throws SQLException {
            int[] indices = SparseDecoder.decodeIndices(data);
            return this.preferredArrayConverter().toDenseArray(length, indices, this.dimensionsDecoder.decodePreferredArrayClass(data, indices.length));
        }

        @Override
        final ArrayConverter<T> preferredArrayConverter() {
            return this.dimensionsDecoder.preferredArrayConverter();
        }

        @Override
        protected VECTOR.SparseDoubleArray decodeSparseDoubleArray(ByteArray data, int length) throws SQLException {
            int[] indices = SparseDecoder.decodeIndices(data);
            double[] values = this.dimensionsDecoder.decodeDoubles(data, indices.length);
            return new SparseDoubleArrayImpl(length, indices, values);
        }

        @Override
        protected VECTOR.SparseFloatArray decodeSparseFloatArray(ByteArray data, int length) throws SQLException {
            int[] indices = SparseDecoder.decodeIndices(data);
            float[] values = this.dimensionsDecoder.decodeFloats(data, indices.length);
            return new SparseFloatArrayImpl(length, indices, values);
        }

        @Override
        protected VECTOR.SparseByteArray decodeSparseByteArray(ByteArray data, int length) throws SQLException {
            int[] indices = SparseDecoder.decodeIndices(data);
            byte[] values = this.dimensionsDecoder.decodeBytes(data, indices.length);
            return new SparseByteArrayImpl(length, indices, values);
        }

        @Override
        protected VECTOR.SparseBooleanArray decodeSparseBooleanArray(ByteArray data, int length) throws SQLException {
            int[] indices = SparseDecoder.decodeIndices(data);
            this.dimensionsDecoder.discardValues(data, indices.length);
            return new SparseBooleanArrayImpl(length, indices);
        }

        @Override
        void discardValues(ByteArray data, int length) {
            int indicesLength = SparseDecoder.discardIndices(data);
            this.dimensionsDecoder.discardValues(data, indicesLength);
        }

        static int[] decodeIndices(ByteArray data) {
            int[] indices = new int[data.getShort()];
            data.getInts(indices, 0, indices.length);
            return indices;
        }

        static int discardIndices(ByteArray data) {
            int indicesLength = data.getShort();
            data.setPosition(data.getPosition() + (long)(indicesLength << 2));
            return indicesLength;
        }
    }

    private static final class BinaryDecoder
    extends Decoder<byte[]> {
        private static final BinaryDecoder INSTANCE = new BinaryDecoder();

        static BinaryDecoder getDecoder() {
            return INSTANCE;
        }

        private BinaryDecoder() {
            super(OracleType.VECTOR_BINARY);
        }

        @Override
        byte[] decodeBytes(ByteArray data, int length) {
            return data.getBytes(length + 7 >> 3);
        }

        @Override
        boolean[] decodeBooleans(ByteArray data, int length) {
            boolean[] array = new boolean[length];
            int byteLength = length >> 3;
            int bitIndex = 0;
            for (int i = 0; i < byteLength; ++i) {
                int bits = data.get() & 0xFF;
                array[bitIndex++] = 0 != (bits & 0x80);
                array[bitIndex++] = 0 != (bits & 0x40);
                array[bitIndex++] = 0 != (bits & 0x20);
                array[bitIndex++] = 0 != (bits & 0x10);
                array[bitIndex++] = 0 != (bits & 8);
                array[bitIndex++] = 0 != (bits & 4);
                array[bitIndex++] = 0 != (bits & 2);
                array[bitIndex++] = 0 != (bits & 1);
            }
            if (bitIndex < length) {
                int bits = data.get() & 0xFF;
                int mask = 128;
                do {
                    array[bitIndex++] = 0 != (bits & mask);
                    mask >>= 1;
                } while (bitIndex < length);
            }
            return array;
        }

        @Override
        String decodeString(ByteArray data, int length) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append('[');
            int int8Length = length + 7 >> 3;
            for (int i = 0; i < int8Length; ++i) {
                byte value = data.get();
                if (i > 0) {
                    stringBuilder.append(',');
                }
                stringBuilder.append(value & 0xFF);
            }
            stringBuilder.append(']');
            return stringBuilder.toString();
        }

        @Override
        VECTOR.SparseBooleanArray decodeSparseBooleanArray(ByteArray data, int length) throws SQLException {
            return VectorData.createSparseBooleanArray(this.decodeBytes(data, length));
        }

        @Override
        byte[] decodePreferredArrayClass(ByteArray data, int length) {
            return this.decodeBytes(data, length);
        }

        @Override
        ArrayConverter<byte[]> preferredArrayConverter() {
            return ByteArrayConverter.INSTANCE;
        }

        @Override
        void discardValues(ByteArray data, int length) {
            data.setPosition(data.getPosition() + (long)(length + 7 >> 3));
        }
    }

    private static final class IeeeFloat64Decoder
    extends Float64Decoder {
        private static final IeeeFloat64Decoder BIG_ENDIAN = new IeeeFloat64Decoder(ByteArray.NumberEncoding.IEEE_BIG_ENDIAN);
        private static final IeeeFloat64Decoder LITTLE_ENDIAN = new IeeeFloat64Decoder(ByteArray.NumberEncoding.IEEE_LITTLE_ENDIAN);

        static IeeeFloat64Decoder getDecoder(ByteOrder byteOrder) {
            return byteOrder == ByteOrder.BIG_ENDIAN ? BIG_ENDIAN : LITTLE_ENDIAN;
        }

        private IeeeFloat64Decoder(ByteArray.NumberEncoding numberEncoding) {
            super(numberEncoding);
        }
    }

    private static final class OracleFloat64Decoder
    extends Float64Decoder {
        static final OracleFloat64Decoder BIG_ENDIAN = new OracleFloat64Decoder(ByteArray.NumberEncoding.ORACLE_BIG_ENDIAN);
        static final OracleFloat64Decoder LITTLE_ENDIAN = new OracleFloat64Decoder(ByteArray.NumberEncoding.ORACLE_LITTLE_ENDIAN);

        static OracleFloat64Decoder getDecoder(ByteOrder byteOrder) {
            return byteOrder == ByteOrder.BIG_ENDIAN ? BIG_ENDIAN : LITTLE_ENDIAN;
        }

        private OracleFloat64Decoder(ByteArray.NumberEncoding numberEncoding) {
            super(numberEncoding);
        }

        @Override
        public Decoder<double[]> toIeee(ByteArray data, int length) throws SQLException {
            return this.numberEncoding.byteOrder() == ByteOrder.LITTLE_ENDIAN ? this.littleEndianToIeee(data, length) : this.bigEndianToIeee(data, length);
        }

        private Decoder<double[]> bigEndianToIeee(ByteArray data, int length) throws SQLException {
            long position;
            long limit = position + ((long)length << 3);
            for (position = data.getPosition(); position < limit; position += 8L) {
                long bits = data.getLong(position);
                if ((bits & Long.MIN_VALUE) != 0L) {
                    data.put(position, (byte)(bits >> 56 & 0x7FL));
                    continue;
                }
                data.putLong(position, bits ^ 0xFFFFFFFFFFFFFFFFL);
            }
            return IeeeFloat64Decoder.BIG_ENDIAN;
        }

        private Decoder<double[]> littleEndianToIeee(ByteArray data, int length) throws SQLException {
            long position;
            long limit = position + ((long)length << 3);
            for (position = data.getPosition(); position < limit; position += 8L) {
                long bits = data.getLong(position);
                if ((bits & 0x80L) != 0L) {
                    data.put(position + 7L, (byte)(bits & 0x7FL));
                    continue;
                }
                data.putLong(position, bits ^ 0xFFFFFFFFFFFFFFFFL);
            }
            return IeeeFloat64Decoder.LITTLE_ENDIAN;
        }
    }

    private static abstract class Float64Decoder
    extends DenseDecoder<double[]> {
        protected static final DecimalFormat POSITIVE_FORMAT;
        protected static final DecimalFormat NEGATIVE_FORMAT;
        private static final int MAX_DISPLAY_SIZE;
        protected final ByteArray.NumberEncoding numberEncoding;

        static Float64Decoder getDecoder(short flag1) {
            ByteArray.NumberEncoding numberEncoding = VectorData.getNumberEncoding(flag1);
            boolean isOracleEncoding = !numberEncoding.isIeee();
            ByteOrder byteOrder = numberEncoding.byteOrder();
            return isOracleEncoding ? OracleFloat64Decoder.getDecoder(byteOrder) : IeeeFloat64Decoder.getDecoder(byteOrder);
        }

        Float64Decoder(ByteArray.NumberEncoding numberEncoding) {
            super(OracleType.VECTOR_FLOAT64);
            this.numberEncoding = numberEncoding;
        }

        @Override
        final double[] decodeDoubles(ByteArray data, int length) {
            double[] array = new double[length];
            data.getDoubles(array, 0, length, this.numberEncoding);
            return array;
        }

        @Override
        final boolean[] decodeBooleans(ByteArray data, int length) {
            boolean[] array = new boolean[length];
            this.streamDoubles(data, (index, value) -> {
                array[index] = value != 0.0;
            }, length);
            return array;
        }

        @Override
        final byte[] decodeBytes(ByteArray data, int length) {
            byte[] array = new byte[length];
            this.streamDoubles(data, (index, value) -> {
                array[index] = (byte)value;
            }, length);
            return array;
        }

        @Override
        final int[] decodeInts(ByteArray data, int length) {
            int[] array = new int[length];
            this.streamDoubles(data, (index, value) -> {
                array[index] = (int)value;
            }, length);
            return array;
        }

        @Override
        final short[] decodeShorts(ByteArray data, int length) {
            short[] array = new short[length];
            this.streamDoubles(data, (index, value) -> {
                array[index] = (short)value;
            }, length);
            return array;
        }

        @Override
        final long[] decodeLongs(ByteArray data, int length) {
            long[] array = new long[length];
            this.streamDoubles(data, (index, value) -> {
                array[index] = (long)value;
            }, length);
            return array;
        }

        @Override
        final float[] decodeFloats(ByteArray data, int length) {
            float[] array = new float[length];
            this.streamDoubles(data, (index, value) -> {
                array[index] = (float)value;
            }, length);
            return array;
        }

        @Override
        final String decodeString(ByteArray data, int length) {
            DecimalFormat positiveFormat = (DecimalFormat)POSITIVE_FORMAT.clone();
            DecimalFormat negativeFormat = (DecimalFormat)NEGATIVE_FORMAT.clone();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append('[');
            this.streamDoubles(data, (index, value) -> {
                if (index > 0) {
                    stringBuilder.append(',');
                }
                String stringValue = value == 0.0 ? "0" : (value >= 1.0 || value <= -1.0 ? positiveFormat.format(new BigDecimal(value)) : negativeFormat.format(new BigDecimal(value)));
                stringBuilder.append(stringValue);
            }, length);
            stringBuilder.append(']');
            return stringBuilder.toString();
        }

        @Override
        double[] decodePreferredArrayClass(ByteArray data, int length) {
            return this.decodeDoubles(data, length);
        }

        @Override
        ArrayConverter<double[]> preferredArrayConverter() {
            return DoubleArrayConverter.INSTANCE;
        }

        @Override
        void discardValues(ByteArray data, int length) {
            data.setPosition(data.getPosition() + (long)(length << 3));
        }

        private void streamDoubles(ByteArray data, IntDoubleConsumer consumer, int length) {
            int bufferSize = Math.min(length, 2048);
            double[] buffer = new double[bufferSize];
            int valueIndex = 0;
            while (valueIndex < length) {
                int getLength = Math.min(length - valueIndex, bufferSize);
                data.getDoubles(buffer, 0, getLength, this.numberEncoding);
                for (int i = 0; i < getLength; ++i) {
                    consumer.accept(valueIndex++, buffer[i]);
                }
            }
        }

        static {
            DecimalFormatSymbols decimalFormatSymbols = DecimalFormatSymbols.getInstance(Locale.US);
            decimalFormatSymbols.setExponentSeparator("E+");
            POSITIVE_FORMAT = new DecimalFormat("0.0###############E000", decimalFormatSymbols);
            POSITIVE_FORMAT.setRoundingMode(RoundingMode.HALF_EVEN);
            decimalFormatSymbols = DecimalFormatSymbols.getInstance(Locale.US);
            NEGATIVE_FORMAT = new DecimalFormat("0.0###############E000", decimalFormatSymbols);
            NEGATIVE_FORMAT.setRoundingMode(RoundingMode.HALF_EVEN);
            MAX_DISPLAY_SIZE = Math.max(VectorData.getMaxDisplaySize(NEGATIVE_FORMAT), VectorData.getMaxDisplaySize(POSITIVE_FORMAT));
        }

        private static interface IntDoubleConsumer {
            public void accept(int var1, double var2);
        }
    }

    private static final class IeeeFloat32Decoder
    extends Float32Decoder {
        static final IeeeFloat32Decoder BIG_ENDIAN = new IeeeFloat32Decoder(ByteArray.NumberEncoding.IEEE_BIG_ENDIAN);
        static final IeeeFloat32Decoder LITTLE_ENDIAN = new IeeeFloat32Decoder(ByteArray.NumberEncoding.IEEE_LITTLE_ENDIAN);

        static IeeeFloat32Decoder getDecoder(ByteOrder byteOrder) {
            return byteOrder == ByteOrder.BIG_ENDIAN ? BIG_ENDIAN : LITTLE_ENDIAN;
        }

        private IeeeFloat32Decoder(ByteArray.NumberEncoding numberEncoding) {
            super(numberEncoding);
        }
    }

    private static final class OracleFloat32Decoder
    extends Float32Decoder {
        private static final OracleFloat32Decoder BIG_ENDIAN = new OracleFloat32Decoder(ByteArray.NumberEncoding.ORACLE_BIG_ENDIAN);
        private static final OracleFloat32Decoder LITTLE_ENDIAN = new OracleFloat32Decoder(ByteArray.NumberEncoding.ORACLE_LITTLE_ENDIAN);

        static OracleFloat32Decoder getDecoder(ByteOrder byteOrder) {
            return byteOrder == ByteOrder.BIG_ENDIAN ? BIG_ENDIAN : LITTLE_ENDIAN;
        }

        private OracleFloat32Decoder(ByteArray.NumberEncoding numberEncoding) {
            super(numberEncoding);
        }

        @Override
        protected Decoder<float[]> toIeee(ByteArray data, int length) throws SQLException {
            return this.numberEncoding.byteOrder() == ByteOrder.LITTLE_ENDIAN ? this.littleEndianToIeee(data, length) : this.bigEndianToIeee(data, length);
        }

        private Decoder<float[]> bigEndianToIeee(ByteArray data, int length) throws SQLException {
            long position;
            long limit = position + ((long)length << 2);
            for (position = data.getPosition(); position < limit; position += 4L) {
                int bits = data.getInt(position);
                if ((bits & Integer.MIN_VALUE) != 0) {
                    data.put(position, (byte)(bits >> 24 & 0x7F));
                    continue;
                }
                data.putInt(position, ~bits);
            }
            return IeeeFloat32Decoder.BIG_ENDIAN;
        }

        private Decoder<float[]> littleEndianToIeee(ByteArray data, int length) throws SQLException {
            long position;
            long limit = position + ((long)length << 2);
            for (position = data.getPosition(); position < limit; position += 4L) {
                int bits = data.getInt(position);
                if ((bits & 0x80) != 0) {
                    data.put(position + 3L, (byte)(bits & 0x7F));
                    continue;
                }
                data.putInt(position, ~bits);
            }
            return IeeeFloat32Decoder.LITTLE_ENDIAN;
        }
    }

    private static abstract class Float32Decoder
    extends DenseDecoder<float[]> {
        protected static final DecimalFormat POSITIVE_FORMAT;
        protected static final DecimalFormat NEGATIVE_FORMAT;
        private static final int MAX_DISPLAY_SIZE;
        protected final ByteArray.NumberEncoding numberEncoding;

        static Float32Decoder getDecoder(short flag1) {
            ByteArray.NumberEncoding numberEncoding = VectorData.getNumberEncoding(flag1);
            boolean isOracleEncoding = !numberEncoding.isIeee();
            ByteOrder byteOrder = numberEncoding.byteOrder();
            return isOracleEncoding ? OracleFloat32Decoder.getDecoder(byteOrder) : IeeeFloat32Decoder.getDecoder(byteOrder);
        }

        Float32Decoder(ByteArray.NumberEncoding numberEncoding) {
            super(OracleType.VECTOR_FLOAT32);
            this.numberEncoding = numberEncoding;
        }

        @Override
        final float[] decodeFloats(ByteArray data, int length) {
            float[] array = new float[length];
            data.getFloats(array, 0, length, this.numberEncoding);
            return array;
        }

        @Override
        final boolean[] decodeBooleans(ByteArray data, int length) {
            boolean[] array = new boolean[length];
            this.streamFloats(data, (index, value) -> {
                array[index] = value != 0.0f;
            }, length);
            return array;
        }

        @Override
        final byte[] decodeBytes(ByteArray data, int length) {
            byte[] array = new byte[length];
            this.streamFloats(data, (index, value) -> {
                array[index] = (byte)value;
            }, length);
            return array;
        }

        @Override
        final short[] decodeShorts(ByteArray data, int length) {
            short[] array = new short[length];
            this.streamFloats(data, (index, value) -> {
                array[index] = (short)value;
            }, length);
            return array;
        }

        @Override
        final int[] decodeInts(ByteArray data, int length) {
            int[] array = new int[length];
            this.streamFloats(data, (index, value) -> {
                array[index] = (int)value;
            }, length);
            return array;
        }

        @Override
        final long[] decodeLongs(ByteArray data, int length) {
            long[] array = new long[length];
            this.streamFloats(data, (index, value) -> {
                array[index] = (long)value;
            }, length);
            return array;
        }

        @Override
        final double[] decodeDoubles(ByteArray data, int length) {
            double[] array = new double[length];
            this.streamFloats(data, (index, value) -> {
                array[index] = value;
            }, length);
            return array;
        }

        @Override
        final String decodeString(ByteArray data, int length) {
            DecimalFormat positiveFormat = (DecimalFormat)POSITIVE_FORMAT.clone();
            DecimalFormat negativeFormat = (DecimalFormat)NEGATIVE_FORMAT.clone();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append('[');
            this.streamFloats(data, (index, value) -> {
                if (index > 0) {
                    stringBuilder.append(',');
                }
                String stringValue = value == 0.0f ? "0" : (value >= 1.0f || value <= -1.0f ? positiveFormat.format(value) : negativeFormat.format(value));
                stringBuilder.append(stringValue);
            }, length);
            stringBuilder.append(']');
            return stringBuilder.toString();
        }

        @Override
        float[] decodePreferredArrayClass(ByteArray data, int length) {
            return this.decodeFloats(data, length);
        }

        @Override
        ArrayConverter<float[]> preferredArrayConverter() {
            return FloatArrayConverter.INSTANCE;
        }

        @Override
        void discardValues(ByteArray data, int length) {
            data.setPosition(data.getPosition() + (long)(length << 2));
        }

        private void streamFloats(ByteArray data, IntFloatConsumer consumer, int length) {
            int bufferSize = Math.min(length, 4096);
            float[] buffer = new float[bufferSize];
            int valueIndex = 0;
            while (valueIndex < length) {
                int getLength = Math.min(length - valueIndex, bufferSize);
                data.getFloats(buffer, 0, getLength, this.numberEncoding);
                for (int i = 0; i < getLength; ++i) {
                    consumer.accept(valueIndex++, buffer[i]);
                }
            }
        }

        static {
            DecimalFormatSymbols decimalFormatSymbols = DecimalFormatSymbols.getInstance(Locale.US);
            decimalFormatSymbols.setExponentSeparator("E+");
            POSITIVE_FORMAT = new DecimalFormat("0.0#######E000", decimalFormatSymbols);
            POSITIVE_FORMAT.setRoundingMode(RoundingMode.HALF_EVEN);
            decimalFormatSymbols = DecimalFormatSymbols.getInstance(Locale.US);
            NEGATIVE_FORMAT = new DecimalFormat("0.0#######E000", decimalFormatSymbols);
            NEGATIVE_FORMAT.setRoundingMode(RoundingMode.HALF_EVEN);
            MAX_DISPLAY_SIZE = Math.max(VectorData.getMaxDisplaySize(NEGATIVE_FORMAT), VectorData.getMaxDisplaySize(POSITIVE_FORMAT));
        }

        private static interface IntFloatConsumer {
            public void accept(int var1, float var2);
        }
    }

    private static final class Int8Decoder
    extends DenseDecoder<byte[]> {
        private static final Int8Decoder INSTANCE = new Int8Decoder();

        static Int8Decoder getDecoder() {
            return INSTANCE;
        }

        private Int8Decoder() {
            super(OracleType.VECTOR_INT8);
        }

        @Override
        boolean[] decodeBooleans(ByteArray data, int length) {
            boolean[] array = new boolean[length];
            for (int i = 0; i < length; ++i) {
                array[i] = data.get() != 0;
            }
            return array;
        }

        @Override
        byte[] decodeBytes(ByteArray data, int length) {
            byte[] array = new byte[length];
            data.getBytes(array, 0, length);
            return array;
        }

        @Override
        short[] decodeShorts(ByteArray data, int length) {
            short[] array = new short[length];
            for (int i = 0; i < length; ++i) {
                array[i] = data.get();
            }
            return array;
        }

        @Override
        int[] decodeInts(ByteArray data, int length) {
            int[] array = new int[length];
            for (int i = 0; i < length; ++i) {
                array[i] = data.get();
            }
            return array;
        }

        @Override
        long[] decodeLongs(ByteArray data, int length) {
            long[] array = new long[length];
            for (int i = 0; i < length; ++i) {
                array[i] = data.get();
            }
            return array;
        }

        @Override
        float[] decodeFloats(ByteArray data, int length) {
            float[] array = new float[length];
            for (int i = 0; i < length; ++i) {
                array[i] = data.get();
            }
            return array;
        }

        @Override
        double[] decodeDoubles(ByteArray data, int length) {
            double[] array = new double[length];
            for (int i = 0; i < length; ++i) {
                array[i] = data.get();
            }
            return array;
        }

        @Override
        String decodeString(ByteArray data, int length) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append('[');
            for (int i = 0; i < length; ++i) {
                byte value = data.get();
                if (i > 0) {
                    stringBuilder.append(',');
                }
                stringBuilder.append(value);
            }
            stringBuilder.append(']');
            return stringBuilder.toString();
        }

        @Override
        byte[] decodePreferredArrayClass(ByteArray data, int length) {
            return this.decodeBytes(data, length);
        }

        @Override
        ArrayConverter<byte[]> preferredArrayConverter() {
            return ByteArrayConverter.INSTANCE;
        }

        @Override
        void discardValues(ByteArray data, int length) {
            data.setPosition(data.getPosition() + (long)length);
        }
    }

    private static abstract class DenseDecoder<T>
    extends Decoder<T> {
        DenseDecoder(OracleType type) {
            super(type);
        }

        @Override
        VECTOR.SparseDoubleArray decodeSparseDoubleArray(ByteArray data, int length) throws SQLException {
            return DoubleArrayConverter.INSTANCE.toSparseDoubleArray(this.decodeDoubles(data, length));
        }

        @Override
        VECTOR.SparseFloatArray decodeSparseFloatArray(ByteArray data, int length) throws SQLException {
            return FloatArrayConverter.INSTANCE.toSparseFloatArray(this.decodeFloats(data, length));
        }

        @Override
        VECTOR.SparseByteArray decodeSparseByteArray(ByteArray data, int length) throws SQLException {
            return ByteArrayConverter.INSTANCE.toSparseByteArray(this.decodeBytes(data, length));
        }

        @Override
        VECTOR.SparseBooleanArray decodeSparseBooleanArray(ByteArray data, int length) throws SQLException {
            return BooleanArrayConverter.INSTANCE.toSparseBooleanArray(this.decodeBooleans(data, length));
        }
    }

    private static abstract class Decoder<T> {
        private final OracleType type;
        private final Decoder<T> sparseDecoder;

        Decoder(OracleType type) {
            this.type = type;
            this.sparseDecoder = SparseDecoder.getDecoder(this);
        }

        private <U> U decode(ByteArray data, int length, Class<U> decodedClass) throws SQLException {
            Object decodedObject;
            if (decodedClass == double[].class) {
                decodedObject = this.decodeDoubles(data, length);
            } else if (decodedClass == float[].class) {
                decodedObject = this.decodeFloats(data, length);
            } else if (decodedClass == byte[].class) {
                decodedObject = this.decodeBytes(data, length);
            } else if (decodedClass == short[].class) {
                decodedObject = this.decodeShorts(data, length);
            } else if (decodedClass == int[].class) {
                decodedObject = this.decodeInts(data, length);
            } else if (decodedClass == long[].class) {
                decodedObject = this.decodeLongs(data, length);
            } else if (decodedClass == boolean[].class) {
                decodedObject = this.decodeBooleans(data, length);
            } else if (decodedClass == String.class) {
                decodedObject = this.decodeString(data, length);
            } else if (decodedClass == VECTOR.SparseDoubleArray.class) {
                decodedObject = this.decodeSparseDoubleArray(data, length);
            } else if (decodedClass == VECTOR.SparseFloatArray.class) {
                decodedObject = this.decodeSparseFloatArray(data, length);
            } else if (decodedClass == VECTOR.SparseByteArray.class) {
                decodedObject = this.decodeSparseByteArray(data, length);
            } else if (decodedClass == VECTOR.SparseBooleanArray.class) {
                decodedObject = this.decodeSparseBooleanArray(data, length);
            } else if (decodedClass == Object.class) {
                decodedObject = decodedClass.cast(this.decodePreferredArrayClass(data, length));
            } else {
                throw VectorData.unsupportedConversion(this.type, decodedClass);
            }
            return decodedClass.cast(decodedObject);
        }

        Decoder<T> toIeee(ByteArray data, int length) throws SQLException {
            return this;
        }

        boolean[] decodeBooleans(ByteArray data, int length) throws SQLException {
            throw VectorData.unsupportedConversion(this.type, boolean[].class);
        }

        byte[] decodeBytes(ByteArray data, int length) throws SQLException {
            throw VectorData.unsupportedConversion(this.type, byte[].class);
        }

        short[] decodeShorts(ByteArray data, int length) throws SQLException {
            throw VectorData.unsupportedConversion(this.type, short[].class);
        }

        int[] decodeInts(ByteArray data, int length) throws SQLException {
            throw VectorData.unsupportedConversion(this.type, int[].class);
        }

        long[] decodeLongs(ByteArray data, int length) throws SQLException {
            throw VectorData.unsupportedConversion(this.type, long[].class);
        }

        float[] decodeFloats(ByteArray data, int length) throws SQLException {
            throw VectorData.unsupportedConversion(this.type, float[].class);
        }

        double[] decodeDoubles(ByteArray data, int length) throws SQLException {
            throw VectorData.unsupportedConversion(this.type, double[].class);
        }

        String decodeString(ByteArray data, int length) throws SQLException {
            throw VectorData.unsupportedConversion(this.type, String.class);
        }

        VECTOR.SparseDoubleArray decodeSparseDoubleArray(ByteArray data, int length) throws SQLException {
            throw VectorData.unsupportedConversion(this.type, VECTOR.SparseDoubleArray.class);
        }

        VECTOR.SparseFloatArray decodeSparseFloatArray(ByteArray data, int length) throws SQLException {
            throw VectorData.unsupportedConversion(this.type, VECTOR.SparseFloatArray.class);
        }

        VECTOR.SparseByteArray decodeSparseByteArray(ByteArray data, int length) throws SQLException {
            throw VectorData.unsupportedConversion(this.type, VECTOR.SparseByteArray.class);
        }

        VECTOR.SparseBooleanArray decodeSparseBooleanArray(ByteArray data, int length) throws SQLException {
            throw VectorData.unsupportedConversion(this.type, VECTOR.SparseBooleanArray.class);
        }

        abstract T decodePreferredArrayClass(ByteArray var1, int var2) throws SQLException;

        abstract ArrayConverter<T> preferredArrayConverter();

        final Decoder<T> getSparseDecoder() throws SQLException {
            if (this.sparseDecoder != null) {
                return this.sparseDecoder;
            }
            throw VectorData.unrecognizedData("Decoding of " + this.type.toString() + " SPARSE VECTOR data is not supported");
        }

        abstract void discardValues(ByteArray var1, int var2);
    }
}

