/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Properties;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.GeneratedPhysicalConnection;
import oracle.jdbc.driver.OracleDriverExtension;
import oracle.jdbc.driver.T2CConnection;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.logging.annotations.Blind;
import oracle.jdbc.pool.OracleOCIConnectionPool;

public abstract class OracleOCIConnection
extends T2CConnection {
    OracleOCIConnectionPool ociConnectionPool = null;
    boolean isPool = false;
    boolean aliasing = false;

    public OracleOCIConnection(String ur, @Blind(value=GeneratedPhysicalConnection.ConnectionPropertiesBlinder.class) Properties info, Object ext) throws SQLException {
        this(ur, info, (OracleDriverExtension)ext);
    }

    OracleOCIConnection(String ur, @Blind(value=GeneratedPhysicalConnection.ConnectionPropertiesBlinder.class) Properties info, OracleDriverExtension ext) throws SQLException {
        super(ur, info, ext);
    }

    public byte[] getConnectionId() throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            byte[] connId = this.t2cGetConnectionId(this.m_nativeState);
            if (connId == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 254, "Cannot create a ByteArray for the connectionId").fillInStackTrace();
            }
            this.aliasing = true;
            byte[] byArray = connId;
            return byArray;
        }
    }

    public void passwordChange(String user, @Blind String oldPassword, @Blind String newPassword) throws SQLException, IOException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.ociPasswordChange(user, oldPassword, newPassword);
        }
    }

    @Override
    public void close() throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            if (this.getLifecycle() == 2 || this.getLifecycle() == 4 || this.aliasing) {
                return;
            }
            super.close();
            this.ociConnectionPool.connectionClosed((oracle.jdbc.oci.OracleOCIConnection)this);
        }
    }

    public void setConnectionPool(OracleOCIConnectionPool cpool) {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.ociConnectionPool = cpool;
        }
    }

    @Override
    public void setStmtCacheSize(int size, boolean clearMetaData) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            super.setStmtCacheSize(size, clearMetaData);
        }
    }
}

