/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.common;

import java.math.BigInteger;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.LongAccumulator;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.jdbc.clio.annotations.Debug;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.ons.Notification;
import oracle.ons.Subscriber;
import oracle.ucp.ConnectionAffinityCallback;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.admin.UniversalConnectionPoolManagerBase;
import oracle.ucp.common.AffinityContext;
import oracle.ucp.common.Clock;
import oracle.ucp.common.ConnectionSource;
import oracle.ucp.common.CoreConnection;
import oracle.ucp.common.DiagnosticsSummary;
import oracle.ucp.common.ONSDriver;
import oracle.ucp.common.SelectorsUtil;
import oracle.ucp.common.Service;
import oracle.ucp.common.ServiceMember;
import oracle.ucp.diagnostics.Diagnosable;
import oracle.ucp.diagnostics.DiagnosticsCollectorImpl;
import oracle.ucp.jdbc.oracle.DataBasedConnectionAffinityCallback;
import oracle.ucp.util.Predicates;
import oracle.ucp.util.Task;
import oracle.ucp.util.TaskHandle;
import oracle.ucp.util.TaskManager;
import oracle.ucp.util.TaskManagerException;
import oracle.ucp.util.UCPTaskBase;
import oracle.ucp.util.Util;

public abstract class LoadBalancer
implements Diagnosable {
    static final String CLASS_NAME = LoadBalancer.class.getName();
    public static final int REBALANCE_LIMIT = 15;
    private static final boolean isAffinityStrict = Util.isAffinityStrict();
    private final TaskManager taskManager;
    private AtomicReference<Task<Object>> task = new AtomicReference<Object>(null);
    private AtomicReference<TaskHandle<Object>> taskHandle = new AtomicReference<Object>(null);
    private Event recentEvent = null;
    private final AtomicBoolean terminate = new AtomicBoolean(false);
    private volatile Diagnosable diagnosticsCollector = DiagnosticsCollectorImpl.getCommon();
    private static final Pattern lb_ptop = Pattern.compile("([^{]*)\\{(.*)\\}(.*)");
    private static final Pattern lb_pg1 = Pattern.compile("(\\w+)=([a-zA-Z_0-9\\.\\-\\:\\%]+)");
    private static final Pattern lb_pg2 = Pattern.compile("\\{([^{]*)\\}");
    private static final Pattern lb_pg3 = Pattern.compile("(timestamp)=(\\d{4}\\-\\d{2}\\-\\d{2} \\d{2}\\:\\d{2}\\:\\d{2})");
    private static final Pattern lb_pg4 = Pattern.compile("(timezone)=(.*)");
    private static final Pattern lb_pg5 = Pattern.compile("[\\+\\-]\\d{2}:\\d{2}");
    private static MixTable mixTable = new MixTable();
    private volatile long gravitationDisableTimestamp = 0L;

    LoadBalancer(Diagnosable diagnosticsCollector) {
        this(UniversalConnectionPoolManagerBase.getTaskManager(), diagnosticsCollector);
    }

    LoadBalancer() {
        this(UniversalConnectionPoolManagerBase.getTaskManager(), DiagnosticsCollectorImpl.getCommon());
    }

    LoadBalancer(TaskManager taskManager, Diagnosable diagnosticsCollector) {
        this.taskManager = Objects.requireNonNull(taskManager);
        this.diagnosticsCollector = Objects.requireNonNull(diagnosticsCollector);
    }

    LoadBalancer(TaskManager taskManager) {
        this(taskManager, DiagnosticsCollectorImpl.getCommon());
    }

    protected abstract ConnectionSource.RebalanceCallback.Result onEvent(Event var1, Predicate<CoreConnection> var2, Predicate<CoreConnection> var3);

    protected abstract Service service();

    /*
     * WARNING - void declaration
     */
    @Debug(level=Debug.Level.FINEST)
    private Task<Object> prepareTask(ONSDriver oNSDriver, String string) {
        try {
            void serviceName;
            void onsDriver;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.LoadBalancer", "prepareTask", "entering args ({0}, {1})", null, null, oNSDriver, string);
            UCPTaskBase<Object> uCPTaskBase = new UCPTaskBase<Object>((ONSDriver)onsDriver, (String)serviceName){
                Subscriber subscriber = null;
                final /* synthetic */ ONSDriver val$onsDriver;
                final /* synthetic */ String val$serviceName;
                {
                    this.val$onsDriver = oNSDriver;
                    this.val$serviceName = string;
                }

                @Override
                public boolean isCritical() {
                    return true;
                }

                @Override
                public void run() {
                    try {
                        this.subscriber = AccessController.doPrivileged(new PrivilegedExceptionAction<Subscriber>(){

                            @Override
                            public Subscriber run() throws UniversalConnectionPoolException {
                                try {
                                    return val$onsDriver.createSubscriber("%\"eventType=database/event/servicemetrics/" + val$serviceName + "\"");
                                }
                                catch (Exception e) {
                                    throw new UniversalConnectionPoolException(e);
                                }
                            }
                        });
                        if (null == this.subscriber) {
                            return;
                        }
                        this.handleNotifications();
                    }
                    catch (PrivilegedActionException e) {
                        LoadBalancer.this.trace(Level.WARNING, CLASS_NAME, "run", "ONS subscription hit exception:", null, e, new Object[0]);
                    }
                    finally {
                        if (null != this.subscriber) {
                            this.subscriber.close();
                            this.subscriber = null;
                        }
                    }
                }

                private void handleNotifications() {
                    LoadBalancer.this.terminate.set(false);
                    while (!Thread.currentThread().isInterrupted() && !LoadBalancer.this.terminate.get()) {
                        try {
                            Notification notification = this.subscriber.receive(true);
                            if (notification == null) {
                                LoadBalancer.this.trace(Level.FINE, CLASS_NAME, "handleNotifications", "empty notification", null, null, new Object[0]);
                                continue;
                            }
                            String nType = notification.type();
                            LoadBalancer.this.trace(Level.FINEST, CLASS_NAME, "handleNotifications", "notificationType={0}", null, null, nType);
                            LoadBalancer.this.trace(Level.FINEST, CLASS_NAME, "handleNotifications", "notificationBody={0}", null, null, new String(notification.body()));
                            Event event = LoadBalancer.this.parseNotification(nType.toLowerCase(), new String(notification.body()).toLowerCase());
                            if (event.wrongFormat()) {
                                LoadBalancer.this.trace(Level.FINE, CLASS_NAME, "handleNotifications", "wrong notification format", null, null, new Object[0]);
                                continue;
                            }
                            if (Objects.nonNull(LoadBalancer.this.recentEvent) && Math.abs(LoadBalancer.this.recentEvent.timestamp().getTime() - event.timestamp().getTime()) < 10000L) {
                                LoadBalancer.this.trace(Level.FINE, CLASS_NAME, "handleNotifications", "more than one OB ONS notification within 10 seconds, ignoring", null, null, new Object[0]);
                                continue;
                            }
                            LoadBalancer.this.service().markup(event);
                            LoadBalancer.this.trace(Level.FINE, CLASS_NAME, "handleNotifications", "event={0}", null, null, event.toString());
                            long sucLbDelta = LoadBalancer.this.service().lbStats.lbBorrows.successful.delta();
                            BigInteger sucLbTotal = LoadBalancer.this.service().lbStats.lbBorrows.successful.total();
                            long failedLbDelta = LoadBalancer.this.service().lbStats.lbBorrows.failed.delta();
                            BigInteger failedLbTotal = LoadBalancer.this.service().lbStats.lbBorrows.failed.total();
                            LoadBalancer.this.trace(Level.FINEST, CLASS_NAME, "handleNotifications", "successfuliLbBorrows={0}({1}), failedLbBorrows={2}({3})", null, null, sucLbDelta, sucLbTotal.toString(), failedLbDelta, failedLbTotal.toString());
                            long totalBorrowTimeDelta = LoadBalancer.this.service().lbStats.borrowTimes.totalDelta();
                            LoadBalancer.this.service().lbStats.accumulate();
                            boolean peaked = false;
                            for (ServiceMember serviceMember : LoadBalancer.this.service().getAllMembers()) {
                                serviceMember.saveAdvisedLoad(event.normalizedPercent(serviceMember.name()));
                                serviceMember.savePeakBorrows();
                                if (serviceMember.peaked()) {
                                    peaked = true;
                                }
                                Stats instStats = serviceMember.lbStats;
                                int totalConns = LoadBalancer.this.service().activeCount() - LoadBalancer.this.service().pendingCloseCount.get();
                                int instConns = serviceMember.activeCount.get() - serviceMember.pendingCloseCount.get();
                                float actualLoad = 0 != totalConns ? (float)instConns / (float)totalConns * 100.0f : 0.0f;
                                int delta = (int)Math.ceil((double)totalConns * (double)serviceMember.averageAdvisedLoad() / 100.0) - instConns;
                                serviceMember.connsToRebalance.set(delta);
                                long returnedDelta = instStats.returns.delta();
                                BigInteger returnedTotal = instStats.returns.total();
                                long peakBorrowsDelta = instStats.peakBorrows.delta();
                                long peakBorrowsTotal = instStats.peakBorrows.total();
                                long minBorrowTimeDelta = instStats.borrowTimes.minDelta();
                                long minBorrowTimeTotal = instStats.borrowTimes.minTotal();
                                long maxBorrowTimeDelta = instStats.borrowTimes.maxDelta();
                                long maxBorrowTimeTotal = instStats.borrowTimes.maxTotal();
                                long borrowTimeDelta = instStats.borrowTimes.totalDelta();
                                BigInteger borrowTimeTotal = instStats.borrowTimes.total();
                                String instName = serviceMember.name();
                                float borrowBasedLoad = 0L != totalBorrowTimeDelta ? (float)borrowTimeDelta / (float)totalBorrowTimeDelta * 100.0f : 0.0f;
                                String lbSummary = instName + ":active=" + serviceMember.activeCount + (delta < 0 ? (char)'-' : '+') + Math.abs(delta) + "(" + String.format("%.2f", Float.valueOf(actualLoad)) + "%)" + ",load=" + String.format("%.2f", Float.valueOf(borrowBasedLoad)) + "%" + ",advised=" + String.format("%.2f", Float.valueOf(event.percent(instName))) + "%" + ",normalized=" + String.format("%.2f", Float.valueOf(event.normalizedPercent(instName))) + "%" + ",average=" + String.format("%.2f", Float.valueOf(serviceMember.averageAdvisedLoad())) + "%" + " (opened=" + instStats.opens.delta() + "(" + instStats.opens.total() + ")" + ",closed=" + instStats.closes.successful.delta() + "(" + instStats.closes.successful.total() + ")" + ",aborted=" + instStats.closes.aborted.delta() + "(" + instStats.closes.aborted.total() + ")" + ",returned=" + returnedDelta + "(" + returnedTotal + ")" + ",borrowed:peak=" + peakBorrowsDelta + "(" + peakBorrowsTotal + ")" + ",minTime=" + minBorrowTimeDelta + "(" + minBorrowTimeTotal + ")" + ",maxTime=" + maxBorrowTimeDelta + "(" + maxBorrowTimeTotal + ")" + ",totalTime=" + borrowTimeDelta + "(" + borrowTimeTotal + "))";
                                LoadBalancer.this.trace(Level.FINEST, CLASS_NAME, "handleNotifications", "lbSummary={0}", null, null, lbSummary);
                                DiagnosticsSummary.addLBSummary(lbSummary);
                                serviceMember.lbStats.accumulate();
                            }
                            StringBuilder sb = new StringBuilder();
                            sb.append("pendingCloseCount: all=").append(LoadBalancer.this.service().pendingCloseCount.get());
                            for (ServiceMember instance3 : LoadBalancer.this.service().getAllMembers()) {
                                sb.append(", inst(" + instance3.name() + ")=" + instance3.pendingCloseCount.get());
                            }
                            LoadBalancer.this.trace(Level.FINEST, CLASS_NAME, "handleNotifications", "lbStats={0}", null, null, sb.toString());
                            LoadBalancer.this.trace(Level.FINEST, CLASS_NAME, "handleNotifications", "peaked={0}", null, null, peaked);
                            LoadBalancer.this.recentEvent = event;
                            boolean bl = peaked && !LoadBalancer.this.isGravitationDisabled();
                            Predicate<CoreConnection> cleanupSelector = bl ? LoadBalancer.this.gravitationSelector(true) : p -> false;
                            Predicate<CoreConnection> markupSelector = bl ? LoadBalancer.this.gravitationSelector(false) : p -> false;
                            LoadBalancer.this.service().pendingRebalance.getAndSet(LoadBalancer.this.onEvent(event, cleanupSelector, markupSelector)).terminate();
                            continue;
                        }
                        catch (Throwable e) {
                            LoadBalancer.this.trace(Level.WARNING, CLASS_NAME, "handleNotifications", "notification processing error:", null, e, new Object[0]);
                            continue;
                        }
                        break;
                    }
                    return;
                }
            };
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.LoadBalancer", "prepareTask", "returning {0}", null, null, uCPTaskBase);
            return uCPTaskBase;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.LoadBalancer", "prepareTask", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    private Predicate<CoreConnection> gravitationSelector(boolean cleanup) {
        return conn -> {
            if (cleanup ^ conn.available()) {
                return false;
            }
            return !conn.markedCloseOnReturn() && !conn.markedToReplace();
        };
    }

    /*
     * WARNING - void declaration
     */
    @Debug(level=Debug.Level.FINEST)
    Event parseNotification(String string, String string2) {
        try {
            void nBodyLowerCase;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.LoadBalancer", "parseNotification", "entering args ({0}, {1})", null, null, string, string2);
            final Properties dbdata = new Properties();
            final boolean[] wrongFormat = new boolean[]{false};
            HashMap<String, Properties> instsdata = new HashMap<String, Properties>();
            Matcher mtop = lb_ptop.matcher((CharSequence)nBodyLowerCase);
            if (mtop.find()) {
                Matcher mg1 = lb_pg1.matcher(mtop.group(1));
                Matcher mg2 = lb_pg2.matcher(mtop.group(2));
                Matcher mg3 = lb_pg3.matcher(mtop.group(3));
                Matcher mg4 = lb_pg4.matcher(mtop.group(3));
                while (mg1.find()) {
                    dbdata.setProperty(mg1.group(1), mg1.group(2));
                }
                while (mg2.find()) {
                    Matcher mg21 = lb_pg1.matcher(mg2.group(1));
                    Properties instdata = new Properties();
                    while (mg21.find()) {
                        instdata.setProperty(mg21.group(1), mg21.group(2));
                    }
                    instsdata.put(instdata.getProperty("instance", "***noname***"), instdata);
                }
                if (0 == instsdata.size()) {
                    wrongFormat[0] = true;
                }
                if (mg3.find()) {
                    dbdata.put(mg3.group(1), mg3.group(2));
                }
                if (mg4.find()) {
                    if (lb_pg5.matcher(mg4.group(2)).find()) {
                        dbdata.put(mg4.group(1), mg4.group(2));
                    } else {
                        this.trace(Level.FINEST, CLASS_NAME, "parseNotification", "unaccepted timezone format: {0}", null, null, mg4.group(2));
                        wrongFormat[0] = true;
                    }
                }
            }
            Event event = new Event(){
                private final String version;
                private final String service;
                private final String database;
                private final String host;
                private Date timestamp;
                private final Map<String, Float> instAdvisories;
                private final Map<String, Float> instNormalizedAdvisories;
                final /* synthetic */ String val$nBodyLowerCase;
                final /* synthetic */ Map val$instsdata;
                {
                    this.val$nBodyLowerCase = string;
                    this.val$instsdata = map;
                    this.version = dbdata.getProperty("version");
                    this.service = dbdata.getProperty("service");
                    this.database = dbdata.getProperty("database");
                    this.host = dbdata.getProperty("host");
                    this.timestamp = new Date();
                    if (null == this.version) {
                        LoadBalancer.this.trace(Level.FINEST, CLASS_NAME, "parseNotification", "no version", null, null, new Object[0]);
                        wrongFormat[0] = true;
                    }
                    String ts = dbdata.getProperty("timestamp", "");
                    String tz = dbdata.getProperty("timezone", "");
                    if ("".equals(ts) && !"".equals(tz)) {
                        LoadBalancer.this.trace(Level.FINEST, CLASS_NAME, "parseNotification", "single timezone (without timestamp) is not allowed", null, null, new Object[0]);
                        wrongFormat[0] = true;
                    }
                    if ("".equals(ts)) {
                        this.timestamp = new Date();
                    } else {
                        try {
                            this.timestamp = "".equals(tz) ? new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(ts) : new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z").parse((String)ts + " GMT" + tz);
                        }
                        catch (ParseException e) {
                            LoadBalancer.this.trace(Level.WARNING, CLASS_NAME, "parseNotification", "", null, e, new Object[0]);
                            wrongFormat[0] = true;
                        }
                    }
                    this.instAdvisories = new HashMap<String, Float>();
                    for (String inst : this.instances()) {
                        String percenti;
                        String percentf = this.instanceAttrs(inst).getProperty("percentf");
                        if (null != percentf) {
                            try {
                                this.instAdvisories.put(inst, Float.valueOf(Float.parseFloat(percentf)));
                                continue;
                            }
                            catch (Exception e) {
                                LoadBalancer.this.trace(Level.WARNING, CLASS_NAME, "parseNotification", "", null, e, new Object[0]);
                                wrongFormat[0] = true;
                            }
                        }
                        if (null != (percenti = this.instanceAttrs(inst).getProperty("percent"))) {
                            try {
                                this.instAdvisories.put(inst, Float.valueOf(Integer.parseInt(percenti)));
                                continue;
                            }
                            catch (Exception e) {
                                LoadBalancer.this.trace(Level.WARNING, CLASS_NAME, "parseNotification", "", null, e, new Object[0]);
                                wrongFormat[0] = true;
                            }
                        }
                        LoadBalancer.this.trace(Level.FINEST, CLASS_NAME, "parseNotification", "no advisory percent in the load balancing event", null, null, new Object[0]);
                        wrongFormat[0] = true;
                    }
                    this.instNormalizedAdvisories = new HashMap<String, Float>();
                    if (!wrongFormat[0]) {
                        float alivePercent = 0.0f;
                        for (Map.Entry<String, Float> entry : this.instAdvisories.entrySet()) {
                            Event.Flag flag = this.flag(entry.getKey());
                            if (Event.Flag.BLOCKED == flag || Event.Flag.NO_DATA == flag) continue;
                            alivePercent += entry.getValue().floatValue();
                        }
                        LoadBalancer.this.trace(Level.FINEST, CLASS_NAME, "parseNotification", "alivePercent={0}", null, null, Float.valueOf(alivePercent));
                        if (0.0f == alivePercent) {
                            wrongFormat[0] = true;
                        }
                        for (Map.Entry<String, Float> entry : this.instAdvisories.entrySet()) {
                            String instname;
                            Event.Flag flag = this.flag(instname = entry.getKey());
                            this.instNormalizedAdvisories.put(instname, Float.valueOf(Event.Flag.BLOCKED != flag && Event.Flag.NO_DATA != flag ? entry.getValue().floatValue() / alivePercent * 100.0f : 0.0f));
                        }
                        LoadBalancer.this.trace(Level.FINEST, CLASS_NAME, "parseNotification", "instNormalizedAdvisories={0}", null, null, this.instNormalizedAdvisories.toString());
                    }
                }

                @Override
                public byte[] body() {
                    return this.val$nBodyLowerCase.getBytes();
                }

                @Override
                public String version() {
                    return this.version;
                }

                @Override
                public String service() {
                    return this.service;
                }

                @Override
                public String database() {
                    return this.database;
                }

                @Override
                public String host() {
                    return this.host;
                }

                @Override
                public Date timestamp() {
                    return this.timestamp;
                }

                @Override
                public Set<String> instances() {
                    return this.val$instsdata.keySet();
                }

                @Override
                public float percent(String instance) {
                    Float percent = this.instAdvisories.get(instance);
                    return null != percent ? percent.floatValue() : 0.0f;
                }

                @Override
                public float normalizedPercent(String instance) {
                    Float percent = this.instNormalizedAdvisories.get(instance);
                    return null != percent ? percent.floatValue() : 0.0f;
                }

                @Override
                public boolean affinity(String instance) {
                    return "true".equals(this.instanceAttrs(instance).getProperty("aff", "false").toLowerCase().trim());
                }

                @Override
                public Event.Flag flag(String instance) {
                    return Event.Flag.parse(this.instanceAttrs(instance).getProperty("flag", "good"));
                }

                private Properties instanceAttrs(String instance) {
                    Properties instdata = (Properties)this.val$instsdata.get(instance);
                    return null != instdata ? instdata : new Properties();
                }

                @Override
                public boolean wrongFormat() {
                    return wrongFormat[0];
                }

                public String toString() {
                    return "" + this.val$instsdata + dbdata;
                }
            };
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.LoadBalancer", "parseNotification", "returning {0}", null, null, event);
            return event;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.LoadBalancer", "parseNotification", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    public Predicate<CoreConnection> borrowSelector(ConnectionRetrievalInfo cri) {
        return this.borrowSelector(cri, this.service().getAllMembers(cri));
    }

    public Predicate<CoreConnection> borrowSelector(ConnectionRetrievalInfo cri, Collection<ServiceMember> allMembers) {
        final ConnectionAffinityCallback callback = cri.getConnectionAffinityCallback();
        final class AffinityHelper {
            AffinityHelper() {
            }

            private void successfulAffBorrowed(CoreConnection conn) {
                LoadBalancer.this.service().lbStats.onSuccessfulAffBorrowed();
                conn.serviceMember().lbStats.onSuccessfulAffBorrowed();
            }

            private void failedAffBorrowed(CoreConnection conn) {
                LoadBalancer.this.service().lbStats.onFailedAffBorrowed();
                conn.serviceMember().lbStats.onFailedAffBorrowed();
            }

            protected boolean affined(CoreConnection conn) {
                if (null == callback) {
                    throw new IllegalArgumentException("callback is null");
                }
                Object affContext = callback.getConnectionAffinityContext();
                if (affContext instanceof AffinityContext) {
                    AffinityContext context = (AffinityContext)affContext;
                    String ctxInstName = context.getInstanceName();
                    if (null == ctxInstName) {
                        LoadBalancer.this.trace(Level.WARNING, CLASS_NAME, "borrowSelector", "no instance name in affinity context", null, null, new Object[0]);
                        this.failedAffBorrowed(conn);
                        return conn.serviceMember().active();
                    }
                    ServiceMember ctxinst = LoadBalancer.this.service().getMember(ctxInstName, context.getDatabaseUniqueName(), context.getServiceName());
                    if (null == ctxinst) {
                        LoadBalancer.this.trace(Level.WARNING, CLASS_NAME, "borrowSelector", String.format("unknown %s in affinity context", ctxInstName), null, null, new Object[0]);
                        this.failedAffBorrowed(conn);
                        return conn.serviceMember().active();
                    }
                    if (!ctxinst.active() || ctxinst.violating()) {
                        LoadBalancer.this.trace(Level.FINE, CLASS_NAME, "borrowSelector", "{0} is unavailable", null, null, ctxinst.name());
                        this.failedAffBorrowed(conn);
                        return conn.serviceMember().active();
                    }
                    ConnectionAffinityCallback.AffinityPolicy policy = callback.getAffinityPolicy();
                    if (conn.serviceMember().name().equals(ctxinst.name())) {
                        if (ConnectionAffinityCallback.AffinityPolicy.WEBSESSION_BASED_AFFINITY == policy) {
                            if (conn.serviceMember().affined()) {
                                this.successfulAffBorrowed(conn);
                                return true;
                            }
                        } else {
                            if (ConnectionAffinityCallback.AffinityPolicy.TRANSACTION_BASED_AFFINITY == policy) {
                                this.successfulAffBorrowed(conn);
                                return true;
                            }
                            throw new IllegalStateException("wrong affinity policy");
                        }
                    }
                    return false;
                }
                throw new IllegalStateException("wrong affinity context type or null");
            }

            boolean dbAffined(CoreConnection conn) {
                DataBasedConnectionAffinityCallback cbk = (DataBasedConnectionAffinityCallback)callback;
                if (0 == LoadBalancer.this.service().getAllMembers().size()) {
                    throw new IllegalStateException("data affinity: list of instances is empty");
                }
                int activeInsts = LoadBalancer.this.service().activeMembersCount();
                if (0 == activeInsts) {
                    return false;
                }
                int i = 0;
                ServiceMember inst = null;
                int partitionId = cbk.getPartitionId();
                block0: while (i++ < mixTable.size()) {
                    int instIdToFind = partitionId % activeInsts;
                    for (ServiceMember instance : LoadBalancer.this.service().getAllMembers()) {
                        inst = instance;
                        int id = inst.id() % activeInsts;
                        if (instIdToFind != id) continue;
                        if (isAffinityStrict) {
                            if (inst.active() && !inst.violating()) break block0;
                            this.failedAffBorrowed(conn);
                            return false;
                        }
                        if (inst.affined() && inst.active() && !inst.violating()) break block0;
                        this.failedAffBorrowed(conn);
                        return conn.serviceMember().active();
                    }
                    partitionId = mixTable.nextPartition(partitionId);
                }
                if (null == inst) {
                    return false;
                }
                boolean res = conn.serviceMember().name().equals(inst.name());
                if (res) {
                    this.successfulAffBorrowed(conn);
                }
                return res;
            }
        }
        AffinityHelper affinityHelper = new AffinityHelper();
        Predicate<CoreConnection> affinitySelector = conn -> {
            boolean active = conn.serviceMember().active();
            if (null != callback && ConnectionAffinityCallback.AffinityPolicy.DATA_BASED_AFFINITY == callback.getAffinityPolicy()) {
                return active && affinityHelper.dbAffined((CoreConnection)conn);
            }
            if (null != callback && callback.getConnectionAffinityContext() != null) {
                return active && affinityHelper.affined((CoreConnection)conn);
            }
            if (conn.serviceMember().isRLBHistoryClean()) {
                int borrowed = conn.serviceMember().borrowedCount.get();
                int borrowedAll = this.service().borrowedCount();
                float actualLoad = 0 == borrowedAll ? 0.0f : (float)borrowed / (float)borrowedAll * 100.0f;
                int activeInsts = this.service().activeMembersCount();
                float advisedLoad = 0 == activeInsts ? 100.0f : 100.0f / (float)activeInsts;
                return actualLoad <= advisedLoad;
            }
            if (null == this.recentEvent) {
                return conn.serviceMember().serviceRef.proportionalDistributionSelector().test((CoreConnection)conn);
            }
            if (!active) {
                return false;
            }
            ServiceMember instance = conn.serviceMember();
            float advisedLoad = instance.active() ? instance.averageAdvisedLoad(cri, allMembers) : 0.0f;
            long instBorrowedTime = instance.lbStats.borrowTimes.totalDelta();
            long totalBorrowedTime = this.service().totalBorrowTimes(cri, allMembers);
            float actualLoad = 0L != totalBorrowedTime ? (float)instBorrowedTime / (float)totalBorrowedTime * 100.0f : 0.0f;
            return actualLoad <= advisedLoad;
        };
        return Predicates.and(SelectorsUtil.availableSelector, affinitySelector);
    }

    /*
     * WARNING - void declaration
     */
    @Debug(level=Debug.Level.FINEST)
    ServiceMember underloadedInstance(ConnectionRetrievalInfo connectionRetrievalInfo) {
        try {
            int maxDelta;
            ServiceMember underloadedInstance;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.LoadBalancer", "underloadedInstance", "entering args ({0})", null, null, connectionRetrievalInfo);
            if (this.isGravitationDisabled()) {
                ServiceMember serviceMember = null;
                this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.LoadBalancer", "underloadedInstance", "returning {0}", null, null, serviceMember);
                return serviceMember;
            }
            Event event = this.recentEvent;
            if (null == event) {
                ServiceMember serviceMember = null;
                this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.LoadBalancer", "underloadedInstance", "returning {0}", null, null, serviceMember);
                return serviceMember;
            }
            do {
                void cri;
                underloadedInstance = null;
                maxDelta = Integer.MIN_VALUE;
                for (ServiceMember instance : this.service().getAllMembers((ConnectionRetrievalInfo)cri, true)) {
                    int delta;
                    if (!instance.active() || (delta = instance.connsToRebalance.get()) <= 0 || delta <= maxDelta) continue;
                    maxDelta = delta;
                    underloadedInstance = instance;
                }
            } while (null != underloadedInstance && !underloadedInstance.connsToRebalance.compareAndSet(maxDelta, maxDelta - 1));
            ServiceMember serviceMember = underloadedInstance;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.LoadBalancer", "underloadedInstance", "returning {0}", null, null, serviceMember);
            return serviceMember;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.LoadBalancer", "underloadedInstance", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Debug(level=Debug.Level.FINEST)
    public boolean start(ONSDriver oNSDriver, String string) {
        try {
            void service;
            void onsDriver;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.LoadBalancer", "start", "entering args ({0}, {1})", null, null, oNSDriver, string);
            if (this.task.compareAndSet(null, this.prepareTask((ONSDriver)onsDriver, (String)service))) {
                this.taskHandle.set(this.taskManager.submitTask(this.task.get()));
                this.trace(Level.FINEST, CLASS_NAME, "start", "LoadBalancer started", null, null, new Object[0]);
            }
            boolean bl = true;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.LoadBalancer", "start", "returning {0}", null, null, bl);
            return bl;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.LoadBalancer", "start", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Debug(level=Debug.Level.FINEST)
    public void stop() {
        try {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.LoadBalancer", "stop", "entering args ()", null, null, new Object[0]);
            Task t = this.task.getAndSet(null);
            if (null != t) {
                block6: {
                    t.release();
                    this.terminate.set(true);
                    try {
                        TaskHandle th = this.taskHandle.getAndSet(null);
                        if (null != th) {
                            th.get(100000L);
                        }
                    }
                    catch (TaskManagerException e) {
                        if (e.getCause() instanceof CancellationException) break block6;
                        this.trace(Level.WARNING, CLASS_NAME, "stop", "", null, e, new Object[0]);
                    }
                }
                this.trace(Level.FINEST, CLASS_NAME, "stop", "stopped", null, null, new Object[0]);
            }
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.LoadBalancer", "stop", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.LoadBalancer", "stop", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    public Diagnosable getDiagnosable() {
        return this.diagnosticsCollector;
    }

    public void disableRLBGravitation() {
        this.gravitationDisableTimestamp = Clock.clock();
    }

    private boolean isGravitationDisabled() {
        return Clock.clock() < this.gravitationDisableTimestamp + Util.getRLBGravitationInoperablePeriod() * 1000L;
    }

    public static interface Event {
        public String version();

        public String database();

        public String host();

        public String service();

        public Set<String> instances();

        public float percent(String var1);

        public float normalizedPercent(String var1);

        public boolean wrongFormat();

        public boolean affinity(String var1);

        public Flag flag(String var1);

        public Date timestamp();

        public byte[] body();

        public static enum Flag {
            GOOD,
            VIOLATING,
            NO_DATA,
            UNKNOWN,
            BLOCKED;


            static Flag parse(String flag) {
                for (Flag f : Flag.values()) {
                    if (!f.toString().toLowerCase().equals(flag)) continue;
                    return f;
                }
                throw new IllegalStateException("unknown flag " + flag);
            }
        }
    }

    public static class Stats {
        public final Counter returns = new Counter();
        final Counter opens = new Counter();
        public final CloseResultsCounter closes = new CloseResultsCounter();
        public final BorrowResultsCounter lbBorrows = new BorrowResultsCounter();
        public final BorrowResultsCounter affBorrows = new BorrowResultsCounter();
        final PeakBorrowed peakBorrows = new PeakBorrowed();
        final Times borrowTimes = new Times();

        void onBorrowed(int borrowedCount) {
            this.peakBorrows.update(borrowedCount);
        }

        void onReturned(long borrowedTimeInterval) {
            this.borrowTimes.update(borrowedTimeInterval);
            this.returns.increment();
        }

        void onOpened() {
            this.opens.increment();
        }

        void onClosed() {
            this.closes.successful.increment();
        }

        void onAborted() {
            this.closes.aborted.increment();
        }

        void onSuccessfulLbBorrowed() {
            this.lbBorrows.successful.increment();
        }

        void onFailedLbBorrowed() {
            this.lbBorrows.failed.increment();
        }

        void onSuccessfulAffBorrowed() {
            this.affBorrows.successful.increment();
        }

        void onFailedAffBorrowed() {
            this.affBorrows.failed.increment();
        }

        void accumulate() {
            this.returns.accumulate();
            this.opens.accumulate();
            this.closes.accumulate();
            this.lbBorrows.accumulate();
            this.affBorrows.accumulate();
            this.peakBorrows.accumulate();
            this.borrowTimes.accumulate();
        }

        public static class Counter {
            private final AtomicReference<BigInteger> accumulator = new AtomicReference<BigInteger>(BigInteger.ZERO);
            private final AtomicLong delta = new AtomicLong(0L);

            private void increment() {
                this.delta.incrementAndGet();
            }

            private void accumulate() {
                this.accumulator.set(this.accumulator.get().add(BigInteger.valueOf(this.delta.getAndSet(0L))));
            }

            long delta() {
                return this.delta.get();
            }

            public BigInteger total() {
                return this.accumulator.get().add(BigInteger.valueOf(this.delta.get()));
            }
        }

        public static class CloseResultsCounter {
            public final Counter successful = new Counter();
            public final Counter aborted = new Counter();

            private void accumulate() {
                this.successful.accumulate();
                this.aborted.accumulate();
            }
        }

        public static class BorrowResultsCounter {
            public final Counter successful = new Counter();
            public final Counter failed = new Counter();

            private void accumulate() {
                this.successful.accumulate();
                this.failed.accumulate();
            }
        }

        public static class PeakBorrowed {
            private final LongAccumulator accumulator = new LongAccumulator(Math::max, 0L);
            private final LongAccumulator delta = new LongAccumulator(Math::max, 0L);

            private void update(int nItems) {
                this.delta.accumulate(nItems);
            }

            private void accumulate() {
                this.accumulator.accumulate(this.delta.getThenReset());
            }

            public int delta() {
                return this.delta.intValue();
            }

            public int total() {
                return Math.max(this.delta.intValue(), Math.max(0, this.accumulator.intValue()));
            }
        }

        static class Times {
            private final AtomicLong minAccumulator = new AtomicLong(Long.MAX_VALUE);
            private final AtomicLong minDelta = new AtomicLong(Long.MAX_VALUE);
            private final AtomicLong maxAccumulator = new AtomicLong(Long.MIN_VALUE);
            private final AtomicLong maxDelta = new AtomicLong(Long.MIN_VALUE);
            private final AtomicReference<BigInteger> totalAccumulator = new AtomicReference<BigInteger>(BigInteger.ZERO);
            private final AtomicLong totalDelta = new AtomicLong(0L);

            Times() {
            }

            private void update(long timeInterval) {
                long oldValue;
                this.totalDelta.addAndGet(timeInterval);
                while (!this.minDelta.compareAndSet(oldValue = this.minDelta.get(), Math.min(timeInterval, oldValue))) {
                }
                while (!this.maxDelta.compareAndSet(oldValue = this.maxDelta.get(), Math.max(timeInterval, oldValue))) {
                }
            }

            private void accumulate() {
                long oldValue;
                this.totalAccumulator.set(this.totalAccumulator.get().add(BigInteger.valueOf(this.totalDelta.getAndSet(0L))));
                long delta = this.minDelta.getAndSet(0L);
                while (!this.minAccumulator.compareAndSet(oldValue = this.minAccumulator.get(), Math.min(delta, oldValue))) {
                }
                delta = this.maxDelta.getAndSet(0L);
                while (!this.maxAccumulator.compareAndSet(oldValue = this.maxAccumulator.get(), Math.max(delta, oldValue))) {
                }
            }

            long minDelta() {
                long val = this.minDelta.get();
                return val < Long.MAX_VALUE ? val : 0L;
            }

            long maxDelta() {
                long val = this.maxDelta.get();
                return val > Long.MIN_VALUE ? val : 0L;
            }

            long totalDelta() {
                return this.totalDelta.get();
            }

            long minTotal() {
                long val = Math.min(this.minAccumulator.get(), this.minDelta.get());
                return val < Long.MAX_VALUE ? val : 0L;
            }

            long maxTotal() {
                long val = Math.max(this.maxAccumulator.get(), this.maxDelta.get());
                return val > Long.MIN_VALUE ? val : 0L;
            }

            public BigInteger total() {
                return this.totalAccumulator.get().add(BigInteger.valueOf(this.totalDelta.get()));
            }
        }
    }

    private static class MixTable {
        private int[] mixTable;
        private static final int MIX_TABLE_SIZE = 4096;
        private static final int IRREDUCIBLE_POLYNOMIAL = 4105;
        private static final int MIX_TABLE_GENERATOR = 3;

        MixTable() {
            this.generateMixTable();
        }

        int nextPartition(int pid) {
            return this.mixTable[pid % this.mixTable.length];
        }

        int size() {
            return this.mixTable.length;
        }

        private void generateMixTable() {
            if (this.mixTable != null) {
                return;
            }
            int[] alog = new int[4096];
            alog[0] = 1;
            for (int i = 1; i < 4096; ++i) {
                alog[i] = alog[i - 1] << 1 ^ alog[i - 1];
                if ((alog[i] & 0x1000) == 0) continue;
                int n = i;
                alog[n] = alog[n] ^ 0x1009;
            }
            int[] log = new int[4096];
            for (int i = 0; i < 4096; ++i) {
                log[alog[i]] = i;
            }
            log[0] = 4096;
            int[] mix = new int[4096];
            for (int i = 1; i < 4096; ++i) {
                mix[log[i - 1] - 1] = log[i] - 1;
            }
            mix[log[4095] - 1] = log[0] - 1;
            this.mixTable = mix;
        }
    }
}

