/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.routing;

import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLType;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import oracle.jdbc.OracleShardingKey;
import oracle.jdbc.OracleType;
import oracle.jdbc.pool.OracleShardingKeyBuilderImpl;
import oracle.jdbc.pool.OracleShardingKeyImpl;
import oracle.jdbc.pool.ShardingMetadata;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.common.FailoverDriver;
import oracle.ucp.common.ServiceMember;
import oracle.ucp.diagnostics.Diagnosable;
import oracle.ucp.jdbc.JDBCConnectionRetrievalInfo;
import oracle.ucp.routing.Chunk;
import oracle.ucp.routing.HashRangeShardingKeys;
import oracle.ucp.routing.ListShardingKeys;
import oracle.ucp.routing.RangeShardingKeys;
import oracle.ucp.routing.RoutingKey;
import oracle.ucp.routing.ShardRoutingCache;
import oracle.ucp.routing.ShardingKeys;
import oracle.ucp.routing.SuperShardingKeys;

public abstract class RACDataAffinityRoutingCache
extends ShardRoutingCache {
    public RACDataAffinityRoutingCache(Diagnosable diagnosticsCollector) {
        super(diagnosticsCollector);
    }

    @Override
    protected RoutingKey makeRoutingKey(Chunk.Metadata chunkInfo) throws SQLException {
        ShardingKeys shardingKeys;
        ShardingMetadata sm = this.shardingMetadata();
        ShardingMetadata.ShardingType sType = this.shardingMetadata().getShardingType();
        SuperShardingKeys superShardingKeys = SuperShardingKeys.DEFAULT_SUPER_SHARDING_KEYS;
        if (sType == ShardingMetadata.ShardingType.LIST) {
            shardingKeys = new ListShardingKeys(OracleShardingKeyImpl.decodeKeys((InputStream)chunkInfo.shardKeyHigh, (ShardingMetadata)sm, (boolean)false, (boolean)true));
        } else if (sType == ShardingMetadata.ShardingType.RANGE) {
            shardingKeys = new RangeShardingKeys((OracleShardingKey)OracleShardingKeyImpl.decodeKeys((InputStream)chunkInfo.shardKeyHigh, (ShardingMetadata)sm, (boolean)false, (boolean)true).get(0), (OracleShardingKey)OracleShardingKeyImpl.decodeKeys((InputStream)chunkInfo.shardKeyLow, (ShardingMetadata)sm, (boolean)false, (boolean)false).get(0));
        } else if (sType == ShardingMetadata.ShardingType.HASH) {
            OracleShardingKeyImpl dummyKey = new OracleShardingKeyBuilderImpl().subkey((Object)chunkInfo.chunkId, (SQLType)OracleType.NUMBER).build();
            shardingKeys = new HashRangeShardingKeys((OracleShardingKey)dummyKey, (OracleShardingKey)dummyKey);
        } else {
            throw new IllegalStateException("Shard Type in database not recognized");
        }
        return new RoutingKey(shardingKeys, superShardingKeys);
    }

    private List<Chunk> chunks(ConnectionRetrievalInfo cri) {
        if (!(cri instanceof JDBCConnectionRetrievalInfo)) {
            return Collections.emptyList();
        }
        JDBCConnectionRetrievalInfo jdbcCri = (JDBCConnectionRetrievalInfo)cri;
        OracleShardingKey key = jdbcCri.getShardingKey();
        if (Objects.isNull(key) || Objects.isNull(this.shardingMetadata())) {
            return Collections.emptyList();
        }
        ShardingMetadata.ShardingType sType = this.shardingMetadata().getShardingType();
        if (sType == ShardingMetadata.ShardingType.LIST || sType == ShardingMetadata.ShardingType.RANGE) {
            return this.chunks(null, key);
        }
        return this.chunks(this.getChunkId(key));
    }

    private int getChunkId(OracleShardingKey shardingKey) {
        long chunkCount = this.chunksCount();
        long hashMask = 1L;
        long bucketSize = chunkCount;
        while ((bucketSize >>= 1) > 0L) {
            hashMask <<= 1;
        }
        hashMask = (hashMask << 1) - 1L;
        long keyHashValue = ((OracleShardingKeyImpl)shardingKey).shardKeyOraHash(this.shardingMetadata());
        long hashBucket = keyHashValue & hashMask;
        if (hashBucket >= chunkCount) {
            hashBucket = keyHashValue & hashMask >> 1;
        }
        return (int)(hashBucket + 1L);
    }

    @Override
    protected boolean hasKeyMapped(OracleShardingKey shardingKey, OracleShardingKey superKey) {
        return this.chunksCount() > 0;
    }

    @Override
    public ServiceMember getBestInstanceToGrow(ConnectionRetrievalInfo cri) {
        return this.getAffinitizedInstance(cri);
    }

    @Override
    public Set<ServiceMember> instancesToGrow(ConnectionRetrievalInfo cri) {
        return this.allInstances(cri);
    }

    @Override
    public Set<ServiceMember> allInstances(ConnectionRetrievalInfo cri) {
        HashSet<ServiceMember> affinitizedInstanceSet = new HashSet<ServiceMember>();
        ServiceMember affinitizedInstance = this.getAffinitizedInstance(cri);
        if (affinitizedInstance != null) {
            affinitizedInstanceSet.add(affinitizedInstance);
        }
        return affinitizedInstanceSet;
    }

    @Override
    public Set<ServiceMember> allPriorityInstances(ConnectionRetrievalInfo cri) {
        return this.allInstances(cri);
    }

    private ServiceMember getAffinitizedInstance(ConnectionRetrievalInfo cri) {
        List<Chunk> reqChunks = this.chunks(cri);
        if (reqChunks != null && reqChunks.size() > 0) {
            for (Chunk chunk : reqChunks) {
                for (ServiceMember instance : this.service().getAllMembers()) {
                    if (instance.dbInstanceId() != chunk.affinitizedInstId().get()) continue;
                    return instance;
                }
            }
        }
        return null;
    }

    @Override
    protected boolean multipleTableFamilySupported(Connection conn) throws SQLException {
        return false;
    }

    @Override
    public void onHAEvent(FailoverDriver.Event haEvent) {
    }

    @Override
    public void onConnectionBorrow(Connection connection, ConnectionRetrievalInfo cri, Consumer<String> setChunkNameConsumer) throws SQLException {
    }

    @Override
    public void onConnectionReturn(Connection connection) throws SQLException {
    }
}

