/*
 * Decompiled with CFR 0.152.
 */
package oracle.streams;

import java.math.BigInteger;
import java.util.HashMap;
import oracle.sql.BINARY_DOUBLE;
import oracle.sql.BINARY_FLOAT;
import oracle.sql.BOOLEAN;
import oracle.sql.CHAR;
import oracle.sql.CharacterSet;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.INTERVALDS;
import oracle.sql.INTERVALYM;
import oracle.sql.NUMBER;
import oracle.sql.RAW;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;
import oracle.streams.AbstractLCR;
import oracle.streams.ChunkColumnValue;
import oracle.streams.ColumnValue;
import oracle.streams.DefaultChunkColumnValue;
import oracle.streams.DefaultColumnValue;
import oracle.streams.DefaultRowLCR;
import oracle.streams.LCR;
import oracle.streams.RowLCR;
import oracle.streams.StreamsException;

final class DefaultRowLCRCache {
    static final int MaxColumnNumber = 4096;
    static final int MaxNameLength = 128;
    static final int MaxNameLength3X = 384;
    static final int InitialColumnValueLength = 100;
    static final int MaxAttributeNumber = 12;
    static final int MaxLowWaterMarkLength = 64;
    static HashMap<String, Integer> rowCommandType = new HashMap();
    static final int KNGLROW_OPNUM_LOB_ERASE = 29;
    static final int KNGLROW_OPNUM_LOB_WRITE = 10;
    static final int KNGLROW_OPNUM_LOB_TRIM = 11;
    static final int KNJ_REALLOCATE_HEADER = 0;
    static final int KNJ_REALLOCATE_ATTRIBUTE = 1;
    static final int KNJ_REALLOCATE_COLUMNVALUE_OLD = 2;
    static final int KNJ_REALLOCATE_COLUMNVALUE_NEW = 3;
    static final int KNJ_REALLOCATE_COLUMNVALUE_STMT = 4;
    static final int JAVA_LCR_COLUMN_LOB_DATA = 0;
    static final int JAVA_LCR_COLUMN_LONG_DATA = 1;
    static final int JAVA_LCR_COLUMN_EMPTY_LOB = 2;
    static final int JAVA_LCR_COLUMN_LAST_CHUNK = 3;
    static final int JAVA_LCR_COLUMN_AL16UTF16 = 4;
    static final int JAVA_LCR_COLUMN_NCLOB = 5;
    static final int JAVA_LCR_COLUMN_XML_DATA = 6;
    static final int JAVA_LCR_COLUMN_XML_DIFF = 7;
    static final int JAVA_LCR_COLUMN_ENCRYPTED = 8;
    static final int JAVA_LCR_COLUMN_32K_DATA = 10;
    static final int JAVA_LCR_COLUMN_OSON_DATA = 11;
    static final int JAVA_LCR_COLUMN_OSON_DIFF = 12;
    private final int DTYCHR = 1;
    private final int DTYNUM = 2;
    private final int DTYINT = 3;
    private final int DTYFLT = 4;
    private final int DTYDAT = 12;
    private final int DTYBIN = 23;
    private final int DTYAFC = 96;
    private final int DTYIBFLOAT = 100;
    private final int DTYIBDOUBLE = 101;
    private final int DTYSTAMP = 180;
    private final int DTYSTZ = 181;
    private final int DTYIYM = 182;
    private final int DTYIDS = 183;
    private final int DTYBURI = 208;
    private final int DTYSITZ = 231;
    private final int DTYBFIL = 114;
    private final int DTYBOL = 252;
    static final int HeaderFieldNumber = 10;
    static final int Ub2BufLength = 20;
    static final int sourceDatabaseNameInd = 0;
    static final int commandTypeInd = 1;
    static final int objectOwnerInd = 2;
    static final int objectNameInd = 3;
    static final int tagInd = 4;
    static final int positionInd = 5;
    static final int transactionIdInd = 6;
    static final int sourceTimeInd = 7;
    static final int scnInd = 8;
    static final int cscnInd = 9;
    static final int oldColumnNumberInd = 10;
    static final int newColumnNumberInd = 11;
    static final int attributeNumberInd = 12;
    static final int lowWaterMarkLengthInd = 13;
    static final int batchStatusInd = 14;
    static final int attributeCSIDInd = 15;
    static final int chunkDataFlagInd = 16;
    static final int commandTypeNumInd = 17;
    static final int stmtLengthInd = 18;
    static final int stmtColumnNumberInd = 19;
    int[] headerFieldLength = new int[20];
    static final int InitialHeaderFieldLength = 100;
    byte[][] headerFieldData = new byte[10][100];
    long flag = 0L;
    static final int JAVA_LCR_FLAG_HAS_ID_KEY_ONLY = 0;
    static final int JAVA_LCR_FLAG_STMT_LCR = 1;
    static final int JAVA_LCR_FLAG_STMT_BIND_BY_POS = 2;
    static final int JAVA_LCR_FLAG_DIRECT_PATH = 3;
    static final int JAVA_LCR_FLAG_SEQ_LCR = 4;
    short[] attributeNameLength = new short[12];
    byte[] attributeName = new byte[1536];
    short[] attributeType = new short[12];
    short[] attributeValueLength = new short[12];
    byte[][] attributeValue = new byte[12][100];
    byte[] lowWaterMark = new byte[64];
    private ColumnValueCache oldValues;
    private ColumnValueCache newValues;
    byte[] stmt = new byte[100];
    private ColumnValueCache stmtValues;

    boolean KNJLCR_LOB_COLUMN(BigInteger bigInteger) {
        return bigInteger.testBit(0) || bigInteger.testBit(3) || bigInteger.testBit(2) || bigInteger.testBit(5);
    }

    boolean KNJLCR_LOBLONGXML_COLUMN(BigInteger bigInteger) {
        return this.KNJLCR_LOB_COLUMN(bigInteger) || bigInteger.testBit(6) || bigInteger.testBit(7) || bigInteger.testBit(1);
    }

    DefaultRowLCRCache() {
        this.headerFieldLength = new int[20];
        this.headerFieldData = new byte[10][100];
        this.attributeNameLength = new short[12];
        this.attributeName = new byte[1536];
        this.attributeType = new short[12];
        this.attributeValueLength = new short[12];
        this.attributeValue = new byte[12][100];
        this.lowWaterMark = new byte[64];
        this.oldValues = new ColumnValueCache();
        this.newValues = new ColumnValueCache();
        this.stmt = new byte[100];
        this.stmtValues = new ColumnValueCache();
    }

    static int reserve(Object object, int n, int n2) {
        byte[][] byArray = (byte[][])object;
        if (byArray[n].length >= n2) {
            return byArray[n].length;
        }
        byArray[n] = new byte[2 * n2];
        return 2 * n2;
    }

    int reserveArray(int n) {
        if (this.stmt.length >= n) {
            return this.stmt.length;
        }
        this.stmt = new byte[n];
        return n;
    }

    static int shortToUB2(short n) {
        return n >= 0 ? n : n + 65536;
    }

    static short uB2ToShort(int n) {
        return (short)(n <= Short.MAX_VALUE ? n : n - 65536);
    }

    static BigInteger longToUB8(long l) {
        return l >= 0L ? BigInteger.valueOf(l) : BigInteger.valueOf(l).add(BigInteger.ONE.shiftLeft(64));
    }

    static long uB8ToLong(BigInteger bigInteger) {
        return bigInteger.compareTo(BigInteger.ONE.shiftLeft(63)) < 0 ? bigInteger.longValue() : bigInteger.subtract(BigInteger.ONE.shiftLeft(64)).longValue();
    }

    static byte[] copyByteArray(byte[] byArray, int n, int n2) {
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        return byArray2;
    }

    DefaultRowLCR exportDefaultRowLCR() throws StreamsException {
        DefaultRowLCR defaultRowLCR = new DefaultRowLCR(new String(this.headerFieldData[0], 0, this.headerFieldLength[0]), new String(this.headerFieldData[1], 0, this.headerFieldLength[1]), new String(this.headerFieldData[2], 0, this.headerFieldLength[2]), new String(this.headerFieldData[3], 0, this.headerFieldLength[3]), new String(this.headerFieldData[6], 0, this.headerFieldLength[6]), DefaultRowLCRCache.copyByteArray(this.headerFieldData[4], 0, this.headerFieldLength[4]), DefaultRowLCRCache.copyByteArray(this.headerFieldData[5], 0, this.headerFieldLength[5]), new DATE(DefaultRowLCRCache.copyByteArray(this.headerFieldData[7], 0, this.headerFieldLength[7])));
        if (this.headerFieldLength[16] == 1) {
            defaultRowLCR.setChunkDataFlag(true);
        }
        BigInteger bigInteger = DefaultRowLCRCache.longToUB8(this.flag);
        defaultRowLCR.setSequenceLCRFlag(bigInteger.testBit(4));
        defaultRowLCR.setIDKeyColumnsOnly(bigInteger.testBit(0));
        CharacterSet characterSet = CharacterSet.make((int)this.headerFieldLength[15]);
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < this.headerFieldLength[12]; ++i) {
            n = DefaultRowLCRCache.shortToUB2(this.attributeNameLength[i]);
            if (n <= 0) continue;
            n2 = DefaultRowLCRCache.shortToUB2(this.attributeType[i]);
            if (1 == n2 || 96 == n2 || 208 == n2) {
                defaultRowLCR.setAttribute(new String(this.attributeName, i * 128, n), new CHAR(DefaultRowLCRCache.copyByteArray(this.attributeValue[i], 0, DefaultRowLCRCache.shortToUB2(this.attributeValueLength[i])), characterSet));
                continue;
            }
            if (2 == n2 || 3 == n2 || 4 == n2) {
                defaultRowLCR.setAttribute(new String(this.attributeName, i * 128, n), new NUMBER(DefaultRowLCRCache.copyByteArray(this.attributeValue[i], 0, DefaultRowLCRCache.shortToUB2(this.attributeValueLength[i]))));
                continue;
            }
            throw new StreamsException("DefaultRowLCRCache.exportDefaultRowLCR Unsupported attribute data type: " + n2 + ", name: " + new String(this.attributeName, i * 128, n));
        }
        defaultRowLCR.setOldValues(this.oldValues.exportColumnValue(this.headerFieldLength[10], this.headerFieldLength[17]));
        defaultRowLCR.setNewValues(this.newValues.exportColumnValue(this.headerFieldLength[11], this.headerFieldLength[17]));
        defaultRowLCR.setStatement(null, null, false);
        return defaultRowLCR;
    }

    void importRowLCR(LCR lCR, long l, long l2) throws StreamsException {
        Object object;
        Object object2;
        if (!(lCR instanceof RowLCR)) {
            throw new StreamsException("Input lcr to importRowLCR is not a RowLCR");
        }
        RowLCR rowLCR = (RowLCR)lCR;
        for (int i = 0; i < this.headerFieldLength.length; ++i) {
            this.headerFieldLength[i] = 0;
        }
        byte[] byArray = rowLCR.getSourceDatabaseName().getBytes();
        this.headerFieldLength[0] = byArray.length;
        if (byArray.length <= this.headerFieldData[0].length) {
            System.arraycopy(byArray, 0, this.headerFieldData[0], 0, byArray.length);
        } else {
            this.headerFieldData[0] = byArray;
            this.ReallocateCacheArrayNative(l, l2, 0, 0, byArray.length);
        }
        byArray = rowLCR.getCommandType().getBytes();
        this.headerFieldLength[1] = byArray.length;
        if (byArray.length <= this.headerFieldData[1].length) {
            System.arraycopy(byArray, 0, this.headerFieldData[1], 0, byArray.length);
        } else {
            this.headerFieldData[1] = byArray;
            this.ReallocateCacheArrayNative(l, l2, 0, 1, byArray.length);
        }
        this.headerFieldLength[17] = rowCommandType.get(rowLCR.getCommandType());
        if (rowLCR.getObjectOwner() == null) {
            this.headerFieldLength[2] = 0;
        } else {
            byArray = rowLCR.getObjectOwner().getBytes();
            this.headerFieldLength[2] = byArray.length;
            if (byArray.length <= this.headerFieldData[2].length) {
                System.arraycopy(byArray, 0, this.headerFieldData[2], 0, byArray.length);
            } else {
                this.headerFieldData[2] = byArray;
                this.ReallocateCacheArrayNative(l, l2, 0, 2, byArray.length);
            }
        }
        if (rowLCR.getObjectName() == null) {
            this.headerFieldLength[3] = 0;
        } else {
            byArray = rowLCR.getObjectName().getBytes();
            this.headerFieldLength[3] = byArray.length;
            if (byArray.length <= this.headerFieldData[3].length) {
                System.arraycopy(byArray, 0, this.headerFieldData[3], 0, byArray.length);
            } else {
                this.headerFieldData[3] = byArray;
                this.ReallocateCacheArrayNative(l, l2, 0, 3, byArray.length);
            }
        }
        byArray = rowLCR.getTransactionId().getBytes();
        this.headerFieldLength[6] = byArray.length;
        if (byArray.length <= this.headerFieldData[6].length) {
            System.arraycopy(byArray, 0, this.headerFieldData[6], 0, byArray.length);
        } else {
            this.headerFieldData[6] = byArray;
            this.ReallocateCacheArrayNative(l, l2, 0, 6, byArray.length);
        }
        byArray = rowLCR.getTag();
        int n = this.headerFieldLength[4] = byArray == null ? 0 : byArray.length;
        if (byArray != null) {
            if (byArray.length <= this.headerFieldData[4].length) {
                System.arraycopy(byArray, 0, this.headerFieldData[4], 0, byArray.length);
            } else {
                this.headerFieldData[4] = byArray;
                this.ReallocateCacheArrayNative(l, l2, 0, 4, byArray.length);
            }
        }
        byArray = rowLCR.getPosition();
        this.headerFieldLength[5] = byArray.length;
        if (byArray.length <= this.headerFieldData[5].length) {
            System.arraycopy(byArray, 0, this.headerFieldData[5], 0, byArray.length);
        } else {
            this.headerFieldData[5] = byArray;
            this.ReallocateCacheArrayNative(l, l2, 0, 5, byArray.length);
        }
        byArray = rowLCR.getSourceTime().getBytes();
        this.headerFieldLength[7] = byArray.length;
        if (byArray.length <= this.headerFieldData[7].length) {
            System.arraycopy(byArray, 0, this.headerFieldData[7], 0, byArray.length);
        } else {
            this.headerFieldData[7] = byArray;
            this.ReallocateCacheArrayNative(l, l2, 0, 7, byArray.length);
        }
        int n2 = this.headerFieldLength[16] = rowLCR.hasChunkData() ? 1 : 0;
        if (rowLCR instanceof DefaultRowLCR) {
            object2 = (ColumnValue[])rowLCR;
            object = BigInteger.ZERO;
            if (object2.isSequenceLCR()) {
                object = ((BigInteger)object).setBit(4);
            }
            if (object2.hasIDKeyColumnsOnly()) {
                object = ((BigInteger)object).setBit(0);
            }
            if (object2.isStatementLCR()) {
                // empty if block
            }
            this.flag = DefaultRowLCRCache.uB8ToLong((BigInteger)object);
        } else {
            this.flag = 0L;
        }
        if (rowLCR instanceof AbstractLCR) {
            object = (AbstractLCR)((Object)rowLCR);
            this.headerFieldLength[12] = ((AbstractLCR)object).getNumAttributes();
            for (int i = 0; i < this.headerFieldLength[12]; ++i) {
                object2 = ((AbstractLCR)object).getAttributeName(i);
                if (null == object2 || ((String)object2).length() == 0) {
                    throw new StreamsException("Null or length 0 attribute name " + i);
                }
                byArray = ((String)object2).getBytes();
                this.attributeNameLength[i] = DefaultRowLCRCache.uB2ToShort(byArray.length);
                System.arraycopy(byArray, 0, this.attributeName, i * 128, byArray.length);
                object2 = ((AbstractLCR)object).getAttributeValue(i);
                if (null == object2) {
                    this.attributeValueLength[i] = 0;
                    continue;
                }
                if (object2 instanceof CHAR) {
                    this.attributeType[i] = DefaultRowLCRCache.uB2ToShort(1);
                } else if (object2 instanceof NUMBER) {
                    this.attributeType[i] = DefaultRowLCRCache.uB2ToShort(2);
                } else {
                    throw new StreamsException("Unsupported attribute value(" + i + ") type.");
                }
                byArray = ((Datum)object2).getBytes();
                this.attributeValueLength[i] = DefaultRowLCRCache.uB2ToShort(byArray.length);
                if (this.attributeValue[i].length >= byArray.length) {
                    System.arraycopy(byArray, 0, this.attributeValue[i], 0, byArray.length);
                    continue;
                }
                this.attributeValue[i] = byArray;
                this.ReallocateCacheArrayNative(l, l2, 1, i, byArray.length);
            }
        } else {
            this.headerFieldLength[12] = 0;
        }
        int n3 = this.headerFieldLength[10] = (object2 = rowLCR.getOldValues()) == null ? 0 : ((ColumnValue[])object2).length;
        if (object2 != null) {
            this.oldValues.importColumnValue((ColumnValue[])object2, l, l2, 2, this.headerFieldLength[17]);
        }
        int n4 = this.headerFieldLength[11] = (object2 = rowLCR.getNewValues()) == null ? 0 : ((ColumnValue[])object2).length;
        if (object2 != null) {
            this.newValues.importColumnValue((ColumnValue[])object2, l, l2, 3, this.headerFieldLength[17]);
        }
        if (rowLCR instanceof DefaultRowLCR) {
            object = (DefaultRowLCR)rowLCR;
            if (((DefaultRowLCR)object).isStatementLCR()) {
                byArray = ((DefaultRowLCR)object).getStatement(false).getBytes();
                this.headerFieldLength[18] = byArray.length;
                if (byArray.length <= this.stmt.length) {
                    System.arraycopy(byArray, 0, this.stmt, 0, byArray.length);
                } else {
                    this.stmt = byArray;
                    this.RefreshArrayRefNative(l, l2, byArray.length);
                }
            }
            int n5 = this.headerFieldLength[19] = (object2 = ((DefaultRowLCR)object).getBinds()) == null ? 0 : ((ColumnValue[])object2).length;
            if (object2 != null) {
                this.stmtValues.importColumnValue((ColumnValue[])object2, l, l2, 4, this.headerFieldLength[17]);
            }
        }
    }

    static String byteArrayToString(byte[] byArray, int n, int n2) {
        if (n2 <= 0) {
            return "[]";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[" + Integer.toHexString(byArray[n]));
        for (int i = 1; i < n2; ++i) {
            stringBuffer.append(" " + Integer.toHexString(byArray[n + i]));
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("DefaultRowLCRCache:\n");
        stringBuffer.append("Fetch low watermark: Len: " + this.headerFieldLength[13] + " : " + DefaultRowLCRCache.byteArrayToString(this.lowWaterMark, 0, this.headerFieldLength[13]) + "\n");
        stringBuffer.append("batch status: " + this.headerFieldLength[14] + "\n");
        stringBuffer.append("chunkDataFlag: " + this.headerFieldLength[16] + "\n");
        stringBuffer.append("command type number: " + this.headerFieldLength[17] + "\n");
        stringBuffer.append("Header fields:\n");
        for (n = 0; n < 10; ++n) {
            stringBuffer.append("(" + n + "): Len: " + this.headerFieldLength[n] + ", data: " + DefaultRowLCRCache.byteArrayToString(this.headerFieldData[n], 0, this.headerFieldLength[n]) + "\n");
        }
        stringBuffer.append("lcr flag: 0x" + Long.toString(this.flag, 16) + "\n");
        stringBuffer.append("Attributes(num = " + this.headerFieldLength[12] + ", csid = " + this.headerFieldLength[15] + "):\n");
        for (n = 0; n < this.headerFieldLength[12]; ++n) {
            stringBuffer.append("(" + n + "): Name-Len: " + this.attributeNameLength[n] + ", Name: " + DefaultRowLCRCache.byteArrayToString(this.attributeName, n * 128, DefaultRowLCRCache.shortToUB2(this.attributeNameLength[n])) + ", Type: " + this.attributeType[n] + ", Value-Len: " + this.attributeValueLength[n] + ", Value: " + DefaultRowLCRCache.byteArrayToString(this.attributeValue[n], 0, DefaultRowLCRCache.shortToUB2(this.attributeValueLength[n])) + "\n");
        }
        stringBuffer.append("Old column value:\n" + this.oldValues.toString(this.headerFieldLength[10]));
        stringBuffer.append("\nNew column value:\n" + this.newValues.toString(this.headerFieldLength[11]));
        BigInteger bigInteger = DefaultRowLCRCache.longToUB8(this.flag);
        if (bigInteger.testBit(1)) {
            stringBuffer.append("stmt Len: " + this.headerFieldLength[18] + ", data: " + DefaultRowLCRCache.byteArrayToString(this.stmt, 0, this.headerFieldLength[18]) + "\n");
            stringBuffer.append("\nStatement column value:\n" + this.stmtValues.toString(this.headerFieldLength[19]));
        }
        return stringBuffer.toString();
    }

    private synchronized native void ReallocateCacheArrayNative(long var1, long var3, int var5, int var6, int var7) throws StreamsException;

    private synchronized native int RefreshArrayRefNative(long var1, long var3, int var5) throws StreamsException;

    static {
        rowCommandType.put("INSERT", 1);
        rowCommandType.put("DELETE", 2);
        rowCommandType.put("UPDATE", 3);
        rowCommandType.put("START_TX", 6);
        rowCommandType.put("COMMIT", 7);
        rowCommandType.put("ROLLBACK", 36);
        rowCommandType.put("ROLLBACK TO UBA", 26);
        rowCommandType.put("LOB LOCATOR", 9);
        rowCommandType.put("LOB ERASE", 29);
        rowCommandType.put("LOB WRITE", 10);
        rowCommandType.put("LOB TRIM", 11);
        rowCommandType.put("LONG WRITE", 103);
        rowCommandType.put("XML DOC_START", 68);
        rowCommandType.put("XML DIFF_START", 69);
        rowCommandType.put("XML DOC_END", 71);
        rowCommandType.put("XML DIFF_END", 72);
        rowCommandType.put("XML WRITE", 70);
    }

    private class ColumnValueCache {
        short[] columnNameLength = new short[4096];
        byte[] columnName = new byte[0x180000];
        short[] columnValueLength = new short[4096];
        byte[][] columnValue = new byte[4096][100];
        short[] csid = new short[4096];
        short[] columnType = new short[4096];
        long[] columnFlag = new long[4096];
        long[] lobOffset = new long[4096];
        long[] lobSize = new long[4096];
        int[] columnChunkType = new int[4096];

        private ColumnValueCache() {
            this.columnNameLength = new short[4096];
            this.columnName = new byte[0x180000];
            this.columnValueLength = new short[4096];
            this.columnValue = new byte[4096][100];
            this.csid = new short[4096];
            this.columnType = new short[4096];
            this.columnFlag = new long[4096];
            this.lobOffset = new long[4096];
            this.lobSize = new long[4096];
            this.columnChunkType = new int[4096];
        }

        private int getChunkType(int n, BigInteger bigInteger) {
            if (23 == n) {
                if (bigInteger.testBit(0)) {
                    if (bigInteger.testBit(5)) {
                        return 3;
                    }
                    if (bigInteger.testBit(4)) {
                        return 1;
                    }
                    if (bigInteger.testBit(11)) {
                        return 7;
                    }
                    return 2;
                }
                if (bigInteger.testBit(6)) {
                    return 4;
                }
                if (bigInteger.testBit(1)) {
                    return 6;
                }
            } else {
                if (bigInteger.testBit(0)) {
                    if (bigInteger.testBit(5)) {
                        return 3;
                    }
                    return 1;
                }
                if (bigInteger.testBit(6)) {
                    return 4;
                }
                if (bigInteger.testBit(1)) {
                    return 5;
                }
            }
            return 0;
        }

        private ColumnValue[] exportColumnValue(int n, int n2) throws StreamsException {
            if (n <= 0) {
                return new ColumnValue[0];
            }
            String string = null;
            int n3 = 0;
            NUMBER nUMBER = null;
            int n4 = 0;
            byte[] byArray = null;
            ColumnValue[] columnValueArray = new ColumnValue[n];
            for (int i = 0; i < n; ++i) {
                block24: {
                    block23: {
                        string = new String(this.columnName, i * 384, DefaultRowLCRCache.shortToUB2(this.columnNameLength[i]));
                        n4 = DefaultRowLCRCache.shortToUB2(this.columnValueLength[i]);
                        n3 = DefaultRowLCRCache.shortToUB2(this.columnType[i]);
                        if (n4 == 0) break block23;
                        byArray = new byte[n4];
                        System.arraycopy(this.columnValue[i], 0, byArray, 0, n4);
                        switch (n3) {
                            case 1: 
                            case 96: {
                                nUMBER = new CHAR(DefaultRowLCRCache.copyByteArray(this.columnValue[i], 0, n4), CharacterSet.make((int)DefaultRowLCRCache.shortToUB2(this.csid[i])));
                                break block24;
                            }
                            case 2: 
                            case 3: 
                            case 4: {
                                nUMBER = new NUMBER(DefaultRowLCRCache.copyByteArray(this.columnValue[i], 0, n4));
                                break block24;
                            }
                            case 12: {
                                nUMBER = new DATE(DefaultRowLCRCache.copyByteArray(this.columnValue[i], 0, n4));
                                break block24;
                            }
                            case 180: {
                                nUMBER = new TIMESTAMP(DefaultRowLCRCache.copyByteArray(this.columnValue[i], 0, n4));
                                break block24;
                            }
                            case 181: {
                                nUMBER = new TIMESTAMPTZ(DefaultRowLCRCache.copyByteArray(this.columnValue[i], 0, n4));
                                break block24;
                            }
                            case 231: {
                                nUMBER = new TIMESTAMPLTZ(DefaultRowLCRCache.copyByteArray(this.columnValue[i], 0, n4));
                                break block24;
                            }
                            case 182: {
                                nUMBER = new INTERVALYM(DefaultRowLCRCache.copyByteArray(this.columnValue[i], 0, n4));
                                break block24;
                            }
                            case 183: {
                                nUMBER = new INTERVALDS(DefaultRowLCRCache.copyByteArray(this.columnValue[i], 0, n4));
                                break block24;
                            }
                            case 100: {
                                nUMBER = new BINARY_FLOAT(DefaultRowLCRCache.copyByteArray(this.columnValue[i], 0, n4));
                                break block24;
                            }
                            case 101: {
                                nUMBER = new BINARY_DOUBLE(DefaultRowLCRCache.copyByteArray(this.columnValue[i], 0, n4));
                                break block24;
                            }
                            case 23: 
                            case 114: 
                            case 208: {
                                nUMBER = new RAW(DefaultRowLCRCache.copyByteArray(this.columnValue[i], 0, n4));
                                break block24;
                            }
                            case 252: {
                                nUMBER = new BOOLEAN(DefaultRowLCRCache.copyByteArray(this.columnValue[i], 0, n4));
                                break block24;
                            }
                            default: {
                                throw new StreamsException("wrong column data type, column: " + i + ", type = " + n3);
                            }
                        }
                    }
                    nUMBER = null;
                }
                BigInteger bigInteger = DefaultRowLCRCache.longToUB8(this.columnFlag[i]);
                if (DefaultRowLCRCache.this.KNJLCR_LOBLONGXML_COLUMN(bigInteger)) {
                    columnValueArray[i] = new DefaultChunkColumnValue(string, (Datum)nUMBER, this.getChunkType(n3, bigInteger), BigInteger.valueOf(this.lobOffset[i]), BigInteger.valueOf(this.lobSize[i]));
                    if (bigInteger.testBit(3) && (n2 == 29 || n2 == 10 || n2 == 11)) {
                        ((DefaultChunkColumnValue)columnValueArray[i]).setLastChunk(true);
                    }
                    if (bigInteger.testBit(2)) {
                        ((DefaultChunkColumnValue)columnValueArray[i]).setEmptyChunk(true);
                    }
                    if (bigInteger.testBit(7)) {
                        ((DefaultChunkColumnValue)columnValueArray[i]).setXMLDiff(true);
                    }
                    if (bigInteger.testBit(6)) {
                        ((DefaultChunkColumnValue)columnValueArray[i]).setCharSetId(DefaultRowLCRCache.shortToUB2(this.csid[i]));
                    }
                    if (bigInteger.testBit(12)) {
                        ((DefaultChunkColumnValue)columnValueArray[i]).setJSONDiff(true);
                    }
                } else {
                    columnValueArray[i] = new DefaultColumnValue(string, (Datum)nUMBER, n3);
                }
                columnValueArray[i].setTDEFlag(bigInteger.testBit(8));
                columnValueArray[i].set32kData(bigInteger.testBit(10));
            }
            return columnValueArray;
        }

        private void importColumnValue(ColumnValue[] columnValueArray, long l, long l2, int n, int n2) throws StreamsException {
            int n3 = columnValueArray.length;
            boolean bl = false;
            for (int i = 0; i < n3; ++i) {
                if (columnValueArray[i] == null) {
                    throw new StreamsException("ColumnValueCache.importColumnValue: column value element " + i + " is null");
                }
                if (columnValueArray[i].getColumnName() == null) {
                    throw new StreamsException("ColumnValueCache.importColumnValue: column name " + i + " is null");
                }
                byte[] byArray = columnValueArray[i].getColumnName().getBytes();
                if (byArray.length == 0 || byArray.length > 384) {
                    throw new StreamsException("ColumnValueCache.importColumnValue: length " + byArray.length + " of column name " + i + " is out of range");
                }
                this.columnNameLength[i] = DefaultRowLCRCache.uB2ToShort(byArray.length);
                System.arraycopy(byArray, 0, this.columnName, i * 384, byArray.length);
                BigInteger bigInteger = BigInteger.ZERO;
                if (columnValueArray[i].getTDEFlag()) {
                    bigInteger = bigInteger.setBit(8);
                }
                if (columnValueArray[i].is32kData()) {
                    bigInteger = bigInteger.setBit(10);
                }
                bl = columnValueArray[i] instanceof ChunkColumnValue;
                Datum datum = columnValueArray[i].getColumnData();
                if (datum == null) {
                    this.columnValueLength[i] = DefaultRowLCRCache.uB2ToShort(0);
                    this.columnType[i] = DefaultRowLCRCache.uB2ToShort(columnValueArray[i].getColumnDataType());
                } else {
                    byArray = datum.shareBytes();
                    this.columnValueLength[i] = DefaultRowLCRCache.uB2ToShort(byArray.length);
                    if (this.columnValue[i].length >= byArray.length) {
                        System.arraycopy(byArray, 0, this.columnValue[i], 0, byArray.length);
                    } else {
                        this.columnValue[i] = datum.getBytes();
                        DefaultRowLCRCache.this.ReallocateCacheArrayNative(l, l2, n, i, byArray.length);
                    }
                    if (datum instanceof CHAR) {
                        int n4 = ((CHAR)datum).oracleId();
                        this.csid[i] = DefaultRowLCRCache.uB2ToShort(n4);
                        if (bl && n4 == 2000 && (n4 == 1 || n4 == 3)) {
                            bigInteger = bigInteger.setBit(4);
                            this.columnType[i] = DefaultRowLCRCache.uB2ToShort(23);
                        } else {
                            this.columnType[i] = DefaultRowLCRCache.uB2ToShort(1);
                        }
                    } else if (datum instanceof NUMBER) {
                        this.columnType[i] = DefaultRowLCRCache.uB2ToShort(2);
                    } else if (datum instanceof DATE) {
                        this.columnType[i] = DefaultRowLCRCache.uB2ToShort(12);
                    } else if (datum instanceof RAW) {
                        this.columnType[i] = DefaultRowLCRCache.uB2ToShort(23);
                    } else if (datum instanceof TIMESTAMP) {
                        this.columnType[i] = DefaultRowLCRCache.uB2ToShort(180);
                    } else if (datum instanceof TIMESTAMPTZ) {
                        this.columnType[i] = DefaultRowLCRCache.uB2ToShort(181);
                    } else if (datum instanceof TIMESTAMPLTZ) {
                        this.columnType[i] = DefaultRowLCRCache.uB2ToShort(231);
                    } else if (datum instanceof INTERVALYM) {
                        this.columnType[i] = DefaultRowLCRCache.uB2ToShort(182);
                    } else if (datum instanceof INTERVALDS) {
                        this.columnType[i] = DefaultRowLCRCache.uB2ToShort(183);
                    } else if (datum instanceof BINARY_DOUBLE) {
                        this.columnType[i] = DefaultRowLCRCache.uB2ToShort(101);
                    } else if (datum instanceof BINARY_FLOAT) {
                        this.columnType[i] = DefaultRowLCRCache.uB2ToShort(100);
                    } else if (datum instanceof BOOLEAN) {
                        this.columnType[i] = DefaultRowLCRCache.uB2ToShort(252);
                    } else {
                        throw new StreamsException("Unsupported data type for column " + i);
                    }
                }
                if (bl) {
                    int n5;
                    ChunkColumnValue chunkColumnValue = (ChunkColumnValue)columnValueArray[i];
                    if (n2 == 29 || n2 == 10 || n2 == 11) {
                        BigInteger bigInteger2 = chunkColumnValue.getChunkOffset();
                        if (bigInteger2 == null) {
                            bigInteger2 = BigInteger.ZERO;
                        }
                        this.lobOffset[i] = DefaultRowLCRCache.uB8ToLong(bigInteger2);
                        BigInteger bigInteger3 = chunkColumnValue.getChunkOperationSize();
                        if (bigInteger3 == null) {
                            bigInteger3 = BigInteger.ZERO;
                        }
                        this.lobSize[i] = DefaultRowLCRCache.uB8ToLong(bigInteger3);
                    }
                    if ((n5 = chunkColumnValue.getChunkType()) == 1) {
                        bigInteger = bigInteger.setBit(0);
                    } else if (n5 == 3) {
                        bigInteger = bigInteger.setBit(0);
                        bigInteger = bigInteger.setBit(5);
                    } else if (n5 == 2) {
                        bigInteger = bigInteger.setBit(0);
                    } else if (n5 == 4) {
                        bigInteger = bigInteger.setBit(6);
                    } else if (n5 == 5) {
                        bigInteger = bigInteger.setBit(1);
                    } else if (n5 == 6) {
                        bigInteger = bigInteger.setBit(1);
                    } else if (n5 == 7) {
                        bigInteger = bigInteger.setBit(11);
                    } else {
                        throw new StreamsException("Invalid chunk type " + n5 + " for column " + i);
                    }
                    if (chunkColumnValue.isLastChunk() && (n2 == 29 || n2 == 10 || n2 == 11)) {
                        bigInteger = bigInteger.setBit(3);
                    }
                    if (chunkColumnValue.isEmptyChunk()) {
                        bigInteger = bigInteger.setBit(2);
                    }
                    if (chunkColumnValue.isXMLDiff()) {
                        bigInteger = bigInteger.setBit(7);
                    }
                    if (chunkColumnValue.isJSONDiff()) {
                        bigInteger = bigInteger.setBit(12);
                    }
                    if (n5 == 4) {
                        this.csid[i] = DefaultRowLCRCache.uB2ToShort(chunkColumnValue.getCharSetId());
                    }
                    this.columnChunkType[i] = DefaultRowLCRCache.uB2ToShort(n5);
                }
                this.columnFlag[i] = DefaultRowLCRCache.uB8ToLong(bigInteger);
            }
        }

        String toString(int n) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("ColumnValueCache: columnNumber = " + n + "\n");
            for (int i = 0; i < n; ++i) {
                stringBuffer.append("(" + i + ") type" + this.columnType[i] + " csid" + this.csid[i] + " flag:0x" + Long.toString(this.columnFlag[i], 16) + " lOffset: " + this.lobOffset[i] + " lSize: " + this.lobSize[i] + " namel" + this.columnNameLength[i] + " name" + DefaultRowLCRCache.byteArrayToString(this.columnName, i * 384, DefaultRowLCRCache.shortToUB2(this.columnNameLength[i])) + " valuel" + this.columnValueLength[i] + " value" + DefaultRowLCRCache.byteArrayToString(this.columnValue[i], 0, DefaultRowLCRCache.shortToUB2(this.columnValueLength[i])) + "\n");
            }
            stringBuffer.append("\n");
            return stringBuffer.toString();
        }
    }
}

